/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing;

import com.biotechvana.shared.jobs.PreprocessingFilters;
import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.FileVariable;

public class PreProcessingCUTADAPTJob
extends WorkflowJob {
    public static final String JOB_ID = "CUTADAPT";
    public static final String JOB_NAME = "CUTADAPT";
    public static final String INPUT_5_ADAPTERS = "INPUT_5_ADAPTERS";
    public static final String INPUT_3_ADAPTERS = "INPUT_3_ADAPTERS";
    public static final String INPUT_5_3_ADAPTERS = "INPUT_5_3_ADAPTERS";
    public static final String OPTION_PR_FILTER = "OPTION_PR_FILTER";

    public PreProcessingCUTADAPTJob() {
        this.jobName = "CUTADAPT";
        this.jobDesc = new JobDescriptor("CUTADAPT");
        this.jobDesc.setDesc("Cutadapt finds and removes adapter sequences, primers, poly-A tails and other types of unwanted sequence from your high-throughput sequencing reads.");
        this.jobDesc.setRef("Martin M. 2011. Cutadapt removes adapter sequences from high-throughput sequencing reads. EMBnetjournal Vol 17. <a href=\"http://doi.org/10.14806/ej.17.1.200\">doi: 10.14806/ej.17.1.200</a>. Online docs: <a href=\"https://cutadapt.readthedocs.io/en/stable/guide.html\">https://cutadapt.readthedocs.io/en/stable/guide.html</a>");
        VariableDescriptor varFastaQ = VariableDescriptor.createDescriptorFor((String)"INPUT_FILES", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFastaQ.isRequired = true;
        varFastaQ.setVariableName("Input Files");
        varFastaQ.addAcceptedFileFormat("FASTQ", false, false, "FASTQ", "");
        varFastaQ.addAcceptedFileFormat("FASTA", false, false, "FASTA", "");
        varFastaQ.addAcceptedFileFormat("FASTA and QUAL", true, "FASTA", "QUAL");
        this.jobDesc.addVariable(varFastaQ);
        VariableDescriptor var5Adapters = VariableDescriptor.createDescriptorFor((String)INPUT_5_ADAPTERS, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        var5Adapters.isRequired = true;
        var5Adapters.setVariableName("5` Adapters");
        var5Adapters.setVariableGroup("Adapters");
        this.jobDesc.addVariable(var5Adapters);
        VariableDescriptor var53Adapters = VariableDescriptor.createDescriptorFor((String)INPUT_5_3_ADAPTERS, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        var53Adapters.isRequired = true;
        var53Adapters.setVariableName("5` and 3` Adapters");
        var53Adapters.setVariableGroup("Adapters");
        this.jobDesc.addVariable(var53Adapters);
        VariableDescriptor var3Adapters = VariableDescriptor.createDescriptorFor((String)INPUT_3_ADAPTERS, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        var3Adapters.isRequired = true;
        var3Adapters.setVariableName("3` Adapters");
        var3Adapters.setVariableGroup("Adapters");
        this.jobDesc.addVariable(var3Adapters);
        VariableDescriptor varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Max COUNT");
        varOption.setCommandParamater("-n");
        varOption.setHelpMsg("Try to remove adapters at most COUNT times. Useful when an adapter gets appended multiple time.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Minimum overlap LENGTH");
        varOption.setCommandParamater("-O");
        varOption.setHelpMsg("If the overlap between the read and the adapter is shorter than LENGTH, the read is not modified. This reduces the no. of bases trimmed purely due to short random adapter matches");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Minimum LENGTH");
        varOption.setCommandParamater("-m");
        varOption.setCommandParamaterAlt("--minimum-length");
        varOption.setHelpMsg("MINIMUM LENGTH: Discard trimmed reads that are shorter than LENGTH. Reads that are too short even before adapter removal are also discarded. In colorspace, an initial primer is not counted.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Maximum LENGTH");
        varOption.setCommandParamater("-M");
        varOption.setHelpMsg("MAXIMUM LENGTH: Discard trimmed reads that are longer than LENGTH. Reads that are too long even before adapter removal are also discarded. In colorspace, an initial primer is not counted.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("File to write reads after the adapter");
        varOption.setCommandParamater("-r");
        varOption.setHelpMsg("FILE: When the adapter matches in the middle of a read, write the rest (after the adapter) into a file.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("WILDCARD FILE");
        varOption.setCommandParamater("--wildcard-file");
        varOption.setHelpMsg("WILDCARD-FILE: When the adapter has wildcard bases (`N`s) write adapter bases matching wildcard positions to FILE.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("File to write reads that are too short");
        varOption.setCommandParamater("--too-short-output");
        varOption.setHelpMsg("Write reads that are too short (according to length specified by -m) to FILE.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Fiel to write reads that do not contain the adapter");
        varOption.setCommandParamater("--untrimmed-output");
        varOption.setHelpMsg("Write reads that do not contain the adapter to FILE, instead of writing them to the regular output file.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.SelectionList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Quality Base");
        varOption.setCommandParamater("--quality-base");
        ((SelectionListVariableDescriptor)varOption).addOptionValue("33");
        ((SelectionListVariableDescriptor)varOption).addOptionValue("64");
        varOption.setHelpMsg("Assume that quality values are encoded as ascii(quality + QUALITY_BASE). The default (33) is usually correct, except for reads produced by some versions of the Illumina pipeline, where this should be set to 64");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Prefix to read names");
        varOption.setCommandParamater("-x");
        varOption.setHelpMsg("PREFIX: Add this prefix to read names.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Suffix to read names");
        varOption.setCommandParamater("-y");
        varOption.setHelpMsg("SUFFIX: Add this suffix to read names.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Trim low-quality ends");
        varOption.setCommandParamater("-q");
        varOption.setHelpMsg("Trim low-quality bases from 5' and/or 3' ends of each\nread before adapter removal. Applied to both reads if\ndata is paired. If one value is given, only the 3' end\nis trimmed. If two comma-separated cutoffs are given,\nthe 5' end is trimmed with the first cutoff, the 3'\nend with the second.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Discard reads that contain the adapter instead of trimming them");
        varOption.setCommandParamater("--discard");
        varOption.setHelpMsg("Discard reads that contain the adapter instead of trimming them. Also use -O in order to avoid throwing away too many randomly matching reads!");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Colorspace mode");
        varOption.setCommandParamater("-c");
        varOption.setHelpMsg("Colorspace mode: Also trim the color that is adjacent to the found adapter.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Double-encode colors");
        varOption.setCommandParamater("-d");
        varOption.setHelpMsg("When in color space, double-encode colors (map 0,1,2,3,4 to A,C,G,T,N).");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Trim primer base and the first color");
        varOption.setCommandParamater("-t");
        varOption.setHelpMsg("When in color space, trim primer base and the first color (which is the transition to the first nucleotide).");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Strip the _F3 suffix of read names");
        varOption.setCommandParamater("--strip-f3");
        varOption.setHelpMsg("For color space: Strip the _F3 suffix of read names.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("MAQ compatible color space output");
        varOption.setCommandParamater("--maq");
        varOption.setHelpMsg("MAQ- -compatible color space output. This enables -c, -d, - t, --strip-f3, -y `/1` and -z.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("BWA compatible color space output");
        varOption.setCommandParamater("--bwa");
        varOption.setHelpMsg("BWA-compatible color space output. This enables -c, -d, -t, -- strip-f3, -y `/1` and -z.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Change negative quality values to zero");
        varOption.setCommandParamater("-z");
        varOption.setHelpMsg("Change negative quality values to zero (workaround to avoid segmentation faults in BWA).");
        this.jobDesc.addVariable(varOption);
        VariableDescriptor varOption_PR_FILTER = VariableDescriptor.createDescriptorFor((String)OPTION_PR_FILTER, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption_PR_FILTER.setVariableName("Good sequences percet after filtering");
        varOption_PR_FILTER.setHelpMsg("Min Good sequences percet of the total sequences input before preprocessing  to consider the preprocessing as succesfull. Has no effect on the bahavoiur of cutapat. Used only for managment pipeline and tracking. Default 80");
        this.jobDesc.addVariable(varOption_PR_FILTER);
        VariableDescriptor varOutputFiles = VariableDescriptor.createDescriptorFor((String)"OUTPUT_FILES", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        varOutputFiles.setVariableName("Output Files");
        varOutputFiles.isRequired = true;
        varOutputFiles.addAcceptedFileFormat("FASTQ", false, false);
        varOutputFiles.addAcceptedFileFormat("FASTA and QUAL", true, "FASTA", "QUAL");
        this.jobDesc.addVariable(varOutputFiles);
        VariableDescriptor varOutputFolder = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(varOutputFolder);
        PreprocessingFilters.addPrepresoccesingFilter(this.jobDesc, varOutputFiles);
        PreprocessingFilters.addPrepresoccesingPRFilter(this.jobDesc, varOutputFiles, varOption_PR_FILTER);
        this.initJobFromDesc(this.jobDesc);
    }

    public boolean notifyVarValueChanged(String varKey, String value) {
        if (!varKey.equals("INPUT_FILES")) {
            varKey.equals("INPUT_OUTPUT_FOLDER");
        }
        return true;
    }

    protected void generateCommand(StringBuilder command) {
        String cutadaptCmd = "cutadapt";
        String parsedOptions = this.getOptionParamatersStrAs$();
        String fileFormat = ((FileVariable)this.getVariable("INPUT_FILES")).getFormatAsBashVarName();
        command.append("cmdPart1=\"" + cutadaptCmd + " " + this.getAdapters() + " " + parsedOptions + " \"\n");
        command.append("outputFolder=\"" + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\"\n");
        command.append(" [ -d \"${outputFolder}/summary\" ] || mkdir \"${outputFolder}/summary\" \n");
        command.append("# to cause fail of pipe - tee \n");
        command.append("set -o pipefail \n");
        command.append(BashHelper.Batcher_noLog((FileListVariable)((FileListVariable)this.getVariable("INPUT_FILES")), (String)BashHelper.IF((String)(" \"" + fileFormat + "\" = \"" + "FASTQ" + "\" ] || [ \"" + fileFormat + "\" = \"" + "FASTA" + "\" "), (String)("fileExt=" + BashHelper.getExt((String)"_inputFile") + "\n" + this.getVariable("OUTPUT_FILES").getBashVarName("$_p,$_i") + "=\"${outputFolder}/${inputFileBaseName}.${fileExt}\" \n"), (String)(String.valueOf(this.getVariable("OUTPUT_FILES").getBashVarName("0,$_i")) + "=\"${outputFolder}/${inputFileBaseName}.fastq\" \n")), (boolean)true));
        command.append(String.valueOf(BashHelper.IF((String)(" \"" + fileFormat + "\" = \"" + "FASTQ" + "\" ] || [ \"" + fileFormat + "\" = \"" + "FASTA" + "\" "), (String)BashHelper.BatcherParallel((FileListVariable)((FileListVariable)this.getVariable("INPUT_FILES")), (String)("fileExt=" + BashHelper.getExt((String)"_inputFile") + "\n" + "$cmdPart1 -o \"${outputFolder}/${inputFileBaseName}.${fileExt}\" ${_inputFile} | tee \"${outputFolder}/summary/${inputFileBaseName}_summary.txt\"  \n")))) + BashHelper.IF((String)("[ \"" + fileFormat + "\" = \"" + "FASTA and QUAL" + "\" ]"), (String)BashHelper.BatcherParallelSingleton((FileListVariable)((FileListVariable)this.getVariable("INPUT_FILES")), (String)"", (String)"", (String)"$cmdPart1 -o \"${outputFolder}/${inputFile1BaseName}.fastq\" ${_inputFile1} ${_inputFile2} | tee \"${outputFolder}/summary/${inputFile1BaseName}_summary.txt\"")));
        command.append("set +o pipefail \n");
    }

    protected void generateCommandWrapUp(StringBuilder command) {
        ((FileVariable)this.getVariable("OUTPUT_FILES")).setFileFormat("FASTQ");
        command.append(((FileVariable)this.getVariable("OUTPUT_FILES")).getFileFormatAsBashVar(this.getVariable("INPUT_FILES")));
    }

    public boolean isValid() {
        boolean valid = true;
        String textAdapters3 = this.getValue(INPUT_3_ADAPTERS);
        String textAdapters53 = this.getValue(INPUT_5_3_ADAPTERS);
        String textAdapters5 = this.getValue(INPUT_5_ADAPTERS);
        if (textAdapters3.isEmpty() && textAdapters53.isEmpty() && textAdapters5.isEmpty()) {
            this.getVariable(INPUT_3_ADAPTERS).setRequired(false);
            this.getVariable(INPUT_5_3_ADAPTERS).setRequired(false);
            this.getVariable(INPUT_5_ADAPTERS).setRequired(false);
            this.getVariable(INPUT_3_ADAPTERS).setWarning("PLease enter at least one adapter");
            this.getVariable(INPUT_5_3_ADAPTERS).setWarning("PLease enter at least one adapter");
            this.getVariable(INPUT_5_ADAPTERS).setWarning("PLease enter at least one adapter");
        } else {
            this.getVariable(INPUT_3_ADAPTERS).setRequired(false);
            this.getVariable(INPUT_5_3_ADAPTERS).setRequired(false);
            this.getVariable(INPUT_5_ADAPTERS).setRequired(false);
        }
        return super.isValid() && valid;
    }

    protected String getFilterCheckCommand() {
        String checkLevel = Tracking.TrackCheckLevels.Fail.toString();
        if (this.getParent() == null) {
            checkLevel = Tracking.TrackCheckLevels.Warning.toString();
        }
        String filterName = "PR";
        String statusVar = "_g_filter_status";
        String cmdCheck = "";
        cmdCheck = String.valueOf(cmdCheck) + "dARate=\"" + this.getVariable(OPTION_PR_FILTER).$() + "\"\n";
        cmdCheck = String.valueOf(cmdCheck) + "[ -n \"${dARate}\" ] ||  dARate=\"80\" \n";
        cmdCheck = String.valueOf(cmdCheck) + BashHelper.Batcher_noLog((FileListVariable)((FileListVariable)this.getVariable("INPUT_FILES")), (String)"", (String)("[ \"" + ((FileVariable)this.getVariable("INPUT_FILES")).getFormatAsBashVarName() + "\" = \"" + "FASTA and QUAL" + "\" ] && [ $_p = \"1\" ] && continue \n" + "wRes=$(grep  \"Total written\" \"${outputFolder}/summary/${inputFileBaseName}_summary.txt\")\n" + "wRes=${wRes// /}\n" + "wRes=${wRes%\\%*}\n" + "wRes=${wRes#*bp(}\n" + "[ -n \"${wRes}\" ] || wRes=\"0\"\n" + "com=$(echo $wRes\">=\"$dARate | bc -l)\n" + BashHelper.IF((String)"[ com -eq 0 ]", (String)("echo \"Total good reads=$wRes% should be more that the defined threshold $dARate% : Did no Pass the filter.\"\n" + Tracking.trackLogCheck((String)"${_inputFile}", (String)filterName, (Tracking.TrackCheckType)Tracking.TrackCheckType.Filter, (String)checkLevel, (String)"Total good reads=$wRes%% should be more that defined threshold $dARate%%") + BashHelper.assign((String)statusVar, (String)checkLevel)), (String)("echo \"Total good reads=$wRes% are more that the defined threshold $dARate% : OK.\"\n" + Tracking.trackLogCheck((String)"${_inputFile}", (String)filterName, (Tracking.TrackCheckType)Tracking.TrackCheckType.Filter, (Tracking.TrackCheckLevels)Tracking.TrackCheckLevels.Pass, (String)"Total good reads=$wRes%% are more that $dARate%% : Pass")))), (String)"");
        return cmdCheck;
    }

    private String getAdapters() {
        String s;
        int n;
        int n2;
        String[] stringArray;
        StringBuilder builder = new StringBuilder();
        String textAdaptersA = this.getValue(INPUT_3_ADAPTERS);
        String textAdaptersB = this.getValue(INPUT_5_3_ADAPTERS);
        String textAdaptersG = this.getValue(INPUT_5_ADAPTERS);
        if (!textAdaptersA.isEmpty()) {
            stringArray = textAdaptersA.split("\n");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                if (!s.trim().isEmpty()) {
                    builder.append(" -a " + s.trim());
                }
                ++n;
            }
        }
        if (!textAdaptersB.isEmpty()) {
            stringArray = textAdaptersB.split("\n");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                if (!s.trim().isEmpty()) {
                    builder.append(" -b " + s.trim());
                }
                ++n;
            }
        }
        if (!textAdaptersG.isEmpty()) {
            stringArray = textAdaptersG.split("\n");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                if (!s.trim().isEmpty()) {
                    builder.append(" -g " + s.trim());
                }
                ++n;
            }
        }
        return builder.toString();
    }
}

