/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared;

import com.biotechvana.shared.InputProcessingWorkflowConfiguration;
import com.biotechvana.workflow.IValidationResult;
import com.biotechvana.workflow.ValidationResult;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.configuration.IConfigurationWithReference;
import com.biotechvana.workflow.manager.IWorkflowManager;

public class MappingPipelineConfiguration
extends InputProcessingWorkflowConfiguration
implements IConfigurationWithReference {
    static final String Mapper_Bwa = "bwa";
    static final String Mapper_Bowtie2 = "Bowtie2";
    static final String Mapper_Tophat = "Tophat";
    static final String Mapper_Hisat2 = "hisat2";
    static final String Mapper_STAR = "STAR";
    private String targetMapper = null;
    String refIndex = "";
    boolean buildNew = false;
    String refIndexSourceFastaFile = "";
    String refPrefix = "";
    String refGTF = "";
    protected boolean withGTF = false;
    protected boolean optionalGTF = true;

    public MappingPipelineConfiguration(IWorkflowManager workflowManager) {
        super(workflowManager);
    }

    @Override
    public IValidationResult validate() {
        boolean doesMatch;
        IValidationResult res = super.validate();
        if (!res.isOK()) {
            return res;
        }
        String errMsg = "";
        if (this.targetMapper != null && !this.targetMapper.isEmpty() && !(doesMatch = this.checkMapperRefAgaisntWorkflowMapper(this.targetMapper))) {
            errMsg = "Selected Reference does not match selected Workflow mapper.";
        }
        if (errMsg.isEmpty()) {
            if (this.refIndexSourceFastaFile.isEmpty() && this.buildNew) {
                errMsg = "No Reference Fasta File selected.";
            } else if (this.refIndex.isEmpty() && !this.buildNew) {
                errMsg = "Reference Index is Empty.";
            }
        }
        if (!errMsg.isEmpty()) {
            return new ValidationResult(4, -1, errMsg);
        }
        return res;
    }

    @Override
    public IValidationResult feedWorkflow() {
        IValidationResult validation = super.feedWorkflow();
        if (!validation.isOK()) {
            return validation;
        }
        if (this.refIndex.isEmpty()) {
            this.buildNew = true;
        }
        if (this.pipeline.getMetadata().hasTag(Mapper_Bowtie2)) {
            WorkflowJob mapper = this.pipeline.getJobByType(Mapper_Bowtie2);
            if (this.buildNew) {
                mapper.setValue("INPUT_INDEX_CHOICE", "true");
                mapper.setValue("INDEX_FASTA_FILE", this.refIndexSourceFastaFile);
                mapper.setValue("INPUT_INDEX_PREFIX", this.refPrefix);
            } else {
                mapper.setValue("INPUT_INDEX_CHOICE", "false");
                mapper.setValue("INPUT_INDEX_FILE", this.refIndex);
            }
        } else if (this.pipeline.getMetadata().hasTag(Mapper_Bwa)) {
            WorkflowJob mapper = this.pipeline.getJobByType(Mapper_Bwa);
            if (this.buildNew) {
                mapper.setValue("INPUT_INDEX_CHOICE", "true");
                mapper.setValue("INPUT_INDEX_FASTA_FILE", this.refIndexSourceFastaFile);
                mapper.setValue("INPUT_INDEX_PREFIX", this.refPrefix);
            } else {
                mapper.setValue("INPUT_INDEX_CHOICE", "false");
                mapper.setValue("INPUT_INDEX_FILE", this.refIndex);
            }
        } else if (this.pipeline.getMetadata().hasTag(Mapper_Tophat)) {
            WorkflowJob mapper = this.pipeline.getJobByType(Mapper_Tophat);
            if (this.buildNew) {
                mapper.setValue("INPUT_INDEX_CHOICE", "true");
                mapper.setValue("INDEX_FASTA_FILE", this.refIndexSourceFastaFile);
                mapper.setValue("INPUT_INDEX_PREFIX", this.refPrefix);
            } else {
                mapper.setValue("INPUT_INDEX_CHOICE", "false");
                mapper.setValue("INPUT_INDEX_FILE", this.refIndex);
            }
            if (!this.getRefereneceGTF().isEmpty()) {
                mapper.getVariableByCMDSwitch("-G").setReadOnly(true);
                mapper.setValueByCMDSwitch("-G", this.getRefereneceGTF());
            } else {
                mapper.getVariableByCMDSwitch("-G").setReadOnly(false);
            }
        } else if (this.pipeline.getMetadata().hasTag(Mapper_Hisat2)) {
            WorkflowJob mapper = this.pipeline.getJobByType(Mapper_Hisat2);
            if (this.buildNew) {
                mapper.setValue("INPUT_INDEX_CHOICE", "true");
                mapper.setValue("INDEX_FASTA_FILE", this.refIndexSourceFastaFile);
                mapper.setValue("INPUT_INDEX_PREFIX", this.refPrefix);
            } else {
                mapper.setValue("INPUT_INDEX_CHOICE", "false");
                mapper.setValue("INPUT_INDEX_FILE", this.refIndex);
            }
        } else if (this.pipeline.getMetadata().hasTag(Mapper_STAR)) {
            WorkflowJob mapper = this.pipeline.getJobByType(Mapper_STAR);
            if (this.buildNew) {
                mapper.setValue("INPUT_INDEX_CHOICE", "true");
                mapper.setValue("INDEX_FASTA_FILE", this.refIndexSourceFastaFile);
                mapper.setValue("INPUT_INDEX_PREFIX", this.refPrefix);
            } else {
                mapper.setValue("INPUT_INDEX_CHOICE", "false");
                mapper.setValue("INPUT_INDEX_FILE", this.refIndex);
            }
            if (!this.getRefereneceGTF().isEmpty()) {
                mapper.getVariableByCMDSwitch("--sjdbGTFfile").setReadOnly(true);
                mapper.setValueByCMDSwitch("--sjdbGTFfile", this.getRefereneceGTF());
            } else {
                mapper.getVariableByCMDSwitch("--sjdbGTFfile").setReadOnly(false);
            }
        }
        return validation;
    }

    public void setReferenceIndexSourceFastaFile(String refIndexFastaFile, boolean buildNew) {
        this.refIndexSourceFastaFile = refIndexFastaFile;
        this.buildNew = buildNew;
    }

    public String getReferenceIndexSourceFastaFile() {
        return this.refIndexSourceFastaFile;
    }

    public void setReferenceIndex(String refIndex) {
        this.buildNew = false;
        this.refIndex = refIndex;
        this.refIndexSourceFastaFile = "";
        this.refPrefix = "";
    }

    public boolean isBuildNew() {
        return this.buildNew;
    }

    public String getReferenceIndex() {
        return this.refIndex;
    }

    public void setReferenecePrefix(String prefix) {
        this.refPrefix = prefix;
    }

    public String getReferenecePrefix() {
        return this.refPrefix;
    }

    public void setRefereneceGTF(String gtfFile) {
        this.refGTF = gtfFile;
    }

    public String getRefereneceGTF() {
        return this.refGTF;
    }

    public String getTargetMapper() {
        return this.targetMapper;
    }

    public void setTargetMapper(String targetMapper) {
        this.targetMapper = targetMapper;
    }

    public boolean checkMapperRefAgaisntWorkflowMapper(String targetMapper) {
        return targetMapper.equals(Mapper_Bowtie2) ? this.pipeline.getMetadata().hasTag(Mapper_Bowtie2) || this.pipeline.getMetadata().hasTag(Mapper_Tophat) : this.pipeline.getMetadata().hasTag(targetMapper);
    }

    @Override
    protected void onSettingWorkflow() {
        super.onSettingWorkflow();
        this.withGTF = this.pipeline.getMetadata().hasTag("GTF/GFF");
        if (this.pipeline.getMetadata().hasTag(Mapper_Bowtie2)) {
            WorkflowJob mapper = this.pipeline.getJobByType(Mapper_Bowtie2);
            mapper.getVariable("INPUT_INDEX_CHOICE").setReadOnly(true);
            mapper.getVariable("INDEX_FASTA_FILE").setReadOnly(true);
            mapper.getVariable("INPUT_INDEX_PREFIX").setReadOnly(true);
            mapper.getVariable("INPUT_INDEX_CHOICE").setReadOnly(true);
            mapper.getVariable("INPUT_INDEX_FILE").setReadOnly(true);
            this.withGTF = false;
        } else if (this.pipeline.getMetadata().hasTag(Mapper_Bwa)) {
            WorkflowJob mapper = this.pipeline.getJobByType(Mapper_Bwa);
            mapper.getVariable("INPUT_INDEX_CHOICE").setReadOnly(true);
            mapper.getVariable("INPUT_INDEX_FASTA_FILE").setReadOnly(true);
            mapper.getVariable("INPUT_INDEX_PREFIX").setReadOnly(true);
            mapper.getVariable("INPUT_INDEX_CHOICE").setReadOnly(true);
            mapper.getVariable("INPUT_INDEX_FILE").setReadOnly(true);
            this.withGTF = false;
        } else if (this.pipeline.getMetadata().hasTag(Mapper_Tophat)) {
            WorkflowJob mapper = this.pipeline.getJobByType(Mapper_Tophat);
            mapper.getVariable("INPUT_INDEX_CHOICE").setReadOnly(true);
            mapper.getVariable("INDEX_FASTA_FILE").setReadOnly(true);
            mapper.getVariable("INPUT_INDEX_PREFIX").setReadOnly(true);
            mapper.getVariable("INPUT_INDEX_CHOICE").setReadOnly(true);
            mapper.getVariable("INPUT_INDEX_FILE").setReadOnly(true);
            this.withGTF = true;
        } else if (this.pipeline.getMetadata().hasTag(Mapper_Hisat2)) {
            WorkflowJob mapper = this.pipeline.getJobByType(Mapper_Hisat2);
            mapper.getVariable("INPUT_INDEX_CHOICE").setReadOnly(true);
            mapper.getVariable("INDEX_FASTA_FILE").setReadOnly(true);
            mapper.getVariable("INPUT_INDEX_PREFIX").setReadOnly(true);
            mapper.getVariable("INPUT_INDEX_CHOICE").setReadOnly(true);
            mapper.getVariable("INPUT_INDEX_FILE").setReadOnly(true);
            this.withGTF = false;
        } else if (this.pipeline.getMetadata().hasTag(Mapper_STAR)) {
            WorkflowJob mapper = this.pipeline.getJobByType(Mapper_STAR);
            mapper.getVariable("INPUT_INDEX_CHOICE").setReadOnly(true);
            mapper.getVariable("INDEX_FASTA_FILE").setReadOnly(true);
            mapper.getVariable("INPUT_INDEX_PREFIX").setReadOnly(true);
            mapper.getVariable("INPUT_INDEX_CHOICE").setReadOnly(true);
            mapper.getVariable("INPUT_INDEX_FILE").setReadOnly(true);
            mapper.getVariable("BAM_OUT").setReadOnly(true);
            this.withGTF = true;
        }
    }

    public String getMapperName() {
        if (this.pipeline == null) {
            return null;
        }
        if (this.pipeline.getMetadata().hasTag(Mapper_Bowtie2)) {
            return Mapper_Bowtie2;
        }
        if (this.pipeline.getMetadata().hasTag(Mapper_Bwa)) {
            return Mapper_Bwa;
        }
        if (this.pipeline.getMetadata().hasTag(Mapper_Tophat)) {
            return Mapper_Tophat;
        }
        if (this.pipeline.getMetadata().hasTag(Mapper_Hisat2)) {
            return Mapper_Hisat2;
        }
        if (this.pipeline.getMetadata().hasTag(Mapper_STAR)) {
            return Mapper_STAR;
        }
        return null;
    }

    public boolean isOptionalGTF() {
        return this.optionalGTF;
    }

    public boolean isWithGTF() {
        return this.withGTF;
    }
}

