/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.AbstractWorkbenchBrowserSupport;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.DefaultWebBrowser;

public class DefaultWorkbenchBrowserSupport
extends AbstractWorkbenchBrowserSupport {
    private Map<String, IWebBrowser> browsers = new HashMap<String, IWebBrowser>();
    private static final String DEFAULT_BROWSER_ID_BASE = "org.eclipse.ui.defaultBrowser";

    void registerBrowser(IWebBrowser browser) {
        this.browsers.put(browser.getId(), browser);
    }

    void unregisterBrowser(IWebBrowser browser) {
        this.browsers.remove(browser.getId());
    }

    IWebBrowser findBrowser(String id) {
        return this.browsers.get(id);
    }

    protected IWebBrowser doCreateBrowser(int style, String browserId, String name, String tooltip) throws PartInitException {
        return new DefaultWebBrowser(this, browserId);
    }

    @Override
    public IWebBrowser createBrowser(int style, String browserId, String name, String tooltip) throws PartInitException {
        IWebBrowser browser = this.findBrowser(browserId == null ? this.getDefaultId() : browserId);
        if (browser != null) {
            return browser;
        }
        browser = this.doCreateBrowser(style, browserId, name, tooltip);
        this.registerBrowser(browser);
        return browser;
    }

    @Override
    public IWebBrowser createBrowser(String browserId) throws PartInitException {
        return this.createBrowser(128, browserId, null, null);
    }

    private String getDefaultId() {
        String id = null;
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            id = DEFAULT_BROWSER_ID_BASE + i;
            if (this.browsers.get(id) == null) break;
            ++i;
        }
        return id;
    }
}

