/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.pipelineCommander;

import com.biotechvana.pipelineCommander.DoPostRequest;
import com.biotechvana.utils.PreferenceManager;
import com.biotechvana.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GproApiRequest {
    public static void main(String[] args) {
        try {
            List<String> gi = GproApiRequest.subject2go("Uncharacterized%2520protein%2520002L");
            System.out.println("gi: " + Arrays.toString(gi.toArray(new String[gi.size()])));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String sanitizeUrl(String url) {
        Pattern pattern = Pattern.compile("(http[s]?://)(.+)");
        Matcher m = pattern.matcher(url);
        if (m.matches()) {
            return m.group(1) + m.group(2).replace("//", "/");
        }
        return url;
    }

    private static String getHost() {
        Object host = PreferenceManager.getInstance().get("ssh_host", "http://opathy.uv.es");
        if (!((String)host).startsWith("http://")) {
            host = "http://" + (String)host;
        }
        return "http://opathy.uv.es";
    }

    private static String doGetRequest(String urlLocation) throws IOException {
        URL url = new URL(GproApiRequest.sanitizeUrl(urlLocation));
        StringBuilder builder = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line;
            while ((line = in.readLine()) != null) {
                builder.append(line);
            }
        }
        return builder.toString();
    }

    public static String uniprot2gi(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/uniprot/to_gi/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        Gi sv = (Gi)gson.fromJson(jsonResponse, Gi.class);
        System.out.println("aqui");
        if (sv != null) {
            return sv.gi;
        }
        return "";
    }

    public static String uniprot2AccessionSwissprot(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/uniprot/to_accession_swissprot/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        AccessionSwissprot sv = (AccessionSwissprot)gson.fromJson(jsonResponse, AccessionSwissprot.class);
        return sv.accession_swissprot;
    }

    public static List<String> uniprot2go(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/uniprot/to_go/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        Go[] sv = (Go[])gson.fromJson(jsonResponse, Go[].class);
        ArrayList<String> listVaues = new ArrayList<String>();
        Go[] goArray = sv;
        int n = sv.length;
        int n2 = 0;
        while (n2 < n) {
            Go s = goArray[n2];
            listVaues.add(s.go_id);
            ++n2;
        }
        return listVaues;
    }

    public static List<String> uniprot2interpro(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/uniprot/to_interpro/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        Interpro[] sv = (Interpro[])gson.fromJson(jsonResponse, Interpro[].class);
        ArrayList<String> listVaues = new ArrayList<String>();
        Interpro[] interproArray = sv;
        int n = sv.length;
        int n2 = 0;
        while (n2 < n) {
            Interpro s = interproArray[n2];
            listVaues.add(s.interpro);
            ++n2;
        }
        return listVaues;
    }

    public static List<String> uniprot2geneName(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/uniprot/to_gene_name/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        Gene[] sv = (Gene[])gson.fromJson(jsonResponse, Gene[].class);
        ArrayList<String> listVaues = new ArrayList<String>();
        Gene[] geneArray = sv;
        int n = sv.length;
        int n2 = 0;
        while (n2 < n) {
            Gene s = geneArray[n2];
            listVaues.add(s.gene_name);
            ++n2;
        }
        return listVaues;
    }

    public static String gi2accessionSwissprot(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/gi/to_accession_swissprot/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        AccessionSwissprot sv = (AccessionSwissprot)gson.fromJson(jsonResponse, AccessionSwissprot.class);
        return sv.accession_swissprot;
    }

    public static String gi2accessionUniprot(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/gi/to_accession_uniprot/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        AccessionUniprot sv = (AccessionUniprot)gson.fromJson(jsonResponse, AccessionUniprot.class);
        return sv.accession_uniprot;
    }

    public static String gi2geneName(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/gi/to_gene_name/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        Gene sv = (Gene)gson.fromJson(jsonResponse, Gene.class);
        return sv.gene_name;
    }

    public static List<String> gi2go(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/gi/to_go/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        Go[] sv = (Go[])gson.fromJson(jsonResponse, Go[].class);
        ArrayList<String> listVaues = new ArrayList<String>();
        Go[] goArray = sv;
        int n = sv.length;
        int n2 = 0;
        while (n2 < n) {
            Go s = goArray[n2];
            listVaues.add(s.go_id);
            ++n2;
        }
        return listVaues;
    }

    public static String swissprot2accessionUniprot(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/swissprot/to_accession_uniprot/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        AccessionUniprot sv = (AccessionUniprot)gson.fromJson(jsonResponse, AccessionUniprot.class);
        return sv.accession_uniprot;
    }

    public static String swissprot2gi(String key) throws IOException {
        Gson gson = new Gson();
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/swissprot/to_gi/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gi sv = (Gi)gson.fromJson(jsonResponse, Gi.class);
        if (sv != null) {
            return sv.gi;
        }
        return "";
    }

    public static List<String> swissprot2go(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/swissprot/to_go/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        Go[] sv = (Go[])gson.fromJson(jsonResponse, Go[].class);
        ArrayList<String> listVaues = new ArrayList<String>();
        Go[] goArray = sv;
        int n = sv.length;
        int n2 = 0;
        while (n2 < n) {
            Go s = goArray[n2];
            listVaues.add(s.go_id);
            ++n2;
        }
        return listVaues;
    }

    public static String gene2accessionGenbank(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/gene/to_accession_genbank/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        AccessionGenbank sv = (AccessionGenbank)gson.fromJson(jsonResponse, AccessionGenbank.class);
        return sv.accession_genbank;
    }

    public static String gene2gi(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/gene/to_gi/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        Gi sv = (Gi)gson.fromJson(jsonResponse, Gi.class);
        return sv.gi;
    }

    public static String genbank2gene_name(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/genbank/to_gene_name/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        Gene sv = (Gene)gson.fromJson(jsonResponse, Gene.class);
        return sv.gene_name;
    }

    public static List<String> subject2go(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/subject/to_go/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        GoEvidence sv = (GoEvidence)gson.fromJson(jsonResponse, GoEvidence.class);
        ArrayList<String> listValues = new ArrayList<String>();
        listValues.add(String.valueOf(sv.getGoCount()));
        listValues.add(sv.go);
        listValues.add(sv.evidence);
        List<String> goCodes = GoEvidence.getGoCodes(sv.go);
        Collection<Enzyme> listEnzymes = GproApiRequest.getEnzymeByGo(goCodes);
        if (listEnzymes != null && !listEnzymes.isEmpty()) {
            ArrayList<String> listEnzymeCodes = new ArrayList<String>();
            for (Enzyme enzyme : listEnzymes) {
                if (enzyme.ecid.trim().isEmpty() || listEnzymeCodes.contains(enzyme.ecid)) continue;
                listEnzymeCodes.add(enzyme.ecid);
            }
            listValues.add(StringUtils.join(listEnzymeCodes, (String)";"));
        } else {
            listValues.add("");
        }
        return listValues;
    }

    public static String go2enzyme(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/go/to_enzyme/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        Enzyme sv = (Enzyme)gson.fromJson(jsonResponse, Enzyme.class);
        return sv.ecid + ":" + sv.ec_desc;
    }

    public static String go2accessionSwissprot(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/go/to_accession_swissprot/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        AccessionSwissprot sv = (AccessionSwissprot)gson.fromJson(jsonResponse, AccessionSwissprot.class);
        return sv.accession_swissprot;
    }

    public static String go2accessionUniprot(String key) throws IOException {
        String url = GproApiRequest.getHost() + "/gpro/GPRO_API_V5/public/index.php/go/to_accession_uniprot/" + URLEncoder.encode(key, "UTF-8");
        String jsonResponse = GproApiRequest.doGetRequest(url);
        Gson gson = new Gson();
        AccessionUniprot sv = (AccessionUniprot)gson.fromJson(jsonResponse, AccessionUniprot.class);
        return sv.accession_uniprot;
    }

    public static String getAccessionSwissprotByGi(String key) throws IOException {
        Object host = PreferenceManager.getInstance().get("ssh_host", "http://opathy.uv.es");
        if (!((String)host).startsWith("http://")) {
            host = "http://" + (String)host;
        }
        String url = (String)host + "/gpro/GPRO_API_V5/public/index.php/gi/to_accession_swissprot/" + URLEncoder.encode(key, "UTF-8");
        return GproApiRequest.doGetRequest(url);
    }

    public static String getEnzymeByGo(String goCode) throws IOException {
        Object host = PreferenceManager.getInstance().get("ssh_host", "http://opathy.uv.es");
        if (!((String)host).startsWith("http://")) {
            host = "http://" + (String)host;
        }
        String url = (String)host + "/gpro/GPRO_API_V5/public/index.php/enzyme/get_by_go/" + URLEncoder.encode(goCode, "UTF-8");
        return GproApiRequest.doGetRequest(url);
    }

    public static String getEnzymeByGo(Collection<String> goCode) throws IOException {
        Object host = PreferenceManager.getInstance().get("ssh_host", "http://opathy.uv.es");
        if (!((String)host).startsWith("http://")) {
            host = "http://" + (String)host;
        }
        String url = (String)host + "/gpro/GPRO_API_V5/public/index.php/enzyme/get_by_gos";
        DoPostRequest postRequest = new DoPostRequest();
        postRequest.setURL(url);
        for (String go : goCode) {
            postRequest.addParamters("gos[]", go);
        }
        return postRequest.doPost();
    }

    public static Collection<Enzyme> getEnzymeByGo(List<String> listGoCodes) {
        HashSet<Enzyme> listEnzymes = new HashSet<Enzyme>();
        for (String goCode : listGoCodes) {
            List<Enzyme> enzymeSubList = GproApiRequest.getEnzymeInstanceByGo(goCode);
            if (enzymeSubList == null) continue;
            listEnzymes.addAll(enzymeSubList);
        }
        return listEnzymes;
    }

    public static String getGoBySwissprotAccession(String swissprotAccession) throws IOException {
        Object host = PreferenceManager.getInstance().get("ssh_host", "http://opathy.uv.es");
        if (!((String)host).startsWith("http://")) {
            host = "http://" + (String)host;
        }
        String url = (String)host + "/gpro/GPRO_API_V5/public/index.php/go/get_by_swissprot_accession/" + URLEncoder.encode(swissprotAccession, "UTF-8");
        return GproApiRequest.doGetRequest(url);
    }

    public static String getGoBySwissprotAccession(List<String> swissprotAccessions) throws IOException {
        Object host = PreferenceManager.getInstance().get("ssh_host", "http://opathy.uv.es");
        if (!((String)host).startsWith("http://")) {
            host = "http://" + (String)host;
        }
        String url = (String)host + "/gpro/GPRO_API_V5/public/index.php/go/get_by_swissprot_accessions";
        DoPostRequest postRequest = new DoPostRequest();
        postRequest.setURL(url);
        for (String accession : swissprotAccessions) {
            postRequest.addParamters("accessions[]", accession);
        }
        return postRequest.doPost();
    }

    public static String getGoByDescription(String description) throws IOException {
        Object host = PreferenceManager.getInstance().get("ssh_host", "http://opathy.uv.es");
        if (!((String)host).startsWith("http://")) {
            host = "http://" + (String)host;
        }
        String url = (String)host + "/gpro/GPRO_API_V5/public/index.php/go/get_by_description/" + URLEncoder.encode(description, "UTF-8");
        return GproApiRequest.doGetRequest(url);
    }

    public static String getGoByDescription(List<String> descriptions) throws IOException {
        Object host = PreferenceManager.getInstance().get("ssh_host", "http://opathy.uv.es");
        if (!((String)host).startsWith("http://")) {
            host = "http://" + (String)host;
        }
        String url = (String)host + "/gpro/GPRO_API_V5/public/index.php/go/get_by_descriptions";
        DoPostRequest postRequest = new DoPostRequest();
        postRequest.setURL(url);
        for (String description : descriptions) {
            postRequest.addParamters("descriptions[]", description);
        }
        return postRequest.doPost();
    }

    public static String getGoDataById(String goId) throws IOException {
        Object host = PreferenceManager.getInstance().get("ssh_host", "http://opathy.uv.es");
        if (!((String)host).startsWith("http://")) {
            host = "http://" + (String)host;
        }
        String url = (String)host + "/gpro/GPRO_API_V5/public/index.php/go/get_go_data/" + URLEncoder.encode(goId, "UTF-8");
        return GproApiRequest.doGetRequest(url);
    }

    public static GoEvidence getGoDataByIdInstance(String goId) {
        try {
            String response = GproApiRequest.getGoDataById(goId);
            Gson gson = new Gson();
            return (GoEvidence)gson.fromJson(response, GoEvidence.class);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static GoEvidence getGoByDescriptionInstance(String description) {
        try {
            String response = GproApiRequest.getGoByDescription(description);
            Gson gson = new Gson();
            return (GoEvidence)gson.fromJson(response, GoEvidence.class);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static List<GoEvidence> getGoByDescriptionInstance(List<String> descriptions) {
        try {
            String response = GproApiRequest.getGoByDescription(descriptions);
            Gson gson = new Gson();
            return (List)gson.fromJson(response, new TypeToken<List<GoEvidence>>(){}.getType());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static GoEvidence getGoBySwissprotAccessionInstance(String swissprotAccession) {
        try {
            String response = GproApiRequest.getGoBySwissprotAccession(swissprotAccession);
            Gson gson = new Gson();
            return (GoEvidence)gson.fromJson(response, GoEvidence.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<GoEvidence> getGoBySwissprotAccessionInstance(List<String> swissprotAccessions) {
        try {
            String response = GproApiRequest.getGoBySwissprotAccession(swissprotAccessions);
            Gson gson = new Gson();
            return (List)gson.fromJson(response, new TypeToken<List<GoEvidence>>(){}.getType());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Enzyme> getEnzymeInstanceByGo(String goCode) {
        try {
            String response = GproApiRequest.getEnzymeByGo(goCode);
            Gson gson = new Gson();
            return (List)gson.fromJson(response, new TypeToken<List<Enzyme>>(){}.getType());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Enzyme> getEnzymeInstanceByGo(Collection<String> goCode) {
        try {
            String response = GproApiRequest.getEnzymeByGo(goCode);
            Gson gson = new Gson();
            return (List)gson.fromJson(response, new TypeToken<List<Enzyme>>(){}.getType());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class AccessionGenbank {
        public String accession_genbank;
    }

    public static class AccessionSwissprot {
        public String accession_swissprot;
    }

    public static class AccessionUniprot {
        public String accession_uniprot;
    }

    public static class Enzyme {
        public String ecid;
        public String ec_desc;
        public String go;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Id: " + this.ecid + "\n");
            builder.append("Description: " + this.ec_desc + "\n");
            builder.append("GO: " + this.go);
            return builder.toString();
        }

        public int hashCode() {
            return this.ecid.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Enzyme && this.ecid != null) {
                return this.ecid.equals(((Enzyme)obj).ecid);
            }
            return false;
        }
    }

    public static class Gene {
        public String gene_name;
    }

    public static class Gi {
        public String gi;
    }

    public static class Go {
        public String go_id;
    }

    public static class GoData {
        public int id;
        public String name;
        public String term_type;
        public String acc;
        public int is_obsolete;
        public int is_root;
        public int is_relation;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Name: " + this.name + "\n");
            builder.append("Term type: " + this.term_type + "\n");
            builder.append("Acc: " + this.acc);
            return builder.toString();
        }
    }

    public static class GoEvidence {
        public String go;
        public String evidence;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GO: " + this.go + "\n");
            builder.append("EV: " + this.evidence);
            return builder.toString();
        }

        public int getGoCount() {
            return StringUtils.countMatches((String)this.go, (String)"GO:");
        }

        public List<String> getGoCodes() {
            return GoEvidence.getGoCodes(this.go);
        }

        public static List<String> getGoCodes(String go) {
            ArrayList<String> listGoCodes = new ArrayList<String>();
            if (go.trim().isEmpty()) {
                return listGoCodes;
            }
            Pattern pattern = Pattern.compile("GO:\\d+");
            Matcher m = pattern.matcher(go);
            int start = 0;
            while (start != -1) {
                if (m.find(start)) {
                    String match = m.group().trim();
                    listGoCodes.add(match);
                    start += match.length();
                    continue;
                }
                start = -1;
            }
            return listGoCodes;
        }

        public List<String> getEnzyme() {
            String[] parts;
            ArrayList<String> listEnzymeCodes = new ArrayList<String>();
            if (this.evidence.trim().isEmpty()) {
                return listEnzymeCodes;
            }
            String[] stringArray = parts = this.evidence.split(";");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                if (!p.trim().isEmpty()) {
                    listEnzymeCodes.add(p.trim());
                }
                ++n2;
            }
            return listEnzymeCodes;
        }
    }

    public static class Interpro {
        public String interpro;
    }
}

