/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.variables;

import com.biotechvana.pipelinestools.utils.PipelineUtils;
import com.biotechvana.utils.StringUtils;
import com.biotechvana.workflow.IBindable;
import com.biotechvana.workflow.VariableCustomAction;
import com.biotechvana.workflow.VariablesRule;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.CheckedJobVariable;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.FolderVariable;
import com.biotechvana.workflow.variables.ListJobVariable;
import com.biotechvana.workflow.variables.MultiListJobVariable;
import com.biotechvana.workflow.variables.NoneTypeJobVariable;
import com.biotechvana.workflow.variables.SimpleVariable;
import com.biotechvana.workflow.variables.StringsJobVariable;
import java.util.ArrayList;
import java.util.List;

public abstract class JobVariable
extends IBindable {
    public static final String PAIRED_FILE_SEP = ",";
    public static final String LISTITEM_VALUE_EOL = "\n";
    public static final String FALSE_VALUE = "false";
    public static final String TRUE_VALUE = "true";
    protected String value = "";
    protected VariableDescriptor desc;
    protected WorkflowJob containerJob;
    String requiredErrorMsg = "field is required.";
    protected boolean _isValid = true;
    protected String errorMsg;
    protected boolean isEnabled = true;
    private boolean isRequired = false;
    private boolean readOnly = false;
    private String warning = "";
    private boolean hasWarnning = false;
    ArrayList<JobVariable> linkedVars = new ArrayList();
    JobVariable mappedToVar = null;
    JobVariable parentVar = null;

    public String toString() {
        String varAsString = "{ key=" + this.getKey() + ",  Type=" + String.valueOf((Object)this.getVarDesc().getVarType()) + ", Role=" + String.valueOf((Object)this.getVarDesc().getVarRole()) + " ";
        if (this.getVarDesc().getVarType() == VariableDescriptor.VariableType.Files && this.desc.getAcceptedFileTypes() != null) {
            varAsString = varAsString + " InputFormat=|";
            for (String fileFormat : this.desc.getAcceptedFileTypes()) {
                varAsString = varAsString + fileFormat + "|";
            }
        }
        return varAsString + " }";
    }

    public static JobVariable createVariable(WorkflowJob containerJob, String name) {
        return new NoneTypeJobVariable(containerJob, name);
    }

    public static JobVariable createVariable(WorkflowJob containerJob, VariableDescriptor varDesc) {
        switch (varDesc.getVarType()) {
            case File: {
                return new FileVariable(containerJob, varDesc);
            }
            case Folder: {
                return new FolderVariable(containerJob, varDesc);
            }
            case FileList: {
                return new FileListVariable(containerJob, varDesc);
            }
            case Int: {
                return new SimpleVariable(containerJob, varDesc);
            }
            case String: {
                return new SimpleVariable(containerJob, varDesc);
            }
            case Strings: {
                return new StringsJobVariable(containerJob, varDesc);
            }
            case Double: {
                return new SimpleVariable(containerJob, varDesc);
            }
            case SelectionList: {
                return new ListJobVariable(containerJob, varDesc);
            }
            case MultiSelectionList: {
                return new MultiListJobVariable(containerJob, varDesc);
            }
            case Checked: {
                return new CheckedJobVariable(containerJob, varDesc);
            }
            case Files: {
                return new FilesVariable(containerJob, varDesc);
            }
            case Folders: {
                return new FileVariable(containerJob, varDesc);
            }
            case Range: {
                return new SimpleVariable(containerJob, varDesc);
            }
        }
        return new NoneTypeJobVariable(containerJob, varDesc);
    }

    protected static void checkType(VariableDescriptor varDesc, VariableDescriptor.VariableType varType) {
        if (varType != varDesc.getVarType()) {
            throw new IllegalArgumentException("Tryping to init an instance of " + String.valueOf((Object)varDesc.getVarType()) + " variable with the wrong Class of Type " + String.valueOf((Object)varType));
        }
    }

    protected JobVariable(WorkflowJob containerJob, VariableDescriptor varDesc) {
        this.containerJob = containerJob;
        this.desc = varDesc;
        if (this.desc.getDefaultValue() != null) {
            this.value = this.desc.getDefaultValue();
        }
        this.isRequired = this.desc.isRequired;
        if (varDesc.getVarType() == VariableDescriptor.VariableType.Checked && this.value.isEmpty()) {
            this.value = FALSE_VALUE;
        }
    }

    protected JobVariable(WorkflowJob containerJob, String name, VariableDescriptor.VariableType varType, VariableDescriptor.VariableRole varRole) {
        this.containerJob = containerJob;
        if (this.desc == null) {
            this.desc = VariableDescriptor.createDescriptorFor(name, varType, varRole);
        }
    }

    public void setValue(String value) {
        String value_modifed;
        if (value == null) {
            value = "";
        }
        value = value.trim();
        if (this.value != null && this.value.equals(value)) {
            return;
        }
        this.warning = "";
        this.hasWarnning = false;
        this.value = value_modifed = this.containerJob.notifyVarValueChanging(this.getKey(), value);
        if (this.desc.getVarType() == VariableDescriptor.VariableType.SelectionList && ((SelectionListVariableDescriptor)this.desc).getOptionValueIndex(value) == -1) {
            String pValue = ((SelectionListVariableDescriptor)this.desc).getOptionValueByCmdParamValue(value);
            this.value = pValue == null ? "" : pValue;
        }
        this.enforceRules();
        for (JobVariable var : this.linkedVars) {
            var.setValue(value);
        }
        this.validate(false);
        if (this.isBinded()) {
            if (this.isVisable()) {
                this.notifyValueChanged();
            } else {
                this.containerJob.notifyVisablitychanged();
            }
        } else if (this.isVisable()) {
            this.containerJob.notifyVisablitychanged();
        }
        if (this._isValid) {
            this.containerJob.notifyVarValueChanged(this.getKey(), this.value);
            this.containerJob.notifyValueschanged();
        }
    }

    public void setValue(boolean value) {
        this.setValue(value ? TRUE_VALUE : FALSE_VALUE);
    }

    public void enforceRules() {
        if (this.desc.hasRules() && this.containerJob != null && this.isEnabled) {
            for (VariablesRule rule : this.desc.getRules()) {
                JobVariable actionVar = this.containerJob.getVariable(rule.getActionVariable().getKey());
                rule.applyRule(this, actionVar);
            }
        }
    }

    public String getValue() {
        if (this.parentVar == null) {
            if (this.hasMapping()) {
                return this.mappedToVar.getValue();
            }
            return this.value;
        }
        if (this.desc.getVarType() == VariableDescriptor.VariableType.Files || this.desc.getVarType() == VariableDescriptor.VariableType.Folders) {
            String newValue = this.value.replaceAll(LISTITEM_VALUE_EOL, LISTITEM_VALUE_EOL + this.parentVar.getValue() + "/");
            return this.parentVar.getValue() + "/" + newValue;
        }
        return this.parentVar.getValue() + "/" + this.value;
    }

    public String getKey() {
        return this.desc.getKey();
    }

    protected VariableDescriptor getVarDesc() {
        return this.desc;
    }

    public WorkflowJob getJob() {
        return this.containerJob;
    }

    public void setDefualt() {
        this.setValue(this.desc.getDefaultValue());
    }

    protected void onValidate() {
    }

    public final void validate() {
        this.validate(true);
    }

    public final void validate(boolean fireValidationChange) {
        boolean wasValid = this._isValid;
        String preErrorMsg = this.errorMsg;
        this._isValid = true;
        if (!this.isEnabled || this.desc.getVarRole() == VariableDescriptor.VariableRole.Output) {
            this._isValid = true;
            this.errorMsg = "";
            return;
        }
        if (this.hasMapping()) {
            boolean mappingValid = this.mappedToVar.isValid();
            if (!mappingValid) {
                this.errorMsg = this.desc.getVariableName() + " Mapping is not Valid";
                this._isValid = false;
                return;
            }
            this.errorMsg = "";
            this._isValid = mappingValid;
            return;
        }
        if (this.isRequired) {
            if (this.value == null) {
                this.errorMsg = this.desc.getVariableName() + " " + this.requiredErrorMsg;
                this._isValid = false;
            }
            if (this.value.isEmpty()) {
                this.errorMsg = this.desc.getVariableName() + " " + this.requiredErrorMsg;
                this._isValid = false;
            }
        }
        this.onValidate();
        if (this._isValid) {
            this.errorMsg = "";
        }
        if (fireValidationChange && this.countObservers() <= 1) {
            if (wasValid != this._isValid) {
                this.notifyValidationChanged();
            }
            if (!this._isValid && preErrorMsg != null && !preErrorMsg.equals(this.errorMsg)) {
                this.notifyValidationChanged();
            }
        }
    }

    public boolean isValid() {
        return this._isValid;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setExternalErrMsg(String string) {
        this.errorMsg = string;
        this._isValid = false;
        this.containerJob.addExternalErrMsg(this.errorMsg);
        this.notifyValidationChanged();
    }

    public boolean hasWarning() {
        return this.hasWarnning;
    }

    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
        this.hasWarnning = true;
        if (warning.isEmpty()) {
            this.hasWarnning = false;
        }
        this.notifyValidationChanged();
    }

    public void reset() {
        this.setDefualt();
        this._isValid = true;
        this.errorMsg = "";
        this.warning = "";
    }

    public void setEnable(boolean isEnabled) {
        this.isEnabled = isEnabled;
        if (this.desc.hasRules()) {
            for (VariablesRule rule : this.getVarDesc().getRules()) {
                if (rule.getAction() != VariablesRule.Action.Enable) continue;
                JobVariable var2 = this.getJob().getVariable(rule.getActionVariable().getKey());
                if (isEnabled) {
                    if (!rule.isTrue(this)) continue;
                    var2.setEnable(isEnabled);
                    continue;
                }
                var2.setEnable(isEnabled);
            }
        }
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
        if (!isRequired) {
            this.requiredErrorMsg = "field is required.";
        }
        this.notifyValueChanged();
    }

    public void setRequired(boolean b, String errorMsgIfNot) {
        this.requiredErrorMsg = errorMsgIfNot;
        this.setRequired(b);
    }

    public void addVarMap(JobVariable inputVar) {
        this.linkedVars.add(inputVar);
        if (this.value != null) {
            inputVar.setValue(this.value);
        }
        if (inputVar.mappedToVar != null) {
            inputVar.mappedToVar.removeVarMap(inputVar);
        }
        inputVar.mappedToVar = this;
    }

    public void removeVarMap(JobVariable inputVar) {
        this.linkedVars.remove(inputVar);
        inputVar.mappedToVar = null;
    }

    public boolean hasMapping() {
        return this.mappedToVar != null;
    }

    public boolean hasMappedVars() {
        return this.linkedVars.size() > 0;
    }

    public boolean isVisable() {
        if (this.hasMapping() && !this.desc.hasRules() || this.desc.getVarRole() == VariableDescriptor.VariableRole.Output || this.desc.getVarRole() == VariableDescriptor.VariableRole.Internal) {
            return false;
        }
        if (this.desc.hasRules() && this.hasMapping()) {
            boolean atLeastOne = false;
            for (VariablesRule rule : this.getVarDesc().getRules()) {
                JobVariable var2;
                if (!rule.isTrue(this) || rule.getAction() != VariablesRule.Action.Enable || !(var2 = this.getJob().getVariable(rule.getActionVariable().getKey())).isVisable()) continue;
                atLeastOne = true;
            }
            return atLeastOne;
        }
        return true;
    }

    @Override
    public void notifyValueChanged() {
        super.notifyValueChanged();
    }

    public String getCMDParamaterValue() {
        Object cmdParamterValue = "";
        if (this.isEnabled && this.desc.getCommandParamater() != null && !this.desc.getCommandParamater().isEmpty() && !this.value.isEmpty() && this.desc.getVarType() != VariableDescriptor.VariableType.Checked) {
            String cmdValue = "";
            if (this.desc.getVarType() == VariableDescriptor.VariableType.Double || this.desc.getVarType() == VariableDescriptor.VariableType.Int || this.desc.getVarType() == VariableDescriptor.VariableType.Double || this.desc.getVarType() == VariableDescriptor.VariableType.String) {
                cmdValue = this.value;
            }
            if (this.desc.getVarType() == VariableDescriptor.VariableType.Strings) {
                cmdValue = this.value.replaceAll("\r", "");
                cmdValue = cmdValue.replaceAll(LISTITEM_VALUE_EOL, PAIRED_FILE_SEP);
            }
            if (this.desc.getVarType() == VariableDescriptor.VariableType.File || this.desc.getVarType() == VariableDescriptor.VariableType.Folder) {
                cmdValue = PipelineUtils.sanitizeFilePathWithTelda(this.containerJob.getWorkflowManager().getUserManager().getHostPathManager().getUserHomePath(), this.value, this.containerJob.getWorkflowManager().getUserManager().getIsChRooted());
            }
            if (this.desc.getVarType() == VariableDescriptor.VariableType.SelectionList) {
                cmdValue = ((SelectionListVariableDescriptor)this.desc).getOptionValueCmdParamValue(this.value);
            }
            if (!cmdValue.isEmpty() || this.desc.getVarType() == VariableDescriptor.VariableType.Checked) {
                cmdParamterValue = " " + this.desc.getCommandParamater() + this.desc.getCommandParamaterSep() + cmdValue + " ";
            }
        }
        if (this.isEnabled && this.desc.getVarType() == VariableDescriptor.VariableType.Checked && this.value.equals(TRUE_VALUE)) {
            cmdParamterValue = " " + this.desc.getCommandParamater() + " ";
        }
        return cmdParamterValue;
    }

    public String getCMDParamaterKeyValueDeclaration() {
        if (this.isEnabled && !this.desc.getCommandParamater().isEmpty()) {
            String cmdValue = this.get_cmdValue();
            if (cmdValue == null || cmdValue.isEmpty()) {
                return "";
            }
            String varArrayValue = this.optionArray_cmd();
            if (this.desc.isSubProg()) {
                varArrayValue = this.optionArray_cmd(this.desc.getSubProgName());
            }
            String cmdParamterValue = "#  " + this.get_cmdValuePrefix() + cmdValue + " \n";
            String ifMappedCheck = "[ -n \"" + cmdValue + "\" ] && ";
            cmdParamterValue = cmdParamterValue + ifMappedCheck + varArrayValue + "=\"" + this.get_cmdValuePrefix() + cmdValue + "\"\n";
            return cmdParamterValue;
        }
        return "";
    }

    public abstract String get_cmdValue();

    protected String get_cmdValuePrefix() {
        return this.desc.getCommandParamater() + this.desc.getCommandParamaterSep();
    }

    public String getCMDParamaterKeyValueDeclaration_oldVersion() {
        Object cmdParamterValue = "";
        if (this.isEnabled && (this.desc.getCommandParamater() != null && !this.desc.getCommandParamater().isEmpty() && !this.value.isEmpty() && this.desc.getVarType() != VariableDescriptor.VariableType.Checked || this.hasMapping() && this.desc.getCommandParamater() != null && !this.desc.getCommandParamater().isEmpty())) {
            String varArrayValue;
            String varArrayKey;
            Object cmdValue = "";
            if (this.desc.getVarType() == VariableDescriptor.VariableType.Double || this.desc.getVarType() == VariableDescriptor.VariableType.Int || this.desc.getVarType() == VariableDescriptor.VariableType.Double || this.desc.getVarType() == VariableDescriptor.VariableType.String) {
                cmdValue = this.value;
            }
            if (this.desc.getVarType() == VariableDescriptor.VariableType.Strings) {
                cmdValue = "${" + this.getBashVarName() + "_all}";
            }
            if (this.desc.getVarType() == VariableDescriptor.VariableType.File || this.desc.getVarType() == VariableDescriptor.VariableType.Folder) {
                cmdValue = PipelineUtils.sanitizeFilePathWithTelda(this.containerJob.getWorkflowManager().getUserManager().getHostPathManager().getUserHomePath(), this.value, this.containerJob.getWorkflowManager().getUserManager().getIsChRooted());
            }
            this.desc.getVarType();
            if (!((String)cmdValue).isEmpty() || this.desc.getVarType() == VariableDescriptor.VariableType.Checked) {
                cmdParamterValue = "#  " + this.desc.getCommandParamater() + this.desc.getCommandParamaterSep() + (String)cmdValue + " \n";
                if (this.desc.getVarType() == VariableDescriptor.VariableType.Strings) {
                    cmdParamterValue = (String)cmdParamterValue + BashHelper.BLOCK_groupArray(this.getBashVarName(), this.getBashVarName() + "_all", PAIRED_FILE_SEP);
                }
                varArrayKey = this.containerJob.getOptionsBashVarName() + "[" + this.desc.getKey() + ",cmdKey]";
                varArrayValue = this.containerJob.getOptionsBashVarName() + "[" + this.desc.getKey() + ",cmdValue]";
                if (this.desc.isSubProg()) {
                    varArrayKey = this.containerJob.getOptionsBashVarName(this.desc.getSubProgName()) + "[" + this.desc.getKey() + ",cmdKey]";
                    varArrayValue = this.containerJob.getOptionsBashVarName(this.desc.getSubProgName()) + "[" + this.desc.getKey() + ",cmdValue]";
                }
                cmdParamterValue = (String)cmdParamterValue + (String)varArrayKey + "=\"" + this.desc.getCommandParamater() + this.desc.getCommandParamaterSep() + "\"\n";
                cmdParamterValue = !this.hasMapping() ? (this.desc.getVarType() == VariableDescriptor.VariableType.Strings ? (String)cmdParamterValue + (String)varArrayValue + "=\"${" + this.getBashVarName() + "_all}\"\n" : (String)cmdParamterValue + (String)varArrayValue + "=\"" + this.$() + "\"\n") : (this.desc.getVarType() == VariableDescriptor.VariableType.Strings ? (String)cmdParamterValue + (String)varArrayValue + "=\"${" + this.mappedToVar.getBashVarName() + "_all}\"\n" : (String)cmdParamterValue + (String)varArrayValue + "=\"" + this.mappedToVar.$() + "\"\n");
                if (this.hasMapping() && this.desc.getVarType() != VariableDescriptor.VariableType.Checked) {
                    cmdParamterValue = (String)cmdParamterValue + "\n[ -n \"${" + (String)varArrayValue + "}\" ] || {\nunset  " + (String)varArrayValue + "\nunset  " + (String)varArrayKey + "\n}\n";
                }
            }
            if (this.hasMapping() && this.value.isEmpty()) {
                varArrayKey = this.containerJob.getOptionsBashVarName() + "[" + this.desc.getKey() + ",cmdKey]";
                varArrayValue = this.containerJob.getOptionsBashVarName() + "[" + this.desc.getKey() + ",cmdValue]";
                if (this.desc.isSubProg()) {
                    varArrayKey = this.containerJob.getOptionsBashVarName(this.desc.getSubProgName()) + "[" + this.desc.getKey() + ",cmdKey]";
                    varArrayValue = this.containerJob.getOptionsBashVarName(this.desc.getSubProgName()) + "[" + this.desc.getKey() + ",cmdValue]";
                }
                cmdParamterValue = "#  " + this.desc.getCommandParamater() + this.desc.getCommandParamaterSep() + (String)cmdValue + " \n";
                cmdParamterValue = (String)cmdParamterValue + varArrayKey + "=\"" + this.desc.getCommandParamater() + this.desc.getCommandParamaterSep() + "\"\n";
                cmdParamterValue = (String)cmdParamterValue + varArrayValue + "=\"" + this.mappedToVar.$() + "\"\n";
            }
        }
        if (this.isEnabled && this.desc.getVarType() == VariableDescriptor.VariableType.Checked && this.value.equals(TRUE_VALUE)) {
            cmdParamterValue = "# " + this.desc.getCommandParamater() + " \n";
            cmdParamterValue = (String)cmdParamterValue + this.containerJob.getOptionsBashVarName() + "[" + this.desc.getKey() + ",cmdKey]=\"" + this.desc.getCommandParamater() + this.desc.getCommandParamaterSep() + "\"\n";
            cmdParamterValue = (String)cmdParamterValue + this.containerJob.getOptionsBashVarName() + "[" + this.desc.getKey() + ",cmdValue]=\" \"\n";
        }
        return cmdParamterValue;
    }

    protected String optionArray_cmd() {
        return this.containerJob.getOptionsBashVarName() + "[" + this.desc.getKey() + "]";
    }

    protected String optionArray_cmd(String subProg) {
        return this.containerJob.getOptionsBashVarName(subProg) + "[" + this.desc.getKey() + "]";
    }

    protected String oa_cmdKey() {
        return this.containerJob.getOptionsBashVarName() + "[" + this.desc.getKey() + ",cmdKey]";
    }

    protected String oa_cmdValue() {
        return this.containerJob.getOptionsBashVarName() + "[" + this.desc.getKey() + ",cmdValue]";
    }

    protected String oa_cmdKey(String subProg) {
        return this.containerJob.getOptionsBashVarName(subProg) + "[" + this.desc.getKey() + ",cmdKey]";
    }

    protected String oa_cmdValue(String subProg) {
        return this.containerJob.getOptionsBashVarName(subProg) + "[" + this.desc.getKey() + ",cmdValue]";
    }

    public final String getBashVarDecleration() {
        String str = "\n#     " + this.desc.getVariableName() + "  Value in " + this.containerJob.getFriendlyName() + " \n";
        if (this.hasMapping()) {
            str = str + "# (" + this.containerJob.getJobID() + "_" + this.desc.getKey() + ") is mapped to " + this.mappedToVar.desc.getVariableName() + " in " + this.mappedToVar.getJob().getFriendlyName() + LISTITEM_VALUE_EOL;
            return str;
        }
        if (this.getValue().isEmpty() && this.getCMDParamaterValue().isEmpty() && this.desc.getVarRole() == VariableDescriptor.VariableRole.Option) {
            return "";
        }
        String varDeclaration = this.onGetBashVarDecleration();
        if (!StringUtils.isEmpty((String)varDeclaration)) {
            str = str + varDeclaration;
            str = str + "\n# ******* " + this.desc.getVariableName() + " *******\n\n";
            return str;
        }
        return "";
    }

    protected abstract String onGetBashVarDecleration();

    public String getBashVarDecleration_oldVersion() {
        if (this.desc.getVarType() == VariableDescriptor.VariableType.Checked && (this.getValue().isEmpty() || this.getValue().equals(FALSE_VALUE))) {
            return "";
        }
        String str = "\n#     " + this.desc.getVariableName() + "  Value in " + this.containerJob.getFriendlyName() + " \n";
        if (this.hasMapping()) {
            str = str + "# (" + this.containerJob.getJobID() + "_" + this.desc.getKey() + ") is mapped to " + this.mappedToVar.desc.getVariableName() + " in " + this.mappedToVar.getJob().getFriendlyName() + LISTITEM_VALUE_EOL;
            return str;
        }
        if (this.getValue().isEmpty() && this.getCMDParamaterValue().isEmpty() && this.desc.getVarRole() == VariableDescriptor.VariableRole.Option) {
            return "";
        }
        String varName = this.getBashVarName();
        if (this.desc.getVarType() == VariableDescriptor.VariableType.Strings) {
            String[] lines = this.value.split(LISTITEM_VALUE_EOL);
            int counter = 0;
            str = str + "# which is an array of Strings \n";
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!(line = line.trim()).isEmpty()) {
                    str = str + varName + "[" + counter + "]=\"" + line + "\" \n";
                    ++counter;
                }
                ++n2;
            }
            str = str + "# ******* " + this.desc.getVariableName() + " *******\n\n";
            return str;
        }
        this.desc.getVarType();
        if (this.desc.getVarType() == VariableDescriptor.VariableType.String || this.desc.getVarType() == VariableDescriptor.VariableType.Int || this.desc.getVarType() == VariableDescriptor.VariableType.Range || this.desc.getVarType() == VariableDescriptor.VariableType.Double || this.desc.getVarType() == VariableDescriptor.VariableType.Checked) {
            str = str + varName + "=\"" + this.value + "\" \n\n";
            return str;
        }
        return "";
    }

    public String getBashVarName() {
        if (this.hasMapping()) {
            return this.mappedToVar.getBashVarName();
        }
        String str = this.containerJob.getJobID() + "_" + this.desc.getKey();
        return str;
    }

    public String getBashVarName(String index) {
        if (this.hasMapping()) {
            return this.mappedToVar.getBashVarName(index);
        }
        String str = this.containerJob.getJobID() + "_" + this.desc.getKey() + "[" + index + "]";
        return str;
    }

    public String $() {
        if (this.hasMapping()) {
            return this.mappedToVar.$();
        }
        String str = "${" + this.containerJob.getJobID() + "_" + this.desc.getKey() + "}";
        return str;
    }

    public String $(String index) {
        if (this.hasMapping()) {
            return this.mappedToVar.$(index);
        }
        String str = "${" + this.containerJob.getJobID() + "_" + this.desc.getKey() + "[" + index + "]}";
        return str;
    }

    public void setRelativeTo(JobVariable variable) {
        this.parentVar = variable;
    }

    public static int numberOfLines(String value) {
        String[] lines = value.split(LISTITEM_VALUE_EOL);
        int counter = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.isEmpty()) {
                ++counter;
            }
            ++n2;
        }
        return counter;
    }

    public VariableDescriptor.VariableRole getDescVarRole() {
        return this.desc.getVarRole();
    }

    public String getDescFriendlyName() {
        return this.desc.getVariableName();
    }

    public boolean descHasEnableActions() {
        return this.desc.hasEnableActions();
    }

    public VariableDescriptor.VariableType getDescVarType() {
        return this.desc.getVarType();
    }

    public boolean getDescGUIVisible() {
        return this.desc.getGUIVisible();
    }

    public String getDescHelpMsg() {
        return this.desc.getHelpMsg();
    }

    public boolean getDescIsRequired() {
        return this.desc.isRequired;
    }

    public ArrayList<String> getDescAcceptedFileTypes() {
        return this.desc.getAcceptedFileTypes();
    }

    public boolean descHasRules() {
        return this.desc.hasRules();
    }

    public ArrayList<VariablesRule> getDescRules() {
        return this.desc.getRules();
    }

    public boolean descHasGroup() {
        return this.desc.hasGroup();
    }

    public String getDescVarGroup() {
        return this.desc.getVarGroup();
    }

    public boolean descHasActions() {
        return this.desc.hasActions();
    }

    public String getDescCommandParamater() {
        return this.desc.getCommandParamater();
    }

    public String getDescCommandParamaterAlt() {
        return this.desc.getCommandParamaterAlt();
    }

    public void setDescVarName(String varName) {
        this.desc.setVariableName(varName);
    }

    public void addRule(VariablesRule variablesRule) {
        this.desc.addRule(variablesRule);
    }

    public void addAction(VariablesRule variablesRule) {
        this.desc.addAction(variablesRule);
    }

    public boolean getHasSampleResources() {
        return this.desc.hasResources();
    }

    public ArrayList<String> getSampleResources() {
        return this.desc.getSampleResources();
    }

    public String getSampleResourcesName(String sample) {
        return this.desc.getSampleResourcesName(sample);
    }

    public String getPropertiesAsBashVar() {
        return "";
    }

    public String getFullKey() {
        String fullKey = this.containerJob.getFullKey() + "." + this.getKey();
        return fullKey;
    }

    public void setAtts(String atts) {
    }

    public String getAtts() {
        return "";
    }

    public boolean getDescIsTracked() {
        return this.desc.getIsTracked();
    }

    public boolean skipOutputCkeck() {
        return this.hasMapping() && this.mappedToVar.getDescVarRole() == VariableDescriptor.VariableRole.Input && this.mappedToVar.containerJob == this.containerJob;
    }

    public String getDescBlankDefaultValue() {
        if (this.getDescHelpMsg() == null) {
            return "";
        }
        String[] tokens = this.getDescHelpMsg().toLowerCase().split("default");
        if (tokens.length > 1) {
            String def = tokens[1];
            if ((def = def.replace("is", "").trim()).split(" ").length > 1) {
                return "";
            }
            return def;
        }
        return "";
    }

    public String getDescShortHelpMsg() {
        return this.desc.getShortHelpMsg();
    }

    public boolean hasCommandParameter() {
        return !this.getDescCommandParamater().isEmpty() || !this.getDescCommandParamaterAlt().isEmpty();
    }

    public boolean hasCustomGUIActions() {
        return this.desc.getCustomActions() != null && this.desc.getCustomActions().size() > 0;
    }

    public List<VariableCustomAction> getCustomActions() {
        return this.desc.getCustomActions();
    }

    public String getSubProgName() {
        return this.desc.getSubProgName();
    }

    public boolean isReadOnly() {
        return this.desc.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.desc.setReadOnly(readOnly);
    }

    public void refresh() {
        if (this.containerJob != null) {
            this.containerJob.notifyVisablitychanged();
        }
    }
}

