/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.variables;

import com.biotechvana.pipelinestools.utils.PipelineUtils;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.variables.FileVariable;
import java.util.List;

public class FileListVariable
extends FileVariable {
    public FileListVariable(WorkflowJob containerJob, VariableDescriptor varDesc) {
        super(containerJob, varDesc);
    }

    @Override
    public String getAtts() {
        Object atts = "(";
        atts = (String)atts + "FileFormat:" + this.getFileFormat() + ",";
        atts = (String)atts + "IsPairedFiles:" + this.getIsPairedFiles() + ",";
        atts = (String)atts + "ShowPairingOptions:" + this.getShowPairingOptions();
        return (String)atts + ")";
    }

    @Override
    public void setAtts(String attStr) {
        attStr = attStr.substring(1, attStr.length() - 2);
        System.out.println(attStr);
        String[] atts = attStr.split(":|,");
        int i = 0;
        while (i < atts.length) {
            if (atts[i].equals("FileFormat")) {
                this.setFileFormat(atts[++i]);
            }
            if (atts[i].equals("IsPairedFiles")) {
                if (atts[++i].equals("true")) {
                    this.setIsPairedFiles(true);
                } else {
                    this.setIsPairedFiles(false);
                }
            }
            if (atts[i].equals("ShowPairingOptions")) {
                if (atts[++i].equals("true")) {
                    this.setShowPairingOptions(true);
                } else {
                    this.setShowPairingOptions(false);
                }
            }
            ++i;
        }
    }

    @Override
    public String getCountAsBashVarName() {
        if (this.hasMapping()) {
            return ((FileVariable)this.mappedToVar).getCountAsBashVarName();
        }
        return "$(getaArrayCount " + this.getBashVarName() + " )";
    }

    @Override
    protected String onGetBashVarDecleration() {
        String varName = this.getBashVarName();
        Object str = "";
        if (this.desc.getVarType() == VariableDescriptor.VariableType.FileList) {
            String[] lines = this.value.split("\n");
            int counter = 0;
            str = (String)str + "# which is an array of Files/Folders \n";
            str = (String)str + "declare -A " + this.getBashVarName() + " \n";
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!line.isEmpty()) {
                    String[] pairedFiles = line.split(",");
                    if (pairedFiles.length > 0) {
                        str = (String)str + varName + "[0," + counter + "]=\"" + PipelineUtils.sanitizeFilePathWithTelda(this.containerJob.getWorkflowManager().getUserManager().getHostPathManager().getUserHomePath(), pairedFiles[0], this.containerJob.getWorkflowManager().getUserManager().getIsChRooted()) + "\" \n";
                    }
                    if (pairedFiles.length > 1) {
                        str = (String)str + varName + "[1," + counter + "]=\"" + PipelineUtils.sanitizeFilePathWithTelda(this.containerJob.getWorkflowManager().getUserManager().getHostPathManager().getUserHomePath(), pairedFiles[1], this.containerJob.getWorkflowManager().getUserManager().getIsChRooted()) + "\" \n";
                    }
                    ++counter;
                }
                ++n2;
            }
            str = (String)str + this.getFormatAsBashVarNameOnly() + "=\"" + this.getFileFormat() + "\"\n";
            return str;
        }
        return "";
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (!(value = value.trim()).isEmpty()) {
            if (value.contains(",")) {
                this.setIsPairedFiles(true);
            } else {
                this.setIsPairedFiles(false);
            }
        }
        super.setValue(value);
    }

    public String[][] getPairedFileLists() {
        String[] files = this.getValue().split("\n");
        String[][] pairedLists = new String[2][files.length];
        int i = 0;
        while (i < files.length) {
            String line = files[i];
            pairedLists[0][i] = "";
            pairedLists[1][i] = "";
            if (!line.isEmpty()) {
                String[] pairedFiles = line.split(",");
                if (pairedFiles.length == 2) {
                    if (!pairedFiles[0].isEmpty()) {
                        pairedLists[0][i] = pairedFiles[0];
                    }
                    if (!pairedFiles[1].isEmpty()) {
                        pairedLists[1][i] = pairedFiles[1];
                    }
                } else if (line.startsWith(",")) {
                    pairedLists[1][i] = pairedFiles[0];
                } else {
                    String[] stringArray = pairedLists[0];
                    int n = i;
                    stringArray[n] = String.valueOf(stringArray[n]) + pairedFiles[0];
                }
            }
            ++i;
        }
        return pairedLists;
    }

    public void setValue(List<String> lines1, List<String> lines2) {
        Object val = "";
        int largerSize = lines1.size() > lines2.size() ? lines1.size() : lines2.size();
        int i = 0;
        while (i < largerSize) {
            Object consValue = "";
            consValue = lines1.size() > i ? lines1.get(i) : "";
            consValue = (String)consValue + ",";
            consValue = lines2.size() > i ? (String)consValue + lines2.get(i) : (String)consValue;
            val = (String)val + (String)consValue + "\n";
            ++i;
        }
        this.setValue((String)val);
    }

    public void setValue(List<String> lines1) {
        Object val = "";
        int i = 0;
        while (i < lines1.size()) {
            String consValue = lines1.get(i);
            val = (String)val + consValue + "\n";
            ++i;
        }
        this.setValue((String)val);
    }
}

