/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.tracking.tasks;

import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;
import com.biotechvana.workflow.tracking.tasks.WorkflowJobTracker;
import com.biotechvana.workflow.tracking.tasks.WorkflowTracker;

public abstract class TaskTracker {
    String templateId;
    String taskId;
    long startTimeStamp;
    long finishTimeStamp;

    public TaskTracker(SubmissionHistoryEntry entry) {
        this.startTimeStamp = entry.getSubmissionTimeStamp();
        this.templateId = entry.getTaskTemplateId();
        this.taskId = entry.getTaskName();
    }

    public static TaskTracker toTaskTracker(WorkflowJob workflowjob, SubmissionHistoryEntry entry) {
        TaskTracker taskTracker = null;
        taskTracker = entry.getTaskType() == SubmissionHistoryEntry.TaskType.Job ? new WorkflowJobTracker(workflowjob, entry) : new WorkflowTracker(entry);
        taskTracker.init(entry);
        return taskTracker;
    }

    protected abstract void init(SubmissionHistoryEntry var1);

    public String getTaskId() {
        return this.taskId;
    }
}

