/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.tracking.events;

import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.tracking.TrackerInfoEntry;
import com.biotechvana.workflow.tracking.events.CMDInfoTrackEvent;
import com.biotechvana.workflow.tracking.events.VarInfoTrackEvent;

public class InfoTrackEvent
extends TrackerInfoEntry {
    public static final String INFO_INPUT_TYPE = "Input";
    public static final String INFO_PROCESS_TYPE = "Process";
    public static final String INFO_OUTPUT_TYPE = "Output";
    Tracking.TrackInfoType infoType;

    protected InfoTrackEvent(String[] tokens) {
        super(tokens);
        if (tokens.length > 2) {
            this.infoType = Tracking.TrackInfoType.valueOf(tokens[2]);
            if (tokens.length > 3) {
                this.logMsg = tokens[3];
            }
        }
    }

    public Tracking.TrackInfoType getInfoType() {
        return this.infoType;
    }

    public static TrackerInfoEntry create(String[] tokens) {
        Tracking.TrackInfoType infoType = Tracking.TrackInfoType.valueOf(tokens[2]);
        if (infoType == Tracking.TrackInfoType.Process) {
            return new CMDInfoTrackEvent(tokens);
        }
        if (infoType == Tracking.TrackInfoType.Input || infoType == Tracking.TrackInfoType.Output || infoType == Tracking.TrackInfoType.Parameter) {
            return new VarInfoTrackEvent(tokens);
        }
        return new InfoTrackEvent(tokens);
    }
}

