/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.manager;

import com.biotechvana.layer.xml.impl.XMLLayerImpl;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.manager.WorkflowManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;

public abstract class JobsCatalog {
    private static JobsCatalog jobsCatalog = null;
    ArrayList<JobCategory> categories = new ArrayList();
    protected ArrayList<JobCatalogItem> jobsItems = new ArrayList();
    protected ClassLoader classLoader;
    WorkflowManager workflowManager;
    protected static HashMap<String, Object> toolboxPerApp = new HashMap();
    protected static String defaultToolBoxId;

    protected abstract void initCatalog();

    protected JobsCatalog() {
        this.initCatalog();
    }

    public JobsCatalog(ClassLoader classLoader) {
        this();
        this.classLoader = classLoader;
    }

    public String getJobFullName(String jobDescID) {
        String className = null;
        for (JobCatalogItem item : this.jobsItems) {
            if (!item.getJobID().equals(jobDescID)) continue;
            className = item.getClassFullName();
            break;
        }
        return className;
    }

    public WorkflowJob createJobInstanceById(String jobDescID, Object ... params) {
        String className = this.getJobFullName(jobDescID);
        if (className == null) {
            throw new NoSuchElementException("Can not Find Job Description defined by " + jobDescID);
        }
        WorkflowJob newJob = null;
        ClassLoader classLoader = this.classLoader;
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        newJob = JobsCatalog.createJobInstanceFromClass(className, classLoader, params);
        newJob.setWorkflowManager(this.workflowManager);
        WorkflowJob.commonVarInit(newJob);
        return newJob;
    }

    public WorkflowJob createJobInstanceByFullName(String className, Object ... params) {
        ClassLoader classLoader;
        if (className != null) {
            className.isEmpty();
        }
        if ((classLoader = this.classLoader) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        WorkflowJob newJob = JobsCatalog.createJobInstanceFromClass(className, classLoader, params);
        newJob.setWorkflowManager(this.workflowManager);
        WorkflowJob.commonVarInit(newJob);
        return newJob;
    }

    private static WorkflowJob createJobInstanceFromClass(String className, ClassLoader classLoader, Object[] params) {
        try {
            Constructor<?> con;
            WorkflowJob newJob = null;
            Class<?> classDef = Class.forName(className, true, classLoader);
            Constructor<?>[] cons = classDef.getDeclaredConstructors();
            Constructor<?> defaultCon = null;
            Constructor<?>[] constructorArray = cons;
            int n = cons.length;
            int n2 = 0;
            while (n2 < n) {
                con = constructorArray[n2];
                if (con.getParameterCount() == 0) {
                    defaultCon = con;
                }
                ++n2;
            }
            if (params == null || params.length == 0) {
                if (defaultCon != null) {
                    newJob = (WorkflowJob)defaultCon.newInstance(new Object[0]);
                }
            } else {
                constructorArray = cons;
                n = cons.length;
                n2 = 0;
                while (n2 < n) {
                    con = constructorArray[n2];
                    if (con.getParameterCount() == params.length) {
                        try {
                            newJob = (WorkflowJob)con.newInstance(params);
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                    }
                    ++n2;
                }
                if (newJob == null && defaultCon != null) {
                    newJob = (WorkflowJob)defaultCon.newInstance(new Object[0]);
                }
            }
            return newJob;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.out.println(e);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            System.out.println(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            System.out.println(e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        throw new NoSuchElementException("Can not init new job defined by " + className);
    }

    public void setWorkflowManager(WorkflowManager workflowManager) {
        this.workflowManager = workflowManager;
    }

    public static Object getToolboxById(String toolBoxId) {
        if (toolboxPerApp.containsKey(toolBoxId)) {
            return toolboxPerApp.get(toolBoxId);
        }
        return toolboxPerApp.get(defaultToolBoxId);
    }

    public boolean hasJobById(String taskId) {
        for (JobCatalogItem item : this.jobsItems) {
            if (!item.getJobID().equals(taskId)) continue;
            return true;
        }
        return false;
    }

    public void addJobsItem(JobCatalogItem jobItem) {
        this.jobsItems.add(jobItem);
        if (jobItem.category != null && !this.categories.contains(jobItem.category)) {
            this.categories.add(jobItem.category);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected void exportAllXML() {
        try {
            XMLLayerImpl xmlLayer = new XMLLayerImpl();
            for (JobCatalogItem jobItem : this.jobsItems) {
                WorkflowJob testJob = this.createJobInstanceByFullName(jobItem.className, new Object[0]);
                String outPath = "/home/data/git/genei_chatboot/genie_src/tasks/xmls/" + testJob.getJobDescID() + ".xml";
                System.err.println("Exporting " + outPath);
                xmlLayer.saveToXML(testJob.getJobDesc(), outPath);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public class JobCatalogItem {
        String jobID;
        String jobName;
        String className;
        JobCategory category;

        public JobCatalogItem(String jobName, String jobID, String className) {
            this.jobID = jobID;
            this.jobName = jobName;
            this.className = className;
        }

        public JobCatalogItem(String jobName, String jobID, String className, JobCategory category) {
            this(jobName, jobID, className);
            this.category = category;
        }

        public String getClassFullName() {
            return this.className;
        }

        public String getJobID() {
            return this.jobID;
        }
    }

    public class JobCategory {
        String categoryName;

        public JobCategory(String categoryName) {
            this.categoryName = categoryName;
        }

        public String getCategoryName() {
            return this.categoryName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + (this.categoryName == null ? 0 : this.categoryName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JobCategory other = (JobCategory)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            return !(this.categoryName == null ? other.categoryName != null : !this.categoryName.equals(other.categoryName));
        }

        private JobsCatalog getEnclosingInstance() {
            return JobsCatalog.this;
        }
    }
}

