/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.executer;

import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.variables.JobVariable;
import java.util.regex.Pattern;

public class BashConditions {
    public static String Equal(String lhsStr, String rhsStr) {
        return "[ \"" + lhsStr + "\" = \"" + rhsStr + "\" ]";
    }

    public static String notEqual(String lhsStr, String rhsStr) {
        return "[ ! \"" + lhsStr + "\" = \"" + rhsStr + "\" ]";
    }

    public static String Equal(JobVariable lhSVariable, String rhsStr) {
        if (lhSVariable.getDescVarType() == VariableDescriptor.VariableType.Checked) {
            if (rhsStr.equals("true")) {
                return BashConditions.True(lhSVariable);
            }
            return BashConditions.False(lhSVariable);
        }
        return "[ \"" + lhSVariable.$() + "\" = \"" + rhsStr + "\" ]";
    }

    public static String True(JobVariable lhSVariable) {
        return "[ \"" + lhSVariable.$() + "\" = \"true\" ]";
    }

    public static String False(JobVariable lhSVariable) {
        return "[ \"" + lhSVariable.$() + "\" != \"true\" ]";
    }

    public static String notEmptyStr(JobVariable jobVariable) {
        return "[ -n \"" + jobVariable.$() + "\" ]";
    }

    public static String notEmptyStr(String varName) {
        return "[ -n \"" + varName + "\" ]";
    }

    public static String emptyStr(JobVariable jobVariable) {
        return "[ -z \"" + jobVariable.$() + "\" ]";
    }

    public static String emptyStr(String varName) {
        return "[ -z \"" + varName + "\" ]";
    }

    public static String emptyList(JobVariable jobVariable) {
        return "[ ${#" + jobVariable.getBashVarName() + "[@]} == 0 ]";
    }

    public static String emptyList(String varName) {
        return "[ ${#" + varName + "[@]} == 0 ]";
    }

    public static String fileExist(String varFileName) {
        return "[ -f \"" + varFileName + "\" ]";
    }

    public static String fileNotExist(String varFileName) {
        return "[ ! -f \"" + varFileName + "\" ]";
    }

    public static String fileNotExist(JobVariable variable) {
        return "[ ! -f \"" + variable.$() + "\" ]";
    }

    public static String or(String cond1, String cond2) {
        cond1 = cond1.replaceAll(Pattern.quote("["), "(");
        cond2 = cond2.replaceAll(Pattern.quote("["), "(");
        cond1 = cond1.replaceAll(Pattern.quote("]"), ")");
        cond2 = cond2.replaceAll(Pattern.quote("]"), ")");
        return "[ " + cond1 + " || " + cond2 + " ]";
    }
}

