/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.descriptors;

import com.biotechvana.workflow.descriptors.VariableDescriptor;

public class CheckedVariableDescriptor
extends VariableDescriptor {
    public static final String YES_NO = "yes_no";
    public static final String T_F = "T_F";
    public static final String on_off = "on_off";
    public static String true_false = "true_false";
    public static String p_0_1 = "p_0_1";
    private boolean explicitMode = false;
    String true_postfix = "";
    String false_postfix = "";

    public CheckedVariableDescriptor(String key, VariableDescriptor.VariableRole varRole) {
        super(key, varRole);
        this.varType = VariableDescriptor.VariableType.Checked;
    }

    public CheckedVariableDescriptor setDefaultValue(boolean value) {
        if (value) {
            this.setDefaultValue("true");
        } else {
            this.setDefaultValue("false");
        }
        return this;
    }

    public CheckedVariableDescriptor setExplicitMode(boolean explicitMode) {
        this.explicitMode = explicitMode;
        return this;
    }

    public CheckedVariableDescriptor setCommandPostfix(String postFix) {
        if (YES_NO.equals(postFix)) {
            this.true_postfix = "yes";
            this.false_postfix = "no";
        } else if (T_F.equals(postFix)) {
            this.true_postfix = "T";
            this.false_postfix = "F";
        } else if (on_off.equals(postFix)) {
            this.true_postfix = "on";
            this.false_postfix = "off";
        } else if (true_false.equals(postFix)) {
            this.true_postfix = "true";
            this.false_postfix = "false";
        } else if (p_0_1.equals(postFix)) {
            this.true_postfix = "1";
            this.false_postfix = "0";
        }
        return this;
    }

    public String getTruePostFix() {
        return this.true_postfix;
    }
}

