/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow;

import com.biotechvana.users.UserManager;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.StringVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class WorkflowStartupJob
extends ISWFJob {
    public static final String INPUT_FASTQ_FILE = "INPUT_FILES";
    public static final String INPUT_LIBRARY_NAMES = "INPUT_LIBRARY_NAMES";
    public static final String OUTPUT_FILES = "OUTPUT_FILES";

    public WorkflowStartupJob(String JOB_ID, String customName) {
        super(JOB_ID, customName);
        this.jobDesc.setDesc("Basic Options for setting Output folder, project name  and  Notification email for the pipeline");
    }

    @Override
    protected void createRules() {
        this.addVariableMap("INPUT_CUSTOM_JOB_NAME", this.getVariable("PROJECT_NAME"));
    }

    @Override
    protected void createInputs() {
        StringVariableDescriptor var = VariableDescriptor.String("PROJECT_NAME", VariableDescriptor.VariableRole.Input);
        var.setVariableName("Project Name");
        var.isRequired = true;
        var.setVariableGroup("Output");
        var.setDefaultValue("");
        var.setHelpMsg("Project name; used to  name the output folder of the running pipeline.");
        this.jobDesc.addVariable(var);
    }

    @Override
    protected void createOutputs() {
    }

    @Override
    protected void createOptions() {
    }

    @Override
    protected final void generateCommand(StringBuilder builder) {
        if (this.getWorkflow() != null) {
            builder.append("pipelineFolder=\"" + this.getVariable("JOB_OUTPUT_FOLDER").$() + "/00_data\" \n");
            builder.append("[ -d \"${pipelineFolder}\" ] || mkdir \"${pipelineFolder}\" \n");
            builder.append("echo \"README :\" > \"${pipelineFolder}/README\"   \n");
            UserManager.RemotePathManager hostPathManager = this.workflowManager.getUserManager().getHostPathManager();
            String userPipelineFile = hostPathManager.sanitizeFilePathWithTelda(hostPathManager.getRemoteUserSubmittedPipelinesFolder("${task_Id}.gpiw"));
            String userProjectCongif = hostPathManager.sanitizeFilePathWithTelda(hostPathManager.getRemoteUserSubmittedProjectFolder(this.getVariable("PROJECT_NAME").$() + ".config"));
            builder.append("[ -f \"" + userPipelineFile + "\" ] && cp   \"" + userPipelineFile + "\"    \"${pipelineFolder}\" \n");
            builder.append("[ -f \"" + userProjectCongif + "\" ] && cp   \"" + userProjectCongif + "\"    \"${pipelineFolder}\" \n");
        }
        this.workflowStartupJobOnGenerateCommand(builder);
        if (this.getWorkflow() != null) {
            for (JobVariable variable : this.getInputVariables()) {
                if (!(variable instanceof FileListVariable)) continue;
                builder.append(BashHelper.Batcher_noLog((FileListVariable)variable, "", "[ -f ${_inputFile} ] && ln -s ${_inputFile} ${pipelineFolder}/ \n", "", true));
            }
        }
    }

    protected void workflowStartupJobOnGenerateCommand(StringBuilder builder) {
    }
}

