/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow;

import com.biotechvana.utils.StringUtils;
import java.util.Properties;

public class WorkflowMetadata
extends Properties {
    private static final long serialVersionUID = 3225511559141988863L;
    public static final String TemplateID_KEY = "TemplateID";
    static final String TAG_KEY = "Tags";
    static final String CATS_KEY = "Categories";
    static final String CHAR_KEY = "Characteristics";
    static final String ID_KEY = "PipelineID";
    static final String DESC_KEY = "Desc";
    static final String AUTHOR_KEY = "Author";
    static final String Ref_KEY = "Ref";
    static final String NAME_KEY = "Name";

    public WorkflowMetadata() {
        this.setProperty(TAG_KEY, "");
        this.setProperty(CHAR_KEY, "");
        this.setProperty(CATS_KEY, "");
    }

    public WorkflowMetadata(String pipelineID) {
        this.setProperty(ID_KEY, pipelineID);
        this.setProperty(TemplateID_KEY, pipelineID);
        this.setProperty(TAG_KEY, "");
        this.setProperty(CHAR_KEY, "");
        this.setProperty(CATS_KEY, "");
    }

    public WorkflowMetadata(int pipelineID) {
        this.setProperty(ID_KEY, "" + pipelineID);
        this.setProperty(TemplateID_KEY, "" + pipelineID);
        this.setProperty(TAG_KEY, "");
        this.setProperty(CHAR_KEY, "");
        this.setProperty(CATS_KEY, "");
    }

    public String getPipelineID() {
        return this.getProperty(ID_KEY);
    }

    public void setPipelineID(String id) {
        this.setProperty(ID_KEY, id);
    }

    public void setDesc(String desc) {
        this.setProperty(DESC_KEY, desc);
    }

    public String getDesc() {
        return this.getProperty(DESC_KEY);
    }

    public void setAuthor(String author) {
        this.setProperty(AUTHOR_KEY, author);
    }

    public String getAuthor() {
        return this.getProperty(AUTHOR_KEY);
    }

    public void setRef(String ref) {
        this.setProperty(Ref_KEY, ref);
    }

    public String getRef() {
        return this.getProperty(Ref_KEY);
    }

    public void setName(String name) {
        this.setProperty(NAME_KEY, name);
    }

    public String getName() {
        return this.getProperty(NAME_KEY);
    }

    public void addChar(String prob) {
        if (prob.isEmpty()) {
            return;
        }
        Object chars = this.getProperty(CHAR_KEY);
        chars = (String)chars + ";" + prob.toLowerCase();
        this.setProperty(CHAR_KEY, (String)chars);
    }

    public boolean hasChars(String prob) {
        String chars = this.getProperty(CHAR_KEY);
        return chars.contains(prob.toLowerCase());
    }

    public void addTag(String tag) {
        if (tag.isEmpty()) {
            return;
        }
        Object tags = this.getProperty(TAG_KEY);
        if (((String)tags).contains(tag.toLowerCase())) {
            return;
        }
        tags = ((String)tags).isEmpty() ? tag.toLowerCase() : (String)tags + ";" + tag.toLowerCase();
        this.setProperty(TAG_KEY, (String)tags);
    }

    public boolean hasTag(String tag) {
        if (StringUtils.isBlank((String)tag)) {
            return false;
        }
        String tags = this.getProperty(TAG_KEY);
        return tags.contains(tag.toLowerCase());
    }

    public void setTemplateId(String pipelineID) {
        this.setProperty(TemplateID_KEY, pipelineID);
    }

    public String getTemplateId() {
        return this.getProperty(TemplateID_KEY);
    }

    public void addCategory(String cat) {
        if (cat.isEmpty()) {
            return;
        }
        Object cats = this.getProperty(CATS_KEY);
        if (((String)cats).contains(cat.toLowerCase())) {
            return;
        }
        cats = ((String)cats).isEmpty() ? cat.toLowerCase() : (String)cats + ";" + cat.toLowerCase();
        this.setProperty(CATS_KEY, (String)cats);
    }

    public boolean hasCategory(String cat) {
        String cats = this.getProperty(CATS_KEY);
        return cats.contains(cat.toLowerCase());
    }
}

