/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow;

import com.biotechvana.pipelinestools.utils.PipelineExecutor;
import com.biotechvana.users.InvalidLoginInfoException;
import com.biotechvana.users.UserManager;
import com.biotechvana.utils.Constants;
import com.biotechvana.utils.PreferenceManager;
import com.biotechvana.utils.StringUtils;
import com.biotechvana.workflow.ITaskBindable;
import com.biotechvana.workflow.ITaskExecutor;
import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.Workflow;
import com.biotechvana.workflow.descriptors.FolderVariableDescriptor;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.RangeVariableDescriptor;
import com.biotechvana.workflow.descriptors.StringVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.FolderVariable;
import com.biotechvana.workflow.variables.JobVariable;
import com.biotechvana.workflow.variables.SimpleVariable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public abstract class WorkflowJob
extends ITaskBindable
implements ITaskExecutor {
    public static final String DOUBLE_QUATE = "\"";
    public static final String OPTION_AUTO = "auto";
    public static final String NO_CMD_PROG = "_NO_CMD_";
    protected static final String outputFolder = "outputFolder";
    private Workflow workflow = null;
    protected JobDescriptor jobDesc = null;
    protected String jobName;
    protected String jobId;
    private HashMap<String, JobVariable> variables = new LinkedHashMap<String, JobVariable>();
    private HashMap<Integer, JobVariable> orderedVariables = new LinkedHashMap<Integer, JobVariable>();
    private HashMap<String, List<JobVariable>> paramSwitchToVariables = new HashMap();
    private HashMap<String, JobVariable> groupsToVariables = new LinkedHashMap<String, JobVariable>();
    private HashMap<String, JobVariable> subProgToVariables = new HashMap();
    private ArrayList<String> groupsName = new ArrayList();
    private ArrayList<String> subProgsName = new ArrayList();
    private int varCount = 0;
    protected IWorkflowManager workflowManager;
    private HashMap<String, JobVariable> variablesMap = new HashMap();
    protected HashMap<String, WorkflowJob> preJobs = new HashMap();
    protected HashMap<String, WorkflowJob> postJobs = new HashMap();
    protected ArrayList<String> allErrorsMsg = new ArrayList();
    boolean validation_before = false;
    final boolean __DEBUG__ = true;
    protected boolean isParallelJob = true;

    public String toString() {
        return "WorkflowJob [jobName=" + this.jobName + ", jobId=" + this.jobId + "]";
    }

    protected WorkflowJob() {
    }

    public WorkflowJob(JobDescriptor jobDesc) {
        this.jobDesc = jobDesc;
        this.initJobFromDesc(jobDesc);
    }

    protected void initJobFromDesc(JobDescriptor jobDesc) {
        this.jobId = jobDesc.jobId;
        this.initJobFromDesc(jobDesc, true, true, this.isParallelJob);
    }

    protected void initJobFromDesc(JobDescriptor jobDesc, boolean createEmailVar, boolean createOutputFolderVar, boolean createParallelOption) {
        this.jobId = jobDesc.jobId;
        if (createOutputFolderVar) {
            VariableDescriptor outputfolderVar = WorkflowJob.createInputOutputFolderVar();
            jobDesc.addVariable(outputfolderVar);
            VariableDescriptor outputfolderNameVar = WorkflowJob.createCustomOutputFolderNameVar();
            outputfolderNameVar.setHelpMsg(outputfolderNameVar.getHelpMsg() + " Default " + this.jobId);
            jobDesc.addVariable(outputfolderNameVar);
        }
        if (createEmailVar) {
            VariableDescriptor emailNotification = WorkflowJob.createNotificatinEmailVar();
            jobDesc.addVariable(emailNotification);
        }
        if (createParallelOption) {
            jobDesc.addVariable(WorkflowJob.createUserMaxNumSpawnProcessesVar());
        }
        for (VariableDescriptor varDesc : jobDesc.getAllVariables()) {
            this.addVariable(varDesc);
        }
        if (createOutputFolderVar) {
            this.getVariable("INPUT_CUSTOM_JOB_NAME").setValue(this.getJobDescID());
        }
    }

    private void enforceRules() {
        for (JobVariable var : this.getAllVariables()) {
            var.enforceRules();
        }
    }

    public JobDescriptor getJobDesc() {
        return this.jobDesc;
    }

    public String notifyVarValueChanging(String varKey, String newValue) {
        return newValue;
    }

    public boolean notifyVarValueChanged(String varKey, String value) {
        return true;
    }

    public void setValue(String key, String value) {
        if (this.variables.containsKey(key)) {
            JobVariable var = this.variables.get(key);
            var.setValue(value);
        } else {
            JobVariable var = JobVariable.createVariable(this, key);
            var.setValue(value);
            this.variables.put(var.getKey(), var);
            this.orderedVariables.put(this.varCount, var);
            ++this.varCount;
        }
    }

    public void setValueByCMDSwitch(String cmdSwitch, String value) {
        JobVariable var = this.getVariableByCMDSwitch(cmdSwitch);
        if (var != null) {
            var.setValue(value);
        }
    }

    public JobVariable getVariableByCMDSwitch(String cmdSwith) {
        if (this.paramSwitchToVariables.containsKey(cmdSwith)) {
            List<JobVariable> vars = this.paramSwitchToVariables.get(cmdSwith);
            if (vars.size() == 1) {
                return vars.get(0);
            }
            for (JobVariable var : vars) {
                if (var.getSubProgName() == null) continue;
                return var;
            }
        }
        return null;
    }

    public JobVariable getVariableByCMDSwitch(String cmdSwith, String subProg) {
        if (this.paramSwitchToVariables.containsKey(cmdSwith)) {
            List<JobVariable> vars = this.paramSwitchToVariables.get(cmdSwith);
            for (JobVariable var : vars) {
                if (var.getSubProgName() != subProg) continue;
                return var;
            }
        }
        return null;
    }

    public void setValue(String key, boolean value) {
        this.setValue(key, value ? "true" : "false");
    }

    protected void addVariable(VariableDescriptor varDesc) {
        if (this.hasVariable(varDesc.getKey())) {
            return;
        }
        JobVariable var = JobVariable.createVariable(this, varDesc);
        this.variables.put(var.getKey(), var);
        if (!this.jobDesc.hasVar(var.getKey())) {
            this.jobDesc.addVariable(varDesc);
        }
        this.orderedVariables.put(this.varCount, var);
        if (!var.getDescCommandParamater().isEmpty()) {
            if (!this.paramSwitchToVariables.containsKey(var.getDescCommandParamater())) {
                this.paramSwitchToVariables.put(var.getDescCommandParamater(), new ArrayList());
            }
            this.paramSwitchToVariables.get(var.getDescCommandParamater()).add(var);
        }
        if (!var.getDescCommandParamaterAlt().isEmpty()) {
            if (!this.paramSwitchToVariables.containsKey(var.getDescCommandParamaterAlt())) {
                this.paramSwitchToVariables.put(var.getDescCommandParamaterAlt(), new ArrayList());
            }
            this.paramSwitchToVariables.get(var.getDescCommandParamaterAlt()).add(var);
        }
        if (varDesc.isSubProg()) {
            this.subProgToVariables.put(varDesc.getSubProgName(), var);
            if (!this.subProgsName.contains(varDesc.getSubProgName())) {
                this.subProgsName.add(varDesc.getSubProgName());
            }
        }
        if (varDesc.hasGroup()) {
            this.groupsToVariables.put(varDesc.getVarGroup(), var);
            if (!this.groupsName.contains(varDesc.getVarGroup())) {
                this.groupsName.add(varDesc.getVarGroup());
            }
        }
        ++this.varCount;
    }

    public String getValue(String key) {
        if (this.variables.containsKey(key)) {
            return this.variables.get(key).getValue();
        }
        return null;
    }

    public IWorkflowManager getWorkflowManager() {
        return this.workflowManager;
    }

    public void setWorkflowManager(IWorkflowManager workflowManager) {
        this.workflowManager = workflowManager;
    }

    public UserManager getUserManager() {
        return this.workflowManager.getUserManager();
    }

    public boolean runJob() {
        String password = null;
        String userName = null;
        try {
            userName = this.workflowManager.getUserManager().getUserLoginInfo().getUserName();
            password = this.workflowManager.getUserManager().getUserLoginInfo().getPassword();
        }
        catch (InvalidLoginInfoException e) {
            e.printStackTrace();
        }
        String moduleId = this.workflowManager.getUserManager().getModuleId();
        if (!this.isValid()) {
            return false;
        }
        if (this.hasVariable("JOB_OUTPUT_FOLDER")) {
            String outputFolder = this.getJobID();
            this.getVariable("JOB_OUTPUT_FOLDER").setRelativeTo(this.getVariable("INPUT_OUTPUT_FOLDER"));
            String folderName = this.getVariable("INPUT_CUSTOM_JOB_NAME").getValue();
            if (!folderName.isEmpty()) {
                outputFolder = folderName;
            } else {
                this.setValue("INPUT_CUSTOM_JOB_NAME", outputFolder);
            }
            this.setValue("JOB_OUTPUT_FOLDER", outputFolder);
        }
        String command = this.getJobCommand();
        String jobFolder = this.getValue("JOB_OUTPUT_FOLDER");
        if (jobFolder == null) {
            jobFolder = "/.gpro/jobs";
        }
        jobFolder.isEmpty();
        StringBuilder commandBuilder = new StringBuilder();
        UserManager.RemotePathManager hostPathManager = this.workflowManager.getUserManager().getHostPathManager();
        String commandFile = hostPathManager.sanitizeFilePathWithTelda(jobFolder + "/." + this.getJobDescID() + "_command");
        String logFile = hostPathManager.sanitizeFilePathWithTelda(jobFolder + "/" + this.getJobDescID() + "_log");
        String errorFile = hostPathManager.sanitizeFilePathWithTelda(jobFolder + "/" + this.getJobDescID() + "_error");
        commandBuilder.append("export USER_HOME=$HOME\n");
        commandBuilder.append(this.getVariable("INPUT_OUTPUT_FOLDER").getBashVarDecleration() + "\n");
        if (this.hasVariable("JOB_OUTPUT_FOLDER")) {
            commandBuilder.append(this.getVariable("JOB_OUTPUT_FOLDER").getBashVarDecleration() + "\n");
            commandBuilder.append("mkdir -p " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\n");
        }
        String before = commandBuilder.toString();
        commandBuilder = new StringBuilder();
        if (this.hasVariable("USER_MAX_NUM_SPAWN_PROCESSES")) {
            String maxNumOfJobs = this.getValue("USER_MAX_NUM_SPAWN_PROCESSES");
            commandBuilder.append(BashHelper.USER_MAX_NUM_PROCESS_VAR + "=\"" + maxNumOfJobs + "\"\n");
        }
        commandBuilder.append("gpro_bin=" + Constants.PIPELINE_BASE_PATH + ";\n");
        commandBuilder.append("export PATH=$PATH:" + Constants.PIPELINE_BASE_PATH + ";\n");
        commandBuilder.append("source helper.v2.sh\n");
        commandBuilder.append("source trackHelper.v2.sh\n");
        commandBuilder.append("source execPaths.v2.sh\n");
        commandBuilder.append("job_subject=\"" + this.getJobDescID() + " Job\" ; \n");
        commandBuilder.append(this.getVariable("INPUT_OUTPUT_FOLDER").getBashVarDecleration() + "\n");
        commandBuilder.append(this.getVariable("JOB_OUTPUT_FOLDER").getBashVarDecleration() + "\n");
        if (!this.getValue("EMAIL_VAR").isEmpty()) {
            commandBuilder.append("user_email=\"" + this.getValue("EMAIL_VAR") + "\" ; \n ");
        }
        commandBuilder.append("##    submission history and tracking   \n");
        commandBuilder.append(Tracking.submitEntry(this.workflowManager.getUserManager(), commandFile, this.getVariable("JOB_OUTPUT_FOLDER").$(), "j", this.getValue("INPUT_CUSTOM_JOB_NAME"), this.getJobDescID()));
        commandBuilder.append(Tracking.trackStart(this.getJobID()));
        commandBuilder.append("# Start of Main Command\n( " + command + " \n) &> " + logFile);
        if (!this.getValue("EMAIL_VAR").isEmpty()) {
            commandBuilder.append(" && ( echo \" Job Finished attached log file \") > .emailbody.txt || ( echo -e \" Job Failed \\n attached log file \") > .emailbody.txt \n");
        } else {
            commandBuilder.append("\n");
        }
        commandBuilder.append(Tracking.cacheLog(this.workflowManager.getUserManager(), logFile, this.getValue("INPUT_CUSTOM_JOB_NAME")) + "\n");
        commandBuilder.append(WorkflowJob.st("createReport --jobOutputFolder" + this.getVariable("JOB_OUTPUT_FOLDER").$() + " --jobId " + this.jobId + " --jobTrackFile " + BashHelper.$(Tracking.TRACK_LOG_LOCK_FILENAME)));
        if (!this.getValue("EMAIL_VAR").isEmpty()) {
            commandBuilder.append("mail -a " + logFile + " -s \"$job_subject\" $user_email < .emailbody.txt  ");
        }
        String commandItself = commandBuilder.toString();
        try {
            File userPath = new File(System.getProperty("user.home"));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(userPath) + "/test_command.sh"), "utf-8"));
            writer.write("commandItself:\n");
            writer.write(commandItself.toString());
            writer.write("\n");
            writer.write("before:\n");
            writer.write(before + "\n");
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            System.out.println(ex.getStackTrace());
        }
        return PipelineExecutor.runCommandWithHTTP(this.workflowManager.getUserManager(), commandItself, before, "", commandFile);
    }

    public String getJobCommand() {
        String declaration;
        this.autoConnentData();
        if (!this.isValid()) {
            return null;
        }
        this.generateCommandInit();
        FolderVariable jobOutputFolder = (FolderVariable)this.getVariable("JOB_OUTPUT_FOLDER");
        FolderVariable jobInputOutputFolder = (FolderVariable)this.getVariable("INPUT_OUTPUT_FOLDER");
        if (jobOutputFolder != null) {
            String outputFolder = jobOutputFolder.getValue();
            jobOutputFolder.setRelativeTo(jobInputOutputFolder);
            if (outputFolder.isEmpty()) {
                outputFolder = this.getJobID();
                String folderName = this.getVariable("INPUT_CUSTOM_JOB_NAME").getValue();
                if (!folderName.isEmpty()) {
                    outputFolder = folderName;
                } else {
                    this.setValue("INPUT_CUSTOM_JOB_NAME", outputFolder);
                }
                jobOutputFolder.setValue(outputFolder);
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("########################### Job Track Variables ################################## \n");
        builder.append(BashHelper.assign("_g_job_exec_status", Tracking.TrackEndStatus.Finished.toString()) + "\n");
        builder.append(BashHelper.assign("_g_filter_status", Tracking.TrackCheckLevels.Pass.toString()) + "\n");
        if (this.getParent() != null) {
            builder.append(Tracking.trackLog(Tracking.TrackEventType.Started, this.getJobID()));
        }
        builder.append("############################################################################# \n");
        builder.append("##                             Input Variables\n");
        for (JobVariable var : this.getInputVariables()) {
            declaration = var.getBashVarDecleration();
            builder.append(declaration);
            if (var.getValue().isEmpty() || declaration.isEmpty()) continue;
            builder.append(Tracking.TrackInfo(Tracking.TrackInfoType.Input, var));
        }
        builder.append("############################################################################# \n");
        builder.append("##                             Output/Internal Variables\n");
        for (JobVariable var : this.getOutputVariables()) {
            builder.append(var.getBashVarDecleration());
        }
        for (JobVariable var : this.getInternalVariables()) {
            declaration = var.getBashVarDecleration();
            builder.append(declaration);
            if (var.getValue().isEmpty() || declaration.isEmpty()) continue;
            builder.append(Tracking.TrackInfo(Tracking.TrackInfoType.Input, var));
        }
        builder.append("############################################################################# \n");
        builder.append("##                            Options Variables\n");
        for (JobVariable var : this.getOptionVariables()) {
            declaration = var.getBashVarDecleration();
            if (declaration.isEmpty()) continue;
            builder.append(declaration);
            builder.append(Tracking.TrackInfo(Tracking.TrackInfoType.Parameter, var));
        }
        builder.append("############################################################################# \n");
        builder.append("##                            CMD-Options Parameters\n");
        builder.append("declare -A " + this.getOptionsBashVarName() + "\n");
        for (String subProg : this.subProgsName) {
            builder.append("declare -A " + this.getOptionsBashVarName(subProg) + "\n");
        }
        for (JobVariable var : this.getAllVariables()) {
            builder.append(var.getCMDParamaterKeyValueDeclaration());
        }
        builder.append("\n## " + this.getOptionParamaters() + "\n");
        builder.append(this.optionalParametersBuilder(this.getOptionsBashVarName()));
        builder.append(Tracking.TrackInfo(Tracking.TrackInfoType.Parameter, this.getOptionsBashVarName(), this.getOptionsBashVarName() + "[@]"));
        for (String subProg : this.subProgsName) {
            builder.append(this.optionalParametersBuilder(this.getOptionsBashVarName(subProg)));
            builder.append(Tracking.TrackInfo(Tracking.TrackInfoType.Parameter, this.getOptionsBashVarName(subProg), this.getOptionsBashVarName(subProg) + "[@]"));
        }
        builder.append("################################### CMD START ################################# \n");
        this.generateCommandSetup(builder);
        Object jobLogFile = "";
        if (this.hasVariable("JOB_OUTPUT_FOLDER")) {
            jobLogFile = this.getVariable("JOB_OUTPUT_FOLDER").$() + "/" + this.getJobID() + "_log";
            builder.append("outputFolder=\"" + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\"\n");
        }
        if (this.getParent() != null && !((String)jobLogFile).isEmpty()) {
            builder.append("\n{\n");
        }
        builder.append("tmpFolder=$outputFolder/tmp\n");
        builder.append("mkdir -p $tmpFolder\n\n");
        this.generateCommand(builder);
        builder.append("############################################################################# \n");
        builder.append("##                             Output Variables\n");
        for (JobVariable var : this.getOutputVariables()) {
            if (!(var instanceof FileVariable)) continue;
            builder.append(((FileVariable)var).getFileFormatAsBashVar());
        }
        for (JobVariable var : this.getOutputVariables()) {
            builder.append(Tracking.TrackInfo(Tracking.TrackInfoType.Output, var));
        }
        this.generateCommandWrapUp(builder);
        if (!PreferenceManager.getInstance().get("DEMO_MODE", Constants.DEMO_MODE_FALSE).equals(Constants.DEMO_MODE_TRUE)) {
            builder.append(this.getCheckCommand());
            builder.append(this.getFilterCheckCommand());
        }
        builder.append("rm -r $tmpFolder\n\n");
        builder.append("[" + BashConditions.Equal("$_g_job_exec_status", Tracking.TrackEndStatus.Failed.toString()) + "] && " + Tracking.trackEnd(this.getJobID(), Tracking.TrackEndStatus.Failed, "Job Execution Failed .... See Log Errors") + "\n[" + BashConditions.Equal("$_g_job_exec_status", Tracking.TrackEndStatus.Failed.toString()) + "] && exit 1 \n" + BashHelper.IF(BashConditions.Equal("$_g_filter_status", Tracking.TrackCheckLevels.Fail.toString()), Tracking.trackEnd(this.getJobID(), Tracking.TrackEndStatus.Failed, "Job Failed to pass one or more of the defined filters.") + "exit 1", BashHelper.IF(BashConditions.Equal("$_g_filter_status", Tracking.TrackCheckLevels.Warning.toString()), Tracking.trackEnd(this.getJobID(), Tracking.TrackEndStatus.Warning, "Job Failed to pass some of the defined filters."), Tracking.trackEnd(this.getJobID(), Tracking.TrackEndStatus.Finished, ""))));
        if (this.getParent() != null && !((String)jobLogFile).isEmpty()) {
            builder.append("\n} &> " + (String)jobLogFile + "\n");
        }
        return builder.toString();
    }

    private String optionalParametersBuilder(String oa) {
        String oaAll = oa + "_all";
        String res = oaAll + "=\"\"\n";
        res = res + BashHelper.forEachValue("_key_v", "${" + oa + "[@]}", oaAll + "=\"${" + oaAll + "}   ${_key_v}\"");
        return res;
    }

    protected void generateCommand(StringBuilder builder) {
    }

    protected String getFilterCheckCommand() {
        return "\n\n";
    }

    protected void generateCommandInit() {
    }

    protected void generateCommandSetup(StringBuilder builder) {
    }

    protected void generateCommandWrapUp(StringBuilder builder) {
    }

    protected String getOptionParamaters() {
        StringBuilder builder = new StringBuilder();
        for (JobVariable var : this.getAllVariables()) {
            builder.append(var.getCMDParamaterValue());
        }
        return builder.toString();
    }

    protected String getOptionParameters(String prefix) {
        StringBuilder builder = new StringBuilder();
        for (JobVariable var : this.getAllVariables()) {
            if (!var.getKey().startsWith(prefix)) continue;
            builder.append(var.getCMDParamaterValue());
        }
        return builder.toString();
    }

    public String getJobDescID() {
        if (this.jobDesc != null) {
            return this.jobDesc.jobId;
        }
        return this.jobId;
    }

    public String getJobID() {
        return this.jobId;
    }

    public Collection<JobVariable> getAllVariables() {
        return this.orderedVariables.values();
    }

    public JobVariable getVariable(String varKey) {
        if (varKey.contains(".")) {
            String[] varKeys = varKey.split("\\.");
            if (this.workflow == null) {
                String jobId = varKeys[0];
                varKey = varKeys[1];
                if (jobId.equals(this.getJobID()) && this.variables.containsKey(varKey)) {
                    return this.variables.get(varKey);
                }
            }
        }
        if (this.variables.containsKey(varKey)) {
            return this.variables.get(varKey);
        }
        return null;
    }

    public String getFriendlyName() {
        return this.jobName;
    }

    public void setFriendlyName(String name) {
        this.jobName = name;
    }

    public boolean hasVariable(String key) {
        return this.variables.containsKey(key);
    }

    public void unLink(Workflow workflow) {
    }

    public WorkflowJob[] getPreJobs() {
        return this.preJobs.values().toArray(new WorkflowJob[this.preJobs.values().size()]);
    }

    public WorkflowJob[] getPostJobs() {
        return this.postJobs.values().toArray(new WorkflowJob[this.postJobs.values().size()]);
    }

    public HashMap<String, JobVariable> getVariablesMap() {
        return this.variablesMap;
    }

    public void addVariableMap(String inputVar, JobVariable outputVarPerJobName) {
        if (outputVarPerJobName == null) {
            throw new NullPointerException("outputVarPerJobName can not be null : in " + this.getJobID() + ":" + this.getFriendlyName());
        }
        if (!this.hasVariable(inputVar)) {
            throw new NullPointerException("Input Job " + this.getJobID() + ":" + this.getFriendlyName() + " does not have variable with key:" + inputVar);
        }
        this.variablesMap.put(inputVar, outputVarPerJobName);
        outputVarPerJobName.addVarMap(this.getVariable(inputVar));
        WorkflowJob varjob = outputVarPerJobName.getJob();
        this.addDependency(varjob);
    }

    public void removeVariableMap(String inputVar) {
        if (this.variablesMap.containsKey(inputVar)) {
            JobVariable outputVarPerJobName = this.variablesMap.get(inputVar);
            this.variablesMap.remove(inputVar);
            this.variables.get(inputVar).setDefualt();
            outputVarPerJobName.removeVarMap(this.getVariable(inputVar));
            WorkflowJob varjob = outputVarPerJobName.getJob();
            this.removeDependency(varjob);
        }
    }

    protected void addDependency(WorkflowJob preJob) {
        if (preJob == this) {
            return;
        }
        this.preJobs.put(preJob.jobId, preJob);
        preJob.postJobs.put(this.jobId, this);
    }

    protected void removeDependency(WorkflowJob preJob) {
        this.preJobs.remove(preJob.jobId);
        preJob.postJobs.remove(this.jobId);
    }

    public void removeMappingTo(WorkflowJob preJob) {
        ArrayList<String> mappingList = new ArrayList<String>();
        for (String key : this.variablesMap.keySet()) {
            if (this.variablesMap.get(key).getJob() != preJob) continue;
            mappingList.add(key);
        }
        for (String key : mappingList) {
            this.removeVariableMap(key);
        }
        this.preJobs.remove(preJob.jobId);
        preJob.postJobs.remove(this.jobId);
    }

    protected void autoConnentData() {
        for (String varInput : this.variablesMap.keySet()) {
            this.setValue(varInput, this.variablesMap.get(varInput).getValue());
        }
    }

    public boolean isValid() {
        return this.isValid(false);
    }

    public boolean isValid(boolean ignoreMapping) {
        boolean isValid = true;
        this.allErrorsMsg.clear();
        for (String varKey : this.variables.keySet()) {
            if (ignoreMapping && this.variablesMap.containsKey(varKey)) continue;
            JobVariable var = this.variables.get(varKey);
            var.validate();
            if (var.isValid()) continue;
            String varError = var.getErrorMsg();
            this.allErrorsMsg.add(varError);
            isValid = false;
        }
        if (this.validation_before != isValid) {
            this.validation_before = isValid;
            this.notifyValidationchanged();
        }
        return isValid;
    }

    public String getFirstErrorMsg() {
        if (this.allErrorsMsg.size() > 0) {
            return this.allErrorsMsg.get(0);
        }
        return null;
    }

    public ArrayList<String> getAllErrorMsgs() {
        return this.allErrorsMsg;
    }

    protected boolean validateEqualNumberOfFiles(String var1, String var2) {
        return this.validateEqualNumberOfFiles(var1, var2, 0);
    }

    protected boolean validateEqualNumberOfFiles(String var1, String var2, int minNumberForMatching) {
        boolean valid = true;
        String inputFile1sString = "";
        String inputFiles2String = "";
        inputFile1sString = this.getValue(var1).trim();
        inputFiles2String = this.getValue(var2).trim();
        if (!inputFiles2String.isEmpty()) {
            ArrayList<String> acceptedInput = WorkflowJob.getListOfStrings(inputFile1sString);
            ArrayList<String> acceptedInput_OptionalInput = WorkflowJob.getListOfStrings(inputFiles2String);
            if (acceptedInput.size() != acceptedInput_OptionalInput.size() && acceptedInput_OptionalInput.size() > minNumberForMatching) {
                valid = false;
                this.getVariable(var2).setExternalErrMsg(this.getVariable(var2).getDescFriendlyName() + " : Number of items does not match " + this.getVariable(var1).getDescFriendlyName());
                this.allErrorsMsg.add(this.getVariable(var2).getDescFriendlyName() + " : Number of items does not match " + this.getVariable(var1).getDescFriendlyName());
            }
        }
        return valid;
    }

    protected boolean validateNoDuplicates(String varKey) {
        boolean valid = true;
        String[] names = WorkflowJob.getList(this.getValue(varKey));
        if (names.length != 0) {
            HashSet<String> strSet = new HashSet<String>();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                strSet.add(n3);
                ++n2;
            }
            if (strSet.size() != names.length) {
                valid = false;
                this.getVariable(varKey).setExternalErrMsg(this.getVariable(varKey).getDescFriendlyName() + " must be unique items ( no duplicate ).");
                this.allErrorsMsg.add(this.getVariable(varKey).getDescFriendlyName() + " must be unique items ( no duplicate ).");
            }
        }
        return valid;
    }

    public void assginBaseName(String sourceVar, String targetVar) {
        String inputFilesString = "";
        Object basenameFilesString = "";
        inputFilesString = this.getValue(sourceVar).trim();
        if (!inputFilesString.isEmpty()) {
            ArrayList<String> fileList = WorkflowJob.getListOfStrings(inputFilesString);
            for (String fileName : fileList) {
                basenameFilesString = (String)basenameFilesString + FilenameUtils.getBaseName((String)fileName) + "\n";
            }
            this.setValue(targetVar, (String)basenameFilesString);
        }
    }

    @Override
    public Object getParent() {
        return this.getWorkflow();
    }

    protected void dumpVar(VariableDescriptor.VariableRole role) {
        System.out.println(String.valueOf((Object)role) + " vars for " + this.getJobDescID() + "\n");
        for (JobVariable var : this.getAllVariables()) {
            if (var.getDescVarRole() != role) continue;
            System.out.println(var.getKey() + ":\n" + var.getValue() + "\n====\n");
        }
        System.out.println("\n********************************\n");
    }

    public static VariableDescriptor createInputOutputFolderVar() {
        FolderVariableDescriptor var = VariableDescriptor.Folder("INPUT_OUTPUT_FOLDER", VariableDescriptor.VariableRole.Input);
        var.setVariableName("Output Folder");
        var.isRequired = true;
        var.setVariableGroup("Output");
        var.setShortHelpMsg("Drag here the output folder from your user account.");
        var.setHelpMsg("After launching the job; a folder with the Custom Folder Name or default name provided will be created inside the selected Folder here.");
        return var;
    }

    public static VariableDescriptor createCustomOutputFolderNameVar() {
        StringVariableDescriptor var = VariableDescriptor.String("INPUT_CUSTOM_JOB_NAME", VariableDescriptor.VariableRole.Input);
        var.setVariableName("Job/Folder Name");
        var.setIsFileName(true);
        var.setVariableGroup("Output");
        var.setHelpMsg("Custom Job Name. Will be used to rename the Output folder of jobs.");
        return var;
    }

    public static void createPrevoiusJobNameVar(WorkflowJob job) {
        VariableDescriptor var = VariableDescriptor.String("PREVIOUS_JOB_NAME", VariableDescriptor.VariableRole.Internal);
        var.setVariableName("Prevoius Job");
        var.setIsFileName(true);
        var.setVariableGroup("Output");
        job.addVariable(var);
        job.jobDesc.addVariable(var);
        var = VariableDescriptor.Int("PREVIOUS_JOB_RESTART", VariableDescriptor.VariableRole.Internal);
        var.setVariableName("N restarts");
        var.setVariableGroup("Output");
        job.addVariable(var);
        job.jobDesc.addVariable(var);
        var = VariableDescriptor.String("PREVIOUS_JOB_TIMESTAMP", VariableDescriptor.VariableRole.Internal);
        var.setVariableName("Prevoius Job timestamp");
        var.setVariableGroup("Output");
        job.addVariable(var);
        job.jobDesc.addVariable(var);
        job.getVariable("INPUT_CUSTOM_JOB_NAME").setReadOnly(true);
    }

    public static ArrayList<String> getListOfStrings(String inputFilesString) {
        return WorkflowJob.getListOfStrings(inputFilesString, "\n");
    }

    public static ArrayList<String> getListOfStrings(String inputFilesString, String del) {
        String[] inputList = inputFilesString.split(del);
        ArrayList<String> acceptedInput = new ArrayList<String>();
        int i = 0;
        while (i < inputList.length) {
            if (!inputList[i].isEmpty()) {
                acceptedInput.add(inputList[i]);
            }
            ++i;
        }
        return acceptedInput;
    }

    public static VariableDescriptor createJobOutputFolderVar() {
        FolderVariableDescriptor varOutputFolder = VariableDescriptor.Folder("JOB_OUTPUT_FOLDER", VariableDescriptor.VariableRole.Output);
        varOutputFolder.setVariableName("Job Output Folder");
        return varOutputFolder;
    }

    public static VariableDescriptor createNotificatinEmailVar() {
        StringVariableDescriptor emailNotification = VariableDescriptor.String("EMAIL_VAR", VariableDescriptor.VariableRole.Input);
        emailNotification.setVariableGroup("Output");
        emailNotification.setVariableName("Email");
        emailNotification.setHelpMsg("You can close your PC after launching the job. Enter Your Email address here to receive email notification after finishing the job.");
        return emailNotification;
    }

    public static VariableDescriptor createUserMaxNumSpawnProcessesVar() {
        RangeVariableDescriptor userMaxNumSpawnProcessesVar = VariableDescriptor.Range("USER_MAX_NUM_SPAWN_PROCESSES", VariableDescriptor.VariableRole.Input);
        userMaxNumSpawnProcessesVar.setMaxValue(4.0);
        userMaxNumSpawnProcessesVar.setMinValue(1.0);
        userMaxNumSpawnProcessesVar.setDefaultValue("2");
        userMaxNumSpawnProcessesVar.setVariableGroup("Output");
        userMaxNumSpawnProcessesVar.setVariableName("Number of simultaneous Tasks/Processes");
        userMaxNumSpawnProcessesVar.setHelpMsg("Number of sub-processes/tasks this job can run simultaneously. Please note that this will be subject to the avialabilty of the server processing resources and user configuration imposed by the system administrator");
        return userMaxNumSpawnProcessesVar;
    }

    public void setJobId(String newId) {
        this.jobId = newId;
    }

    public Collection<JobVariable> getInputVariables() {
        ArrayList<JobVariable> selectedVars = new ArrayList<JobVariable>();
        Collection<JobVariable> vars = this.getAllVariables();
        for (JobVariable var : vars) {
            if (var.getDescVarRole() != VariableDescriptor.VariableRole.Input) continue;
            selectedVars.add(var);
        }
        return selectedVars;
    }

    public Collection<JobVariable> getOutputVariables() {
        ArrayList<JobVariable> selectedVars = new ArrayList<JobVariable>();
        Collection<JobVariable> vars = this.getAllVariables();
        for (JobVariable var : vars) {
            if (var.getDescVarRole() != VariableDescriptor.VariableRole.Output) continue;
            selectedVars.add(var);
        }
        return selectedVars;
    }

    public Collection<JobVariable> getInternalVariables() {
        ArrayList<JobVariable> selectedVars = new ArrayList<JobVariable>();
        Collection<JobVariable> vars = this.getAllVariables();
        for (JobVariable var : vars) {
            if (var.getDescVarRole() != VariableDescriptor.VariableRole.Internal) continue;
            selectedVars.add(var);
        }
        return selectedVars;
    }

    public Collection<JobVariable> getOptionVariables() {
        ArrayList<JobVariable> selectedVars = new ArrayList<JobVariable>();
        Collection<JobVariable> vars = this.getAllVariables();
        for (JobVariable var : vars) {
            if (var.getDescVarRole() != VariableDescriptor.VariableRole.Option) continue;
            selectedVars.add(var);
        }
        return selectedVars;
    }

    public Collection<JobVariable> getAllRequiredInputVariables() {
        ArrayList<JobVariable> selectedVars = new ArrayList<JobVariable>();
        Collection<JobVariable> vars = this.getAllVariables();
        for (JobVariable var : vars) {
            if (var.getDescVarRole() != VariableDescriptor.VariableRole.Input || var.descHasEnableActions() || !var.isVisable()) continue;
            selectedVars.add(var);
        }
        return selectedVars;
    }

    public String getOptionsBashVarName() {
        String str = this.jobId + "_oa";
        return str;
    }

    public String getOptionsBashVarName(String subProg) {
        String str = this.jobId + "_oa_" + subProg;
        return str;
    }

    protected String getOptionParamatersStrAs$() {
        return " ${" + this.jobId + "_oa_all} ";
    }

    protected String getOptionParamatersStrAs$(String subProg) {
        subProg = subProg.replace(" ", "_");
        return " ${" + this.jobId + "_oa_" + subProg + "_all} ";
    }

    public String getCleanCommand() {
        Object cmdCheck = "\n";
        for (JobVariable var : this.getOutputVariables()) {
            if (var.getDescIsRequired() && var.getDescVarType() == VariableDescriptor.VariableType.File) {
                cmdCheck = (String)cmdCheck + BashHelper.IF(" -f   \"" + var.$() + DOUBLE_QUATE, "[ -s  \"" + var.$() + "\" ] || rm \"" + var.$() + DOUBLE_QUATE);
            }
            if (!var.getDescIsRequired() || var.getDescVarType() != VariableDescriptor.VariableType.FileList && var.getDescVarType() != VariableDescriptor.VariableType.Files) continue;
            cmdCheck = (String)cmdCheck + BashHelper.forEachValue("_File", var.$("@"), BashHelper.IF(" -f   \"${_File}\"", "[ -s  \"${_File}\" ] || rm \"${_File}\""));
        }
        return (String)cmdCheck + "\n";
    }

    public ArrayList<JobVariable> selectVariables(VariableDescriptor.VariableRole[] varRoles, VariableDescriptor.VariableType[] variableTypes) {
        ArrayList<JobVariable> selectedOutputVars = new ArrayList<JobVariable>();
        for (JobVariable var : this.getAllVariables()) {
            if (!WorkflowJob.varSatisyAny(var, varRoles) || !WorkflowJob.varSatisfyAny(var, variableTypes)) continue;
            selectedOutputVars.add(var);
        }
        return selectedOutputVars;
    }

    public ArrayList<JobVariable> selectVariables(VariableDescriptor.VariableRole varRole, VariableDescriptor.VariableType[] variableTypes) {
        return this.selectVariables(new VariableDescriptor.VariableRole[]{varRole}, variableTypes);
    }

    public ArrayList<JobVariable> selectVariables(VariableDescriptor.VariableRole varRole, VariableDescriptor.VariableType variableType) {
        return this.selectVariables(new VariableDescriptor.VariableRole[]{varRole}, new VariableDescriptor.VariableType[]{variableType});
    }

    private static boolean varSatisfyAny(JobVariable var, VariableDescriptor.VariableType[] variableTypes) {
        VariableDescriptor.VariableType[] variableTypeArray = variableTypes;
        int n = variableTypes.length;
        int n2 = 0;
        while (n2 < n) {
            VariableDescriptor.VariableType type = variableTypeArray[n2];
            if (var.getDescVarType() == type) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean varSatisyAny(JobVariable var, VariableDescriptor.VariableRole[] varRoles) {
        VariableDescriptor.VariableRole[] variableRoleArray = varRoles;
        int n = varRoles.length;
        int n2 = 0;
        while (n2 < n) {
            VariableDescriptor.VariableRole role = variableRoleArray[n2];
            if (var.getDescVarRole() == role) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getFullKey() {
        if (this.getWorkflow() != null) {
            return this.getWorkflow().getFullKey() + "." + this.getJobID();
        }
        return this.getJobID();
    }

    public String getMappingSummary(String jobId) {
        Object summary = "Mapping : \n";
        for (String key : this.variablesMap.keySet()) {
            String varInInfo = this.getVariable(key).getDescFriendlyName();
            String varOutInfo = this.variablesMap.get(key).getDescFriendlyName();
            if (!jobId.equals(this.variablesMap.get(key).getJob().getJobDescID())) continue;
            summary = (String)summary + varInInfo + " <- " + varOutInfo + ".\n";
        }
        return summary;
    }

    public String getJobTags() {
        return "";
    }

    public String getJobChars() {
        return "";
    }

    public void addExternalErrMsg(String errorMsg) {
        this.allErrorsMsg.add(errorMsg);
    }

    protected List<String> loadJobResource(String jobname, String res_name) {
        String resourceFolder = "job_resources";
        ClassLoader classLoader = this.getClass().getClassLoader();
        String resourceName = resourceFolder + "/" + jobname + "/" + res_name;
        InputStream file = classLoader.getResourceAsStream(resourceName);
        List fileText = null;
        try {
            fileText = IOUtils.readLines((InputStream)file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileText;
    }

    public static List<String> loadJobResource(String jobname, String res_name, ClassLoader classLoader) {
        String resourceFolder = "job_resources";
        String resourceName = resourceFolder + "/" + jobname + "/" + res_name;
        InputStream file = classLoader.getResourceAsStream(resourceName);
        List fileText = null;
        try {
            fileText = IOUtils.readLines((InputStream)file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileText;
    }

    public static String st(String statment) {
        return statment + "\n";
    }

    public static String qt(String str) {
        return DOUBLE_QUATE + str + DOUBLE_QUATE;
    }

    public String getGeneratedBashScriptFileName() {
        return "." + this.getJobDescID() + "_command";
    }

    public static void commonVarInit(WorkflowJob job) {
        SimpleVariable userMaxNumSpawnProcessesVar;
        String emailAddress = PreferenceManager.getInstance().get("email", "");
        JobVariable emailNotification = job.getVariable("EMAIL_VAR");
        if (emailNotification != null) {
            emailNotification.setValue(emailAddress);
        }
        if ((userMaxNumSpawnProcessesVar = (SimpleVariable)job.getVariable("USER_MAX_NUM_SPAWN_PROCESSES")) != null) {
            String maxValue = PreferenceManager.getInstance().get("MAX_PROCESSES", "32");
            String defaultValue = PreferenceManager.getInstance().get("DEFAULT_NUMBER_PROCESSES", "4");
            userMaxNumSpawnProcessesVar.setMaxValue(Double.parseDouble(maxValue));
            userMaxNumSpawnProcessesVar.setMinValue(1.0);
            userMaxNumSpawnProcessesVar.setValue(defaultValue);
        }
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    protected void setWorkflow(Workflow workflow) {
        this.workflow = workflow;
    }

    public String getCheckCommand() {
        Object cmdCheck = this.getCleanCommand();
        String statusVar = "_g_output_fail_";
        cmdCheck = (String)cmdCheck + "\n" + statusVar + "=false\n";
        for (JobVariable var : this.getOutputVariables()) {
            if (var.skipOutputCkeck()) continue;
            if (var.getDescVarType() == VariableDescriptor.VariableType.File) {
                cmdCheck = (String)cmdCheck + BashHelper.IF(" -f   \"" + var.$() + DOUBLE_QUATE, Tracking.trackLogCheck(var.$(), "Exist", Tracking.TrackCheckType.Output, Tracking.TrackCheckLevels.Pass, "Ok"), Tracking.trackLogCheck(var.$(), "Exist", Tracking.TrackCheckType.Output, Tracking.TrackCheckLevels.Fail, "Missing") + statusVar + "=true\n");
            }
            if (var.getDescVarType() != VariableDescriptor.VariableType.FileList && var.getDescVarType() != VariableDescriptor.VariableType.Files) continue;
            cmdCheck = (String)cmdCheck + BashHelper.forEachValue("_File", var.$("@"), BashHelper.IF(" -f   \"${_File}\"", Tracking.trackLogCheck("${_File}", "Exist", Tracking.TrackCheckType.Output, Tracking.TrackCheckLevels.Pass, "Ok"), Tracking.trackLogCheck("${_File}", "Exist", Tracking.TrackCheckType.Output, Tracking.TrackCheckLevels.Fail, "Missing") + statusVar + "=true\n"));
        }
        cmdCheck = (String)cmdCheck + BashHelper.IF("${" + statusVar + "} = true", BashHelper.assign("_g_job_exec_status", Tracking.TrackEndStatus.Failed.toString()));
        return cmdCheck;
    }

    public static String[] getList(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return new String[0];
        }
        String[] files = value.split("\n");
        return files;
    }
}

