/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.dialogs;

import com.biotechvana.utils.PreferenceManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ChatDialog
extends TrayDialog {
    private static final String SAVE_CHAT = "SAVE_CHAT";
    public static String AboutDialog_shellTitle = "{0}: Ask Genie";
    private IProduct product = Platform.getProduct();
    private String productName;
    private Browser chatBrowser;
    boolean clearChat = false;
    private boolean loaded = false;
    private static final String RESEOURCE_PREFIX = "com/biotechvana/ui/resources/";

    public ChatDialog(Shell parentShell) {
        super(parentShell);
        if (this.product != null) {
            this.productName = this.product.getName();
        }
    }

    public boolean close() {
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind((String)AboutDialog_shellTitle, (Object)this.productName));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        Button b = this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
        b.setFocus();
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        String saveChatPreferences = PreferenceManager.getInstance().get(SAVE_CHAT, null);
        if (saveChatPreferences != null && saveChatPreferences.equals("false")) {
            this.clearChat = true;
        }
        Composite workArea = new Composite(parent, 0);
        GridLayout workLayout = new GridLayout();
        workLayout.marginHeight = 0;
        workLayout.marginWidth = 0;
        workLayout.verticalSpacing = 0;
        workLayout.horizontalSpacing = 0;
        workArea.setLayout((Layout)workLayout);
        workArea.setLayoutData((Object)new GridData(1808));
        Color background = JFaceColors.getBannerBackground((Display)parent.getDisplay());
        Color foreground = JFaceColors.getBannerForeground((Display)parent.getDisplay());
        Composite top = (Composite)super.createDialogArea(workArea);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(1808));
        top.setBackground(background);
        top.setForeground(foreground);
        Composite topContainer = new Composite(top, 0);
        topContainer.setBackground(background);
        topContainer.setForeground(foreground);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        topContainer.setLayout((Layout)layout);
        GC gc = new GC((Drawable)parent);
        int topContainerHeightHint = 600;
        try {
            topContainerHeightHint = Math.max(topContainerHeightHint, gc.getFontMetrics().getHeight() * 6);
        }
        finally {
            gc.dispose();
        }
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.heightHint = topContainerHeightHint;
        topContainer.setLayoutData((Object)data);
        int minWidth = 800;
        this.chatBrowser = new Browser(topContainer, 0);
        data = new GridData(4, 4, true, true);
        data.widthHint = 800;
        this.chatBrowser.setLayoutData((Object)data);
        this.loadData(this.chatBrowser);
        this.chatBrowser.setFont(parent.getFont());
        this.chatBrowser.setCursor(null);
        this.chatBrowser.setBackground(background);
        this.chatBrowser.setForeground(foreground);
        Label bar = new Label(workArea, 258);
        data = new GridData();
        data.horizontalAlignment = 4;
        bar.setLayoutData((Object)data);
        Composite bottom = (Composite)super.createDialogArea(workArea);
        layout = new GridLayout();
        bottom.setLayout((Layout)layout);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        bottom.setLayoutData((Object)data);
        final Button check = new Button(bottom, 32);
        check.setText("Save Chat History");
        check.setSelection(!this.clearChat);
        check.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (check.getSelection()) {
                    PreferenceManager.getInstance().put(ChatDialog.SAVE_CHAT, "true");
                } else {
                    PreferenceManager.getInstance().put(ChatDialog.SAVE_CHAT, "false");
                }
                PreferenceManager.getInstance().savePreferences();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return workArea;
    }

    private void loadData(Browser text2) {
        text2.setText(ChatDialog.getHtmlContent("ChatViewer.html"));
        text2.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                ChatDialog.this.loaded = true;
                StringBuffer script = new StringBuffer();
                script.append("init(); deleteAllCookies(); ");
                try {
                    if (ChatDialog.this.clearChat) {
                        ChatDialog.this.eval("clearChat();");
                    }
                }
                catch (SWTException e) {
                    e.printStackTrace();
                }
            }

            public void changed(ProgressEvent event) {
            }
        });
    }

    private void eval(String script) {
        try {
            this.chatBrowser.evaluate(script);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private static String getHtmlContent(String url) {
        StringBuilder html = new StringBuilder();
        html.append(ChatDialog.getTextFromResource(url, "UTF-8"));
        return html.toString();
    }

    private static String getTextFromResource(String resourceName, String charset) {
        try {
            return ChatDialog.getTextFromResourceChecked(RESEOURCE_PREFIX + resourceName, charset);
        }
        catch (IOException exception) {
            String message = "Could not read text from resource: " + resourceName;
            throw new IllegalArgumentException(message, exception);
        }
    }

    private static String getTextFromResourceChecked(String resourceName, String charset) throws IOException {
        InputStream inputStream = ChatDialog.class.getClassLoader().getResourceAsStream(resourceName);
        if (inputStream == null) {
            throw new IllegalArgumentException("Resource not found: " + resourceName);
        }
        try {
            String string = ChatDialog.getTextFromInputStream(inputStream, charset);
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    private static String getTextFromInputStream(InputStream inputStream, String charset) throws IOException {
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charset));
        String line = reader.readLine();
        while (line != null) {
            builder.append(line);
            builder.append('\n');
            line = reader.readLine();
        }
        return builder.toString();
    }

    private static void inlineScripts(StringBuilder html) {
        String srcAttrStr = "src=\"./";
        String quotStr = "\"";
        String tagStr = "<script ";
        String closingTagStr = "</script>";
        String newTagStr = "<script type=\"text/javascript\">";
        int offset = html.length();
        while ((offset = html.lastIndexOf(tagStr, offset)) != -1) {
            int srcAttrStart;
            int srcAttrEnd;
            int closeTag = html.indexOf(closingTagStr, offset);
            int srcAttr = html.indexOf(srcAttrStr, offset);
            if (srcAttr != -1 && srcAttr < closeTag && (srcAttrEnd = html.indexOf(quotStr, srcAttrStart = srcAttr + srcAttrStr.length())) != -1) {
                String filename = html.substring(srcAttrStart, srcAttrEnd);
                StringBuffer newScriptTag = new StringBuffer();
                newScriptTag.append(newTagStr);
                newScriptTag.append(ChatDialog.getTextFromResource(filename, "UTF-8"));
                newScriptTag.append(closingTagStr);
                html.replace(offset, closeTag + closingTagStr.length(), newScriptTag.toString());
            }
            --offset;
        }
    }

    private static void inlineCSS(StringBuilder html) {
        String srcAttrStr = "href=\"./";
        String quotStr = "\"";
        String tagStr = "<link ";
        String closingTagStr = "</link>";
        String newClosingTagStr = "</style>";
        String newTagStr = "<style type=\"text/css\">";
        int offset = html.length();
        while ((offset = html.lastIndexOf(tagStr, offset)) != -1) {
            int srcAttrStart;
            int srcAttrEnd;
            int closeTag = html.indexOf(closingTagStr, offset);
            int srcAttr = html.indexOf(srcAttrStr, offset);
            if (srcAttr != -1 && srcAttr < closeTag && (srcAttrEnd = html.indexOf(quotStr, srcAttrStart = srcAttr + srcAttrStr.length())) != -1) {
                String filename = html.substring(srcAttrStart, srcAttrEnd);
                StringBuffer newScriptTag = new StringBuffer();
                newScriptTag.append(newTagStr);
                newScriptTag.append(ChatDialog.getTextFromResource(filename, "UTF-8"));
                newScriptTag.append(newClosingTagStr);
                html.replace(offset, closeTag + closingTagStr.length(), newScriptTag.toString());
            }
            --offset;
        }
    }
}

