/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui;

import com.biotechvana.commons.GRPOApplication;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class UpdateHandler {
    boolean cancelled = false;

    @Execute
    public void execute(final IProvisioningAgent agent, final UISynchronize sync, final IWorkbench workbench, final GRPOApplication gproApp) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                UpdateHandler.this.update(agent, monitor, sync, workbench, gproApp);
            }
        };
        try {
            new ProgressMonitorDialog(null).run(true, true, runnable);
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private IStatus update(IProvisioningAgent agent, IProgressMonitor monitor, final UISynchronize sync, final IWorkbench workbench, GRPOApplication gproApp) {
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Checking for application updates...", (int)200);
        URI uri = null;
        try {
            uri = new URI(gproApp.getUpdateURI());
        }
        catch (URISyntaxException e) {
            throw new OperationCanceledException("Invalid repository location");
        }
        operation.getProvisioningContext().setArtifactRepositories(new URI[]{uri});
        operation.getProvisioningContext().setMetadataRepositories(new URI[]{uri});
        System.out.println("Checking for Update : " + String.valueOf(uri));
        IStatus status = operation.resolveModal((IProgressMonitor)sub.newChild(100));
        if (status.getCode() == 10000) {
            this.showMessage(sync, "Nothing to update");
            return Status.CANCEL_STATUS;
        }
        final ProvisioningJob provisioningJob = operation.getProvisioningJob((IProgressMonitor)sub.newChild(100));
        if (provisioningJob != null) {
            sync.syncExec(new Runnable(){

                @Override
                public void run() {
                    boolean performUpdate = MessageDialog.openQuestion(null, (String)"Updates available", (String)"There are updates available. Do you want to install them now?");
                    if (performUpdate) {
                        provisioningJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                            public void done(IJobChangeEvent event) {
                                if (event.getResult().isOK()) {
                                    sync.syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            boolean restart = MessageDialog.openQuestion(null, (String)"Updates installed, restart?", (String)"Updates have been installed successfully, do you want to restart?");
                                            if (restart) {
                                                workbench.restart();
                                            }
                                        }
                                    });
                                } else {
                                    UpdateHandler.this.showError(sync, event.getResult().getMessage());
                                    (this).UpdateHandler.this.cancelled = true;
                                }
                            }
                        });
                        provisioningJob.schedule();
                    } else {
                        UpdateHandler.this.cancelled = true;
                    }
                }
            });
        } else {
            if (operation.hasResolved()) {
                this.showError(sync, "Couldn't get provisioning job: " + String.valueOf(operation.getResolutionResult()));
            } else {
                this.showError(sync, "Couldn't resolve provisioning job");
            }
            this.cancelled = true;
        }
        if (this.cancelled) {
            this.cancelled = false;
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private void showMessage(UISynchronize sync, final String message) {
        sync.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation(null, (String)"Information", (String)message);
            }
        });
    }

    private void showError(UISynchronize sync, final String message) {
        sync.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError(null, (String)"Error", (String)message);
            }
        });
    }
}

