/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ftpservice.internal;

import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;

public class RLFileImpl {
    public FileObject file;
    long fileSize = 0L;
    long lastModifiedTime;

    public RLFileImpl(FileObject file) {
        this.file = file;
        try {
            if (file.isFile()) {
                FileContent fileContent = file.getContent();
                this.fileSize = fileContent.getSize();
                this.lastModifiedTime = fileContent.getLastModifiedTime();
            }
        }
        catch (FileSystemException e) {
            e.printStackTrace();
        }
    }

    public boolean exists() {
        try {
            return this.file.exists();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getName() {
        return this.file.getName().getBaseName();
    }

    public String getPath() {
        return this.file.getName().getPath();
    }

    public boolean isExecutable() {
        try {
            return this.file.isExecutable();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isFile() {
        try {
            return this.file.isFile();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isFolder() {
        try {
            return this.file.isFolder();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isHidden() {
        try {
            return this.file.isHidden();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isReadable() {
        try {
            return this.file.isReadable();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isSymbolicLink() {
        try {
            return this.file.isSymbolicLink();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isWriteable() {
        try {
            return this.file.isWriteable();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getURI() {
        return this.file.getName().toString();
    }

    public Object getFileObject() {
        return this.file;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }
}

