/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ftpservice.internal;

import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.commons.ftpservice.IFTPQueue;
import com.biotechvana.commons.ftpservice.IFTPQueueListener;
import com.biotechvana.commons.ftpservice.IFileTransferJob;
import com.biotechvana.commons.ftpservice.IFtpFileTransfer;
import com.biotechvana.commons.ftpservice.TransferStatus;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.vfs2.FileSystemException;
import org.eclipse.e4.core.services.events.IEventBroker;

public class FTPQueueImpl
implements IFTPQueue {
    private BlockingQueue<IFileTransferJob> jobQueue = new LinkedBlockingQueue<IFileTransferJob>();
    private List<IFileTransferJob> jobList = new ArrayList<IFileTransferJob>();
    private BlockingQueue<IFtpFileTransfer> fileTransfersQueue = new LinkedBlockingQueue<IFtpFileTransfer>();
    private List<FileThread> fileThreadList = new ArrayList<FileThread>();
    private JobThread jobThread;
    private int numConcurrentTranfers = 2;
    IFTPManager manager;
    @Inject
    private IEventBroker eventsBroker;
    private List<IFTPQueueListener> listeners = new ArrayList<IFTPQueueListener>();

    @PostConstruct
    public void init(IFTPManager manager) {
        this.manager = manager;
        this.jobThread = new JobThread();
        this.jobThread.setName("Main FTP Job Thread");
        this.adjustFileThreads();
        this.jobThread.start();
    }

    private void adjustFileThreads() {
        int diference = this.numConcurrentTranfers - this.fileThreadList.size();
        if (diference > 0) {
            this.createFileThreads(diference);
        } else if (diference < 0) {
            this.removeFileThreads(-diference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFileThreads(int amount) {
        int i = 0;
        while (i < amount) {
            FileThread thread = new FileThread();
            thread.setName("#" + i + " FileThread@FTPQueueImpl");
            List<FileThread> list = this.fileThreadList;
            synchronized (list) {
                this.fileThreadList.add(thread);
            }
            thread.start();
            ++i;
        }
    }

    private void removeFileThreads(int amount) {
        for (FileThread fileThread : this.fileThreadList.subList(0, amount)) {
            fileThread.keepRunning.set(false);
        }
    }

    public void addJob(IFtpFileTransfer fileTransferJob) {
        this.fileTransfersQueue.add(fileTransferJob);
        boolean retValue = this.eventsBroker.post("TRANSFER_FILE/NEW", (Object)fileTransferJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IFTPQueueListener l) {
        List<IFTPQueueListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    private void handleFileTransferJob(IFtpFileTransfer job) throws FileSystemException {
        job.startTransfer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IFTPQueueListener l) {
        List<IFTPQueueListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public List<IFtpFileTransfer> getQueuedFiles() {
        ArrayList<IFtpFileTransfer> listOfFiles = new ArrayList<IFtpFileTransfer>();
        for (IFileTransferJob transferJob : this.jobQueue) {
            listOfFiles.addAll(transferJob.getFiles());
        }
        return listOfFiles;
    }

    public List<IFileTransferJob> getQueuedJobs() {
        return new ArrayList<IFileTransferJob>(this.jobQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileTransferStatusUpdate(IFtpFileTransfer fileTransfer, TransferStatus oldStatus) {
        if (fileTransfer.getStatus() == oldStatus) {
            this.eventsBroker.post("TRANSFER_FILE/UPDATED", (Object)fileTransfer);
        } else {
            this.eventsBroker.post("TRANSFER_FILE/CHANGED", (Object)fileTransfer);
        }
        List<IFTPQueueListener> list = this.listeners;
        synchronized (list) {
            ArrayList<IFTPQueueListener> tmp_list = new ArrayList<IFTPQueueListener>(this.listeners);
            for (IFTPQueueListener listener : tmp_list) {
                listener.fileStatusChange(fileTransfer);
            }
        }
    }

    public void fileTransferJobUpdated(IFileTransferJob job) {
        this.eventsBroker.post("TRANSFER_JOB/UPDATED", (Object)job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileTransferJobStatusChange(IFileTransferJob job, TransferStatus oldStatus) {
        if (job.getStatus() == oldStatus) {
            this.eventsBroker.post("TRANSFER_JOB/UPDATED", (Object)job);
        } else {
            this.eventsBroker.post("TRANSFER_JOB/CHANGED", (Object)job);
        }
        List<IFTPQueueListener> list = this.listeners;
        synchronized (list) {
            ArrayList<IFTPQueueListener> tmp_list = new ArrayList<IFTPQueueListener>(this.listeners);
            for (IFTPQueueListener listener : tmp_list) {
                listener.jobStatusChange(job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFileTransferJob addJob(IFileTransferJob job) {
        this.jobQueue.add(job);
        this.jobList.add(job);
        boolean retValue = this.eventsBroker.post("TRANSFER_JOB/NEW", (Object)job);
        List<IFTPQueueListener> list = this.listeners;
        synchronized (list) {
            ArrayList<IFTPQueueListener> tmp_list = new ArrayList<IFTPQueueListener>(this.listeners);
            for (IFTPQueueListener listener : tmp_list) {
                listener.newJobAddToQueue(job);
            }
        }
        return job;
    }

    public IFTPManager getFTPManager() {
        return this.manager;
    }

    public boolean isIdle() {
        return this.fileTransfersQueue.size() == 0;
    }

    public List<IFtpFileTransfer> getFiles() {
        ArrayList<IFtpFileTransfer> listOfFiles = new ArrayList<IFtpFileTransfer>();
        for (IFileTransferJob transferJob : this.jobList) {
            listOfFiles.addAll(transferJob.getFiles());
        }
        return listOfFiles;
    }

    public List<IFileTransferJob> getJobs() {
        return new ArrayList<IFileTransferJob>(this.jobList);
    }

    public List<IFtpFileTransfer> getActiveFiles() {
        ArrayList<IFtpFileTransfer> listOfFiles = new ArrayList<IFtpFileTransfer>();
        for (IFileTransferJob transferJob : this.jobList) {
            listOfFiles.addAll(transferJob.getActive());
        }
        return listOfFiles;
    }

    public List<IFileTransferJob> getActiveJobs() {
        ArrayList<IFileTransferJob> listOfJobs = new ArrayList<IFileTransferJob>();
        for (IFileTransferJob transferJob : this.jobList) {
            if (transferJob.getActive().size() <= 0) continue;
            listOfJobs.add(transferJob);
        }
        return listOfJobs;
    }

    public List<IFtpFileTransfer> getDoneFiles() {
        ArrayList<IFtpFileTransfer> listOfFiles = new ArrayList<IFtpFileTransfer>();
        for (IFileTransferJob transferJob : this.jobList) {
            listOfFiles.addAll(transferJob.getDone());
        }
        return listOfFiles;
    }

    public List<IFileTransferJob> getDoneJobs() {
        ArrayList<IFileTransferJob> listOfJobs = new ArrayList<IFileTransferJob>();
        for (IFileTransferJob transferJob : this.jobList) {
            if (transferJob.getDone().size() != transferJob.getFiles().size()) continue;
            listOfJobs.add(transferJob);
        }
        return listOfJobs;
    }

    private class FileThread
    extends Thread {
        private final AtomicBoolean keepRunning = new AtomicBoolean(true);
        private final AtomicBoolean done = new AtomicBoolean(false);

        private FileThread() {
        }

        @Override
        public void run() {
            while (this.keepRunning.get()) {
                try {
                    IFtpFileTransfer job = FTPQueueImpl.this.fileTransfersQueue.poll(1L, TimeUnit.SECONDS);
                    if (job == null) continue;
                    try {
                        FTPQueueImpl.this.handleFileTransferJob(job);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (job.getStatus() == TransferStatus.ERROR) continue;
                        job.setStatus(TransferStatus.ERROR);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.done.set(true);
            this.clean();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clean() {
            List<FileThread> list = FTPQueueImpl.this.fileThreadList;
            synchronized (list) {
                FTPQueueImpl.this.fileThreadList.remove(this);
            }
            new Thread(){};
        }
    }

    private class JobThread
    extends Thread {
        private JobThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (true) {
                try {
                    block6: while (true) {
                        IFileTransferJob job = FTPQueueImpl.this.jobQueue.take();
                        job.handleTransferJob();
                        List<IFTPQueueListener> list = FTPQueueImpl.this.listeners;
                        // MONITORENTER : list
                        ArrayList<IFTPQueueListener> tmp_list = new ArrayList<IFTPQueueListener>(FTPQueueImpl.this.listeners);
                        Iterator iterator = tmp_list.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                // MONITOREXIT : list
                                continue block6;
                            }
                            IFTPQueueListener listener = (IFTPQueueListener)iterator.next();
                            listener.newFilesAddedToQueue(new ArrayList(job.getFiles()));
                        }
                        break;
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT : list
                        throw throwable;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

