/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ftpservice.internal;

import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.commons.ftpservice.IRemoteFile;
import com.biotechvana.commons.model.ILocalFile;
import com.biotechvana.commons.model.UserLoginInfo;
import com.biotechvana.ftpservice.internal.LocalFileImpl;
import com.biotechvana.ftpservice.internal.RemoteFileImpl;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamException;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.net.io.Util;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;

@Creatable
public class FTPManagerImpl
implements IFTPManager {
    public FileSystemManager fileSystemManager = VFS.getManager();
    FileSystemManager updateManager = VFS.getManager();
    FileSystemOptions SFTPopts = new FileSystemOptions();
    FileSystemOptions FTPopts;
    private String local_home;
    private int numConcurrentTranfers = 2;
    public FileObject remoteRootFolder;
    FileObject remoteRootFolderUpdate;
    FileObject remoteCWD;
    private IEventBroker eventsBroker;
    UserLoginInfo activeLogin;
    boolean is_chRooted = true;

    @Inject
    @Optional
    public void setEventBroker(IEventBroker eventsBroker) {
        this.eventsBroker = eventsBroker;
    }

    public FTPManagerImpl() throws FileSystemException {
        SftpFileSystemConfigBuilder.getInstance().setIdentities(this.SFTPopts, new File[0]);
        SftpFileSystemConfigBuilder.getInstance().setSessionTimeout(this.SFTPopts, Duration.ofSeconds(5L));
        this.FTPopts = new FileSystemOptions();
        FtpFileSystemConfigBuilder.getInstance().setPassiveMode(this.FTPopts, true);
        this.local_home = System.getProperty("user.home");
    }

    @Inject
    public void setActiveLogin(@Optional @Named(value="ACTIVE_LOGIN") UserLoginInfo activeLogin) {
        if (this.activeLogin != activeLogin) {
            this.activeLogin = activeLogin;
            this.setConnectionSettings();
        }
    }

    private void setConnectionSettings() {
        if (this.isConnected()) {
            this.close();
        }
        if (this.activeLogin == null) {
            this.close();
            return;
        }
        if (this.login()) {
            System.out.println("Login Correct");
            if (this.eventsBroker != null) {
                this.eventsBroker.post("FTP/CONN/OPENED", null);
                this.eventsBroker.post("FTP/WD/CHANGED", (Object)"/");
            }
        }
    }

    public boolean login() {
        if (this.activeLogin != null) {
            return this.login(this.activeLogin);
        }
        return false;
    }

    public boolean login(UserLoginInfo activeLogin) {
        String scheme;
        String password;
        String username;
        String hostname;
        block16: {
            hostname = activeLogin.getHostInfo().getServerURL();
            username = activeLogin.getUserName();
            password = activeLogin.getPassword();
            scheme = activeLogin.getHostInfo().getScheme();
            if (!hostname.isEmpty() && !username.isEmpty() && !password.isEmpty()) break block16;
            this.close();
            return false;
        }
        try {
            int connPort = 22;
            switch (scheme) {
                case "ftp": {
                    connPort = activeLogin.getHostInfo().getFtpPort();
                    break;
                }
                case "sftp": {
                    connPort = activeLogin.getHostInfo().getSshPort();
                    break;
                }
                case "ftps": {
                    connPort = activeLogin.getHostInfo().getFtpPort();
                    break;
                }
                default: {
                    scheme = "sftp";
                    connPort = activeLogin.getHostInfo().getSshPort();
                }
            }
            String userHome = activeLogin.getHostInfo().getUserHomePath();
            SftpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(this.SFTPopts, userHome.isEmpty());
            FileSystemOptions opts = "sftp".equals(scheme) ? this.SFTPopts : this.FTPopts;
            URI uri = new URI(scheme, username + ":" + password, hostname, connPort, userHome, null, null);
            URI rooturi = new URI(scheme, username + ":" + password, hostname, connPort, "/", null, null);
            this.remoteCWD = this.fileSystemManager.resolveFile(uri.toString(), opts);
            this.remoteRootFolder = this.fileSystemManager.resolveFile(rooturi.toString(), opts);
            this.remoteRootFolderUpdate = this.updateManager.resolveFile(rooturi.toString(), opts);
            this.chechIfRooted();
        }
        catch (URISyntaxException | FileSystemException e) {
            e.printStackTrace();
            return false;
        }
        this.activeLogin = activeLogin;
        return true;
    }

    public boolean testConnection(String scheme, String username, String password, String hostname, int port) {
        try (StandardFileSystemManager testFileSystemManager = new StandardFileSystemManager();){
            try {
                testFileSystemManager.init();
                FileSystemOptions opts = scheme.equals("sftp") ? this.SFTPopts : this.FTPopts;
                URI uri = new URI(scheme, username + ":" + password, hostname, port, "", null, null);
                System.out.println("Testing start");
                FileObject x = testFileSystemManager.resolveFile(uri.toString(), opts);
                FileObject[] y = x.getChildren();
                System.out.println("Testing ended");
            }
            catch (URISyntaxException | FileSystemException e) {
                e.printStackTrace();
                testFileSystemManager.close();
                return false;
            }
        }
        return true;
    }

    public boolean changeWorkingDirectory(String path) {
        String old_wd = null;
        if (this.remoteCWD != null) {
            old_wd = this.remoteCWD.getName().getPath();
        }
        if (old_wd != null && old_wd.equals(path)) {
            return true;
        }
        FileObject directory = this.getDirectory(path);
        if (directory != null) {
            this.remoteCWD = directory;
            String new_wd = this.remoteCWD.getName().getPath();
            if (old_wd != null && !old_wd.equals(new_wd) && this.eventsBroker != null) {
                this.eventsBroker.post("FTP/WD/CHANGED", (Object)new_wd);
            }
            return true;
        }
        return false;
    }

    public boolean changeToParentDirectory() {
        try {
            if (this.remoteCWD.getName().getDepth() > 0) {
                this.remoteCWD = this.remoteCWD.getParent();
                String new_wd = this.remoteCWD.getName().getPath();
                if (this.eventsBroker != null) {
                    this.eventsBroker.post("FTP/WD/CHANGED", (Object)new_wd);
                }
            }
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public IRemoteFile[] listFiles() {
        return this.listFiles(false, false, false);
    }

    private IRemoteFile[] listFiles(FileObject directory, boolean addCurrent, boolean addParent, boolean showHidden) {
        ArrayList<RemoteFileImpl> listFiles = new ArrayList<RemoteFileImpl>();
        ArrayList<RemoteFileImpl> listFolders = new ArrayList<RemoteFileImpl>();
        try {
            FileObject parent;
            FileObject[] tempList;
            FileObject[] fileObjectArray = tempList = directory.getChildren();
            int n = tempList.length;
            int n2 = 0;
            while (n2 < n) {
                FileObject file = fileObjectArray[n2];
                if (file.getName().getBaseName().charAt(0) != '.') {
                    if (file.isFile()) {
                        listFiles.add(new RemoteFileImpl(file));
                    } else {
                        listFolders.add(new RemoteFileImpl(file));
                    }
                }
                ++n2;
            }
            this.sortFiles(listFiles);
            this.sortFiles(listFolders);
            if (addParent && (parent = directory.getParent()) != null) {
                listFolders.add(0, new RemoteFileImpl(parent){

                    @Override
                    public boolean isParent() {
                        return true;
                    }
                });
            }
            if (addCurrent) {
                listFolders.add(0, new RemoteFileImpl(directory){

                    @Override
                    public boolean isCWD() {
                        return true;
                    }
                });
            }
            listFolders.addAll(listFiles);
        }
        catch (FileSystemException e) {
            e.printStackTrace();
        }
        return (IRemoteFile[])listFolders.toArray(RemoteFileImpl[]::new);
    }

    public IRemoteFile[] listFiles(String path) {
        FileObject directory = this.getDirectoryUpdate(path);
        return this.listFiles(directory, false, false, false);
    }

    public IRemoteFile[] listFiles(String path, boolean addCurrent, boolean addParent, boolean showHidden) {
        FileObject directory = this.getDirectoryUpdate(path);
        return this.listFiles(directory, addCurrent, addParent, showHidden);
    }

    public IRemoteFile[] listFiles(boolean addCurrent, boolean addParent, boolean showHidden) {
        return this.listFiles(this.remoteCWD.getName().getPath(), addCurrent, addParent, showHidden);
    }

    public boolean uploadFile(String local, String remote) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileObject getDirectory(String path) {
        try {
            FileObject fileFound = this.remoteCWD.resolveFile(path);
            if (!fileFound.exists()) {
                fileFound.close();
                return null;
            }
            if (fileFound.isFile()) {
                fileFound.close();
                return null;
            }
            return fileFound;
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileObject getDirectoryUpdate(String path) {
        try {
            FileObject fileFound = this.remoteRootFolderUpdate.resolveFile(path);
            if (!fileFound.exists()) {
                fileFound.close();
                return null;
            }
            if (fileFound.isFile()) {
                fileFound.close();
                return null;
            }
            return fileFound;
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean close() {
        if (this.remoteCWD != null) {
            try {
                try {
                    this.remoteCWD.close();
                    VFS.reset();
                    this.fileSystemManager = VFS.getManager();
                    this.updateManager = VFS.getManager();
                }
                catch (FileSystemException e) {
                    e.printStackTrace();
                    this.remoteCWD = null;
                    if (this.eventsBroker != null) {
                        this.eventsBroker.post("FTP/CONN/CLOSED", null);
                    }
                }
            }
            finally {
                this.remoteCWD = null;
                if (this.eventsBroker != null) {
                    this.eventsBroker.post("FTP/CONN/CLOSED", null);
                }
            }
        }
        return true;
    }

    public boolean isConnected() {
        return this.remoteCWD != null;
    }

    public boolean createFolder(String path) {
        try {
            FileObject folderToCreate = this.remoteCWD.resolveFile(path);
            folderToCreate.createFolder();
        }
        catch (FileSystemException e) {
            return false;
        }
        return true;
    }

    public boolean createFile(String path) {
        try {
            FileObject fileToCreate = this.remoteCWD.resolveFile(path);
            fileToCreate.createFile();
        }
        catch (FileSystemException e) {
            return false;
        }
        return true;
    }

    public IRemoteFile getWorkingDirectory() {
        return new RemoteFileImpl(this.remoteCWD);
    }

    public boolean delete(String path) {
        try {
            this.remoteCWD.resolveFile(path).deleteAll();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean rename(String uri, String value) {
        FileObject destFile;
        FileObject srcFile;
        block3: {
            try {
                String scheme = this.activeLogin.getHostInfo().getScheme();
                FileSystemOptions opts = "sftp".equals(scheme) ? this.SFTPopts : this.FTPopts;
                srcFile = this.fileSystemManager.resolveFile(uri, opts);
                destFile = srcFile.getParent().resolveFile(value);
                if (!destFile.exists()) break block3;
                return false;
            }
            catch (FileSystemException e) {
                e.printStackTrace();
                return false;
            }
        }
        srcFile.moveTo(destFile);
        return true;
    }

    public boolean paste(String source, String destination, boolean move) {
        FileObject srcFile;
        FileObject destDirectory;
        block11: {
            FileSystemOptions opts;
            block10: {
                block9: {
                    String scheme = this.activeLogin.getHostInfo().getScheme();
                    opts = "sftp".equals(scheme) ? this.SFTPopts : this.FTPopts;
                    destDirectory = this.fileSystemManager.resolveFile(destination, opts);
                    if (destDirectory.exists()) break block9;
                    return false;
                }
                if (destDirectory.isFile()) {
                    destDirectory = destDirectory.getParent();
                }
                if (destDirectory.isWriteable()) break block10;
                return false;
            }
            srcFile = this.fileSystemManager.resolveFile(source, opts);
            if (srcFile.exists() && srcFile.isReadable()) break block11;
            return false;
        }
        try {
            FileObject destFile = destDirectory.resolveFile(srcFile.getName().getBaseName());
            while (destFile.exists()) {
                FileObject aux = destDirectory.resolveFile(destFile.getName().getBaseName() + "_copy");
                destFile.close();
                destFile = aux;
            }
            if (move) {
                srcFile.moveTo(destFile);
            } else {
                destFile.copyFrom(srcFile, Selectors.SELECT_ALL);
            }
        }
        catch (FileSystemException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void copy_file_to(String fileName, OutputStream destinationOutputStream) {
        try {
            FileObject sourceFile = this.remoteCWD.resolveFile(fileName);
            InputStream sourceFileIn = sourceFile.getContent().getInputStream();
            try {
                try {
                    Util.copyStream((InputStream)sourceFileIn, (OutputStream)destinationOutputStream, (int)0x7D0000, (long)sourceFile.getContent().getSize(), (CopyStreamListener)new CopyStreamListener(){

                        public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
                        }

                        public void bytesTransferred(CopyStreamEvent event) {
                        }
                    });
                }
                catch (CopyStreamException e) {
                    e.printStackTrace();
                }
            }
            finally {
                try {
                    sourceFileIn.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (FileSystemException e) {
            e.printStackTrace();
        }
    }

    public void copy_file_from(String destinationFileName, InputStream sourceStream) {
        try {
            FileObject destinationFile = this.remoteCWD.resolveFile(destinationFileName);
            OutputStream destinationOutputStream = destinationFile.getContent().getOutputStream();
            try {
                try {
                    Util.copyStream((InputStream)sourceStream, (OutputStream)destinationOutputStream, (int)0x7D0000, (long)-1L, (CopyStreamListener)new CopyStreamListener(){

                        public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
                        }

                        public void bytesTransferred(CopyStreamEvent event) {
                        }
                    });
                }
                catch (CopyStreamException e) {
                    e.printStackTrace();
                    try {
                        destinationOutputStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    destinationOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (FileSystemException e) {
            e.printStackTrace();
        }
    }

    public static void writeContent(FileObject sourceFile, FileObject destinationFile, CopyStreamListener progressMonitor) throws IOException {
        try (InputStream sourceFileIn = sourceFile.getContent().getInputStream();
             OutputStream destinationFileOut = destinationFile.getContent().getOutputStream();){
            Util.copyStream((InputStream)sourceFileIn, (OutputStream)destinationFileOut, (int)0x7D0000, (long)sourceFile.getContent().getSize(), (CopyStreamListener)progressMonitor);
        }
    }

    public long getSizeInBytes(String fileName) {
        try {
            FileObject sourceFile = this.remoteCWD.resolveFile(fileName);
            return sourceFile.getContent().getSize();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public IRemoteFile resolveRemoteFile(String relPath) throws IOException {
        return this.resolveRemoteFile(relPath, false);
    }

    public IRemoteFile resolveRemoteFile(String path, boolean isRel) throws IOException {
        try {
            if (isRel) {
                FileObject fileObject = this.remoteCWD.resolveFile(path);
                return new RemoteFileImpl(fileObject);
            }
            FileObject fileObject = this.remoteRootFolder.resolveFile(path);
            return new RemoteFileImpl(fileObject);
        }
        catch (FileSystemException e) {
            IOException newEx = new IOException("Can not locate file : " + path, e);
            throw newEx;
        }
    }

    public ILocalFile resolveLocalFile(String path) throws IOException {
        try {
            String scheme = this.activeLogin.getHostInfo().getScheme();
            FileSystemOptions opts = "sftp".equals(scheme) ? this.SFTPopts : this.FTPopts;
            return new LocalFileImpl(this.fileSystemManager.resolveFile(path, opts));
        }
        catch (FileSystemException e) {
            IOException newEx = new IOException("Can not locate file : " + path, e);
            throw newEx;
        }
    }

    public void sortFiles(ArrayList<RemoteFileImpl> listFiles) {
        Collections.sort(listFiles, new Comparator<RemoteFileImpl>(){

            @Override
            public int compare(RemoteFileImpl arg0, RemoteFileImpl arg1) {
                return arg0.getName().compareToIgnoreCase(arg1.getName());
            }
        });
    }

    public boolean isChRooted() {
        return this.is_chRooted;
    }

    public boolean isDirectory(String ftpFile) {
        return false;
    }

    public boolean chechIfRooted() {
        this.is_chRooted = true;
        String replyStr_default = this.getWorkingDirectory().getPath();
        System.out.println("ftpClient.printWorkingDirectory() =  " + replyStr_default);
        if (this.changeWorkingDirectory("/")) {
            String replyStr = this.getWorkingDirectory().getPath();
            System.out.println("After ftpClient.changeWorkingDirectory -> ftpClient.printWorkingDirectory() =  " + replyStr);
            if (!replyStr_default.equals(replyStr)) {
                this.is_chRooted = false;
            }
        }
        this.changeWorkingDirectory(replyStr_default);
        return this.is_chRooted;
    }
}

