/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.rcp.status;

import com.biotechvana.ui.rcp.status.StatusMsg;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.swt.graphics.Image;

public class CStatusLineManager
implements IStatusLineManager {
    @Inject
    ESelectionService service;
    private MPart part;
    HashMap<MPart, StatusMsg> msgsPerPart = new HashMap();
    StatusLineManager statusLineManager;

    @Inject
    public void setActivePart(@Optional @Named(value="e4ActivePart") MPart activePart) {
        this.part = activePart;
        if (this.msgsPerPart.containsKey(this.part)) {
            StatusMsg newMsg = this.msgsPerPart.get(this.part);
            this.service.setSelection((Object)newMsg);
        } else {
            this.service.setSelection((Object)new StatusMsg(""));
        }
    }

    public void setUnderLayingManager(StatusLineManager statusLineManager) {
        this.statusLineManager = statusLineManager;
    }

    public void setMessage(String msg) {
        StatusMsg newMsg = new StatusMsg(msg);
        this.msgsPerPart.put(this.part, newMsg);
        newMsg.setImage(null);
        newMsg.setMessage(msg);
        newMsg.setIsError(false);
        this.service.setSelection((Object)newMsg);
    }

    public void add(IAction action) {
    }

    public void add(IContributionItem item) {
    }

    public void appendToGroup(String groupName, IAction action) {
    }

    public void appendToGroup(String groupName, IContributionItem item) {
    }

    public IContributionItem find(String id) {
        return this.statusLineManager.find(id);
    }

    public IContributionItem[] getItems() {
        return this.statusLineManager.getItems();
    }

    public IContributionManagerOverrides getOverrides() {
        return this.statusLineManager.getOverrides();
    }

    public void insertAfter(String id, IAction action) {
        this.statusLineManager.insertAfter(id, action);
    }

    public void insertAfter(String id, IContributionItem item) {
    }

    public void insertBefore(String id, IAction action) {
    }

    public void insertBefore(String id, IContributionItem item) {
    }

    public boolean isDirty() {
        return this.statusLineManager.isDirty();
    }

    public boolean isEmpty() {
        return this.statusLineManager.isEmpty();
    }

    public void markDirty() {
        this.statusLineManager.markDirty();
    }

    public void prependToGroup(String groupName, IAction action) {
        this.statusLineManager.prependToGroup(groupName, action);
    }

    public void prependToGroup(String groupName, IContributionItem item) {
        this.statusLineManager.prependToGroup(groupName, item);
    }

    public IContributionItem remove(String id) {
        return this.statusLineManager.remove(id);
    }

    public IContributionItem remove(IContributionItem item) {
        return this.statusLineManager.remove(item);
    }

    public void removeAll() {
        this.statusLineManager.removeAll();
    }

    public void update(boolean force) {
        this.statusLineManager.update(force);
    }

    public IProgressMonitor getProgressMonitor() {
        if (this.statusLineManager != null) {
            return this.statusLineManager.getProgressMonitor();
        }
        return new NullProgressMonitor();
    }

    public boolean isCancelEnabled() {
        return this.statusLineManager.isCancelEnabled();
    }

    public void setCancelEnabled(boolean enabled) {
        this.statusLineManager.setCancelEnabled(enabled);
    }

    public void setErrorMessage(String message) {
        StatusMsg newMsg = new StatusMsg(message);
        this.msgsPerPart.put(this.part, newMsg);
        newMsg.setImage(null);
        newMsg.setMessage(message);
        newMsg.setIsError(true);
        this.service.setSelection((Object)newMsg);
    }

    public void setErrorMessage(Image image, String message) {
        StatusMsg newMsg = new StatusMsg(message);
        this.msgsPerPart.put(this.part, newMsg);
        newMsg.setImage(image);
        newMsg.setMessage(message);
        newMsg.setIsError(true);
        this.service.setSelection((Object)newMsg);
    }

    public void setMessage(Image image, String message) {
        StatusMsg newMsg = new StatusMsg(message);
        this.msgsPerPart.put(this.part, newMsg);
        newMsg.setImage(image);
        newMsg.setMessage(message);
        newMsg.setIsError(false);
        this.service.setSelection((Object)newMsg);
    }
}

