/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.variables;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.commons.model.DropManager;
import com.biotechvana.users.InvalidLoginInfoException;
import com.biotechvana.workflow.IWorkflowJobComposite;
import com.biotechvana.workflow.WorkflowConstants;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.ui.variables.VariableComposite;
import com.biotechvana.workflow.variables.JobVariable;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class FilesVariableComposite
extends VariableComposite {
    private static final String CONS_FIELD_TYPE_PREFIX = "Field Type : ";
    boolean loopBack = false;

    protected FilesVariableComposite(Composite parent, IWorkflowJobComposite parentJobComposite, JobVariable var, int istyle) {
        super(parent, parentJobComposite, var, istyle);
    }

    @Override
    protected void createContolsPart() {
        super.createContolsPart();
        if (this.var.getDescGUIVisible()) {
            GridData layoutData;
            VariableDescriptor.VariableType varType = this.var.getDescVarType();
            if (varType != VariableDescriptor.VariableType.Checked && varType != VariableDescriptor.VariableType.FileList) {
                int varDesclabelHSpan = 2;
                this.varDesclabel = new Link((Composite)this, 0x40 | this.style);
                layoutData = new GridData(1, 0x1000000, false, false, varDesclabelHSpan, 1);
                layoutData.minimumWidth = 50;
                layoutData.minimumWidth = 50;
                layoutData.widthHint = 400;
                this.varDesclabel.setLayoutData((Object)layoutData);
                if (this.parentJobComposite.supportShowHelp()) {
                    this.varDesclabel.setText(this.var.getDescFriendlyName() + " : !");
                    this.varDesclabel.setToolTipText("Double Click! to Show more help.");
                } else {
                    this.varDesclabel.setText(this.var.getDescFriendlyName());
                    if (this.var.getDescHelpMsg() != null) {
                        this.varDesclabel.setToolTipText(this.var.getDescHelpMsg());
                    }
                }
                FontData fontdata = this.varDesclabel.getFont().getFontData()[0];
                fontdata.setStyle(1);
                final Font font = new Font((Device)this.getDisplay(), fontdata);
                this.varDesclabel.setFont(font);
                this.varDesclabel.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        font.dispose();
                    }
                });
            }
            if (varType != VariableDescriptor.VariableType.Checked && varType != VariableDescriptor.VariableType.FileList) {
                Object cmdParamater;
                Link varErrorslabel = new Link((Composite)this, 0x40 | this.style);
                layoutData = new GridData(4, 1, true, false, 1, 1);
                layoutData.widthHint = 300;
                layoutData.horizontalIndent = 10;
                varErrorslabel.setLayoutData((Object)layoutData);
                this.disposableParts.add(varErrorslabel);
                String helpMsg = this.var.getDescHelpMsg();
                if (helpMsg == null) {
                    helpMsg = "";
                }
                if (!((String)(cmdParamater = this.var.getDescCommandParamater().trim())).isEmpty()) {
                    cmdParamater = "(" + (String)cmdParamater;
                    String alt = this.var.getDescCommandParamaterAlt().trim();
                    if (!alt.isEmpty()) {
                        cmdParamater = (String)cmdParamater + "/" + alt;
                    }
                    cmdParamater = (String)cmdParamater + ") ";
                }
                this.helpMsg = (String)cmdParamater + helpMsg;
                this.varHelplabel = varErrorslabel;
            }
            if (varType == VariableDescriptor.VariableType.Files || varType == VariableDescriptor.VariableType.Folders) {
                final List varValueList = new List((Composite)this, 2818);
                int verticalSpan = 5;
                layoutData = new GridData(4, 1, true, false, 2, verticalSpan);
                layoutData.horizontalIndent = 25;
                layoutData.minimumWidth = 500;
                layoutData.heightHint = 150;
                varValueList.setLayoutData((Object)layoutData);
                String helpMsg = this.var.getDescShortHelpMsg();
                if ((helpMsg == null || helpMsg.isEmpty()) && ((helpMsg = this.var.getDescHelpMsg()) == null || helpMsg.isEmpty())) {
                    helpMsg = "Drag files from the FTP Browser";
                }
                varValueList.setToolTipText(helpMsg);
                String value = this.var.getValue();
                if (value != null) {
                    String[] files;
                    varValueList.removeAll();
                    String[] stringArray = files = this.var.getValue().split("\n");
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String file = stringArray[n2];
                        if (!file.isEmpty()) {
                            varValueList.add(file);
                        }
                        ++n2;
                    }
                }
                this.controlDecoration = new ControlDecoration((Control)varValueList, 0x1004000);
                this.controlDecoration.setDescriptionText("");
                this.controlDecoration.hide();
                varValueList.addListener(24, new Listener(){

                    public void handleEvent(Event event) {
                        FilesVariableComposite.this.updateVar(varValueList);
                    }
                });
                this.addListener(24, new Listener(){

                    public void handleEvent(Event event) {
                        String[] files;
                        if (FilesVariableComposite.this.loopBack) {
                            FilesVariableComposite.this.loopBack = false;
                            return;
                        }
                        varValueList.removeAll();
                        String[] stringArray = files = FilesVariableComposite.this.var.getValue().split("\n");
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String file = stringArray[n2];
                            if (!file.isEmpty()) {
                                varValueList.add(file);
                            }
                            ++n2;
                        }
                    }
                });
                varValueList.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (!FilesVariableComposite.this.var.isValid()) {
                            FilesVariableComposite.this.varErrorslabel.setText(FilesVariableComposite.this.var.getErrorMsg());
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Button moveUp = new Button((Composite)this, 8);
                layoutData = new GridData(1, 1, false, true, 1, 1);
                layoutData.widthHint = 40;
                layoutData.heightHint = 26;
                moveUp.setImage(SharedImages.ARROWUP);
                moveUp.setLayoutData((Object)layoutData);
                moveUp.setToolTipText("Move selected Items Up");
                moveUp.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (varValueList.getItemCount() == 0 || varValueList.getSelectionCount() == 0) {
                            return;
                        }
                        int[] selIndices = varValueList.getSelectionIndices();
                        int startIndex = selIndices[0];
                        if (startIndex == 0) {
                            return;
                        }
                        String[] selected = varValueList.getSelection();
                        varValueList.remove(selIndices);
                        int i = 0;
                        while (i < selIndices.length) {
                            varValueList.add(selected[i], startIndex - 1 + i);
                            selIndices[i] = selIndices[i] - 1;
                            ++i;
                        }
                        varValueList.setSelection(selIndices);
                        FilesVariableComposite.this.updateVar(varValueList);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Button buttonSelectAll = new Button((Composite)this, 8);
                buttonSelectAll.setText("Select all");
                layoutData = new GridData(1, 0x1000000, false, true, 1, 1);
                layoutData.widthHint = 120;
                buttonSelectAll.setLayoutData((Object)layoutData);
                buttonSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        varValueList.selectAll();
                    }
                });
                Button buttonSelectNone = new Button((Composite)this, 8);
                buttonSelectNone.setText("Select None");
                layoutData = new GridData(1, 0x1000000, false, true, 1, 1);
                layoutData.widthHint = 120;
                buttonSelectNone.setLayoutData((Object)layoutData);
                buttonSelectNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        varValueList.deselectAll();
                    }
                });
                Button buttonDeleteQuery = new Button((Composite)this, 8);
                buttonDeleteQuery.setText("Delete Selected");
                layoutData = new GridData(1, 0x1000000, false, true, 1, 1);
                layoutData.widthHint = 120;
                buttonDeleteQuery.setLayoutData((Object)layoutData);
                buttonDeleteQuery.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (varValueList.getItemCount() == 0) {
                            return;
                        }
                        int[] selIndices = varValueList.getSelectionIndices();
                        varValueList.remove(selIndices);
                        if (selIndices[0] > 0) {
                            varValueList.setSelection(selIndices[0] - 1);
                        } else {
                            varValueList.setSelection(0);
                        }
                        varValueList.notifyListeners(24, new Event());
                    }
                });
                Button moveDown = new Button((Composite)this, 8);
                layoutData = new GridData(1, 1024, false, true, 1, 1);
                layoutData.widthHint = 40;
                layoutData.heightHint = 26;
                moveDown.setImage(SharedImages.ARROWDOWN);
                moveDown.setLayoutData((Object)layoutData);
                moveDown.setToolTipText("Move selected Items Down");
                moveDown.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (varValueList.getItemCount() == 0 || varValueList.getSelectionCount() == 0) {
                            return;
                        }
                        int[] selIndices = varValueList.getSelectionIndices();
                        int startIndex = selIndices[0];
                        if (startIndex + selIndices.length >= varValueList.getItemCount()) {
                            return;
                        }
                        String[] selected = varValueList.getSelection();
                        varValueList.remove(selIndices);
                        int i = 0;
                        while (i < selIndices.length) {
                            varValueList.add(selected[i], startIndex + 1 + i);
                            selIndices[i] = selIndices[i] + 1;
                            ++i;
                        }
                        varValueList.setSelection(selIndices);
                        FilesVariableComposite.this.updateVar(varValueList);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                int dropManagerType = -1;
                switch (varType) {
                    case Files: {
                        dropManagerType = 3;
                        break;
                    }
                    case Folders: {
                        dropManagerType = 4;
                    }
                }
                if (dropManagerType != -1) {
                    try {
                        String userName = this.parentJobComposite.getUserManager().getUserLoginInfo().getUserName();
                        String hostName = this.parentJobComposite.getUserManager().getUserLoginInfo().getHostInfo().getServerURL();
                        String password = this.parentJobComposite.getUserManager().getUserLoginInfo().getPassword();
                        String ftpPort = "" + this.parentJobComposite.getUserManager().getUserLoginInfo().getHostInfo().getFtpPort();
                        this.dropManager = DropManager.create((Control)varValueList, (int)2, (int)dropManagerType);
                    }
                    catch (InvalidLoginInfoException e1) {
                        e1.printStackTrace();
                    }
                    if (this.var.getDescAcceptedFileTypes() != null) {
                        Object filter = "";
                        for (String fileFormat : this.var.getDescAcceptedFileTypes()) {
                            filter = (String)filter + "|" + fileFormat;
                        }
                        if (!((String)filter).isEmpty()) {
                            this.dropManager.setFilesFilter(WorkflowConstants.getFileFormatFilter((String)filter));
                        }
                    }
                }
            }
            if (varType == VariableDescriptor.VariableType.Files && this.var.getHasSampleResources()) {
                Link link = new Link((Composite)this, 0);
                link.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
                Object linkText = "Examples of accepted Input format : ";
                if (this.var.getSampleResources().size() == 1) {
                    linkText = "Example of accepted Input format : ";
                }
                for (String sample : this.var.getSampleResources()) {
                    String sampleDisplayName = this.var.getSampleResourcesName(sample);
                    linkText = (String)linkText + "<a href=\"" + sample + "\">" + sampleDisplayName + "</a>, ";
                }
                link.setText(((String)linkText).substring(0, ((String)linkText).length() - 2));
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String filename = e.text.substring(e.text.lastIndexOf(47) + 1);
                        FilesVariableComposite.this.exportResources(FilesVariableComposite.this.var.getJob().getJobDescID(), filename);
                    }
                });
            }
        }
    }

    protected void updateVar(List varValueList) {
        Object val = "";
        String[] stringArray = varValueList.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            val = (String)val + file + "\n";
            ++n2;
        }
        this.loopBack = true;
        this.var.setValue((String)val);
    }

    public static List createBasicControl(IWorkflowJobComposite parentJobComposite, Composite parent, final JobVariable variable, int observerUpdateEvent, boolean orderBtn, boolean sortBtn) {
        final List varValueList = new List(parent, 2818);
        Listener updateEvenet = new Listener(){

            public void handleEvent(Event event) {
                String value = variable.getValue();
                if (value != null) {
                    String[] lines;
                    varValueList.removeAll();
                    String[] stringArray = lines = variable.getValue().split("\n");
                    int n = lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        if (!line.isEmpty()) {
                            varValueList.add(line);
                        }
                        ++n2;
                    }
                }
            }
        };
        updateEvenet.handleEvent(null);
        varValueList.addListener(observerUpdateEvent, updateEvenet);
        varValueList.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                Object val = "";
                String[] stringArray = varValueList.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    val = (String)val + file + "\n";
                    ++n2;
                }
                variable.setValue((String)val);
            }
        });
        int dropManagerType = -1;
        switch (variable.getDescVarType()) {
            case Files: {
                dropManagerType = 3;
                break;
            }
            case Folders: {
                dropManagerType = 4;
                break;
            }
        }
        if (dropManagerType != -1) {
            DropManager dropManager = null;
            try {
                String userName = parentJobComposite.getUserManager().getUserLoginInfo().getUserName();
                String hostName = parentJobComposite.getUserManager().getUserLoginInfo().getHostInfo().getServerURL();
                String password = parentJobComposite.getUserManager().getUserLoginInfo().getPassword();
                String ftpPort = "" + parentJobComposite.getUserManager().getUserLoginInfo().getHostInfo().getFtpPort();
                dropManager = DropManager.create((Control)varValueList, (int)2, (int)dropManagerType);
            }
            catch (InvalidLoginInfoException e1) {
                e1.printStackTrace();
            }
            if (variable.getDescAcceptedFileTypes() != null) {
                Object filter = "";
                for (String fileFormat : variable.getDescAcceptedFileTypes()) {
                    filter = (String)filter + "|" + fileFormat;
                }
                if (!((String)filter).isEmpty()) {
                    dropManager.setFilesFilter(WorkflowConstants.getFileFormatFilter((String)filter));
                }
            }
        }
        Menu menu = new Menu((Control)varValueList);
        varValueList.setMenu(menu);
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText("Delete Selected");
        menuItem = new MenuItem(menu, 0);
        menuItem.setText("Delete All");
        menuItem = new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 0);
        menuItem.setText("Select All");
        menuItem = new MenuItem(menu, 0);
        menuItem.setText("Select None");
        if (orderBtn) {
            menuItem = new MenuItem(menu, 2);
            menuItem = new MenuItem(menu, 0);
            menuItem.setText("Move Selected Up");
            menuItem.setImage(SharedImages.ARROWUP);
            menuItem = new MenuItem(menu, 0);
            menuItem.setText("Move Selected Down");
            menuItem.setImage(SharedImages.ARROWDOWN);
        }
        if (sortBtn) {
            menuItem = new MenuItem(menu, 2);
            menuItem = new MenuItem(menu, 64);
            menuItem.setText("Sort");
            Menu subMenu = new Menu(menu);
            menuItem.setMenu(subMenu);
            menuItem = new MenuItem(subMenu, 8);
            menuItem.setText("Sort by Name");
            menuItem = new MenuItem(subMenu, 8);
            menuItem.setText("Sort by Name/number");
        }
        return varValueList;
    }

    public static List createBasicControl(IWorkflowJobComposite parentJobComposite, Composite parent, JobVariable variable, int observerUpdateEvent) {
        return FilesVariableComposite.createBasicControl(parentJobComposite, parent, variable, observerUpdateEvent, true, false);
    }
}

