/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import java.util.Hashtable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.internal.forms.widgets.FormImages;
import org.eclipse.ui.internal.forms.widgets.FormUtil;

public class Section
extends ExpandableComposite {
    public static final int DESCRIPTION = 128;
    private Control descriptionControl;
    private Control separator;
    private Hashtable<String, Color> titleColors;
    private static final String COLOR_BG = "bg";
    private static final String COLOR_GBG = "gbg";
    private static final String COLOR_BORDER = "border";

    public Section(Composite parent, int style) {
        this(parent, 0, style);
    }

    Section(Composite parent, int cstyle, int style) {
        super(parent, cstyle | Section.getBackgroundStyle(style), style);
        int rtl = cstyle & 0x4000000;
        if ((style & 0x80) != 0) {
            this.descriptionControl = new Label((Composite)this, 0x40 | rtl);
        }
        if ((style & 0x100) != 0) {
            Listener listener = e -> {
                Image image = Section.super.getBackgroundImage();
                if (image != null) {
                    FormImages.getInstance().markFinished(image, this.getDisplay());
                }
                Section.super.setBackgroundImage(null);
            };
            this.addListener(12, listener);
            this.addListener(11, listener);
        }
    }

    private static int getBackgroundStyle(int estyle) {
        return (estyle & 0x100) != 0 ? 262144 : 0;
    }

    @Override
    protected void internalSetExpanded(boolean expanded) {
        super.internalSetExpanded(expanded);
        if ((this.getExpansionStyle() & 0x100) != 0 && !expanded) {
            super.setBackgroundImage(null);
        }
        this.reflow();
    }

    @Override
    protected void reflow() {
        super.reflow();
    }

    public void setDescription(String description) {
        if (this.descriptionControl instanceof Label) {
            ((Label)this.descriptionControl).setText(description);
        }
    }

    public String getDescription() {
        if (this.descriptionControl instanceof Label) {
            return ((Label)this.descriptionControl).getText();
        }
        return null;
    }

    public void setSeparatorControl(Control separator) {
        Assert.isTrue((separator != null && separator.getParent().equals((Object)this) ? 1 : 0) != 0);
        this.separator = separator;
    }

    @Override
    public Control getSeparatorControl() {
        return this.separator;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.descriptionControl != null && (this.getExpansionStyle() & 0x80) != 0) {
            this.descriptionControl.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.descriptionControl != null) {
            this.descriptionControl.setForeground(fg);
        }
    }

    @Override
    public Control getDescriptionControl() {
        return this.descriptionControl;
    }

    public void setDescriptionControl(Control descriptionControl) {
        Assert.isTrue(((this.getExpansionStyle() & 0x80) == 0 ? 1 : 0) != 0);
        Assert.isTrue((descriptionControl != null && descriptionControl.getParent().equals((Object)this) ? 1 : 0) != 0);
        this.descriptionControl = descriptionControl;
    }

    public void setTitleBarBorderColor(Color color) {
        this.putTitleBarColor(COLOR_BORDER, color);
    }

    public void setTitleBarBackground(Color color) {
        this.putTitleBarColor(COLOR_BG, color);
    }

    public void setTitleBarGradientBackground(Color color) {
        this.putTitleBarColor(COLOR_GBG, color);
    }

    public Color getTitleBarBorderColor() {
        if (this.titleColors == null) {
            return null;
        }
        return this.titleColors.get(COLOR_BORDER);
    }

    public Color getTitleBarGradientBackground() {
        if (this.titleColors == null) {
            return null;
        }
        if ((this.getExpansionStyle() & 0x200) != 0) {
            return this.getBackground();
        }
        return this.titleColors.get(COLOR_GBG);
    }

    public Color getTitleBarBackground() {
        if (this.titleColors == null) {
            return null;
        }
        return this.titleColors.get(COLOR_BG);
    }

    private void putTitleBarColor(String key, Color color) {
        if (color == null) {
            return;
        }
        if (this.titleColors == null) {
            this.titleColors = new Hashtable();
        }
        this.titleColors.put(key, color);
    }

    @Override
    protected void onPaint(PaintEvent e) {
        Color bg = null;
        Color fg = null;
        Color border = null;
        GC gc = e.gc;
        Image buffer = null;
        Rectangle bounds = this.getClientArea();
        if (bounds.width == 0 || bounds.height == 0) {
            return;
        }
        if ((this.getExpansionStyle() & 0x100) != 0) {
            buffer = new Image((Device)this.getDisplay(), bounds.width, bounds.height);
            buffer.setBackground(this.getBackground());
            gc = new GC((Drawable)buffer);
        }
        if (this.titleColors != null) {
            bg = this.titleColors.get(COLOR_BG);
            fg = this.getTitleBarForeground();
            border = this.titleColors.get(COLOR_BORDER);
        }
        if (bg == null) {
            bg = this.getBackground();
        }
        if (fg == null) {
            fg = this.getForeground();
        }
        if (border == null) {
            border = fg;
        }
        int theight = 0;
        int gradientheight = 0;
        int tvmargin = 4;
        if ((this.getExpansionStyle() & 0x100) != 0) {
            Point size;
            Point tsize = null;
            Point tcsize = null;
            if (this.toggle != null) {
                tsize = this.toggle.getSize();
            }
            if (this.getTextClient() != null) {
                tcsize = this.getTextClient().getSize();
            }
            Point point = size = this.textLabel == null ? new Point(0, 0) : this.textLabel.getSize();
            if (tsize != null) {
                theight += Math.max(theight, tsize.y);
            }
            gradientheight = theight;
            if (tcsize != null) {
                theight = Math.max(theight, tcsize.y);
            }
            theight = Math.max(theight, size.y);
            gradientheight = Math.max(gradientheight, size.y);
            theight += tvmargin + tvmargin;
            gradientheight += tvmargin + tvmargin;
        } else {
            theight = 5;
        }
        if ((this.getExpansionStyle() & 0x100) != 0) {
            if (this.getBackgroundImage() == null) {
                this.updateHeaderImage(bg, bounds, gradientheight, theight);
            }
            gc.setBackground(this.getBackground());
            gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
            this.drawBackground(gc, bounds.x, bounds.y, bounds.width, theight - 2);
            if (this.marginWidth > 0) {
                gc.setBackground(this.getBackground());
                gc.fillRectangle(0, 0, this.marginWidth, theight);
                gc.fillRectangle(bounds.x + bounds.width - this.marginWidth, 0, this.marginWidth, theight);
            }
        } else if (this.isExpanded()) {
            gc.setForeground(bg);
            gc.setBackground(this.getBackground());
            gc.fillGradientRectangle(this.marginWidth, this.marginHeight, bounds.width - this.marginWidth - this.marginWidth, theight, true);
        }
        gc.setBackground(this.getBackground());
        FormUtil.setAntialias(gc, 1);
        gc.fillPolygon(new int[]{this.marginWidth, this.marginHeight, this.marginWidth, this.marginHeight + 2, this.marginWidth + 2, this.marginHeight});
        gc.fillPolygon(new int[]{bounds.width - this.marginWidth - 3, this.marginHeight, bounds.width - this.marginWidth, this.marginHeight, bounds.width - this.marginWidth, this.marginHeight + 3});
        gc.setForeground(border);
        if (this.isExpanded() || (this.getExpansionStyle() & 0x100) != 0) {
            gc.drawLine(this.marginWidth, this.marginHeight + 2, this.marginWidth + 2, this.marginHeight);
            gc.drawLine(this.marginWidth + 2, this.marginHeight, bounds.width - this.marginWidth - 3, this.marginHeight);
            gc.drawLine(bounds.width - this.marginWidth - 3, this.marginHeight, bounds.width - this.marginWidth - 1, this.marginHeight + 2);
        } else {
            gc.drawLine(this.marginWidth, this.marginHeight, bounds.width - 1, this.marginHeight);
        }
        if ((this.getExpansionStyle() & 0x100) != 0 || this.isExpanded()) {
            gc.fillGradientRectangle(this.marginWidth, this.marginHeight + 2, 1, theight + 2, true);
            gc.fillGradientRectangle(bounds.width - this.marginWidth - 1, this.marginHeight + 2, 1, theight + 2, true);
        }
        if ((this.getExpansionStyle() & 0x100) != 0) {
            gc.setForeground(this.getBackground());
            gc.drawPolyline(new int[]{this.marginWidth + 1, this.marginHeight + gradientheight + 4, this.marginWidth + 1, this.marginHeight + 2, this.marginWidth + 2, this.marginHeight + 2, this.marginWidth + 2, this.marginHeight + 1, bounds.width - this.marginWidth - 3, this.marginHeight + 1, bounds.width - this.marginWidth - 3, this.marginHeight + 2, bounds.width - this.marginWidth - 2, this.marginHeight + 2, bounds.width - this.marginWidth - 2, this.marginHeight + gradientheight + 4});
        }
        if (buffer != null) {
            gc.dispose();
            e.gc.drawImage(buffer, 0, 0);
            buffer.dispose();
        }
    }

    private void updateHeaderImage(Color bg, Rectangle bounds, int theight, int realtheight) {
        Color gradient = this.getTitleBarGradientBackground() != null ? this.getTitleBarGradientBackground() : this.getBackground();
        Image image = FormImages.getInstance().getSectionGradientImage(gradient, bg, realtheight, theight, this.marginHeight, this.getDisplay());
        super.setBackgroundImage(image);
    }

    public final void setBackgroundImage(Image image) {
    }
}

