/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.expert.ui.internal;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.expert.DiagnoseRequest;
import com.biotechvana.expert.ExpertSystemAPI;
import com.biotechvana.expert.ui.internal.ExpertSystemView;
import com.biotechvana.workflow.tracking.ExecStatus;
import com.biotechvana.workflow.tracking.tasks.CMDTaskTracker;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ExpertSystemSummaryView {
    ExpertSystemView expertSystemView;
    Section summarySection;
    FormToolkit toolkit;
    DiagnoseRequest diagnoseRequest;
    CMDTaskTracker cmdTaskTracker;
    CMDTaskTracker.FilesTask filesTask;
    private Font boldFont;
    Label requestStatusLabel;
    ControlDecoration requestStatusLabelDecoration;

    public ExpertSystemSummaryView(ExpertSystemView expertSystemView, Section summarySection, FormToolkit toolkit) {
        this.expertSystemView = expertSystemView;
        this.summarySection = summarySection;
        this.toolkit = toolkit;
    }

    public void createSection() {
        ToolBar tbar = new ToolBar((Composite)this.summarySection, 0x800100);
        ToolItem titem = new ToolItem(tbar, 8);
        titem.setImage(SharedImages.REFRESH);
        titem.setToolTipText("Check Request Status");
        titem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExpertSystemSummaryView.this.expertSystemView.updateRequestStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        tbar.pack();
        this.summarySection.setTextClient((Control)tbar);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = 5;
        this.summarySection.setLayoutData((Object)gd);
        this.summarySection.setLayout((Layout)new GridLayout(3, true));
    }

    protected void updateRequestStatus() {
        try {
            this.expertSystemView.getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Update in Progress, Please wait", -1);
                    try {
                        ExpertSystemSummaryView.this.expertSystemView.getUiSync().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ExpertSystemSummaryView.this.updateRequestStatusLabel(true);
                            }
                        });
                        ExpertSystemSummaryView.this.expertSystemView.getExpertSystemAPI().updateRequestStatus(ExpertSystemSummaryView.this.diagnoseRequest, monitor);
                        monitor.done();
                        ExpertSystemSummaryView.this.expertSystemView.getUiSync().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ExpertSystemSummaryView.this.updateRequestStatusLabel(false);
                            }
                        });
                    }
                    catch (ExpertSystemAPI.APIError | ExpertSystemAPI.NoAPIConnection e) {
                        e.printStackTrace();
                        throw new InvocationTargetException(e, "Can not update request at the moment");
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void update(DiagnoseRequest diagnoseRequest) {
        this.diagnoseRequest = diagnoseRequest;
        this.cmdTaskTracker = null;
        this.filesTask = null;
        this.updateDescSection();
    }

    private void updateDescSection() {
        ControlDecoration decoration;
        Label label;
        if (this.summarySection.getClient() != null && !this.summarySection.getClient().isDisposed()) {
            this.summarySection.getClient().dispose();
            if (this.boldFont != null && !this.boldFont.isDisposed()) {
                this.boldFont.dispose();
            }
        }
        Composite client = this.toolkit.createComposite((Composite)this.summarySection, 0);
        FontData fontdata = client.getFont().getFontData()[0];
        fontdata.setStyle(1);
        this.boldFont = new Font((Device)client.getDisplay(), fontdata);
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        layout.makeColumnsEqualWidth = false;
        client.setLayout((Layout)layout);
        GridData layoutDataTitle = new GridData(1, 1, false, false);
        layoutDataTitle.horizontalIndent = 25;
        GridData layoutData = new GridData(4, 1, true, false);
        if (this.diagnoseRequest != null) {
            label = this.toolkit.createLabel(client, "Request Id", 64);
            label.setLayoutData((Object)layoutDataTitle);
            decoration = new ControlDecoration((Control)label, 16384);
            decoration.setMarginWidth(2);
            label = this.toolkit.createLabel(client, "", 2048);
            label.setLayoutData((Object)layoutData);
            label.setFont(this.boldFont);
            if (this.diagnoseRequest.getId() == null) {
                label.setText("no request");
                decoration.setImage(SharedImages.CANCEL);
                decoration.setDescriptionText("Request was not send to the Expert System");
            } else {
                label.setText(": #" + String.valueOf(this.diagnoseRequest.getId()));
                decoration.setImage(SharedImages.ACCEPT);
                decoration.setDescriptionText("Request successfully submitted to the Expert System");
            }
            this.createBlankField(client);
            label = this.toolkit.createLabel(client, "Request Status", 64);
            label.setLayoutData((Object)layoutDataTitle);
            this.requestStatusLabelDecoration = new ControlDecoration((Control)label, 16384);
            this.requestStatusLabelDecoration.setMarginWidth(2);
            this.requestStatusLabel = this.toolkit.createLabel(client, "", 2048);
            this.requestStatusLabel.setLayoutData((Object)layoutData);
            this.requestStatusLabel.setFont(this.boldFont);
            this.updateRequestStatusLabel(false);
        }
        if (this.cmdTaskTracker != null) {
            label = this.toolkit.createLabel(client, "Sub Task", 64);
            label.setLayoutData((Object)layoutDataTitle);
            decoration = new ControlDecoration((Control)label, 16384);
            label = this.toolkit.createLabel(client, "", 2048);
            label.setText(": " + this.cmdTaskTracker.getTaskId());
            label.setLayoutData((Object)layoutData);
            label.setFont(this.boldFont);
            decoration.setMarginWidth(2);
            decoration.setDescriptionText(this.cmdTaskTracker.getStatus().name());
            if (this.cmdTaskTracker.getStatus() == ExecStatus.Failed) {
                decoration.setImage(SharedImages.ERROR);
            } else if (this.cmdTaskTracker.getStatus() == ExecStatus.Finished) {
                decoration.setImage(SharedImages.ACCEPT);
                decoration.setDescriptionText("The selected Process has finished correctly and has no problem");
            } else if (this.cmdTaskTracker.getStatus() == ExecStatus.Warning) {
                decoration.setImage(SharedImages.WARNNING_YELLOW);
            } else if (this.cmdTaskTracker.getStatus() == ExecStatus.Canceled) {
                decoration.setImage(SharedImages.CANCEL);
            } else {
                decoration.setImage(SharedImages.WARNNING_RED);
            }
            this.createBlankField(client);
            this.createBlankField(client);
        }
        this.summarySection.setClient((Control)client);
        client.layout();
        this.summarySection.layout(true);
        this.expertSystemView.updateLayout();
    }

    void updateRequestStatusLabel(boolean updateing) {
        if (this.requestStatusLabel == null) {
            return;
        }
        if (updateing) {
            this.requestStatusLabel.setText(": Updating ...");
            this.requestStatusLabelDecoration.setImage(SharedImages.REFRESH);
        } else {
            this.requestStatusLabel.setText(": " + this.diagnoseRequest.getStatus().name());
            if (this.diagnoseRequest.getStatus() == DiagnoseRequest.DiagnosticRequestStatus.Pending) {
                this.requestStatusLabelDecoration.setDescriptionText("Please wait while Your request has been submitted  to the expert system");
                this.requestStatusLabelDecoration.setImage(SharedImages.WARNNING_YELLOW);
            }
            if (this.diagnoseRequest.getStatus() == DiagnoseRequest.DiagnosticRequestStatus.Processing) {
                this.requestStatusLabelDecoration.setDescriptionText("Your request will be processed soon by the expert system");
                this.requestStatusLabelDecoration.setImage(SharedImages.WARNNING_YELLOW);
            }
            if (this.diagnoseRequest.getStatus() == DiagnoseRequest.DiagnosticRequestStatus.Finished) {
                this.requestStatusLabelDecoration.setDescriptionText("");
                this.requestStatusLabelDecoration.setImage(SharedImages.ACCEPT);
            }
        }
    }

    public void setSelection(CMDTaskTracker cmdTaskTracker) {
        this.cmdTaskTracker = cmdTaskTracker;
        this.filesTask = null;
        this.updateDescSection();
    }

    public void setSelection(CMDTaskTracker.FilesTask filesTask) {
        this.filesTask = filesTask;
        this.cmdTaskTracker = filesTask.getCMDTaskTracker();
        this.updateDescSection();
    }

    public void createBlankField(Composite composite) {
        Label label = this.toolkit.createLabel(composite, "", 0);
        GridData layoutData = new GridData(1, 1, false, false);
        layoutData.horizontalIndent = 25;
        layoutData.widthHint = 50;
        label.setLayoutData((Object)layoutData);
        label = this.toolkit.createLabel(composite, "", 0);
        layoutData = new GridData(1, 1, false, false);
        layoutData.widthHint = 50;
        label.setLayoutData((Object)layoutData);
    }
}

