/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.expert;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CancelableRunnableWithProgress
implements IRunnableWithProgress {
    boolean isCanceled = false;
    Runnable backgroundProcess;

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public CancelableRunnableWithProgress(Runnable backgroundProcess) {
        this.backgroundProcess = backgroundProcess;
    }

    public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Submit Task", -1);
        monitor.subTask("Checking Configuration ...");
        Thread thread = new Thread(this.backgroundProcess);
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        Future<?> future = scheduler.submit(this.backgroundProcess);
        while (!future.isDone()) {
            if (!monitor.isCanceled()) continue;
            monitor.subTask("Canceling ... Please wait");
            future.cancel(true);
            this.isCanceled = true;
        }
        monitor.done();
    }
}

