/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.views;

import com.biotechvana.users.UserManager;
import com.biotechvana.workflow.IWorkflowJobComposite;
import com.biotechvana.workflow.VariableControl;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.ui.variables.VariableComposite;
import com.biotechvana.workflow.variables.JobVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class WorkflowJobPlainComposite
implements IWorkflowJobComposite {
    int hIndent = 25;
    WorkflowJob workflowJob;
    Label jobDesclabel = null;
    Composite parent;
    private IWorkflowManager workflowManager;
    protected Collection<JobVariable> inputVarBasicGroup = new ArrayList<JobVariable>();
    protected HashMap<String, Collection<JobVariable>> inputVarGroups = new HashMap();
    protected Collection<JobVariable> optionalVarBasicGroup = new ArrayList<JobVariable>();
    protected HashMap<String, Collection<JobVariable>> optionalVarGroups = new HashMap();
    Composite inputCompositeBody;
    int style;
    ArrayList<VariableControl> cVars = new ArrayList();
    ArrayList<Composite> declaredComposite = new ArrayList();

    public WorkflowJobPlainComposite(IWorkflowManager workflowManager, WorkflowJob job, Composite parent, int style) {
        this.bindWorkflowJob(job);
        this.parent = parent;
        this.style = 0;
        this.workflowManager = workflowManager;
        if (parent.getLayout() instanceof GridLayout) {
            int n = ((GridLayout)parent.getLayout()).numColumns;
        } else {
            boolean cfr_ignored_0 = parent.getLayout() instanceof FillLayout;
        }
        this.Init();
        WorkflowJobPlainComposite thisC = this;
        parent.addDisposeListener(new DisposeListener((Observer)((Object)thisC)){
            private final /* synthetic */ Observer val$thisC;
            {
                this.val$thisC = observer;
            }

            public void widgetDisposed(DisposeEvent e) {
                WorkflowJobPlainComposite.this.workflowJob.deleteObserver(this.val$thisC);
            }
        });
        this.refreshLayout();
    }

    void Init() {
        this.parent.setData((Object)this.workflowJob);
        this.setupVariables();
        this.createInputGroup();
        this.toggleVarHelpMsg();
    }

    protected void setupVariables() {
        Collection vars = this.workflowJob.getAllVariables();
        for (JobVariable var : vars) {
            if (var.getDescVarRole() != VariableDescriptor.VariableRole.Input || var.descHasEnableActions() || var.descHasGroup() || !var.isVisable()) continue;
            this.inputVarBasicGroup.add(var);
        }
        for (String group : this.workflowJob.getJobDesc().getVarGroups()) {
            if (this.workflowJob.getJobDesc().groupType(group) != VariableDescriptor.VariableRole.Input || !WorkflowJobPlainComposite.shouldRenderGroup(this.workflowJob, group)) continue;
            ArrayList<JobVariable> newInputVarGroup = new ArrayList<JobVariable>();
            for (VariableDescriptor var : this.workflowJob.getJobDesc().getGroupVars(group)) {
                JobVariable jobVar = this.workflowJob.getVariable(var.getKey());
                if (var.hasEnableActions() || !jobVar.isVisable()) continue;
                newInputVarGroup.add(jobVar);
            }
            if (newInputVarGroup.size() <= 0) continue;
            this.inputVarGroups.put(group, newInputVarGroup);
        }
        for (JobVariable var : vars) {
            if (var.getDescVarRole() != VariableDescriptor.VariableRole.Option || var.descHasEnableActions() || var.descHasGroup()) continue;
            this.optionalVarBasicGroup.add(var);
        }
        for (String group : this.workflowJob.getJobDesc().getVarGroups()) {
            if (this.workflowJob.getJobDesc().groupType(group) != VariableDescriptor.VariableRole.Option || !WorkflowJobPlainComposite.shouldRenderGroup(this.workflowJob, group)) continue;
            ArrayList<JobVariable> newOptionsVarGroup = new ArrayList<JobVariable>();
            for (VariableDescriptor var : this.workflowJob.getJobDesc().getGroupVars(group)) {
                if (var.hasEnableActions()) continue;
                newOptionsVarGroup.add(this.workflowJob.getVariable(var.getKey()));
            }
            if (newOptionsVarGroup.size() <= 0) continue;
            this.optionalVarGroups.put(group, newOptionsVarGroup);
        }
    }

    private void createInputGroup() {
        GridData layoutData;
        if (this.declaredComposite.size() > 0) {
            for (Composite varComp : this.declaredComposite) {
                varComp.dispose();
            }
            this.declaredComposite.clear();
        }
        int colorIndex = 0;
        for (JobVariable var : this.inputVarBasicGroup) {
            VariableComposite varComposite = null;
            varComposite = VariableComposite.createJobVariableComposite((Composite)this.parent, (IWorkflowJobComposite)this, (JobVariable)var, (int)this.style);
            this.declaredComposite.add((Composite)varComposite);
            layoutData = new GridData(4, 1, true, false, 1, 1);
            varComposite.setLayoutData((Object)layoutData);
            varComposite.setColor(colorIndex);
            ++colorIndex;
        }
        for (String group : this.inputVarGroups.keySet()) {
            Group varGroup = new Group(this.parent, this.style);
            FontData fontdata = varGroup.getFont().getFontData()[0];
            fontdata.setStyle(1);
            Font font = new Font((Device)this.parent.getDisplay(), fontdata);
            varGroup.setFont(font);
            varGroup.setText(group);
            layoutData = new GridData(4, 1, true, false, 1, 1);
            varGroup.setLayoutData((Object)layoutData);
            varGroup.setLayout((Layout)new GridLayout(1, false));
            colorIndex = 1;
            for (JobVariable var : this.inputVarGroups.get(group)) {
                VariableComposite varComposite = VariableComposite.createJobVariableComposite((Composite)varGroup, (IWorkflowJobComposite)this, (JobVariable)this.workflowJob.getVariable(var.getKey()), (int)this.style);
                this.declaredComposite.add((Composite)varComposite);
                layoutData = new GridData(4, 1, true, false, 1, 1);
                varComposite.setLayoutData((Object)layoutData);
                varComposite.bindNewValue(false);
                varComposite.setColor(colorIndex);
                ++colorIndex;
            }
        }
        this.parent.layout(true);
    }

    protected static boolean shouldRenderGroup(WorkflowJob job, String group) {
        int varCount = 0;
        for (VariableDescriptor var : job.getJobDesc().getGroupVars(group)) {
            JobVariable jobVar = job.getVariable(var.getKey());
            if (var.hasEnableActions() || !jobVar.isVisable()) continue;
            ++varCount;
        }
        return varCount != 0;
    }

    private void refreshLayout() {
        this.parent.layout(true);
    }

    public void update(Observable o, Object arg) {
        this.parent.setLayoutDeferred(true);
        int eventType = (Integer)arg;
        if (eventType == 100) {
            this.refreshLayout();
        }
        if (eventType == 300) {
            this.createInputGroup();
            this.refreshLayout();
        }
        this.parent.setLayoutDeferred(false);
    }

    public void requestShowHelp(JobVariable var) {
    }

    public void removeVarComposite(VariableControl variableControl) {
        this.cVars.remove(variableControl);
    }

    public void addVarComposite(VariableControl variableControl) {
        this.cVars.add(variableControl);
    }

    protected void toggleVarHelpMsg() {
        for (VariableControl varComposite : this.cVars) {
            varComposite.toggleHelpMsg();
        }
        this.refreshLayout();
    }

    public void bindWorkflowJob(WorkflowJob job) {
        this.workflowJob = job;
        this.workflowJob.addObserver((Observer)((Object)this));
    }

    public int varsCommandParamaterMaxStrLen() {
        return 25;
    }

    public WorkflowJob getWorkflowJob() {
        return this.workflowJob;
    }

    public boolean supportShowHelp() {
        return false;
    }

    public UserManager getUserManager() {
        return this.workflowManager.getUserManager();
    }
}

