/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.views;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.users.UserManager;
import com.biotechvana.utils.StringUtils;
import com.biotechvana.workflow.IValidationResult;
import com.biotechvana.workflow.IWorkflowJobComposite;
import com.biotechvana.workflow.VariableControl;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobLink;
import com.biotechvana.workflow.descriptors.Publication;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.ui.variables.VariableComposite;
import com.biotechvana.workflow.variables.JobVariable;
import com.biotechvana.workflow.views.VariableHelpViewer;
import com.biotechvana.workflow.views.VariableSearchViewer;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class WorkflowJobBasicComposite
extends Composite
implements IWorkflowJobComposite {
    FormToolkit toolkit;
    private static final int MIN_WIDTH = 600;
    protected static final int MAX_WIDTH = 800;
    static final int hIndent = 25;
    static final int vIndent = 10;
    WorkflowJob workflowJob;
    ScrolledComposite jobScrolledComposite;
    Label jobDesclabel = null;
    ExpandListener exListener;
    protected boolean SHOW_SEARCH = false;
    private SashForm topForm;
    Composite searchInerControls;
    boolean createdesc = true;
    boolean addToolbar = true;
    IWorkflowManager workflowManager;
    Form detailsForm;
    Composite mainBody;
    Section jobDescriptionSection;
    Section jobInputSection;
    Section jobOptionSection;
    protected Collection<JobVariable> inputVarBasicGroup = new ArrayList<JobVariable>();
    protected HashMap<String, Collection<JobVariable>> inputVarGroups = new HashMap();
    protected Collection<JobVariable> optionalVarBasicGroup = new ArrayList<JobVariable>();
    protected HashMap<String, Collection<JobVariable>> optionalVarGroups = new LinkedHashMap<String, Collection<JobVariable>>();
    Composite inputCompositeBody;
    int style;
    Composite optionsCompositeBody;
    VariableHelpViewer helpViewer;
    VariableSearchViewer searchViewer;
    ArrayList<VariableControl> cVars = new ArrayList();

    public WorkflowJobBasicComposite(IWorkflowManager workflowManager, WorkflowJob job, Composite parent, int style, FormToolkit toolkit, boolean createdesc, boolean addToolbar) {
        super(parent, style);
        if (toolkit == null) {
            toolkit = new FormToolkit(this.getDisplay());
        }
        this.createdesc = createdesc;
        this.addToolbar = addToolbar;
        this.toolkit = toolkit;
        this.bindWorkflowJob(job);
        this.workflowManager = workflowManager;
        this.style = 0;
        this.setLayout((Layout)new GridLayout(1, false));
        this.topForm = new SashForm((Composite)this, 66048);
        this.helpViewer = new VariableHelpViewer(this.topForm);
        this.searchViewer = new VariableSearchViewer(this.topForm);
        GridData layoutData = new GridData(4, 4, true, true);
        this.topForm.setLayoutData((Object)layoutData);
        if (this.SHOW_SEARCH) {
            this.renderSearchControl();
        }
        Composite jobPartinSashFrom = new Composite((Composite)this.topForm, 0);
        jobPartinSashFrom.setLayout((Layout)new FillLayout());
        this.createDetailsViewFormControls(jobPartinSashFrom);
        this.topForm.setForeground(null);
        this.topForm.setForeground(this.getDisplay().getSystemColor(24));
        this.Init();
        this.jobScrolledComposite.setMinSize(this.mainBody.computeSize(-1, -1));
        this.jobScrolledComposite.setContent((Control)this.mainBody);
        this.jobScrolledComposite.setExpandVertical(true);
        this.jobScrolledComposite.setExpandHorizontal(true);
        this.jobScrolledComposite.setAlwaysShowScrollBars(true);
        WorkflowJobBasicComposite thisC = this;
        parent.addDisposeListener(new DisposeListener((Observer)((Object)thisC)){
            private final /* synthetic */ Observer val$thisC;
            {
                this.val$thisC = observer;
            }

            public void widgetDisposed(DisposeEvent e) {
                WorkflowJobBasicComposite.this.workflowJob.deleteObserver(this.val$thisC);
            }
        });
        this.refreshLayout();
    }

    public WorkflowJobBasicComposite(IWorkflowManager workflowManager, WorkflowJob job, Composite parent, int style) {
        this(workflowManager, job, parent, style, null, true, true);
    }

    private void createDetailsViewFormControls(Composite topForm) {
        this.detailsForm = this.toolkit.createForm(topForm);
        this.detailsForm.setText(this.workflowJob.getFriendlyName());
        this.detailsForm.addMessageHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter());
        this.toolkit.decorateFormHeading(this.detailsForm);
        this.detailsForm.getBody().setLayout((Layout)new FillLayout());
        this.jobScrolledComposite = new ScrolledComposite(this.detailsForm.getBody(), 768);
        this.jobScrolledComposite.setExpandVertical(true);
        this.jobScrolledComposite.setExpandHorizontal(true);
        this.jobScrolledComposite.setAlwaysShowScrollBars(true);
        this.mainBody = this.toolkit.createComposite((Composite)this.jobScrolledComposite);
        this.mainBody.setLayout((Layout)new GridLayout(2, false));
        String descTxt = this.workflowJob.getJobDesc().getDesc();
        if (StringUtils.isEmpty((String)descTxt)) {
            this.createdesc = false;
        }
        Section descSec = null;
        if (this.createdesc) {
            descSec = this.createDescSection();
            this.addBlack();
        }
        Section inputSection = this.createBodySection();
        this.addBlack();
        if (this.createdesc) {
            descSec.descriptionVerticalSpacing = inputSection.getTextClientHeightDifference();
        }
        if (this.workflowJob.getJobDesc().hasOptions()) {
            Section s3 = this.createOptionSection();
            s3.descriptionVerticalSpacing = inputSection.getTextClientHeightDifference();
            this.addBlack();
        }
        this.addBlack();
        this.addBlack();
        WorkflowJobBasicComposite.renderRefSection(this.workflowJob, this.mainBody, this.toolkit);
        this.addBlack();
        this.detailsForm.setImage(SharedImages.ACCEPT);
        if (this.addToolbar) {
            this.detailsForm.getToolBarManager().add((IAction)new Action("Run"){
                {
                    this.setImageDescriptor(SharedImages.RUNNING_DESC);
                }

                public void run() {
                    WorkflowJobBasicComposite.this.runJob();
                }
            });
            this.detailsForm.getToolBarManager().add((IAction)new Action("Help"){
                {
                    this.setImageDescriptor(SharedImages.RUNNING_DESC);
                    this.setImageDescriptor(SharedImages.HELP_DESC);
                    this.setToolTipText("Toggle Help/Manual");
                }

                public void run() {
                    WorkflowJobBasicComposite.this.toggleVarHelpMsg();
                }
            });
            this.detailsForm.getToolBarManager().update(true);
        }
        this.refreshLayout();
    }

    private Section createDescSection() {
        this.jobDescriptionSection = this.toolkit.createSection(this.mainBody, 258);
        this.jobDescriptionSection.setActiveToggleColor(this.toolkit.getHyperlinkGroup().getActiveForeground());
        this.jobDescriptionSection.setToggleColor(this.toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        this.toolkit.createCompositeSeparator((Composite)this.jobDescriptionSection);
        this.jobDescriptionSection.setText("Overview");
        this.jobDescriptionSection.setExpanded(true);
        this.jobDescriptionSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                WorkflowJobBasicComposite.this.refreshLayout();
            }
        });
        GridData gd = new GridData(1808);
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = 25;
        this.jobDescriptionSection.setLayoutData((Object)gd);
        Composite client = (Composite)this.jobDescriptionSection.getClient();
        try {
            if (client != null && !client.isDisposed()) {
                client.dispose();
            }
        }
        catch (SWTException swtEx) {
            swtEx.printStackTrace();
        }
        client = this.toolkit.createComposite((Composite)this.jobDescriptionSection, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        client.setLayout((Layout)layout);
        WorkflowJobBasicComposite.addDescText(this.workflowJob, client, this.toolkit);
        this.jobDescriptionSection.setClient((Control)client);
        this.jobDescriptionSection.layout(true);
        return this.jobDescriptionSection;
    }

    public static void addDescText(WorkflowJob workflowJob, Composite parent, FormToolkit toolkit) {
        String txt = workflowJob.getJobDesc().getDesc();
        Label ft = toolkit.createLabel(parent, "", 64);
        GridData layoutData = new GridData(4, 1, true, false);
        layoutData.widthHint = 0;
        layoutData.horizontalIndent = 25;
        ft.setLayoutData((Object)layoutData);
        ft.setText(txt);
        FontData fontdata = ft.getFont().getFontData()[0];
        fontdata.setHeight(12);
        Font font = new Font((Device)parent.getDisplay(), fontdata);
        ft.setFont(font);
    }

    private Section createBodySection() {
        this.jobInputSection = this.toolkit.createSection(this.mainBody, 258);
        this.jobInputSection.setActiveToggleColor(this.toolkit.getHyperlinkGroup().getActiveForeground());
        this.jobInputSection.setToggleColor(this.toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        this.toolkit.createCompositeSeparator((Composite)this.jobInputSection);
        this.jobInputSection.setText("Inputs");
        this.jobInputSection.setExpanded(true);
        this.jobInputSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                WorkflowJobBasicComposite.this.refreshLayout();
            }
        });
        ToolBar tbar = new ToolBar((Composite)this.jobInputSection, 0x800100);
        this.jobInputSection.setTextClient((Control)tbar);
        GridData gd = new GridData(1808);
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = 25;
        gd.verticalIndent = 10;
        this.jobInputSection.setLayoutData((Object)gd);
        Composite jobMainComposite = (Composite)this.jobInputSection.getClient();
        try {
            if (jobMainComposite != null && !jobMainComposite.isDisposed()) {
                jobMainComposite.dispose();
            }
        }
        catch (SWTException swtEx) {
            swtEx.printStackTrace();
        }
        jobMainComposite = this.toolkit.createComposite((Composite)this.jobInputSection, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        jobMainComposite.setLayout((Layout)layout);
        this.jobInputSection.setClient((Control)jobMainComposite);
        this.jobInputSection.layout(true);
        return this.jobInputSection;
    }

    private Section createOptionSection() {
        this.jobOptionSection = this.toolkit.createSection(this.mainBody, 258);
        this.jobOptionSection.setActiveToggleColor(this.toolkit.getHyperlinkGroup().getActiveForeground());
        this.jobOptionSection.setToggleColor(this.toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        this.jobOptionSection.setText("Options");
        this.jobOptionSection.setExpanded(true);
        this.jobOptionSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                WorkflowJobBasicComposite.this.refreshLayout();
            }
        });
        GridData gd = new GridData(1808);
        gd = new GridData(4, 0x1000000, false, false);
        gd.horizontalIndent = 25;
        gd.verticalIndent = 10;
        this.jobOptionSection.setLayoutData((Object)gd);
        Composite jobMainComposite = (Composite)this.jobOptionSection.getClient();
        try {
            if (jobMainComposite != null && !jobMainComposite.isDisposed()) {
                jobMainComposite.dispose();
            }
        }
        catch (SWTException swtEx) {
            swtEx.printStackTrace();
        }
        jobMainComposite = this.toolkit.createComposite((Composite)this.jobOptionSection, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        jobMainComposite.setLayout((Layout)layout);
        this.jobOptionSection.setClient((Control)jobMainComposite);
        this.jobOptionSection.layout(true);
        return this.jobOptionSection;
    }

    protected void renderSearchControl() {
        String defaultPhrase = "Enter Search Text/Parameter Here";
        Composite searchComposite = new Composite((Composite)this, 0);
        searchComposite.setSize(-1, 100);
        GridData layoutData = new GridData(4, 4, true, false);
        searchComposite.setLayoutData((Object)layoutData);
        searchComposite.setLayout((Layout)new GridLayout(2, false));
        this.searchInerControls = new Composite(searchComposite, 0);
        layoutData = new GridData(4, 4, true, false);
        this.searchInerControls.setLayout((Layout)new GridLayout(5, false));
        this.searchInerControls.setLayoutData((Object)layoutData);
        this.searchInerControls.setVisible(false);
        final Text searchText = new Text(this.searchInerControls, 2944);
        layoutData = new GridData(4, 4, true, false);
        searchText.setLayoutData((Object)layoutData);
        searchText.setData((Object)false);
        searchText.setForeground(this.getDisplay().getSystemColor(33));
        searchText.setText("Enter Search Text/Parameter Here");
        searchText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (searchText.getText().trim().isEmpty()) {
                    searchText.setText("Enter Search Text/Parameter Here");
                    searchText.setForeground(Display.getDefault().getSystemColor(33));
                }
            }

            public void focusGained(FocusEvent e) {
                boolean hasText = (Boolean)searchText.getData();
                searchText.setForeground(null);
                if (searchText.getText().trim().equals("Enter Search Text/Parameter Here")) {
                    searchText.setText("");
                }
            }
        });
        final Button searchCMDParm = new Button(this.searchInerControls, 32);
        searchCMDParm.setText("Parameters");
        searchCMDParm.setToolTipText("Search Command Parameter Switch Only");
        Button searchHelpText = new Button(this.searchInerControls, 32);
        searchHelpText.setText("Help Text");
        searchHelpText.setToolTipText("Search keywords in Help/Manual Text");
        final Button searchOK = new Button(this.searchInerControls, 8);
        layoutData = new GridData(0x1000000, 0x1000000, false, false);
        layoutData.widthHint = 100;
        searchOK.setLayoutData((Object)layoutData);
        searchOK.setText("Find");
        searchOK.setToolTipText("Start Search and Show result");
        searchOK.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WorkflowJobBasicComposite.this.showSearch();
                String keyWords = searchText.getText();
                if (keyWords.isEmpty() || keyWords.equals("Enter Search Text/Parameter Here")) {
                    WorkflowJobBasicComposite.this.searchViewer.bindSearchResult(null);
                    return;
                }
                ArrayList<JobVariable> result = new ArrayList<JobVariable>();
                Collection allSelectedVars = WorkflowJobBasicComposite.this.workflowJob.getAllVariables();
                for (JobVariable var : allSelectedVars) {
                    if (searchCMDParm.getSelection()) {
                        if (!var.getDescCommandParamater().contains(keyWords) && !var.getDescCommandParamaterAlt().contains(keyWords)) continue;
                        result.add(var);
                        continue;
                    }
                    if (!var.getDescFriendlyName().contains(keyWords)) continue;
                    result.add(var);
                }
                WorkflowJobBasicComposite.this.searchViewer.bindSearchResult(result);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        searchText.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail != 256) {
                    searchOK.notifyListeners(13, new Event());
                }
            }
        });
        Label empty_ = new Label(this.searchInerControls, 0);
        layoutData = new GridData(4, 4, false, false);
        layoutData.widthHint = 50;
        empty_.setLayoutData((Object)layoutData);
        empty_.setVisible(false);
        final Button searchBtn = new Button(searchComposite, 2);
        layoutData = new GridData(16384, 0x1000000, false, false);
        searchBtn.setLayoutData((Object)layoutData);
        this.searchInerControls.setData((Object)searchBtn);
        searchBtn.setImage(SharedImages.SEARCH);
        searchBtn.setToolTipText("Show/Hide Quick Search Bar to find Parameters or Options");
        searchBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!searchBtn.getSelection()) {
                    WorkflowJobBasicComposite.this.closeSearch();
                }
                WorkflowJobBasicComposite.this.searchInerControls.setVisible(searchBtn.getSelection());
                if (searchBtn.getSelection()) {
                    searchText.setText("Enter Search Text/Parameter Here");
                    searchText.setForeground(Display.getDefault().getSystemColor(33));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void renderJobDescSection() {
        String jobDesc = this.workflowJob.getJobDesc().getDesc();
        if (jobDesc != null && !jobDesc.isEmpty()) {
            Composite jobMainComposite = (Composite)this.jobDescriptionSection.getClient();
            this.jobDesclabel = new Label(jobMainComposite, 64);
            GridData gridData = new GridData(4, 1, true, false, 1, 1);
            gridData.horizontalAlignment = 4;
            gridData.minimumWidth = 600;
            gridData.horizontalIndent = 25;
            gridData.widthHint = 0;
            this.jobDesclabel.setLayoutData((Object)gridData);
            this.jobDesclabel.setText(this.workflowJob.getJobDesc().getDesc());
            FontData fontdata = this.jobDesclabel.getFont().getFontData()[0];
            fontdata.setHeight(12);
            Font font = new Font((Device)this.getDisplay(), fontdata);
            this.jobDesclabel.setFont(font);
        }
    }

    public static void renderRefSection(WorkflowJob workflowJob, Composite parent, FormToolkit toolkit) {
        String ref = workflowJob.getJobDesc().getRef();
        if (ref != null && !ref.isEmpty()) {
            Group helpGroup = new Group(parent, 2048);
            helpGroup.setText("Reference :");
            helpGroup.setLayout((Layout)new GridLayout(1, false));
            GridData gridData = new GridData(4, 1, true, false, 3, 1);
            gridData.horizontalAlignment = 4;
            gridData.minimumWidth = 600;
            gridData.widthHint = 0;
            gridData.horizontalIndent = 25;
            helpGroup.setLayoutData((Object)gridData);
            Link jobLinkReflabel = new Link((Composite)helpGroup, 64);
            gridData = new GridData(4, 1, true, false, 1, 1);
            gridData.horizontalIndent = 20;
            jobLinkReflabel.setText(ref);
            jobLinkReflabel.setLayoutData((Object)gridData);
            FontData fontdata = jobLinkReflabel.getFont().getFontData()[0];
            fontdata.setStyle(1);
            Font font = new Font((Device)parent.getDisplay(), fontdata);
            jobLinkReflabel.setFont(font);
            helpGroup.setFont(font);
            jobLinkReflabel.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().browse(new URI(e.text));
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        catch (URISyntaxException ex) {
                            ex.printStackTrace();
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        } else {
            JobLink[] links;
            int n;
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().browse(new URI(e.text));
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        catch (URISyntaxException ex) {
                            ex.printStackTrace();
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
            Publication[] pubs = workflowJob.getJobDesc().getPublications();
            if (pubs.length > 0) {
                Group helpGroup = new Group(parent, 2048);
                helpGroup.setText("Reference :");
                helpGroup.setLayout((Layout)new GridLayout(1, false));
                GridData gridData = new GridData(4, 1, true, false, 3, 1);
                gridData.horizontalAlignment = 4;
                gridData.minimumWidth = 600;
                gridData.widthHint = 0;
                gridData.horizontalIndent = 25;
                helpGroup.setLayoutData((Object)gridData);
                Publication[] publicationArray = pubs;
                n = pubs.length;
                int n2 = 0;
                while (n2 < n) {
                    Publication pub = publicationArray[n2];
                    Link jobLinkReflabel = new Link((Composite)helpGroup, 64);
                    gridData = new GridData(4, 1, true, false, 1, 1);
                    gridData.horizontalIndent = 20;
                    ref = "";
                    ref = pub.getDOI() != null ? String.format("- %1$s. <a href=\"http://doi.org/%2$s\">doi:%2$s.</a>", pub.getCitation(), pub.getDOI(true)) : (pub.getUrl() != null ? String.format("<a href=\"%s\">- %s</a>", pub.getUrl(), pub.getCitation()) : pub.getFormatedStr());
                    jobLinkReflabel.setText(ref);
                    jobLinkReflabel.setLayoutData((Object)gridData);
                    FontData fontdata = jobLinkReflabel.getFont().getFontData()[0];
                    fontdata.setStyle(1);
                    Font font = new Font((Device)parent.getDisplay(), fontdata);
                    jobLinkReflabel.setFont(font);
                    helpGroup.setFont(font);
                    jobLinkReflabel.addSelectionListener(selectionListener);
                    ++n2;
                }
            }
            if ((links = workflowJob.getJobDesc().getLinks()).length > 0) {
                Group helpGroup = new Group(parent, 2048);
                helpGroup.setText("Links :");
                helpGroup.setLayout((Layout)new GridLayout(1, false));
                GridData gridData = new GridData(4, 1, true, false, 1, 1);
                gridData.horizontalAlignment = 4;
                gridData.minimumWidth = 600;
                gridData.widthHint = 0;
                gridData.horizontalIndent = 25;
                helpGroup.setLayoutData((Object)gridData);
                JobLink[] jobLinkArray = links;
                int n3 = links.length;
                n = 0;
                while (n < n3) {
                    JobLink link = jobLinkArray[n];
                    Link jobLinkReflabel = new Link((Composite)helpGroup, 64);
                    gridData = new GridData(4, 1, true, false, 1, 1);
                    gridData.horizontalIndent = 20;
                    ref = link.getHTMLLink();
                    jobLinkReflabel.setText(ref);
                    jobLinkReflabel.setLayoutData((Object)gridData);
                    FontData fontdata = jobLinkReflabel.getFont().getFontData()[0];
                    fontdata.setStyle(1);
                    Font font = new Font((Device)parent.getDisplay(), fontdata);
                    jobLinkReflabel.setFont(font);
                    helpGroup.setFont(font);
                    jobLinkReflabel.setToolTipText(link.getUrl());
                    jobLinkReflabel.addSelectionListener(selectionListener);
                    ++n;
                }
            }
        }
    }

    void addBlack() {
        Label blankLabel = this.toolkit.createLabel(this.mainBody, "");
        GridData gridData = new GridData(4, 1, false, false, 1, 1);
        gridData.widthHint = 25;
        blankLabel.setLayoutData((Object)gridData);
    }

    void Init() {
        this.setData(this.workflowJob);
        WorkflowJobBasicComposite thisC = this;
        this.exListener = new ExpandListener(){

            public void itemExpanded(ExpandEvent e) {
                WorkflowJobBasicComposite.this.refreshLayout();
            }

            public void itemCollapsed(ExpandEvent e) {
                WorkflowJobBasicComposite.this.refreshLayout();
            }
        };
        this.setupVariables();
        this.createInputGroup((Composite)this.jobInputSection.getClient());
        if (this.workflowJob.getJobDesc().hasOptions()) {
            Composite jobMainComposite = (Composite)this.jobOptionSection.getClient();
            this.createOptionsGroup(jobMainComposite);
        }
    }

    protected void setupVariables() {
        Collection vars = this.workflowJob.getAllVariables();
        for (JobVariable var : vars) {
            if (var.getDescVarRole() != VariableDescriptor.VariableRole.Input || var.descHasEnableActions() || var.descHasGroup() || !var.isVisable()) continue;
            this.inputVarBasicGroup.add(var);
        }
        for (String group : this.workflowJob.getJobDesc().getVarGroups()) {
            if (this.workflowJob.getJobDesc().groupType(group) != VariableDescriptor.VariableRole.Input || !WorkflowJobBasicComposite.shouldRenderGroup(this.workflowJob, group)) continue;
            ArrayList<JobVariable> newInputVarGroup = new ArrayList<JobVariable>();
            for (VariableDescriptor var : this.workflowJob.getJobDesc().getGroupVars(group)) {
                JobVariable jobVar = this.workflowJob.getVariable(var.getKey());
                if (var.hasEnableActions() || !jobVar.isVisable()) continue;
                newInputVarGroup.add(jobVar);
            }
            if (newInputVarGroup.size() <= 0) continue;
            this.inputVarGroups.put(group, newInputVarGroup);
        }
        for (JobVariable var : vars) {
            if (var.getDescVarRole() != VariableDescriptor.VariableRole.Option || var.descHasEnableActions() || var.descHasGroup()) continue;
            this.optionalVarBasicGroup.add(var);
        }
        for (String group : this.workflowJob.getJobDesc().getVarGroups()) {
            if (this.workflowJob.getJobDesc().groupType(group) != VariableDescriptor.VariableRole.Option || !WorkflowJobBasicComposite.shouldRenderGroup(this.workflowJob, group)) continue;
            ArrayList<JobVariable> newOptionsVarGroup = new ArrayList<JobVariable>();
            for (VariableDescriptor var : this.workflowJob.getJobDesc().getGroupVars(group)) {
                if (var.hasEnableActions()) continue;
                newOptionsVarGroup.add(this.workflowJob.getVariable(var.getKey()));
            }
            if (newOptionsVarGroup.size() <= 0) continue;
            this.optionalVarGroups.put(group, newOptionsVarGroup);
        }
    }

    private void createInputGroup(Composite inputGroup) {
        GridData layoutData;
        boolean inputGroupVisable = false;
        if (this.inputCompositeBody != null) {
            this.inputCompositeBody.dispose();
        }
        this.inputCompositeBody = new Composite(inputGroup, this.style);
        this.inputCompositeBody.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        this.inputCompositeBody.setLayout((Layout)new GridLayout(1, false));
        int colorIndex = 0;
        for (JobVariable var : this.inputVarBasicGroup) {
            VariableComposite varComposite = null;
            varComposite = VariableComposite.createJobVariableComposite((Composite)this.inputCompositeBody, (IWorkflowJobComposite)this, (JobVariable)var, (int)this.style);
            layoutData = new GridData(4, 1, true, false, 1, 1);
            varComposite.setLayoutData((Object)layoutData);
            inputGroupVisable = true;
            varComposite.setColor(colorIndex);
            ++colorIndex;
        }
        for (String group : this.inputVarGroups.keySet()) {
            Group varGroup = new Group(this.inputCompositeBody, this.style);
            FontData fontdata = varGroup.getFont().getFontData()[0];
            fontdata.setStyle(1);
            final Font font = new Font((Device)this.getDisplay(), fontdata);
            varGroup.setFont(font);
            varGroup.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    font.dispose();
                }
            });
            varGroup.setText(group);
            layoutData = new GridData(4, 1, true, false, 1, 1);
            varGroup.setLayoutData((Object)layoutData);
            varGroup.setLayout((Layout)new GridLayout(1, false));
            colorIndex = 1;
            for (JobVariable var : this.inputVarGroups.get(group)) {
                VariableComposite varComposite = VariableComposite.createJobVariableComposite((Composite)varGroup, (IWorkflowJobComposite)this, (JobVariable)this.workflowJob.getVariable(var.getKey()), (int)this.style);
                layoutData = new GridData(4, 1, true, false, 1, 1);
                varComposite.setLayoutData((Object)layoutData);
                varComposite.bindNewValue(false);
                inputGroupVisable = true;
                varComposite.setColor(colorIndex);
                ++colorIndex;
            }
        }
        inputGroup.layout(true);
    }

    @Deprecated
    private void createInputGroup_old(Group inputGroup) {
        GridData layoutData;
        boolean inputGroupVisable = false;
        if (this.inputCompositeBody != null) {
            this.inputCompositeBody.dispose();
        }
        this.inputCompositeBody = new Composite((Composite)inputGroup, this.style | 0x800);
        this.inputCompositeBody.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        this.inputCompositeBody.setLayout((Layout)new GridLayout(1, false));
        Collection vars = this.workflowJob.getAllVariables();
        int colorIndex = 0;
        for (JobVariable var : vars) {
            if (var.getDescVarRole() != VariableDescriptor.VariableRole.Input || var.descHasEnableActions() || var.descHasGroup() || !var.isVisable()) continue;
            VariableComposite varComposite = null;
            varComposite = VariableComposite.createJobVariableComposite((Composite)this.inputCompositeBody, (IWorkflowJobComposite)this, (JobVariable)var, (int)this.style);
            layoutData = new GridData(4, 1, true, false, 1, 1);
            varComposite.setLayoutData((Object)layoutData);
            inputGroupVisable = true;
            varComposite.setColor(colorIndex);
            ++colorIndex;
        }
        for (String group : this.workflowJob.getJobDesc().getVarGroups()) {
            if (this.workflowJob.getJobDesc().groupType(group) != VariableDescriptor.VariableRole.Input || !WorkflowJobBasicComposite.shouldRenderGroup(this.workflowJob, group)) continue;
            Group varGroup = new Group(this.inputCompositeBody, this.style);
            FontData fontdata = varGroup.getFont().getFontData()[0];
            fontdata.setStyle(1);
            Font font = new Font((Device)this.getDisplay(), fontdata);
            varGroup.setFont(font);
            varGroup.setText(group);
            layoutData = new GridData(4, 1, true, false, 1, 1);
            varGroup.setLayoutData((Object)layoutData);
            varGroup.setLayout((Layout)new GridLayout(1, false));
            colorIndex = 1;
            for (VariableDescriptor var : this.workflowJob.getJobDesc().getGroupVars(group)) {
                JobVariable jobVar = this.workflowJob.getVariable(var.getKey());
                if (var.hasEnableActions() || !jobVar.isVisable()) continue;
                VariableComposite varComposite = VariableComposite.createJobVariableComposite((Composite)varGroup, (IWorkflowJobComposite)this, (JobVariable)this.workflowJob.getVariable(var.getKey()), (int)this.style);
                layoutData = new GridData(4, 1, true, false, 1, 1);
                varComposite.setLayoutData((Object)layoutData);
                varComposite.bindNewValue(false);
                inputGroupVisable = true;
                varComposite.setColor(colorIndex);
                ++colorIndex;
            }
        }
        inputGroup.layout(true);
    }

    protected void createOptionsGroup(Composite optionsGroup) {
        GridData layoutData;
        if (this.optionsCompositeBody != null) {
            this.optionsCompositeBody.dispose();
            this.redraw();
        }
        this.optionsCompositeBody = new Composite(optionsGroup, this.style);
        this.optionsCompositeBody.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        this.optionsCompositeBody.setLayout((Layout)new GridLayout(1, false));
        int colorIndex = 0;
        for (JobVariable var : this.optionalVarBasicGroup) {
            VariableComposite varComposite = VariableComposite.createJobVariableComposite((Composite)this.optionsCompositeBody, (IWorkflowJobComposite)this, (JobVariable)var, (int)this.style);
            layoutData = new GridData(4, 1, true, false, 1, 1);
            varComposite.setLayoutData((Object)layoutData);
            varComposite.setColor(colorIndex);
            ++colorIndex;
        }
        for (String group : this.optionalVarGroups.keySet()) {
            Group varGroup = new Group(this.optionsCompositeBody, this.style);
            FontData fontdata = varGroup.getFont().getFontData()[0];
            fontdata.setStyle(1);
            Font font = new Font((Device)this.getDisplay(), fontdata);
            varGroup.setFont(font);
            layoutData = new GridData(4, 1, true, false, 1, 1);
            varGroup.setLayoutData((Object)layoutData);
            varGroup.setLayout((Layout)new GridLayout(1, false));
            colorIndex = 1;
            for (JobVariable var : this.optionalVarGroups.get(group)) {
                VariableComposite varComposite = VariableComposite.createJobVariableComposite((Composite)varGroup, (IWorkflowJobComposite)this, (JobVariable)this.workflowJob.getVariable(var.getKey()), (int)this.style);
                layoutData = new GridData(4, 1, true, false, 1, 1);
                varComposite.setLayoutData((Object)layoutData);
                varComposite.setColor(colorIndex);
                ++colorIndex;
            }
        }
    }

    @Deprecated
    private void createOptionsGroup_old(Group optionsGroup) {
        GridData layoutData;
        if (this.optionsCompositeBody != null) {
            this.optionsCompositeBody.dispose();
            this.redraw();
        }
        this.optionsCompositeBody = new Composite((Composite)optionsGroup, this.style | 0x800);
        this.optionsCompositeBody.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        this.optionsCompositeBody.setLayout((Layout)new GridLayout(1, false));
        Collection vars = this.workflowJob.getAllVariables();
        int colorIndex = 0;
        for (JobVariable var : vars) {
            if (var.getDescVarRole() != VariableDescriptor.VariableRole.Option || var.descHasEnableActions() || var.descHasGroup()) continue;
            VariableComposite varComposite = VariableComposite.createJobVariableComposite((Composite)this.optionsCompositeBody, (IWorkflowJobComposite)this, (JobVariable)var, (int)this.style);
            layoutData = new GridData(4, 1, true, false, 1, 1);
            varComposite.setLayoutData((Object)layoutData);
            varComposite.setColor(colorIndex);
            ++colorIndex;
        }
        for (String group : this.workflowJob.getJobDesc().getVarGroups()) {
            if (this.workflowJob.getJobDesc().groupType(group) != VariableDescriptor.VariableRole.Option || !WorkflowJobBasicComposite.shouldRenderGroup(this.workflowJob, group)) continue;
            Group varGroup = new Group(this.optionsCompositeBody, this.style);
            FontData fontdata = varGroup.getFont().getFontData()[0];
            fontdata.setStyle(1);
            Font font = new Font((Device)this.getDisplay(), fontdata);
            varGroup.setFont(font);
            varGroup.setText(group);
            layoutData = new GridData(4, 1, true, false, 1, 1);
            varGroup.setLayoutData((Object)layoutData);
            varGroup.setLayout((Layout)new GridLayout(1, false));
            colorIndex = 1;
            for (VariableDescriptor var : this.workflowJob.getJobDesc().getGroupVars(group)) {
                if (var.hasEnableActions()) continue;
                VariableComposite varComposite = VariableComposite.createJobVariableComposite((Composite)varGroup, (IWorkflowJobComposite)this, (JobVariable)this.workflowJob.getVariable(var.getKey()), (int)this.style);
                layoutData = new GridData(4, 1, true, false, 1, 1);
                varComposite.setLayoutData((Object)layoutData);
                varComposite.setColor(colorIndex);
                ++colorIndex;
            }
        }
    }

    protected static boolean shouldRenderGroup(WorkflowJob job, String group) {
        int varCount = 0;
        for (VariableDescriptor var : job.getJobDesc().getGroupVars(group)) {
            JobVariable jobVar = job.getVariable(var.getKey());
            if (var.hasEnableActions() || !jobVar.isVisable()) continue;
            ++varCount;
        }
        return varCount != 0;
    }

    private void refreshLayout() {
        int width = this.topForm.getSize().x;
        if (width > 800) {
            width = 800;
        }
        Point newSize = this.mainBody.computeSize(-1, -1, true);
        this.jobScrolledComposite.setMinSize(newSize.x, newSize.y);
    }

    void showSearch() {
        if (this.helpViewer.isVisable()) {
            this.helpViewer.close();
        }
        this.searchViewer.show(this.workflowJob);
    }

    void closeSearch() {
        if (this.searchViewer.isVisable()) {
            this.searchViewer.close();
            this.searchInerControls.setVisible(false);
            ((Button)this.searchInerControls.getData()).setSelection(false);
        }
    }

    public void update(Observable o, final Object arg) {
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                WorkflowJobBasicComposite.this.setLayoutDeferred(true);
                int eventType = (Integer)arg;
                if (eventType == 100) {
                    WorkflowJobBasicComposite.this.refreshLayout();
                }
                if (eventType == 300) {
                    WorkflowJobBasicComposite.this.createInputGroup((Composite)WorkflowJobBasicComposite.this.jobInputSection.getClient());
                    WorkflowJobBasicComposite.this.refreshLayout();
                }
                WorkflowJobBasicComposite.this.setLayoutDeferred(false);
            }
        });
    }

    public void requestShowHelp(JobVariable var) {
        this.closeSearch();
        this.helpViewer.showHelp(var);
    }

    public void removeVarComposite(VariableControl variableControl) {
        this.cVars.remove(variableControl);
    }

    public void addVarComposite(VariableControl variableControl) {
        this.cVars.add(variableControl);
    }

    public void toggleVarHelpMsg() {
        for (VariableControl varComposite : this.cVars) {
            varComposite.toggleHelpMsg();
        }
        this.refreshLayout();
    }

    public void bindWorkflowJob(WorkflowJob job) {
        this.workflowJob = job;
        this.workflowJob.addObserver((Observer)((Object)this));
    }

    public int varsCommandParamaterMaxStrLen() {
        return 25;
    }

    public WorkflowJob getWorkflowJob() {
        return this.workflowJob;
    }

    public boolean supportShowHelp() {
        return true;
    }

    public boolean runJob() {
        this.topForm.setFocus();
        IValidationResult res = this.workflowManager.submitWorkflowJob(this.workflowJob);
        if (res.isOK()) {
            this.detailsForm.setMessage("");
            this.detailsForm.setImage(SharedImages.ACCEPT);
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.workflowJob.getFriendlyName(), (String)(this.workflowJob.getFriendlyName() + " Job launched successfully. A notification and log file will be sent by email."));
        } else {
            this.detailsForm.setMessage(this.workflowJob.getFirstErrorMsg(), 3);
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.workflowJob.getFriendlyName(), (String)("Error running Job.\n" + this.workflowJob.getFirstErrorMsg()));
            ErrorDialog.openError((Shell)this.getShell(), (String)this.workflowJob.getFriendlyName(), (String)"Can not run current Task.", (IStatus)this.createMultiStatus(res));
        }
        return res.isOK();
    }

    private IStatus createMultiStatus(IValidationResult res) {
        if (res.isMultiValidation()) {
            MultiStatus ms = new MultiStatus(((Object)((Object)this)).getClass(), res.getCode(), res.getMessage(), res.getException());
            IValidationResult[] iValidationResultArray = res.getChildren();
            int n = iValidationResultArray.length;
            int n2 = 0;
            while (n2 < n) {
                IValidationResult vs = iValidationResultArray[n2];
                ms.add((IStatus)new Status(vs.getSeverity(), ((Object)((Object)this)).getClass(), vs.getCode(), vs.getMessage(), vs.getException()));
                ++n2;
            }
            res.getException();
            return ms;
        }
        return new Status(res.getSeverity(), ((Object)((Object)this)).getClass(), res.getCode(), res.getMessage(), res.getException());
    }

    public boolean checkValidation() {
        if (!this.workflowJob.isValid()) {
            this.detailsForm.setMessage(this.workflowJob.getFirstErrorMsg(), 3);
            return false;
        }
        return true;
    }

    public UserManager getUserManager() {
        return this.workflowManager.getUserManager();
    }
}

