/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.internal;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.commons.model.UserLoginInfo;
import com.biotechvana.commons.model.UserNotifyListener;
import com.biotechvana.commons.viewers.IFTPBrowser;
import com.biotechvana.pipelinestools.utils.PipelineUtils;
import com.biotechvana.users.UserManager;
import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.IValidationResult;
import com.biotechvana.workflow.SubmissionHistoryManager;
import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.Workflow;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.expert.IExpertSystemAPI;
import com.biotechvana.workflow.ext.SubmissionHistoryUpdator;
import com.biotechvana.workflow.ext.TrackingComposite;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;
import com.biotechvana.workflow.tracking.ExecStatus;
import com.biotechvana.workflow.tracking.ITrackerInfo;
import com.biotechvana.workflow.tracking.TrackerInfoEntry;
import com.biotechvana.workflow.tracking.events.InfoTrackEvent;
import com.biotechvana.workflow.tracking.tasks.TaskTracker;
import com.biotechvana.workflow.ui.handlers.OpenJobsMainViewHandler;
import com.biotechvana.workflow.ui.widgets.WorkflowVis;
import com.biotechvana.workflow.variables.JobVariable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmissionHistoryView {
    private static final Logger logger = LoggerFactory.getLogger(SubmissionHistoryView.class);
    UserLoginInfo activeLogin;
    @Inject
    @Named(value="activeShell")
    private Shell activeShell;
    @Inject
    MApplication application;
    SashForm container;
    Thread currentRefreshThread = null;
    IEclipseContext expertSubContext = null;
    @Inject
    @Optional
    IExpertSystemAPI expertSystem;
    @Inject
    @Optional
    IFTPBrowser ftp;
    boolean isVisable = true;
    Text lastLog = null;
    @Inject
    IStatusLineManager manager;
    @Inject
    private MPart part;
    IPartListener partListener;
    Workflow preSelectedPipeline = null;
    WorkflowVis preWorkflowVis = null;
    StatusLineContributionItem statusLine = null;
    IProgressMonitor statusProgressMoniter;
    @Inject
    SubmissionHistoryManager submissionHistoryManager;
    private Table table;
    TableViewer tableViewer;
    TrackingComposite trackerPart;
    @Inject
    UISynchronize uiSync;
    SubmissionHistoryUpdator updator;
    @Inject
    private UserManager userManager;
    int[] w = null;
    @Inject
    IWorkflowManager workflowManager;
    boolean initialed = false;
    IProgressMonitor monitor = null;

    private void createActions() {
    }

    private IStatus createMultiStatus(IValidationResult res) {
        if (res.isMultiValidation()) {
            MultiStatus ms = new MultiStatus(this.getClass(), res.getCode(), res.getMessage(), res.getException());
            IValidationResult[] iValidationResultArray = res.getChildren();
            int n = iValidationResultArray.length;
            int n2 = 0;
            while (n2 < n) {
                IValidationResult vs = iValidationResultArray[n2];
                ms.add((IStatus)new Status(vs.getSeverity(), this.getClass(), vs.getCode(), vs.getMessage(), vs.getException()));
                ++n2;
            }
            res.getException();
            return ms;
        }
        return new Status(res.getSeverity(), this.getClass(), res.getCode(), res.getMessage(), res.getException());
    }

    @PostConstruct
    public void createPartControl(Composite parent, EPartService partService, MApplication app) {
        app.getContext().set(SubmissionHistoryView.class, (Object)this);
        this.container = new SashForm(parent, 512);
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
        this.tableViewer = new TableViewer((Composite)this.container, 268503810);
        this.table = this.tableViewer.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.setupTable();
        this.trackerPart = new TrackingComposite((Composite)this.container, 0);
        this.partListener = new IPartListener(){

            public void partActivated(MPart part) {
                if (part == SubmissionHistoryView.this.part) {
                    SubmissionHistoryView.this.gettingActivated();
                }
            }

            public void partBroughtToTop(MPart part) {
            }

            public void partDeactivated(MPart part) {
                if (part == SubmissionHistoryView.this.part) {
                    SubmissionHistoryView.this.isVisable = false;
                }
            }

            public void partHidden(MPart part) {
                if (part == SubmissionHistoryView.this.part) {
                    SubmissionHistoryView.this.isVisable = false;
                    if (SubmissionHistoryView.this.updator != null) {
                        SubmissionHistoryView.this.updator.stop();
                    }
                }
            }

            public void partVisible(MPart part) {
                if (part == SubmissionHistoryView.this.part) {
                    SubmissionHistoryView.this.isVisable = true;
                    if (SubmissionHistoryView.this.updator != null) {
                        SubmissionHistoryView.this.updator.start();
                    }
                }
            }
        };
        partService.addPartListener(this.partListener);
        this.container.setWeights(new int[]{1, 1});
    }

    private void gettingActivated() {
        if (!this.initialed) {
            this.statusLine = new StatusLineContributionItem("TStatus", 200);
            if (this.userManager.isLogin()) {
                this.manager.setMessage(SharedImages.ACCEPT, "Connection Ok");
                this.submissionHistoryManager.loadCurrentUserHistory(false, true);
            } else {
                this.manager.setErrorMessage(SharedImages.ERROR, "No active connection");
            }
            this.updator = new SubmissionHistoryUpdator(this);
            UserNotifyListener userNotifyListener = new UserNotifyListener(){

                public void userChanged() {
                    SubmissionHistoryView.this.uiSync.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).SubmissionHistoryView.this.expertSubContext != null) {
                                (this).SubmissionHistoryView.this.expertSubContext.set("activeDiagnoseRequest", null);
                            }
                            (this).SubmissionHistoryView.this.tableViewer.setInput(null);
                            (this).SubmissionHistoryView.this.tableViewer.refresh();
                            SubmissionHistoryView.this.selectedEntryChanged(null);
                        }
                    });
                    Thread newThread = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            SubmissionHistoryManager submissionHistoryManager = (this).SubmissionHistoryView.this.submissionHistoryManager;
                            synchronized (submissionHistoryManager) {
                                (this).SubmissionHistoryView.this.submissionHistoryManager.loadCurrentUserHistory(true, false);
                            }
                            SubmissionHistoryView.this.updateSubmissionHistory();
                        }
                    });
                    newThread.start();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void userChanging() {
                    SubmissionHistoryManager submissionHistoryManager = SubmissionHistoryView.this.submissionHistoryManager;
                    synchronized (submissionHistoryManager) {
                        SubmissionHistoryView.this.submissionHistoryManager.saveUserHistoryToDisk();
                    }
                }
            };
            this.userManager.addUserNotiferList(userNotifyListener);
            this.refreshTable();
            this.updator.start();
        }
    }

    @PreDestroy
    public void dispose(EPartService partService) {
        partService.removePartListener(this.partListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PersistState
    public void save() {
        if (this.updator != null) {
            this.updator.stop();
        }
        SubmissionHistoryManager submissionHistoryManager = this.submissionHistoryManager;
        synchronized (submissionHistoryManager) {
            this.submissionHistoryManager.saveUserHistoryToDisk();
        }
    }

    private void editAndSubmit(WorkflowJob job) {
        try {
            IEclipseContext varContext = EclipseContextFactory.create();
            this.application.getContext().set(WorkflowJob.class, (Object)job);
            varContext.setParent(this.application.getContext());
            ContextInjectionFactory.invoke((Object)new OpenJobsMainViewHandler(), Execute.class, (IEclipseContext)this.application.getContext());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void initializeMenu() {
    }

    private void initializeToolBar() {
    }

    private void initTask(WorkflowJob job, SubmissionHistoryEntry entry) {
        int indexR;
        int nRestart = 0;
        String taskIntenalId = entry.getTaskInternalId();
        job.setJobId(taskIntenalId);
        WorkflowJob.createPrevoiusJobNameVar((WorkflowJob)job);
        for (ITrackerInfo info : entry.getTrackInfo().getTrackerInfoEntries()) {
            String[] varKeys;
            JobVariable var;
            String varKeyValue;
            String[] tokens;
            if (!(info instanceof TrackerInfoEntry) || ((TrackerInfoEntry)info).getEventtype() != Tracking.TrackEventType.Info) continue;
            System.out.print(info);
            if (((InfoTrackEvent)info).getInfoType() == Tracking.TrackInfoType.Process || (tokens = (varKeyValue = info.getLogMsg()).split("=")).length <= 1) continue;
            String varFullKey = tokens[0];
            String varValue = tokens[1];
            if (!varFullKey.contains(".") || (var = job.getVariable((varKeys = varFullKey.split("\\."))[1])).getDescVarRole() == VariableDescriptor.VariableRole.Output) continue;
            varValue = varValue.replace(";", "\n");
            var.setValue(varValue);
            if (!"PREVIOUS_JOB_RESTART".equals(varKeys[1])) continue;
            nRestart = Integer.parseInt(varValue);
        }
        String name = job.getValue("INPUT_CUSTOM_JOB_NAME");
        if (++nRestart > 1 && (indexR = (name = job.getValue("PREVIOUS_JOB_NAME")).lastIndexOf(".")) != -1) {
            name = name.substring(0, indexR);
        }
        job.setValue("INPUT_CUSTOM_JOB_NAME", name + ".R" + nRestart);
        job.setValue("PREVIOUS_JOB_RESTART", "" + nRestart);
        job.setValue("PREVIOUS_JOB_NAME", entry.getTaskName());
        job.setValue("PREVIOUS_JOB_TIMESTAMP", "" + entry.getSubmissionTimeStamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void refreshHistory(boolean redo) {
        try {
            this.currentRefreshThread = Thread.currentThread();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (SubmissionHistoryView.this.container.isDisposed()) {
                        return;
                    }
                    SubmissionHistoryView.this.statusLine.setText("Updating Track Information");
                    SubmissionHistoryView.this.manager.getProgressMonitor().beginTask("Updating", -1);
                }
            });
            SubmissionHistoryManager submissionHistoryManager = this.submissionHistoryManager;
            synchronized (submissionHistoryManager) {
                Thread.sleep(8000L);
                this.submissionHistoryManager.sync();
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (SubmissionHistoryView.this.container.isDisposed()) {
                        return;
                    }
                    SubmissionHistoryView.this.refreshTable();
                    SubmissionHistoryView.this.statusLine.setText("");
                    SubmissionHistoryView.this.manager.getProgressMonitor().done();
                }
            });
        }
        catch (Exception ex) {
            System.out.println("Can not Sync History");
            ex.printStackTrace();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SubmissionHistoryView.this.statusLine.setText("");
                    SubmissionHistoryView.this.manager.getProgressMonitor().done();
                }
            });
            ex.printStackTrace();
        }
    }

    private void refreshLayout() {
        if (this.w == null) {
            this.container.setWeights(new int[]{1, 1});
        } else {
            this.container.setWeights(this.w);
        }
        this.container.layout(true);
    }

    private void refreshTable() {
        int[] selectedIndeces = this.table.getSelectionIndices();
        this.tableViewer.setInput((Object)this.submissionHistoryManager.getUserSubmissionHistory().getSubmissionHistoryEntries());
        if (selectedIndeces != null) {
            this.table.setSelection(selectedIndeces);
        }
        this.tableViewer.refresh();
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        SubmissionHistoryEntry entry = (SubmissionHistoryEntry)selection.getFirstElement();
        if (entry != null) {
            this.selectedEntryChanged(entry);
        }
        this.tableViewer.getTable().layout();
        this.tableViewer.getTable().getColumn(this.tableViewer.getTable().getColumnCount() - 1).pack();
    }

    protected void resolveAction(SubmissionHistoryEntry entry) {
        TaskTracker tracker = null;
        if (entry.getTaskType() == SubmissionHistoryEntry.TaskType.Job) {
            WorkflowJob workflowjob = this.submissionHistoryManager.createJobInstance(entry);
            tracker = TaskTracker.toTaskTracker((WorkflowJob)workflowjob, (SubmissionHistoryEntry)entry);
            entry.setTracker(tracker);
        }
        if (this.expertSubContext == null) {
            this.expertSubContext = this.application.getContext();
        }
        this.expertSystem.submit(entry);
    }

    protected void selectedEntryChanged(SubmissionHistoryEntry entry) {
        this.w = this.container.getWeights();
        if (entry != null) {
            this.trackerPart.setEntry(this.workflowManager, entry);
        } else {
            this.trackerPart.clearTracker();
        }
        this.refreshLayout();
    }

    @Inject
    public void setActiveLogin(@Optional @Named(value="ACTIVE_LOGIN") UserLoginInfo activeLogin) {
        this.activeLogin = activeLogin;
    }

    @Focus
    public void setFocus() {
    }

    void setupTable() {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Date");
        tblclmn.setWidth(150);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Name");
        tblclmn.setWidth(150);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Type");
        tblclmn.setWidth(150);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tableViewerColumn = new TableViewerColumn(this.tableViewer, 8);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Finish Time");
        tblclmn.setWidth(100);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tableViewerColumn = new TableViewerColumn(this.tableViewer, 8);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Last Time Updated");
        tblclmn.setWidth(100);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tableViewerColumn = new TableViewerColumn(this.tableViewer, 8);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Status");
        tblclmn.setWidth(100);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tableViewerColumn = new TableViewerColumn(this.tableViewer, 8);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Path");
        tblclmn.setWidth(100);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(16384);
        final Menu menu = new Menu((Control)this.table);
        this.table.setMenu(menu);
        final MenuItem mntmOpenFTP = new MenuItem(menu, 0);
        mntmOpenFTP.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubmissionHistoryView.this.manager.setMessage("select ftp");
                SubmissionHistoryView.this.statusLine.setText("select ftp2");
                SubmissionHistoryView.this.statusLine.setVisible(true);
                SubmissionHistoryView.this.manager.setErrorMessage(SharedImages.ERROR, "Not Connected");
                IStructuredSelection selection = (IStructuredSelection)SubmissionHistoryView.this.tableViewer.getSelection();
                SubmissionHistoryEntry entry = (SubmissionHistoryEntry)selection.getFirstElement();
                if (entry != null) {
                    Object path = entry.getScriptFolderPath();
                    boolean failOpen = false;
                    path = PipelineUtils.sanitizeFTPFilePath((String)SubmissionHistoryView.this.userManager.getHostPathManager().getUserHomePath(), (String)path, (boolean)SubmissionHistoryView.this.userManager.getIsChRooted());
                    if (entry.getTaskType() == SubmissionHistoryEntry.TaskType.Pipeline) {
                        path = (String)path + "/" + entry.getTaskName();
                    }
                    if (path != null) {
                        try {
                            failOpen = !SubmissionHistoryView.this.ftp.setelectPath((String)path);
                        }
                        catch (Exception ex) {
                            failOpen = true;
                            ex.printStackTrace();
                        }
                    } else {
                        failOpen = true;
                    }
                    if (failOpen) {
                        MessageDialog.openWarning((Shell)SubmissionHistoryView.this.activeShell, (String)Constants.MODULE_NAME, (String)"Can not locate the directory in the server. It could be deleted or renamed.");
                    }
                }
            }
        });
        mntmOpenFTP.setText("Select In FTP Explorer");
        final MenuItem mntmViewReport = new MenuItem(menu, 0);
        mntmViewReport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubmissionHistoryView.this.updator.stop();
            }
        });
        mntmViewReport.setText("View Report");
        mntmViewReport.setEnabled(true);
        new MenuItem(menu, 2);
        MenuItem mntmRefresh = new MenuItem(menu, 0);
        mntmRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubmissionHistoryView.this.updator.start();
            }
        });
        mntmRefresh.setText("Refresh");
        MenuItem mntmClear = new MenuItem(menu, 0);
        mntmClear.setText("Clear All");
        mntmClear.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                final ArrayList<SubmissionHistoryEntry> entries = new ArrayList<SubmissionHistoryEntry>();
                for (SubmissionHistoryEntry entry : SubmissionHistoryView.this.submissionHistoryManager.getUserSubmissionHistory().getSubmissionHistoryEntries()) {
                    if (!entry.isNotRunning()) continue;
                    entries.add(entry);
                }
                if (entries.size() > 0) {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask("Clearing History", -1);
                            SubmissionHistoryManager submissionHistoryManager = (this).SubmissionHistoryView.this.submissionHistoryManager;
                            synchronized (submissionHistoryManager) {
                                (this).SubmissionHistoryView.this.submissionHistoryManager.getUserSubmissionHistory().delete(entries);
                            }
                        }
                    };
                    try {
                        new ProgressMonitorDialog(SubmissionHistoryView.this.activeShell).run(true, false, runnable);
                        SubmissionHistoryView.this.tableViewer.refresh();
                        SubmissionHistoryView.this.selectedEntryChanged(null);
                    }
                    catch (InvocationTargetException ev) {
                        ev.printStackTrace();
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        new MenuItem(menu, 2);
        final MenuItem mntmDelete = new MenuItem(menu, 0);
        mntmDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)SubmissionHistoryView.this.tableViewer.getSelection();
                final ArrayList<SubmissionHistoryEntry> entries = new ArrayList<SubmissionHistoryEntry>();
                for (Object objectEntry : selection.toList()) {
                    SubmissionHistoryEntry entry = (SubmissionHistoryEntry)objectEntry;
                    if (entry.isNotRunning()) {
                        entries.add(entry);
                        continue;
                    }
                    MessageDialog.openWarning((Shell)SubmissionHistoryView.this.activeShell, (String)Constants.MODULE_NAME, (String)"Can not delete a running task.");
                    return;
                }
                if (entries.size() > 0) {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask("Deleting Selected Items", -1);
                            SubmissionHistoryManager submissionHistoryManager = (this).SubmissionHistoryView.this.submissionHistoryManager;
                            synchronized (submissionHistoryManager) {
                                (this).SubmissionHistoryView.this.submissionHistoryManager.getUserSubmissionHistory().delete(entries);
                            }
                        }
                    };
                    try {
                        new ProgressMonitorDialog(SubmissionHistoryView.this.activeShell).run(true, false, runnable);
                        SubmissionHistoryView.this.tableViewer.refresh();
                        SubmissionHistoryView.this.selectedEntryChanged(null);
                    }
                    catch (InvocationTargetException ev) {
                        ev.printStackTrace();
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        mntmDelete.setText("Delete");
        final MenuItem mntmCancel = new MenuItem(menu, 0);
        mntmCancel.setText("Cancel");
        mntmCancel.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)SubmissionHistoryView.this.tableViewer.getSelection();
                final SubmissionHistoryEntry entry = (SubmissionHistoryEntry)selection.getFirstElement();
                if (entry != null && !entry.isNotRunning()) {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask("Stoping " + entry.getTaskName(), -1);
                            SubmissionHistoryManager submissionHistoryManager = (this).SubmissionHistoryView.this.submissionHistoryManager;
                            synchronized (submissionHistoryManager) {
                                (this).SubmissionHistoryView.this.submissionHistoryManager.getUserSubmissionHistory().stop(entry);
                            }
                        }
                    };
                    try {
                        new ProgressMonitorDialog(SubmissionHistoryView.this.activeShell).run(true, false, runnable);
                        SubmissionHistoryView.this.tableViewer.refresh();
                    }
                    catch (InvocationTargetException ev) {
                        ev.printStackTrace();
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        menu.addMenuListener(new MenuListener(){
            MenuItem editRestartItem = null;
            MenuItem restartItem = null;
            MenuItem seperator = null;
            MenuItem mntmExpertSystem = null;

            private void addDynItems(final SubmissionHistoryEntry entry) {
                if (entry.getTaskType() == SubmissionHistoryEntry.TaskType.Job) {
                    this.seperator = new MenuItem(menu, 2);
                    if (entry.isNotRunning()) {
                        this.restartItem = new MenuItem(menu, 0);
                        this.restartItem.setText("Restart");
                        this.restartItem.addSelectionListener(new SelectionListener(){

                            public void widgetDefaultSelected(SelectionEvent e) {
                            }

                            public void widgetSelected(SelectionEvent e) {
                                WorkflowJob job = (this).SubmissionHistoryView.this.workflowManager.restart(entry);
                                SubmissionHistoryView.this.initTask(job, entry);
                                SubmissionHistoryView.this.submitJob(job);
                            }
                        });
                        this.editRestartItem = new MenuItem(menu, 0);
                        this.editRestartItem.setText("Edit && Restart");
                        this.editRestartItem.addSelectionListener(new SelectionListener(){

                            public void widgetDefaultSelected(SelectionEvent e) {
                            }

                            public void widgetSelected(SelectionEvent e) {
                                WorkflowJob job = (this).SubmissionHistoryView.this.workflowManager.restart(entry);
                                SubmissionHistoryView.this.initTask(job, entry);
                                SubmissionHistoryView.this.editAndSubmit(job);
                            }
                        });
                    }
                    if ((entry.getStatus() == ExecStatus.Failed || entry.getStatus() == ExecStatus.Warning) && SubmissionHistoryView.this.expertSystem != null) {
                        this.mntmExpertSystem = new MenuItem(menu, 0);
                        this.mntmExpertSystem.setText("Resolve");
                        this.mntmExpertSystem.addSelectionListener(new SelectionListener(){

                            public void widgetDefaultSelected(SelectionEvent e) {
                            }

                            public void widgetSelected(SelectionEvent e) {
                                IStructuredSelection selection = (IStructuredSelection)(this).SubmissionHistoryView.this.tableViewer.getSelection();
                                List entries = selection.toList();
                                if (entries.size() != 0) {
                                    SubmissionHistoryEntry entry = (SubmissionHistoryEntry)entries.get(0);
                                    SubmissionHistoryView.this.resolveAction(entry);
                                }
                            }
                        });
                    }
                }
            }

            public void menuHidden(MenuEvent e) {
            }

            public void menuShown(MenuEvent e) {
                this.remove();
                mntmCancel.setText("Cancel");
                mntmDelete.setText("Delete");
                mntmDelete.setEnabled(true);
                mntmCancel.setEnabled(true);
                if (SubmissionHistoryView.this.ftp == null) {
                    mntmOpenFTP.setEnabled(false);
                } else {
                    mntmOpenFTP.setEnabled(true);
                }
                mntmViewReport.setEnabled(false);
                try {
                    IStructuredSelection selection = (IStructuredSelection)SubmissionHistoryView.this.tableViewer.getSelection();
                    List entries = selection.toList();
                    if (entries.size() > 1) {
                        mntmDelete.setText("Delete All Selected");
                        mntmCancel.setText("Cancel");
                        mntmCancel.setEnabled(false);
                    } else if (entries.size() == 0) {
                        mntmDelete.setEnabled(false);
                        mntmCancel.setEnabled(false);
                    } else {
                        SubmissionHistoryEntry entry = (SubmissionHistoryEntry)entries.get(0);
                        if (entry.isNotRunning()) {
                            mntmCancel.setEnabled(false);
                            mntmDelete.setText("Delete [" + entry.getTaskName() + "]");
                            if (entry.isSucceed()) {
                                mntmViewReport.setEnabled(true);
                            }
                        } else {
                            mntmDelete.setEnabled(false);
                            mntmCancel.setEnabled(true);
                            mntmCancel.setText("Cancel [" + entry.getTaskName() + "]");
                        }
                        this.addDynItems(entry);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            private void remove() {
                if (this.seperator != null) {
                    this.seperator.dispose();
                }
                if (this.restartItem != null) {
                    this.restartItem.dispose();
                }
                if (this.mntmExpertSystem != null) {
                    this.mntmExpertSystem.dispose();
                }
                if (this.editRestartItem != null) {
                    this.editRestartItem.dispose();
                }
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Set entries = (Set)inputElement;
                Object[] allList = entries.toArray(new SubmissionHistoryEntry[entries.size()]);
                Arrays.sort(allList);
                return allList;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                SubmissionHistoryEntry entry = (SubmissionHistoryEntry)element;
                if (columnIndex == 2) {
                    if (entry.getTaskType() == SubmissionHistoryEntry.TaskType.Job) {
                        return SharedImages.PROCESS;
                    }
                    return SharedImages.WORKFLOW;
                }
                if (columnIndex == 5) {
                    if (entry.getStatus() == ExecStatus.Finished) {
                        return SharedImages.ACCEPT;
                    }
                    if (entry.getStatus() == ExecStatus.Failed) {
                        return SharedImages.ERROR;
                    }
                    if (entry.getStatus() == ExecStatus.Running) {
                        return SharedImages.RUNNING;
                    }
                    if (entry.getStatus() == ExecStatus.Warning) {
                        return SharedImages.WARNNING_YELLOW;
                    }
                    if (entry.getStatus() == ExecStatus.Paused) {
                        return SharedImages.RUNNING;
                    }
                    if (entry.getStatus() == ExecStatus.Canceled) {
                        return SharedImages.CANCEL;
                    }
                }
                if (columnIndex == 6) {
                    return SharedImages.FOLDER;
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                SubmissionHistoryEntry entry = (SubmissionHistoryEntry)element;
                switch (columnIndex) {
                    case 0: {
                        return entry.getSubmissionTime();
                    }
                    case 1: {
                        return entry.getTaskName();
                    }
                    case 2: {
                        return entry.getTaskType().toString() + "/" + entry.getTaskTemplateId();
                    }
                    case 3: {
                        return entry.getFinishTime();
                    }
                    case 4: {
                        return entry.getLastTimeUpdated();
                    }
                    case 5: {
                        return entry.getStatus().toString();
                    }
                    case 6: {
                        return entry.getScriptFolderPath();
                    }
                }
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.tableViewer.setInput((Object)this.submissionHistoryManager.getUserSubmissionHistory().getSubmissionHistoryEntries());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                SubmissionHistoryEntry entry = (SubmissionHistoryEntry)selection.getFirstElement();
                if (entry != null) {
                    SubmissionHistoryView.this.selectedEntryChanged(entry);
                }
            }
        });
    }

    private IStatus Status_error(String msg, Exception ex) {
        return new Status(4, this.getClass(), msg, ex){};
    }

    protected void stopUpdate() {
        if (this.currentRefreshThread != null) {
            System.out.println("stopUpdate ");
            if (this.currentRefreshThread.isAlive()) {
                System.out.println("stopUpdate Stoping.1");
                this.currentRefreshThread.interrupt();
                System.out.println("stopUpdate Stoping.2");
            }
        }
    }

    private boolean submitJob(WorkflowJob workflowJob) {
        IValidationResult res = this.workflowManager.submitWorkflowJob(workflowJob);
        if (res.isOK()) {
            MessageDialog.openInformation((Shell)this.activeShell, (String)workflowJob.getFriendlyName(), (String)(workflowJob.getFriendlyName() + " Job launched successfully."));
            this.updator.start();
        } else {
            ErrorDialog.openError((Shell)this.activeShell, (String)workflowJob.getFriendlyName(), (String)"Can not run current Task. Please review and edit it before submiting it", (IStatus)this.createMultiStatus(res));
        }
        return res.isOK();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSubmissionHistory() {
        logger.debug("Updating History : updateSubmissionHistory");
        SubmissionHistoryManager submissionHistoryManager = this.submissionHistoryManager;
        synchronized (submissionHistoryManager) {
            logger.debug("Updating History : pre refresh");
            try {
                this.uiSync.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SubmissionHistoryView.this.container.isDisposed()) {
                            return;
                        }
                        SubmissionHistoryView.this.statusLine.setText("Updating Track Information");
                        SubmissionHistoryView.this.monitor = SubmissionHistoryView.this.manager.getProgressMonitor();
                        SubmissionHistoryView.this.monitor.beginTask("Updating", -1);
                    }
                });
                this.submissionHistoryManager.sync();
                this.uiSync.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SubmissionHistoryView.this.container.isDisposed()) {
                            return;
                        }
                        SubmissionHistoryView.this.refreshTable();
                        SubmissionHistoryView.this.statusLine.setText("");
                        if (SubmissionHistoryView.this.monitor != null) {
                            SubmissionHistoryView.this.monitor.done();
                        }
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.error("Can not Sync History", (Throwable)ex);
                this.uiSync.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SubmissionHistoryView.this.container.isDisposed()) {
                            return;
                        }
                        SubmissionHistoryView.this.statusLine.setText("Can not Sync History, Please Try again later");
                        if (SubmissionHistoryView.this.monitor != null) {
                            SubmissionHistoryView.this.monitor.done();
                        }
                    }
                });
            }
        }
    }

    public SubmissionHistoryUpdator updator() {
        return this.updator;
    }
}

