/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui;

import com.biotechvana.workflow.manager.WorkflowCatalog;
import com.biotechvana.workflow.template.WorkflowTemplate;
import com.biotechvana.workflow.ui.WorkflowSelectionViewfilters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class BasicWorkflowSelectionViewfilters
implements WorkflowSelectionViewfilters {
    static final String FILTERS_GROUP_MAPPING_KEY = "FILTERS_GROUP_MAPPING_KEY";
    static final String FILTERS_GROUP_PREPROCESSING_KEY = "FILTERS_GROUP_PREPROCESSING_KEY";
    protected HashMap<String, FiltersGroup> filtersGroups = new HashMap();
    boolean isPairEnd = true;
    List<WorkflowSelectionViewfilters.FiltersValuesChangedListener> listeners = new ArrayList<WorkflowSelectionViewfilters.FiltersValuesChangedListener>();
    protected HashSet<Button> selectedBtns = new HashSet();

    protected void addBlank(Composite row) {
        Label lb = new Label(row, 0);
        RowData rd = new RowData();
        rd.width = 10;
        lb.setLayoutData((Object)rd);
    }

    protected abstract void addCommonsFilters(Group var1);

    @Override
    public void addListener(WorkflowSelectionViewfilters.FiltersValuesChangedListener listener) {
        this.listeners.add(listener);
    }

    protected void addMappingToolsFilter(Composite row) {
        this.filtersGroups.put(FILTERS_GROUP_MAPPING_KEY, new FiltersGroup());
        Group mappingToolsGroup = new Group(row, 0);
        mappingToolsGroup.setLayout((Layout)new RowLayout(512));
        mappingToolsGroup.setText("Mapping Steps");
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.widget;
                String tag = source.getText();
                if (source.getSelection()) {
                    BasicWorkflowSelectionViewfilters.this.filtersGroups.get((Object)BasicWorkflowSelectionViewfilters.FILTERS_GROUP_MAPPING_KEY).hasTags.add(tag);
                    BasicWorkflowSelectionViewfilters.this.filtersGroups.get((Object)BasicWorkflowSelectionViewfilters.FILTERS_GROUP_MAPPING_KEY).doesNotContainsTags.remove(tag);
                } else {
                    BasicWorkflowSelectionViewfilters.this.filtersGroups.get((Object)BasicWorkflowSelectionViewfilters.FILTERS_GROUP_MAPPING_KEY).hasTags.remove(tag);
                    BasicWorkflowSelectionViewfilters.this.filtersGroups.get((Object)BasicWorkflowSelectionViewfilters.FILTERS_GROUP_MAPPING_KEY).doesNotContainsTags.add(tag);
                }
                BasicWorkflowSelectionViewfilters.this.notifyListner();
            }
        };
        Button button1Step = new Button((Composite)mappingToolsGroup, 32);
        button1Step.setText("bwa");
        button1Step.setSelection(false);
        button1Step.addSelectionListener(selectionListener);
        this.selectedBtns.add(button1Step);
        button1Step = new Button((Composite)mappingToolsGroup, 32);
        button1Step.setText("Bowtie2");
        button1Step.setSelection(false);
        button1Step.addSelectionListener(selectionListener);
        this.selectedBtns.add(button1Step);
        button1Step = new Button((Composite)mappingToolsGroup, 32);
        button1Step.setText("Tophat");
        button1Step.setSelection(false);
        button1Step.addSelectionListener(selectionListener);
        this.selectedBtns.add(button1Step);
        button1Step = new Button((Composite)mappingToolsGroup, 32);
        button1Step.setText("STAR");
        button1Step.setSelection(false);
        button1Step.addSelectionListener(selectionListener);
        this.selectedBtns.add(button1Step);
        button1Step = new Button((Composite)mappingToolsGroup, 32);
        button1Step.setText("hisat2");
        button1Step.setSelection(false);
        button1Step.addSelectionListener(selectionListener);
        this.selectedBtns.add(button1Step);
    }

    protected void addPreprocessingToolsFilter(Composite row) {
        this.filtersGroups.put(FILTERS_GROUP_PREPROCESSING_KEY, new FiltersGroup());
        Group preToolsGroup = new Group(row, 0);
        preToolsGroup.setLayout((Layout)new RowLayout(512));
        preToolsGroup.setText("Pre-Processing Steps");
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.widget;
                String tag = source.getText();
                if (source.getSelection()) {
                    BasicWorkflowSelectionViewfilters.this.filtersGroups.get((Object)BasicWorkflowSelectionViewfilters.FILTERS_GROUP_PREPROCESSING_KEY).hasTags.add(tag);
                    BasicWorkflowSelectionViewfilters.this.filtersGroups.get((Object)BasicWorkflowSelectionViewfilters.FILTERS_GROUP_PREPROCESSING_KEY).doesNotContainsTags.remove(tag);
                } else {
                    BasicWorkflowSelectionViewfilters.this.filtersGroups.get((Object)BasicWorkflowSelectionViewfilters.FILTERS_GROUP_PREPROCESSING_KEY).hasTags.remove(tag);
                    BasicWorkflowSelectionViewfilters.this.filtersGroups.get((Object)BasicWorkflowSelectionViewfilters.FILTERS_GROUP_PREPROCESSING_KEY).doesNotContainsTags.add(tag);
                }
                BasicWorkflowSelectionViewfilters.this.notifyListner();
            }
        };
        Button button1Step = new Button((Composite)preToolsGroup, 32);
        button1Step.setText("CUTADAPT");
        button1Step.setSelection(false);
        button1Step.addSelectionListener(selectionListener);
        this.selectedBtns.add(button1Step);
        button1Step = new Button((Composite)preToolsGroup, 32);
        button1Step.setText("PRINSEQ");
        button1Step.setSelection(false);
        button1Step.addSelectionListener(selectionListener);
        this.selectedBtns.add(button1Step);
        button1Step = new Button((Composite)preToolsGroup, 32);
        button1Step.setText("trimmomatic");
        button1Step.setSelection(false);
        button1Step.addSelectionListener(selectionListener);
        this.selectedBtns.add(button1Step);
    }

    protected void addReadLayoutFilter(Composite row) {
        Group readLayoutGroup = new Group(row, 0);
        readLayoutGroup.setLayout((Layout)new RowLayout(512));
        readLayoutGroup.setText("Read Layout");
        Button buttonSE = new Button((Composite)readLayoutGroup, 16);
        buttonSE.setText("Single-End");
        final Button buttonPE = new Button((Composite)readLayoutGroup, 16);
        buttonPE.setText("Pair-End");
        buttonPE.setSelection(true);
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                BasicWorkflowSelectionViewfilters.this.isPairEnd = buttonPE.getSelection();
                BasicWorkflowSelectionViewfilters.this.notifyListner();
            }

            public void widgetSelected(SelectionEvent e) {
                BasicWorkflowSelectionViewfilters.this.isPairEnd = buttonPE.getSelection();
                BasicWorkflowSelectionViewfilters.this.notifyListner();
            }
        };
        buttonPE.addSelectionListener(selectionListener);
        buttonSE.addSelectionListener(selectionListener);
    }

    @Override
    public List<WorkflowTemplate> applyFilters(List<WorkflowTemplate> wfTemplates) {
        for (FiltersGroup filterGroup : this.filtersGroups.values()) {
            wfTemplates = this.applyFiltersGroup(wfTemplates, filterGroup);
        }
        return wfTemplates;
    }

    private List<WorkflowTemplate> applyFiltersGroup(List<WorkflowTemplate> wfTemplates, FiltersGroup filterGroup) {
        if (filterGroup.hasTags.isEmpty()) {
            return wfTemplates;
        }
        wfTemplates = WorkflowCatalog.filterTemplatesByHasTag(wfTemplates, (String[])filterGroup.hasTags.toArray(new String[filterGroup.hasTags.size()]), (boolean)true, (boolean)true);
        if (!filterGroup.doesNotContainsTags.isEmpty()) {
            wfTemplates = WorkflowCatalog.filterTemplatesByHasTag((List)wfTemplates, (String[])filterGroup.doesNotContainsTags.toArray(new String[filterGroup.doesNotContainsTags.size()]), (boolean)false, (boolean)false);
        }
        return wfTemplates;
    }

    protected List<WorkflowTemplate> applyPairEndFilter(List<WorkflowTemplate> wfTemplates) {
        String isPETag = "";
        isPETag = !this.isPairEnd ? "pair" : "single";
        wfTemplates = WorkflowCatalog.filterTemplatesByHasTag(wfTemplates, (String[])new String[]{isPETag}, (boolean)false, (boolean)true);
        return wfTemplates;
    }

    @Override
    public List<WorkflowTemplate> applyStaticFilters(List<WorkflowTemplate> wfTemplates) {
        wfTemplates = this.applyPairEndFilter(wfTemplates);
        return wfTemplates;
    }

    @Override
    public void clearSelectedFilters() {
        for (Button btn : this.selectedBtns) {
            btn.setSelection(false);
            btn.notifyListeners(13, new Event());
        }
    }

    @Override
    public String getMapper(WorkflowTemplate wf) {
        if (wf.getMetadata().hasTag("bwa")) {
            return "Bwa";
        }
        if (wf.getMetadata().hasTag("Bowtie2")) {
            return "Bowtie2";
        }
        if (wf.getMetadata().hasTag("STAR")) {
            return "STAR";
        }
        if (wf.getMetadata().hasTag("Tophat")) {
            return "Tophat2";
        }
        if (wf.getMetadata().hasTag("hisat2")) {
            return "Hisat2";
        }
        return "";
    }

    @Override
    public String getPreprecossingSteps(WorkflowTemplate wf) {
        Object pe_tags = "";
        if (wf.getMetadata().hasTag("CUTADAPT")) {
            pe_tags = (String)pe_tags + (((String)pe_tags).isEmpty() ? "" : " - ");
            pe_tags = (String)pe_tags + "CUTADAPT";
        }
        if (wf.getMetadata().hasTag("PRINSEQ")) {
            pe_tags = (String)pe_tags + (((String)pe_tags).isEmpty() ? "" : " - ");
            pe_tags = (String)pe_tags + "PRINSEQ";
        }
        if (wf.getMetadata().hasTag("trimmomatic")) {
            pe_tags = (String)pe_tags + (((String)pe_tags).isEmpty() ? "" : " - ");
            pe_tags = (String)pe_tags + "Trimmomatic";
        }
        return pe_tags;
    }

    @Override
    public String getReadLayout(WorkflowTemplate wf) {
        if (wf.getMetadata().hasTag("pairend")) {
            return "Pair-End";
        }
        if (wf.getMetadata().hasTag("singleend")) {
            return "Single-End";
        }
        return "---";
    }

    protected void notifyListner() {
        for (WorkflowSelectionViewfilters.FiltersValuesChangedListener listener : this.listeners) {
            listener.updateListener();
        }
    }

    @Override
    public void renderGUI(Composite upperPart) {
        Group filterGroup = new Group(upperPart, 2048);
        filterGroup.setText("Pipelines Filters");
        GridData layoutData = new GridData(4, 4, true, true, 2, 1);
        layoutData.minimumHeight = 200;
        filterGroup.setLayoutData((Object)layoutData);
        filterGroup.setLayout((Layout)new RowLayout(512));
        this.addCommonsFilters(filterGroup);
    }

    public class FiltersGroup {
        public HashSet<String> doesNotContainsTags = new HashSet();
        public HashSet<String> hasTags = new HashSet();
    }
}

