/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ext;

import com.biotechvana.workflow.ui.internal.SubmissionHistoryView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmissionHistoryUpdator {
    private static final Logger logger = LoggerFactory.getLogger(SubmissionHistoryUpdator.class);
    public static final int HISTORY_REFRESH_INTERVAL_MILLIS = 30000;
    Thread updateThread;
    int updateInterval = 30000;
    Boolean toRun = true;
    SubmissionHistoryView submissionHistoryView;

    public SubmissionHistoryUpdator(SubmissionHistoryView submissionHistoryView) {
        this.submissionHistoryView = submissionHistoryView;
        this.updateThread = this.init();
        this.updateThread.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread init() {
        Boolean bl = this.toRun;
        synchronized (bl) {
            this.toRun = true;
        }
        return new Thread(new Runnable(){

            @Override
            public void run() {
                while (SubmissionHistoryUpdator.this.toRun.booleanValue()) {
                    try {
                        logger.debug("Updating Submission History");
                        SubmissionHistoryUpdator.this.submissionHistoryView.updateSubmissionHistory();
                        logger.debug("Submission History Updated");
                    }
                    catch (Exception e) {
                        System.out.println("Someone wake me up !!");
                    }
                    try {
                        Thread.sleep(SubmissionHistoryUpdator.this.updateInterval);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.debug("Someone wake me up !! SubmissionHistoryUpdator");
                        if (!SubmissionHistoryUpdator.this.updateThread.isInterrupted()) continue;
                        System.out.println("Someone wake me up !!");
                    }
                }
                SubmissionHistoryUpdator.this.updateThread = null;
            }
        });
    }

    public void start() {
        if (this.updateThread == null) {
            this.updateThread = this.init();
        }
        if (this.updateThread.getState() == Thread.State.NEW) {
            this.updateThread.start();
        } else if (this.updateThread.getState() == Thread.State.TIMED_WAITING) {
            this.updateThread.interrupt();
        } else if (this.updateThread.getState() == Thread.State.WAITING) {
            this.updateThread.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Boolean bl = this.toRun;
        synchronized (bl) {
            this.toRun = false;
        }
    }

    public void pause() {
        try {
            this.updateThread.wait();
        }
        catch (InterruptedException e) {
            System.err.print("Can not pause SubmissionHistoryUpdator.");
            e.printStackTrace();
        }
    }
}

