/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.wizards.pages;

import com.biotechvana.utils.StringUtils;
import com.biotechvana.workflow.VariableCustomAction;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.configuration.IConfigurationWithInputFileList;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.variables.JobVariable;
import java.util.HashSet;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Label;

public class InputFilesJobCollector
extends WorkflowJob {
    public static final String INPUT_FASTQ_FILE = "INPUT_FILES";
    public static final String INPUT_LIBRARY_NAMES = "INPUT_LIBRARY_NAMES";
    IConfigurationWithInputFileList expConfig;
    Label infoLabel;
    public static final String OUTPUT_FILES = "OUTPUT_FILES";

    public InputFilesJobCollector(IConfigurationWithInputFileList expConfig, Label infoLabel, boolean withGTF) {
        this.expConfig = expConfig;
        this.infoLabel = infoLabel;
        this.jobName = "Input Files";
        this.jobDesc = new JobDescriptor("_input_files_");
        VariableDescriptor varFastaQ = VariableDescriptor.createDescriptorFor((String)INPUT_FASTQ_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFastaQ.isRequired = true;
        varFastaQ.setVariableName("Input FASTQ");
        varFastaQ.addAcceptedFileFormat("FASTQ", expConfig.isPairEnd(), false);
        this.jobDesc.addVariable(varFastaQ);
        VariableDescriptor outputVarLibraryName = VariableDescriptor.createDescriptorFor((String)INPUT_LIBRARY_NAMES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        outputVarLibraryName.setVariableName("Library Names");
        outputVarLibraryName.setHelpMsg("Library Names");
        outputVarLibraryName.addCustomAction(new VariableCustomAction("Generate Names", VariableCustomAction.Button, new VariableCustomAction.CustomActionCallback(){

            public void call(JobVariable var) {
                InputFilesJobCollector.this.generateNames();
            }
        }));
        outputVarLibraryName.addCustomAction(new VariableCustomAction("Remove Common Suffix", VariableCustomAction.Button, new VariableCustomAction.CustomActionCallback(){

            public void call(JobVariable var) {
                InputFilesJobCollector.this.removeCommonSuffix();
            }
        }));
        outputVarLibraryName.addCustomAction(new VariableCustomAction("Remove Common Prefix", VariableCustomAction.Button, new VariableCustomAction.CustomActionCallback(){

            public void call(JobVariable var) {
                InputFilesJobCollector.this.removeCommonPrefix();
            }
        }));
        this.jobDesc.addVariable(outputVarLibraryName);
        this.initJobFromDesc(this.jobDesc, false, false, false);
    }

    public boolean notifyVarValueChanged(String varKey, String value) {
        String[] names;
        if ((INPUT_FASTQ_FILE.equals(varKey) || INPUT_LIBRARY_NAMES.equals(varKey)) && !this.validateEqualNumberOfFiles(INPUT_FASTQ_FILE, INPUT_LIBRARY_NAMES)) {
            this.getVariable(INPUT_LIBRARY_NAMES).setExternalErrMsg("Library Names does not match number of input files.");
        }
        if (INPUT_LIBRARY_NAMES.equals(varKey) && (names = InputFilesJobCollector.getList((String)this.getValue(INPUT_LIBRARY_NAMES))).length != 0) {
            HashSet<String> strSet = new HashSet<String>();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                strSet.add(n3);
                ++n2;
            }
            if (strSet.size() != names.length) {
                this.getVariable(INPUT_LIBRARY_NAMES).setExternalErrMsg("Library Names must be unique.");
            }
        }
        return true;
    }

    public String notifyVarValueChanging(String varKey, String value) {
        return value;
    }

    public boolean isValid() {
        boolean valid = super.isValid();
        valid &= this.validateEqualNumberOfFiles(INPUT_FASTQ_FILE, INPUT_LIBRARY_NAMES);
        return valid &= this.validateNoDuplicates(INPUT_LIBRARY_NAMES);
    }

    void generateNames() {
        String[][] filesValue = InputFilesJobCollector.getPairList(this.getValue(INPUT_FASTQ_FILE));
        if (filesValue.length == 0) {
            return;
        }
        String[] names = null;
        names = this.expConfig.isPairEnd() ? InputFilesJobCollector.generateNames(filesValue[0], filesValue[1]) : InputFilesJobCollector.generateNames(filesValue[0]);
        this.setValue(INPUT_LIBRARY_NAMES, StringUtils.join((String[])names, (String)"\n"));
    }

    static String[] generateNames(String[] f1) {
        Assert.isNotNull((Object)f1);
        String[] names = new String[f1.length];
        int i = 0;
        while (i < f1.length) {
            String f1Name;
            names[i] = f1Name = FilenameUtils.getBaseName((String)f1[i]);
            ++i;
        }
        return names;
    }

    static String[] generateNames(String[] f1, String[] f2) {
        Assert.isNotNull((Object)f1);
        Assert.isNotNull((Object)f2);
        Assert.isTrue((f1.length == f2.length ? 1 : 0) != 0, (String)"generateNames: the given two array have different size");
        int i = 0;
        while (i < f1.length) {
            f1[i] = FilenameUtils.getBaseName((String)f1[i]);
            f2[i] = FilenameUtils.getBaseName((String)f2[i]);
            ++i;
        }
        String[] names = new String[f1.length];
        String f1Prefix = StringUtils.longestCommonPrefix((String[])f1);
        String f2Prefix = StringUtils.longestCommonPrefix((String[])f2);
        String f1Suffix = StringUtils.longestCommonSuffix((String[])f1);
        String f2Suffix = StringUtils.longestCommonSuffix((String[])f2);
        String suffix = StringUtils.longestCommonSuffix((String[])new String[]{f1Suffix, f2Suffix});
        int suffixLen = suffix.length();
        int i2 = 0;
        while (i2 < f1.length) {
            Object commonName;
            String f1Name = f1[i2];
            String f2Name = f2[i2];
            if (f1Name.length() > suffixLen) {
                f1Name = f1Name.substring(0, f1Name.length() - suffixLen);
            }
            if (f2Name.length() > suffixLen) {
                f2Name = f2Name.substring(0, f2Name.length() - suffixLen);
            }
            if (((String)(commonName = StringUtils.longestCommonSubStr((String)f1Name, (String)f2Name))).isEmpty()) {
                commonName = f1Name + "_" + f2Name;
            }
            names[i2] = commonName;
            ++i2;
        }
        suffix = StringUtils.longestCommonSuffix((String[])names);
        if (!suffix.isEmpty()) {
            int lastIndex = suffix.lastIndexOf(".");
            int index = suffix.lastIndexOf("-");
            if (index > lastIndex) {
                lastIndex = index;
            }
            if ((index = suffix.lastIndexOf("_")) > lastIndex) {
                lastIndex = index;
            }
            if (lastIndex != -1) {
                int suffixToRemoveLen = suffix.length() - lastIndex;
                int i3 = 0;
                while (i3 < names.length) {
                    names[i3] = names[i3].substring(0, names[i3].length() - suffixToRemoveLen);
                    ++i3;
                }
            }
        }
        return names;
    }

    protected void removeCommonSuffix() {
        String[] names = InputFilesJobCollector.getList((String)this.getValue(INPUT_LIBRARY_NAMES));
        String suffix = StringUtils.longestCommonSuffix((String[])names);
        if (!suffix.isEmpty()) {
            int lastIndex = suffix.lastIndexOf(".");
            int index = suffix.lastIndexOf("-");
            if (index > lastIndex) {
                lastIndex = index;
            }
            if ((index = suffix.lastIndexOf("_")) > lastIndex) {
                lastIndex = index;
            }
            int suffixToRemoveLen = suffix.length();
            if (lastIndex != -1) {
                suffixToRemoveLen = suffix.length() - lastIndex;
            }
            int i = 0;
            while (i < names.length) {
                names[i] = names[i].substring(0, names[i].length() - suffixToRemoveLen);
                ++i;
            }
        }
        this.setValue(INPUT_LIBRARY_NAMES, StringUtils.join((String[])names, (String)"\n"));
    }

    protected void removeCommonPrefix() {
        String[] names = InputFilesJobCollector.getList((String)this.getValue(INPUT_LIBRARY_NAMES));
        String prefix = StringUtils.longestCommonPrefix((String[])names);
        if (!prefix.isEmpty()) {
            int i = 0;
            while (i < names.length) {
                names[i] = names[i].substring(prefix.length());
                ++i;
            }
        }
        this.setValue(INPUT_LIBRARY_NAMES, StringUtils.join((String[])names, (String)"\n"));
    }

    public static String[][] getPairList(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return new String[0][0];
        }
        String[] lines = value.split("\n");
        String[][] finalList = new String[2][lines.length];
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if (!line.isEmpty()) {
                String[] pairedFiles = line.split(",");
                if (pairedFiles.length == 2) {
                    finalList[0][i] = pairedFiles[0].trim();
                    finalList[1][i] = pairedFiles[1].trim();
                } else if (line.startsWith(",")) {
                    finalList[1][i] = pairedFiles[0].trim();
                } else {
                    finalList[0][i] = pairedFiles[0].trim();
                }
            }
            ++i;
        }
        return finalList;
    }

    public static void main(String[] argv) {
        String[] f1 = new String[]{"1NCELL_R1.large_intersect.fastq", "2NCELL_R1.large_intersect.fastq", "3NCELL_R1.large_intersect.fastq", "1TCELL_R1.large_intersect.fastq", "2TCELL_R1.large_intersect.fastq", "3TCELL_R1.large_intersect.fastq"};
        String[] f2 = new String[]{"1NCELL_R2.large_intersect.fastq", "2NCELL_R2.large_intersect.fastq", "3NCELL_R2.large_intersect.fastq", "1TCELL_R2.large_intersect.fastq", "2TCELL_R2.large_intersect.fastq", "3TCELL_R2.large_intersect.fastq"};
        System.out.println(StringUtils.join((String[])InputFilesJobCollector.generateNames(f1, f2), (String)"\n"));
    }

    public String[] getDefaulLibraryNames() {
        String[][] filesValue = InputFilesJobCollector.getPairList(this.getValue(INPUT_FASTQ_FILE));
        String[] names = null;
        names = this.expConfig.isPairEnd() ? InputFilesJobCollector.generateNames(filesValue[0], filesValue[1]) : InputFilesJobCollector.generateNames(filesValue[0]);
        return names;
    }
}

