/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.views;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.variables.JobVariable;
import com.biotechvana.workflow.variables.ListJobVariable;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class VariableHelpViewer {
    Composite helpFromComposite;
    Composite helpFormCompositeBody = null;
    ScrolledComposite scrolledComposite_HelpForm = null;
    SashForm container;
    int[] weightsMainToHelp = new int[]{3, 1};
    private boolean helpIsVisable = false;
    CTabFolder tabFolder;
    String helpCurrentVarKey = "";
    int LabelPropertyNameWidth = 150;
    Font boldFont;

    public VariableHelpViewer(SashForm container) {
        this.container = container;
    }

    public void close() {
        if (this.helpFromComposite != null) {
            this.weightsMainToHelp = this.container.getWeights();
            this.helpFromComposite.dispose();
            this.helpFormCompositeBody = null;
            this.helpFromComposite = null;
            this.scrolledComposite_HelpForm = null;
            this.helpIsVisable = false;
            this.container.setWeights(new int[]{1});
            this.helpCurrentVarKey = "";
        }
    }

    public boolean isVisable() {
        return this.helpIsVisable;
    }

    public void show() {
        if (!this.helpIsVisable) {
            this.helpFromComposite = new Composite((Composite)this.container, 2048);
            this.helpFromComposite.setLayout((Layout)new GridLayout(1, false));
            this.tabFolder = new CTabFolder(this.helpFromComposite, 2048);
            this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
            this.tabFolder.setTabHeight(30);
            CTabItem tbtmNewItem = new CTabItem(this.tabFolder, 0);
            tbtmNewItem.setShowClose(true);
            tbtmNewItem.setText("Help");
            tbtmNewItem.setImage(SharedImages.HELP);
            this.tabFolder.setSelection(tbtmNewItem);
            this.scrolledComposite_HelpForm = new ScrolledComposite((Composite)this.tabFolder, 768);
            tbtmNewItem.setControl((Control)this.scrolledComposite_HelpForm);
            this.scrolledComposite_HelpForm.setExpandHorizontal(true);
            this.scrolledComposite_HelpForm.setExpandVertical(true);
            this.helpFormCompositeBody = new Composite((Composite)this.scrolledComposite_HelpForm, 2048);
            this.helpFormCompositeBody.setLayout((Layout)new GridLayout(3, false));
            this.scrolledComposite_HelpForm.setContent((Control)this.helpFormCompositeBody);
            this.tabFolder.addCTabFolder2Listener(new CTabFolder2Listener(){

                public void showList(CTabFolderEvent event) {
                }

                public void restore(CTabFolderEvent event) {
                }

                public void minimize(CTabFolderEvent event) {
                }

                public void maximize(CTabFolderEvent event) {
                }

                public void close(CTabFolderEvent event) {
                    VariableHelpViewer.this.close();
                }
            });
            this.helpIsVisable = true;
            this.container.setWeights(this.weightsMainToHelp);
            VariableHelpViewer.applyDialogFont((Control)this.helpFromComposite, this.tabFolder.getFont());
        } else {
            this.clear();
        }
    }

    private static void applyDialogFont(Control control, Font dialogFont) {
        control.setFont(dialogFont);
        if (control instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                VariableHelpViewer.applyDialogFont(element, dialogFont);
                ++n2;
            }
        }
    }

    private void clear() {
        if (this.helpFormCompositeBody != null) {
            Control[] controlArray = this.helpFormCompositeBody.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
        }
    }

    public void showHelp(JobVariable var) {
        if (this.helpCurrentVarKey.equals(var.getKey())) {
            this.close();
        } else {
            this.helpCurrentVarKey = var.getKey();
            this.show();
            this.buildHelpForm(var);
            VariableHelpViewer.applyDialogFont((Control)this.helpFromComposite, this.tabFolder.getFont());
        }
    }

    private void buildHelpForm(final JobVariable var) {
        this.helpRow("Variable/Parameter", var.getDescFriendlyName());
        if (var.getDescHelpMsg() != null && !var.getDescHelpMsg().isEmpty()) {
            this.helpRow("Description", var.getDescHelpMsg());
        }
        if (!var.getDescCommandParamater().isEmpty()) {
            Object cmdSwtich = var.getDescCommandParamater();
            if (!var.getDescCommandParamaterAlt().isEmpty()) {
                cmdSwtich = (String)cmdSwtich + "/" + var.getDescCommandParamaterAlt();
            }
            this.helpRow("Parameter", (String)cmdSwtich);
        }
        if (!var.getDescBlankDefaultValue().isEmpty()) {
            this.helpRow("Default", var.getDescBlankDefaultValue());
        }
        if (var.getDescVarType() == VariableDescriptor.VariableType.SelectionList || var.getDescVarType() == VariableDescriptor.VariableType.MultiSelectionList) {
            String[] helpMsgs = ((ListJobVariable)var).getDescHelpAvlOptions();
            String title = "Available Options";
            this.helpRow(title, "", "");
            if (helpMsgs != null) {
                String[] stringArray = helpMsgs;
                int n = helpMsgs.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    this.helpRow("", line, "*");
                    title = "";
                    ++n2;
                }
            }
        }
        if (var.getHasSampleResources()) {
            Label propertyNameLabel = new Label(this.helpFormCompositeBody, 1);
            GridData layoutData = new GridData(4, 1, false, false);
            layoutData.widthHint = this.LabelPropertyNameWidth;
            propertyNameLabel.setText("Resources");
            propertyNameLabel.setLayoutData((Object)layoutData);
            if (this.boldFont == null) {
                FontData fontdata = propertyNameLabel.getFont().getFontData()[0];
                fontdata.setStyle(1);
                this.boldFont = new Font((Device)this.container.getDisplay(), fontdata);
            }
            propertyNameLabel.setFont(this.boldFont);
            propertyNameLabel.setForeground(this.container.getDisplay().getSystemColor(2));
            propertyNameLabel = new Label(this.helpFormCompositeBody, 1);
            layoutData = new GridData(4, 1, false, false);
            layoutData.widthHint = 7;
            propertyNameLabel.setText(":");
            propertyNameLabel.setLayoutData((Object)layoutData);
            propertyNameLabel.setFont(this.boldFont);
            Link link = new Link(this.helpFormCompositeBody, 64);
            layoutData = new GridData(4, 1, true, false);
            link.setLayoutData((Object)layoutData);
            Object linkText = "";
            for (String sample : var.getSampleResources()) {
                String sampleDisplayName = var.getSampleResourcesName(sample);
                linkText = (String)linkText + "<a href=\"" + sample + "\">" + sampleDisplayName + "</a>, ";
            }
            link.setText(((String)linkText).substring(0, ((String)linkText).length() - 2));
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String filename = e.text.substring(e.text.lastIndexOf(47) + 1);
                    VariableHelpViewer.this.exportResources(var.getJob(), filename);
                }
            });
        }
        this.helpFormCompositeBody.layout(true);
        Point newSize = this.helpFormCompositeBody.computeSize(this.helpFormCompositeBody.getSize().x, -1, true);
        this.scrolledComposite_HelpForm.setMinHeight(newSize.y);
    }

    public void exportResources(WorkflowJob workflowJob, String filename) {
    }

    private void helpRow(String propertyName, String propertyValue) {
        this.helpRow(propertyName, propertyValue, ":");
    }

    private void helpRow(String propertyName, String propertyValue, String sep) {
        Label propertyNameLabel = new Label(this.helpFormCompositeBody, 1);
        GridData layoutData = new GridData(4, 1, false, false);
        layoutData.widthHint = this.LabelPropertyNameWidth;
        propertyNameLabel.setText(propertyName);
        propertyNameLabel.setLayoutData((Object)layoutData);
        if (this.boldFont == null) {
            FontData fontdata = propertyNameLabel.getFont().getFontData()[0];
            fontdata.setStyle(1);
            this.boldFont = new Font((Device)this.container.getDisplay(), fontdata);
        }
        propertyNameLabel.setFont(this.boldFont);
        propertyNameLabel.setForeground(this.container.getDisplay().getSystemColor(2));
        propertyNameLabel = new Label(this.helpFormCompositeBody, 1);
        layoutData = new GridData(4, 1, false, false);
        layoutData.widthHint = 7;
        propertyNameLabel.setText(sep);
        propertyNameLabel.setLayoutData((Object)layoutData);
        propertyNameLabel.setFont(this.boldFont);
        Label propertyNameValue = new Label(this.helpFormCompositeBody, 64);
        layoutData = new GridData(4, 1, true, false);
        propertyNameValue.setText(propertyValue);
        propertyNameValue.setLayoutData((Object)layoutData);
    }
}

