/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.menus;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.workflow.ui.menus.JobsToolBoxItem;
import com.biotechvana.workflow.ui.menus.JobsToolBoxJobItemTool;
import com.biotechvana.workflow.ui.menus.JobsToolBoxPipelineItemTool;
import java.util.ArrayList;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class JobsToolBoxItemList
extends JobsToolBoxItem {
    private ArrayList<JobsToolBoxItem> items = new ArrayList();

    public JobsToolBoxItemList(String name) {
        super(name);
    }

    public void addItem(JobsToolBoxItem item) {
        this.items.add(item);
    }

    @Override
    public void renderAsMenuItem(MenuManager menuItem) {
        for (JobsToolBoxItem item : this.items) {
            if (item instanceof JobsToolBoxItemList) {
                MenuManager subMenuItem = new MenuManager(item.getName());
                menuItem.add((IContributionItem)subMenuItem);
                item.renderAsMenuItem(subMenuItem);
                continue;
            }
            item.renderAsMenuItem(menuItem);
        }
    }

    @Override
    public void renderAsToolBarItems(Menu menu, SelectionAdapter menuClick) {
        for (JobsToolBoxItem item : this.items) {
            if (item instanceof JobsToolBoxItemList) {
                MenuItem subMenuItem = new MenuItem(menu, 64);
                subMenuItem.setText(item.getName());
                Menu subMenu = new Menu(menu);
                subMenuItem.setMenu(subMenu);
                item.renderAsToolBarItems(subMenu, menuClick);
                continue;
            }
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setText(item.getName());
            menuItem.setData((Object)item);
            menuItem.addSelectionListener((SelectionListener)menuClick);
            if (item instanceof JobsToolBoxJobItemTool) {
                menuItem.setImage(SharedImages.PROCESS);
            }
            if (!(item instanceof JobsToolBoxPipelineItemTool)) continue;
            menuItem.setImage(SharedImages.WORKFLOW);
        }
    }

    public void addItems(ArrayList<JobsToolBoxItem> items2) {
        this.items.addAll(items2);
    }
}

