/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.internal;

import com.biotechvana.workflow.Workflow;
import com.biotechvana.workflow.configuration.IPipelineConfiguration;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.views.WorkflowTabsComposite;
import com.biotechvana.workflow.wizards.WorkflowWizard;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class WorkflowView {
    @Inject
    IPipelineConfiguration basicConfig;
    @Inject
    @Optional
    WorkflowWizard workflowConfigWizard;
    private FormToolkit toolkit;
    @Inject
    IWorkflowManager workflowManager;

    @PostConstruct
    public void init() {
    }

    @PostConstruct
    public void createPartControl(Composite parent, IEclipseContext cntx) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        Workflow sampleflow = this.basicConfig.getWorkflow();
        parent.setLayout((Layout)new GridLayout(1, false));
        final WorkflowTabsComposite flowComposite = new WorkflowTabsComposite(this.workflowManager, this.basicConfig, cntx, parent, 2048);
        flowComposite.setLayoutData(new GridData(4, 4, true, true));
        Button runButton = new Button(parent, 0);
        runButton.setText("Run Workflow");
        runButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        runButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                flowComposite.runPipeline();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void setFocus() {
    }

    @PreDestroy
    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
    }
}

