/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.handlers;

import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.workflow.configuration.IPipelineConfiguration;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.ui.ConfigurationWizardDialog;
import com.biotechvana.workflow.wizards.BasicWorkflowWizard;
import com.biotechvana.workflow.wizards.WorkflowWizard;
import jakarta.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Shell;

public class ShowWorkflowViewHandler {
    @Execute
    public void execute(EPartService partService, IEclipseContext cntx, IWorkflowManager workflowManager, @Named(value="workflow_id") String templateID, @Named(value="activeShell") Shell shell) {
        IPipelineConfiguration worflowConfig = workflowManager.getWorkflowConfigurator(templateID);
        IEclipseContext workflowViewContext = EclipseContextFactory.create((String)"com.biotechvana.workflow.ui.WorkflowView");
        workflowViewContext.set(IPipelineConfiguration.class, (Object)worflowConfig);
        workflowViewContext.setParent(cntx);
        Class<BasicWorkflowWizard> WorkflowWizardClazz = workflowManager.getWorkflowConfiguratorWizardClass(worflowConfig.getClass());
        if (WorkflowWizardClazz == null) {
            WorkflowWizardClazz = BasicWorkflowWizard.class;
        }
        IEclipseContext workflowWizardContext = EclipseContextFactory.create((String)WorkflowWizard.class.getName());
        workflowWizardContext.setParent(workflowViewContext);
        IFTPManager wizardIFTPManager = (IFTPManager)ContextInjectionFactory.make(IFTPManager.class, (IEclipseContext)workflowWizardContext);
        workflowWizardContext.set(IFTPManager.class, (Object)wizardIFTPManager);
        WorkflowWizard workflowWizard = (WorkflowWizard)((Object)ContextInjectionFactory.make(WorkflowWizardClazz, (IEclipseContext)workflowWizardContext));
        workflowViewContext.set(WorkflowWizard.class, (Object)workflowWizard);
        if (workflowWizard != null) {
            ConfigurationWizardDialog wizardDialog = new ConfigurationWizardDialog(shell, workflowWizard);
            wizardDialog.setPageSize(1000, 400);
            if (wizardDialog.open() == 0) {
                workflowWizardContext.dispose();
                MPart part = partService.createPart("com.biotechvana.workflow.ui.WorkflowView");
                part.setContext(workflowViewContext);
                part.setLabel(worflowConfig.getPojectName());
                partService.showPart(part, EPartService.PartState.ACTIVATE);
            } else {
                workflowWizardContext.dispose();
                System.out.println("Cancel pressed");
            }
        }
    }

    public static boolean reConfigure(IPipelineConfiguration worflowConfig, IWorkflowManager workflowManager, IEclipseContext newContext, Shell shell) {
        Class WorkflowWizardClazz = workflowManager.getWorkflowConfiguratorWizardClass(worflowConfig.getClass());
        WorkflowWizard workflowWizard = (WorkflowWizard)((Object)ContextInjectionFactory.make((Class)WorkflowWizardClazz, (IEclipseContext)newContext));
        if (workflowWizard != null) {
            ConfigurationWizardDialog wizardDialog = new ConfigurationWizardDialog(shell, workflowWizard);
            wizardDialog.setPageSize(1000, 400);
            return wizardDialog.open() == 0;
        }
        return false;
    }
}

