/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.groups.ui;

import com.biotechvana.workflow.groups.ExperimentGroup;
import com.biotechvana.workflow.groups.GroupAssignment;
import com.biotechvana.workflow.groups.ui.GroupAssignmentControl;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;

public final class GroupClmEditingSupport
extends EditingSupport {
    private ComboBoxViewerCellEditor cellEditor = null;
    GroupAssignmentControl groupAssignmentControl;
    TableViewer tablerViewer;

    GroupClmEditingSupport(GroupAssignmentControl groupAssignmentControl, ColumnViewer viewer) {
        super(viewer);
        this.tablerViewer = groupAssignmentControl.getTableViewer();
        this.groupAssignmentControl = groupAssignmentControl;
        this.cellEditor = new ComboBoxViewerCellEditor((Composite)this.getViewer().getControl(), 8);
        this.cellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.cellEditor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        this.updateGroups();
    }

    public void updateGroups() {
        this.cellEditor.setInput(this.groupAssignmentControl.getGroups());
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (element instanceof GroupAssignment) {
            GroupAssignment data = (GroupAssignment)element;
            if (data.getExperimentGroup() == null) {
                return "No Assignment";
            }
            return data.getExperimentGroup();
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        boolean notifyChanged = false;
        if (element instanceof GroupAssignment) {
            GroupAssignment data = (GroupAssignment)element;
            if (value instanceof ExperimentGroup) {
                ExperimentGroup newValue = (ExperimentGroup)value;
                if (newValue != data.getExperimentGroup()) {
                    notifyChanged = true;
                }
                data.setExperimentGroup(newValue);
            }
        }
        if (notifyChanged) {
            this.groupAssignmentControl.notifyChange();
            this.tablerViewer.update(element, null);
        }
    }
}

