/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.postprocessing.samtools;

import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class SAMToolsMergeJob
extends ISWFJob {
    public static final String JOB_ID = "samtools_merge";
    public static final String JOB_NAME = "Samtools : Merge";
    public static final String INPUT_BAM_FILES = "INPUT_FILES";
    public static final String INPUT_SAMPLE_NAME = "INPUT_SAMPLE_NAME";
    public static final String OUTPUT_BAM_FILE = "OUTPUT_BAM_FILE";

    public SAMToolsMergeJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc("Merge multiple sorted alignment files, producing a single sorted output file that contains all the input records and maintains the existing sort order.");
    }

    protected void createInputs() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)INPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input Alignment Files");
        varReadInputFile.setHelpMsg("Input Bam Files to merge.");
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor inputVar = VariableDescriptor.createDescriptorFor((String)INPUT_SAMPLE_NAME, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        inputVar.setVariableName("Output Merged File Name");
        inputVar.setIsFileName(true);
        inputVar.isRequired = true;
        inputVar.setDefaultValue("merged");
        this.jobDesc.addVariable(inputVar);
    }

    protected void createOutputs() {
        VariableDescriptor bamOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_BAM_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        bamOutputFile.isRequired = true;
        bamOutputFile.setVariableName("Merged Bam File");
        bamOutputFile.setHelpMsg("Merged Bam File");
        this.jobDesc.addVariable(bamOutputFile);
    }

    protected void createOptions() {
        VariableDescriptor optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Use zlib compression level 1 to compress the output.");
        optionVar.setHelpMsg("Use zlib compression level 1 to compress the output.");
        optionVar.setCommandParamater("-1");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Force to overwrite the output file if present.");
        optionVar.setHelpMsg("Force to overwrite the output file if present.");
        optionVar.setCommandParamater("-f");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Optional Sam file to copy the header from.");
        optionVar.setHelpMsg(" Use the lines of the file as @ headers to be copied to out.bam, replacing any header lines that would otherwise be copied from the first input bam file.");
        optionVar.setCommandParamater("-h");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("The input alignments are sorted by read names rather than by chromosomal coordinates");
        optionVar.setHelpMsg("The input alignments are sorted by read names rather than by chromosomal coordinates");
        optionVar.setCommandParamater("-n");
        this.jobDesc.addVariable(optionVar);
        optionVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionVar.setVariableName("Attach an RG tag to each alignment. The tag value is inferred from file names.");
        optionVar.setHelpMsg("Attach an RG tag to each alignment. The tag value is inferred from file names.");
        optionVar.setCommandParamater("-r");
        this.jobDesc.addVariable(optionVar);
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefix = "samtools merge ";
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(INPUT_BAM_FILES);
        FileVariable outputBamFilesVar = (FileVariable)this.getVariable(OUTPUT_BAM_FILE);
        builder.append(SAMToolsMergeJob.st((String)"_ext=\"bam\""));
        String mergeBamsInputStr = "mergeBamIn";
        builder.append(SAMToolsMergeJob.st((String)BashHelper.assign((String)"sampleName", (String)this.getVariable(INPUT_SAMPLE_NAME).$())));
        builder.append(SAMToolsMergeJob.st((String)BashHelper.assign((String)mergeBamsInputStr, (String)"")));
        builder.append(SAMToolsMergeJob.st((String)BashHelper.assign((JobVariable)outputBamFilesVar, (String)(String.valueOf(this.getVariable(INPUT_SAMPLE_NAME).$()) + ".bam "))));
        builder.append(BashHelper.Batcher_noLog((FilesVariable)inputBamFilesVar, (String)SAMToolsMergeJob.st((String)BashHelper.strAppend((String)mergeBamsInputStr, (String)"  ${_inputFile}")), (boolean)true));
        builder.append(BashHelper.command_withTrack((String)BashHelper.$((String)mergeBamsInputStr), (String)(String.valueOf(cmdPrefix) + this.getOptionParamatersStrAs$() + this.getVariable(INPUT_SAMPLE_NAME).$() + ".bam " + SAMToolsMergeJob.$((String)mergeBamsInputStr)), (String)"Samtools Merge"));
    }
}

