/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.mapping;

import com.biotechvana.utils.Constants;
import com.biotechvana.utils.FilenameUtils;
import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.VariablesRule;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class MappingTophatJob2
extends WorkflowJob {
    public static final String JOB_ID = "Tophat";
    public static final String JOB_NAME = "Tophat";
    public static final String INPUT_INDEX_CHOICE = "INPUT_INDEX_CHOICE";
    public static final String INPUT_INDEX_FASTA_FILE = "INDEX_FASTA_FILE";
    public static final String INPUT_INDEX_PREFIX = "INPUT_INDEX_PREFIX";
    public static final String INPUT_INDEX_FILE = "INPUT_INDEX_FILE";
    public static final String INPUT_READS_TYPE = "INPUT_READS_TYPE";
    public static final String INPUT_FASTQ_FILE = "INPUT_FILES";
    public static final String INPUT_MAPPING_ORIENTATION = "INPUT_MAPPING_ORIENTATION";
    public static final String INPUT_STD_INNER_DISTANCE = "INPUT_MAPPING_MIN_INSERT";
    public static final String INPUT_REPORT_DISCORDANT_PAIR = "INPUT_REPORT_DISCORDANT_PAIR";
    public static final String INPUT_MEAN_INNER_DISTANCE = "INPUT_MAPPING_INSERT_SIZE";
    private static final String OPTION_MAX_REALIGN_EDIT_DISTANCE = "MAX_REALIGN_EDIT_DISTANCE";
    private static final String OPTION_MAX_EDIT_DISTANCE = "MAX_EDIT_DISTANCE";
    private static final String OPTION_LIBRARY_TYPE = "LIBRARY_TYPE";
    private static final String OPTION_FINAL_READ_MISMATCHES = "FINAL_READ_MISMATCHES";
    private static final String OPTION_USE_BOWTIE_N_MODE = "USE_BOWTIE_N_MODE";
    private static final String OPTION_MIN_ANCHOR_LENGTH = "MIN_ANCHOR_LENGTH";
    private static final String OPTION_SPLICE_MISMATCHES = "SPLICE_MISMATCHES";
    private static final String OPTION_MAXIMUM_INTRON_LENGTH = "MAXIMUM_INTRON_LENGTH";
    private static final String OPTION_MAX_INSERTION_LENGTH = "MAX_INSERTION_LENGTH";
    private static final String OPTION_MAX_DELETION_LENGTH = "MAX_DELETION_LENGTH";
    private static final String OPTION_MAXIMUM_NUMBER_OF_ALIGNMENTS = "MAXIMUM_NUMBER_OF_ALIGNMENTS";
    private static final String OPTION_MIN_SEGMENT_INTRON = "MIN_SEGMENT_INTRON";
    private static final String OPTION_MAX_SEGMENT_INTRON = "MAX_SEGMENT_INTRON";
    private static final String OPTION_SEGMENT_MISMATCHES = "SEGMENT_MISMATCHES";
    private static final String OPTION_SEGMENT_LENGTH = "SEGMENT_LENGTH";
    private static final String OPTION_USE_MICROEXON_SEARCH = "USE_MICROEXON_SEARCH";
    public static final String OUTPUT_ACCEPTED_HITS = "OUTPUT_FILES";
    public static final String OUTPUT_JUNCTION_FILE = "OUTPUT_JUNCTION_FILE";
    public static final String OUTPUT_INSERTION_FILE = "OUTPUT_INSERTION_FILE";
    public static final String OUTPUT_DELETION_FILE = "OUTPUT_DELETION_FILE";
    private static final String OUTPUT_REF_INDEX = "OUTPUT_REF_INDEX";
    private static final String GROUP_TRANSCRIPTOME = "Reference Transcriptome";
    private static final String GROUP_GENERAL = "General";
    public static final String OPTION_RM_FILTER = "OPTION_RM";
    public static final String OUTPUT_LIBRARY_NAMES = "OUTPUT_LIBRARY_NAMES";
    private static final String OPTION_BUILD_NEW_TRANS = "OPTION_BUILD_NEW_TRANS";
    private static final String OPTION_REF_NEW_TRANS = "OPTION_REF_NEW_TRANS";
    private static final String OPTION_FODLER_NEW_TRANS = "OPTION_FODLER_NEW_TRANS";
    private static final String OPTION_TRANS_INDEX = "OPTION_TRANS_INDEX";
    private static final String OPTION_PREFIX_NEW_TRANS = "OPTION_PREFIX_NEW_TRANS";
    private static final String OPTION_NEW_TRANS_SAME_REF = "OPTION_NEW_TRANS_SAME_REF";

    public MappingTophatJob2() {
        this.jobName = "Tophat";
        this.jobDesc = new JobDescriptor("Tophat");
        this.jobDesc.setDesc("TopHat is a program that aligns RNA-Seq reads to a genome in order to identify exon-exon splice junctions.");
        this.jobDesc.setRef("Trapnell C, Roberts A, Goff L, et al. 2012. Differential gene and transcript expression analysis of RNA-seq experiments with TopHat and Cufflinks. NatProtoc 7: 562-578.<a href=\"http://doi.org/10.1038/nprot.2012.016\">doi:10.1038/nprot.2012.016</a>");
        VariableDescriptor varIndexChioce = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_CHOICE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexChioce.isRequired = true;
        varIndexChioce.setVariableName("Create new index");
        varIndexChioce.setHelpMsg("Use an existing index or create new one from a Fasta File");
        varIndexChioce.setDefaultValue("false");
        this.jobDesc.addVariable(varIndexChioce);
        VariableDescriptor varUsedIndexFile = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varUsedIndexFile.isRequired = true;
        varUsedIndexFile.setVariableName("Index File");
        varUsedIndexFile.setShortHelpMsg("Drag an Existing index .bt2 or .bt2l extensions");
        varUsedIndexFile.setHelpMsg("Bowtie2 Index files end with bt2 or bt2l extensions and are build by bowtie2-build program.");
        this.jobDesc.addVariable(varUsedIndexFile);
        VariableDescriptor varIndexFile = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_FASTA_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexFile.isRequired = true;
        varIndexFile.setVariableName("Input Ref Fasta File");
        varIndexFile.setHelpMsg("Reference Fasta file to build a new index.");
        varIndexFile.setShortHelpMsg("Drag a Fasta file to build a new index.");
        this.jobDesc.addVariable(varIndexFile);
        VariableDescriptor varIndexFilePrefix = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_PREFIX, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexFilePrefix.setVariableName("Prefix");
        varIndexFilePrefix.setIsFileName(true);
        varIndexFilePrefix.setHelpMsg("A prefix name for the output index file. Defualt same as the prefix of the input Fasta File Name.");
        this.jobDesc.addVariable(varIndexFilePrefix);
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)INPUT_FASTQ_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input File");
        varReadInputFile.addAcceptedFileFormat("FASTQ", true, true);
        varReadInputFile.setHelpMsg("Input Fastq files to map.");
        varReadInputFile.setIsTracked(true);
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor varMeanInnerDistance = VariableDescriptor.createDescriptorFor((String)INPUT_MEAN_INNER_DISTANCE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varMeanInnerDistance.setVariableName("Mean Inner Distance between Mate Pairs");
        varMeanInnerDistance.setHelpMsg("This is the expected (mean) inner distance between mate pairs.For, example, for paired end runs with fragments selected at 300bp, where each end is 50bp, you should set the mean value to be 200. The default is 50bp.");
        varMeanInnerDistance.setCommandParamater("--mate-inner-dist");
        this.jobDesc.addVariable(varMeanInnerDistance);
        VariableDescriptor varStdInnerDistance = VariableDescriptor.createDescriptorFor((String)INPUT_STD_INNER_DISTANCE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varStdInnerDistance.setVariableName("Std. Dev for Distance between Mate Pairs");
        varStdInnerDistance.setHelpMsg("The standard deviation for the distribution on inner distances between mate pairs.");
        varStdInnerDistance.setCommandParamater("--mate-std-dev");
        this.jobDesc.addVariable(varStdInnerDistance);
        VariableDescriptor varReportDiscordantPair = VariableDescriptor.createDescriptorFor((String)INPUT_REPORT_DISCORDANT_PAIR, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReportDiscordantPair.setVariableName("Report only concordant mappings.");
        varReportDiscordantPair.setCommandParamater("--no-discordant");
        this.jobDesc.addVariable(varReportDiscordantPair);
        SelectionListVariableDescriptor varShortReadsType = VariableDescriptor.SelectionList((String)INPUT_READS_TYPE, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varShortReadsType.isRequired = true;
        varShortReadsType.addOptionValue("Single-end");
        varShortReadsType.addOptionValue("Paired-end");
        varShortReadsType.setVariableName("Reads Input Type");
        varShortReadsType.setDefaultIndexValue(0);
        varShortReadsType.setGUIVisible(false);
        this.jobDesc.addVariable((VariableDescriptor)varShortReadsType);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        VariableDescriptor varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Genome Reference annotations GTF/GFF3");
        varOptions.setHelpMsg("Supply TopHat with a set of gene model annotations and/or known transcripts, as a GTF 2.2 or GFF3 formatted file. If this option is provided, TopHat will first extract the transcript sequences and use Bowtie to align reads to this virtual transcriptome first. Only the reads that do not fully map to the transcriptome will then be mapped on the genome. The reads that did map on the transcriptome will be converted to genomic mappings (spliced as needed) and merged with the novel mappings and junctions in the final tophat output.");
        varOptions.setDefaultValue("");
        varOptions.setCommandParamater("-G");
        varOptions.setCommandParamaterAlt("--GTF");
        varOptions.setVariableGroup(GROUP_TRANSCRIPTOME);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_BUILD_NEW_TRANS, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Build New Transcriptome");
        varOptions.setHelpMsg("To build new Transcriptome provide reference Fasta File and Path to build the Transcriptome.");
        varOptions.setVariableGroup(GROUP_TRANSCRIPTOME);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_NEW_TRANS_SAME_REF, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Same as Input reference index Options");
        varOptions.setHelpMsg("Use refenernece index or fasta file provided in the input section.");
        varOptions.setVariableGroup(GROUP_TRANSCRIPTOME);
        varOptions.setDefaultValue("false");
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_REF_NEW_TRANS, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.isRequired = true;
        varOptions.setVariableName("Transcriptome Reference Fasta file");
        varOptions.setHelpMsg("Reference Fasta file to build a new Transcriptome.");
        varOptions.setVariableGroup(GROUP_TRANSCRIPTOME);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_FODLER_NEW_TRANS, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Folder, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.isRequired = true;
        varOptions.setVariableName("Output Folder for the Transcriptome");
        varOptions.setHelpMsg("Folder to build the new Transcriptome.");
        varOptions.setVariableGroup(GROUP_TRANSCRIPTOME);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_PREFIX_NEW_TRANS, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Prefix for the Transcriptome");
        varOptions.setHelpMsg("Default same as the reference annotations  gtf or gff file used to build the Transcriptome");
        varOptions.setIsFileName(true);
        varOptions.setVariableGroup(GROUP_TRANSCRIPTOME);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_TRANS_INDEX, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Transcriptome index path");
        varOptions.setShortHelpMsg("Drag any of the transcriptome file  prefix.fa, prefix.gff or prefix.*.bowtie index files ");
        varOptions.setHelpMsg("Path for Transcriptome index that contains transcriptome data. Drag any of the transcriptome file  prefix.fa, prefix.gff or prefix.*.bowtie index files ");
        varOptions.setDefaultValue("");
        varOptions.setCommandParamater("--transcriptome-index");
        varOptions.setCommandParamaterSep("=");
        varOptions.setVariableGroup(GROUP_TRANSCRIPTOME);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Only align the reads to the transcriptome and report only those mappings as genomic mappings");
        varOptions.setHelpMsg("Used with when Reference transcriptome is provided -G/--transcriptome-index options");
        varOptions.setDefaultValue("");
        varOptions.setCommandParamater("-T");
        varOptions.setCommandParamaterAlt("--transcriptome-only");
        varOptions.setVariableGroup(GROUP_TRANSCRIPTOME);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Maximum number of mappings allowed for a read, when aligned to the transcriptome.");
        varOptions.setHelpMsg("Any reads found with more then this number of mappings will be discarded. Used with when Reference transcriptome is provided -G/--transcriptome-index options");
        varOptions.setCommandParamater("-x");
        varOptions.setCommandParamaterAlt("--transcriptome-max-hits");
        varOptions.setVariableGroup(GROUP_TRANSCRIPTOME);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("First align the reads to the whole genome in order to determine and exclude multi-mapped reads.");
        varOptions.setHelpMsg("When mapping reads on the transcriptome, some repetitive or low complexity reads that would be discarded in the context of the genome may appear to align to the transcript sequences and thus may end up reported as mapped to those genes only. This option directs TopHat to first align the reads to the whole genome in order to determine and exclude such multi-mapped reads (according to the value of the -g/--max-multihits option).");
        varOptions.setDefaultValue("");
        varOptions.setCommandParamater("-M");
        varOptions.setCommandParamaterAlt("--prefilter-multihits");
        varOptions.setVariableGroup(GROUP_TRANSCRIPTOME);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Raw junctions file");
        varOptions.setHelpMsg("Supply TopHat with a list of raw junctions. Junctions are specified one per line, in a tab-delimited format. Records look like:\n<chrom> <left> <right> <+/->\nleft and right are zero-based coordinates, and specify the last character of the left sequenced to be spliced to the first character of the right sequence, inclusive. That is, the last and the first positions of the flanking exons.\nYou can convert junctions.bed (one of the TopHat outputs) to this format using \"bed to juncs\" tool from preprocessing menu");
        varOptions.setCommandParamater("-j");
        varOptions.setCommandParamaterAlt("--raw-juncs");
        varOptions.setVariableGroup(GROUP_TRANSCRIPTOME);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Only look for reads across junctions indicated in the supplied GFF or junctions file.");
        varOptions.setHelpMsg("Only look for reads across junctions indicated in the supplied GFF or junctions file. Ignored if no Raw junctions(-j) and enome Reference annotations(-G) provided.");
        varOptions.setCommandParamater("--no-novel-juncs");
        varOptions.setVariableGroup(GROUP_TRANSCRIPTOME);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("--no-gtf-juncs");
        varOptions.setHelpMsg("--no-gtf-juncs.");
        varOptions.setCommandParamater("--no-gtf-juncs");
        varOptions.setVariableGroup(GROUP_TRANSCRIPTOME);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Supply TopHat with a list of insertions with respect to the reference");
        varOptions.setHelpMsg("Supply TopHat with a list of insertions with respect to the reference.  Indels are specified one per line, in a tab-delimited format, identical to that of junctions. Records are formatted as follows:\n<chrom> <left> <dummy> <inserted sequence>\nleft is zero-based coordinate and dummy can be set to the same value as left. For instance:\n\nchr1 17491 17491 CA\nmeans that the two base pairs \"CA\" are inserted between 17490 and 17491 of the reference genome.");
        varOptions.setCommandParamater("--insertions");
        varOptions.setVariableGroup(GROUP_TRANSCRIPTOME);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Supply TopHat with a list of deletions with respect to the reference");
        varOptions.setHelpMsg("Supply TopHat with a list of deletions with respect to the reference.  Indels are specified one per line, in a tab-delimited format, identical to that of junctions. Records are formatted as follows:\n<chrom> <left> <right>\nleft and right are zero-based coordinates, and specify the last character of the left sequenced to be spliced to the first character of the right sequence, inclusive. For example:\nchr1 20564 20567\nmeans that two base pairs located at 20565 and 20566 are deleted in the sequenced genome.");
        varOptions.setCommandParamater("--deletions");
        varOptions.setVariableGroup(GROUP_TRANSCRIPTOME);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Only look for reads across indels in the supplied indel file, or disable indel detection when no file has been provided.");
        varOptions.setHelpMsg("Only look for reads across indels in the supplied indel file, or disable indel detection when no file has been provided.");
        varOptions.setCommandParamater("--no-novel-indels");
        varOptions.setVariableGroup(GROUP_TRANSCRIPTOME);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_FINAL_READ_MISMATCHES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Max Read mismatches");
        varOptions.setHelpMsg(" Final read alignments having more than these many mismatches are discarded. The default is 2.");
        varOptions.setDefaultValue("");
        varOptions.setCommandParamater("--read-mismatches");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Max read gap length");
        varOptions.setHelpMsg(" Final read alignments having more than these many total length of gaps are discarded. The default is 2. ");
        varOptions.setDefaultValue("");
        varOptions.setCommandParamater("--read-gap-length");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_MAX_EDIT_DISTANCE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Max edit distance");
        varOptions.setHelpMsg("Final read alignments having more than these many edit distance are discarded. The default is 2.");
        varOptions.setCommandParamater("--read-edit-dist");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_MAX_REALIGN_EDIT_DISTANCE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Max realign edit distance");
        varOptions.setHelpMsg("Some of the reads spanning multiple exons may be mapped incorrectly as a contiguous alignment to the genome even though the correct alignment should be a spliced one - this can happen in the presence of processed pseudogenes that are rarely (if at all) transcribed or expressed. This option can direct TopHat to re-align reads for which the edit distance of an alignment obtained in a previous mapping step is above or equal to this option value. If you set this option to 0, TopHat will map every read in all the mapping steps (transcriptome if you provided gene annotations, genome, and finally splice variants detected by TopHat), reporting the best possible alignment found in any of these mapping steps. This may greatly increase the mapping accuracy at the expense of an increase in running time. The default value for this option is set such that TopHat will not try to realign reads already mapped in earlier steps.");
        varOptions.setCommandParamater("--read-realign-edit-dist");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_MIN_ANCHOR_LENGTH, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Min Anchor length (at least 3)");
        varOptions.setHelpMsg("TopHat will report junctions spanned by reads with at least this many bases on each side of the junction. Note that individual spliced alignments may span a junction with fewer than this many bases on one side. However, every junction involved in spliced alignments is supported by at least one read with this many bases on each side. This must be at least 3 and the default is 8.");
        varOptions.setCommandParamater("--min-anchor-length");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_SPLICE_MISMATCHES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Max Splice Mismatches");
        varOptions.setHelpMsg("The maximum number of mismatches that may appear in the \"anchor\" region of a spliced alignment. The default is 0.");
        varOptions.setCommandParamater("--splice-mismatches");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Min intron length");
        varOptions.setHelpMsg(" The minimum intron length. TopHat will ignore donor/acceptor pairs closer than this many bases apart. The default is 70. ");
        varOptions.setCommandParamater("--min-intron-length");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_MAXIMUM_INTRON_LENGTH, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Maximum intron length");
        varOptions.setHelpMsg("The maximum intron length. When searching for junctions ab initio, TopHat will ignore donor/acceptor pairs farther than this many bases apart, except when such a pair is supported by a split segment alignment of a long read. The default is 500000.");
        varOptions.setCommandParamater("--max-intron-length");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        VariableDescriptor varOptions_OPTION_MAX_INSERTION_LENGTH = VariableDescriptor.createDescriptorFor((String)OPTION_MAX_INSERTION_LENGTH, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions_OPTION_MAX_INSERTION_LENGTH.setVariableName("Max insertion length");
        varOptions_OPTION_MAX_INSERTION_LENGTH.setHelpMsg("The maximum insertion length. The default is 3.");
        varOptions_OPTION_MAX_INSERTION_LENGTH.setCommandParamater("--max-insertion-length");
        varOptions_OPTION_MAX_INSERTION_LENGTH.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions_OPTION_MAX_INSERTION_LENGTH);
        VariableDescriptor varOptions_OPTION_MAX_DELETION_LENGTH = VariableDescriptor.createDescriptorFor((String)OPTION_MAX_DELETION_LENGTH, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions_OPTION_MAX_DELETION_LENGTH.setVariableName("Max deletion length");
        varOptions_OPTION_MAX_DELETION_LENGTH.setHelpMsg("The maximum deletion length. The default is 3.");
        varOptions_OPTION_MAX_DELETION_LENGTH.setCommandParamater("--max-deletion-length");
        varOptions_OPTION_MAX_DELETION_LENGTH.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions_OPTION_MAX_DELETION_LENGTH);
        SelectionListVariableDescriptor varOptionsSelectionList = VariableDescriptor.SelectionList((String)OPTION_LIBRARY_TYPE, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptionsSelectionList.setVariableName("Library Type");
        varOptionsSelectionList.addOptionValue("fr-unstranded", "fr-unstranded", "Reads from the left-most end of the fragment (in transcript coordinates) map to the transcript strand, and the right-most end maps to the opposite strand. Examples:- Standard Illumina");
        varOptionsSelectionList.addOptionValue("fr-firststrand", "fr-firststrand", "Same as fr-unstranded except it enforces the rule that the right-most end of the fragment (in transcript coordinates) is the first sequenced (or only sequenced for single-end reads). Equivalently, it is assumed that only the strand generated during first strand synthesis is sequenced. Examples:- dUTP, NSR, NNSR");
        varOptionsSelectionList.addOptionValue("fr-secondstrand", "fr-secondstrand", "Same as fr-unstranded except it enforces the rule that the left-most end of the fragment (in transcript coordinates) is the first sequenced (or only sequenced for single-end reads). Equivalently, it is assumed that only the strand generated during second strand synthesis is sequenced. Examples:- Directional Illumina (Ligation), Standard SOLiD");
        varOptionsSelectionList.setHelpMsg("The default is unstranded (fr-unstranded). If either fr-firststrand or fr-secondstrand is specified, every read alignment will have an XS attribute tag. Consider supplying library type options to select the correct RNA-seq protocol.");
        varOptionsSelectionList.setCommandParamater("--library-type");
        varOptionsSelectionList.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable((VariableDescriptor)varOptionsSelectionList);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_USE_BOWTIE_N_MODE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Use bowtie -n mode");
        varOptions.setHelpMsg("TopHat uses \"-v\" in Bowtie for initial read mapping (the default), but with this option, \"-n\" is used instead. Read segments are always mapped using \"-v\" option.");
        varOptions.setDefaultValue("false");
        varOptions.setCommandParamater("--bowtie-n");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_USE_BOWTIE_N_MODE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Use bowtie1");
        varOptions.setHelpMsg("Uses Bowtie1 instead of Bowtie2. If you use colorspace reads, you need to use this option as Bowtie2 does not support colorspace reads.");
        varOptions.setDefaultValue("false");
        varOptions.setCommandParamater("--bowtie1");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Use the Solexa scale for quality values in FASTQ files");
        varOptions.setHelpMsg("Use the Solexa scale for quality values in FASTQ files.");
        varOptions.setDefaultValue("false");
        varOptions.setCommandParamater("--solexa-quals");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Use the Solexa scale for Illumina GA pipeline version 1.3");
        varOptions.setHelpMsg("As of the Illumina GA pipeline version 1.3, quality scores are encoded in Phred-scaled base-64. Use this option for FASTQ files from pipeline 1.3 or later.");
        varOptions.setDefaultValue("false");
        varOptions.setCommandParamater("--solexa1.3-quals");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Use Separated quality value files");
        varOptions.setHelpMsg(" Separate quality value files - colorspace read files (CSFASTA) come with separate qual files.");
        varOptions.setDefaultValue("false");
        varOptions.setCommandParamater("--quals");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Quality values are space-delimited integer values");
        varOptions.setHelpMsg("Quality values are space-delimited integer values, this becomes default when you specify -C/--color.");
        varOptions.setDefaultValue("false");
        varOptions.setCommandParamater("--integer-quals");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Colorspace reads");
        varOptions.setHelpMsg("Colorspace reads, note that it uses a colorspace bowtie index");
        varOptions.setDefaultValue("false");
        varOptions.setCommandParamater("--color");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_USE_MICROEXON_SEARCH, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Use Microexon Search");
        varOptions.setHelpMsg("With this option, the pipeline will attempt to find alignments incident to micro-exons. Works only for reads 50bp or longer.");
        varOptions.setDefaultValue("false");
        varOptions.setCommandParamater("--microexon-search");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_MAXIMUM_NUMBER_OF_ALIGNMENTS, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Maximum number of alignments to be allowed");
        varOptions.setHelpMsg("Instructs TopHat to allow up to this many alignments to the reference for a given read, and choose the alignments based on their alignment scores if there are more than this number. The default is 20 for read mapping. Unless you use --report-secondary-alignments, TopHat will report the alignments with the best alignment score. If there are more alignments with the same score than this number, TopHat will randomly report only this many alignments. In case of using --report-secondary-alignments, TopHat will try to report alignments up to this option value, and TopHat may randomly output some of the alignments with the same score to meet this number.");
        varOptions.setDefaultValue("");
        varOptions.setCommandParamater("--max-multihits");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Report secondary alignments");
        varOptions.setHelpMsg("By default TopHat reports best or primary alignments based on alignment scores (AS). Use this option if you want to output additional or secondary alignments  (up to 20 alignments will be reported this way, this limit can be changed by using the -g/--max-multihits option above).");
        varOptions.setDefaultValue("false");
        varOptions.setCommandParamater("--report-secondary-alignments");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Disables the coverage based search for junctions. ");
        varOptions.setHelpMsg("Disables the coverage based search for junctions.");
        varOptions.setCommandParamater("--no-coverage-search");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_MIN_SEGMENT_INTRON, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Minimum intron length that may be found during split-segment");
        varOptions.setHelpMsg("The minimum intron length that may be found during split-segment search. The default is 50.");
        varOptions.setDefaultValue("");
        varOptions.setCommandParamater("--min-segment-intron");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_MAX_SEGMENT_INTRON, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Maximum intron length that may be found during split-segment");
        varOptions.setHelpMsg("The maximum intron length that may be found during split-segment search. The default is 500000.");
        varOptions.setDefaultValue("");
        varOptions.setCommandParamater("--max-segment-intron");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_SEGMENT_MISMATCHES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Number of mismatches allowed in each segment alignment");
        varOptions.setHelpMsg("Read segments are mapped independently, allowing up to this many mismatches in each segment alignment. The default is 2.");
        varOptions.setCommandParamater("--segment-mismatches");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_SEGMENT_LENGTH, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Minimum length of read segments");
        varOptions.setHelpMsg("Each read is cut up into segments, each at least this long. These segments are mapped independently. The default is 25.");
        varOptions.setCommandParamater("--segment-length");
        varOptions.setVariableGroup(GROUP_GENERAL);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_RM_FILTER, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Overall alignment rate");
        varOptions.setHelpMsg("Min overall alignment rate to consider the mapping succesfull. Has no effect of the bahavoiur of The mapper. Only used for pipeline managment and tracking. Default 80");
        varOptions.setDefaultValue("80");
        this.jobDesc.addVariable(varOptions);
        VariableDescriptor outputVarLibraryName = VariableDescriptor.createDescriptorFor((String)OUTPUT_LIBRARY_NAMES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        outputVarLibraryName.setVariableName("Library Names");
        outputVarLibraryName.setHelpMsg("Library Names");
        outputVarLibraryName.setGUIVisible(false);
        this.jobDesc.addVariable(outputVarLibraryName);
        VariableDescriptor outputVarAcceptedHits = VariableDescriptor.createDescriptorFor((String)OUTPUT_ACCEPTED_HITS, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        outputVarAcceptedHits.isRequired = true;
        outputVarAcceptedHits.setVariableName("accepted_hits.bam");
        outputVarAcceptedHits.setHelpMsg("A list of read alignments in BAM format.");
        this.jobDesc.addVariable(outputVarAcceptedHits);
        VariableDescriptor outputRefIndex = VariableDescriptor.createDescriptorFor((String)OUTPUT_REF_INDEX, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        outputRefIndex.setVariableName("REF Index");
        outputRefIndex.setHelpMsg("Ref Index");
        this.jobDesc.addVariable(outputRefIndex);
        this.initJobFromDesc(this.jobDesc);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_FILE), VariablesRule.Condition.False, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_FASTA_FILE), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_PREFIX), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        if (((FileListVariable)this.getVariable(INPUT_FASTQ_FILE)).getIsPairedFiles()) {
            this.getVariable(INPUT_READS_TYPE).setValue("Paired-end");
        }
        new VariablesRule(this.getVariable(INPUT_READS_TYPE), this.getVariable(INPUT_MEAN_INNER_DISTANCE), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, "Paired-end");
        new VariablesRule(this.getVariable(INPUT_READS_TYPE), this.getVariable(INPUT_STD_INNER_DISTANCE), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, "Paired-end");
        new VariablesRule(this.getVariable(INPUT_READS_TYPE), this.getVariable(INPUT_REPORT_DISCORDANT_PAIR), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, "Paired-end");
        new VariablesRule(this.getVariable(OPTION_BUILD_NEW_TRANS), this.getVariable(OPTION_NEW_TRANS_SAME_REF), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(OPTION_NEW_TRANS_SAME_REF), this.getVariable(OPTION_REF_NEW_TRANS), VariablesRule.Condition.False, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(OPTION_BUILD_NEW_TRANS), this.getVariable(OPTION_PREFIX_NEW_TRANS), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(OPTION_BUILD_NEW_TRANS), this.getVariable(OPTION_FODLER_NEW_TRANS), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(OPTION_BUILD_NEW_TRANS), this.getVariable(OPTION_TRANS_INDEX), VariablesRule.Condition.False, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(OPTION_BUILD_NEW_TRANS), this.getVariableByCMDSwitch("-G"), VariablesRule.Condition.True, VariablesRule.Action.SetToRequired, true);
    }

    public boolean notifyVarValueChanged(String varKey, String value) {
        try {
            if (varKey.equals(INPUT_FASTQ_FILE)) {
                if (((FileVariable)this.getVariable(INPUT_FASTQ_FILE)).getIsPairedFiles()) {
                    this.getVariable(INPUT_READS_TYPE).setValue("Paired-end");
                } else {
                    this.getVariable(INPUT_READS_TYPE).setValue("Single-end");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return true;
    }

    public String notifyVarValueChanging(String varKey, String value) {
        try {
            String ext;
            String refIndex;
            if (varKey.equals(INPUT_INDEX_FILE)) {
                refIndex = value;
                ext = FilenameUtils.getExtension((String)refIndex);
                System.out.println(ext);
                if (ext != null && (ext.equals(".bt2") || ext.equals(".bt") || ext.equals(".bt2l"))) {
                    String raw = FilenameUtils.getBasename((String)refIndex, (boolean)true);
                    String ext2 = FilenameUtils.getExtension((String)(raw = FilenameUtils.getBasename((String)raw, (boolean)true)), (boolean)true);
                    if (ext2 != null && ext2.equals(".rev")) {
                        raw = FilenameUtils.getBasename((String)raw, (boolean)true);
                    }
                    String path = org.apache.commons.io.FilenameUtils.getPath((String)refIndex);
                    return "/" + path + raw;
                }
                this.getVariable(INPUT_INDEX_FILE).setWarning("May not be a Bowtie Index File.");
            }
            if (varKey.equals(OPTION_TRANS_INDEX)) {
                refIndex = value;
                ext = FilenameUtils.getExtension((String)refIndex);
                System.out.println(ext);
                if (ext != null && (ext.equals(".bt2") || ext.equals(".bt2l") || ext.equals(".fa") || ext.equals(".gff") || ext.equals(".tlst") || ext.equals(".ver"))) {
                    String ext2;
                    String raw = FilenameUtils.getBasename((String)refIndex, (boolean)true);
                    if (ext.equals(".bt2") || ext.equals(".bt2l") || ext.equals(".tlst")) {
                        raw = FilenameUtils.getBasename((String)raw, (boolean)true);
                    }
                    if ((ext2 = FilenameUtils.getExtension((String)raw, (boolean)true)) != null && ext2.equals(".rev")) {
                        raw = FilenameUtils.getBasename((String)raw, (boolean)true);
                    }
                    String path = org.apache.commons.io.FilenameUtils.getPath((String)refIndex);
                    return "/" + path + raw;
                }
            }
        }
        catch (Exception ex) {
            System.out.println("notifyVarValueChanging Error in " + varKey + "  " + this.getJobDescID());
        }
        return value;
    }

    protected void generateCommand(StringBuilder builder) {
        String outputIndexFile = this.getVariable(OUTPUT_REF_INDEX).getBashVarName();
        builder.append(BashHelper.If((String)BashConditions.Equal((JobVariable)this.getVariable(INPUT_INDEX_CHOICE), (String)"true")).Then("_baseDir=$(dirname \"" + this.getVariable(INPUT_INDEX_FASTA_FILE).$() + "\")\n" + "inputIndexFileBaseName=" + BashHelper.getBaseName((JobVariable)this.getVariable(INPUT_INDEX_FASTA_FILE)) + outputIndexFile + "=\"${_baseDir}/${inputIndexFileBaseName}\"\n" + BashHelper.If((String)BashConditions.notEmptyStr((JobVariable)this.getVariable(INPUT_INDEX_PREFIX))).Then(String.valueOf(outputIndexFile) + "=\"${_baseDir}/" + this.getVariable(INPUT_INDEX_PREFIX).$() + "\"\n") + "prefixOption=\"${" + outputIndexFile + "}\"\n" + BashHelper.command_withTrack((String)this.getVariable(INPUT_INDEX_FASTA_FILE).$(), (String)(String.valueOf(Constants.PIPELINE_BASE_PATH) + "bowtie2-build -q  " + this.getVariable(INPUT_INDEX_FASTA_FILE).$() + " ${prefixOption} "), (String)"bowtie2-build Reference Index")).Else(String.valueOf(outputIndexFile) + "=\"" + this.getVariable(INPUT_INDEX_FILE).$() + "\"\n"));
        builder.append(BashHelper.IF((String)BashConditions.Equal((JobVariable)this.getVariable(OPTION_BUILD_NEW_TRANS), (String)"true"), (String)("printf \"Buidling transcriptome ........ \\n\\n\" \n" + BashHelper.IF((String)("[ -z \"" + this.getVariable(OPTION_PREFIX_NEW_TRANS).$() + "\" ]"), (String)("transcriptPrefix=" + BashHelper.getBaseName((String)this.getVariableByCMDSwitch("-G").getBashVarName()) + " \n"), (String)("transcriptPrefix=\"" + this.getVariable(OPTION_PREFIX_NEW_TRANS).$() + "\" \n")) + BashHelper.IF((String)("[ \"" + this.getVariable(OPTION_NEW_TRANS_SAME_REF).$() + "\" = \"" + "true" + "\" ]"), (String)("transRef=\"" + this.getVariable(OUTPUT_REF_INDEX).$() + "\"\n"), (String)("transRef=\"" + this.getVariable(OPTION_FODLER_NEW_TRANS).$() + "/${transcriptPrefix}\" \n" + BashHelper.command_withTrack((String)this.getVariable(OPTION_REF_NEW_TRANS).$(), (String)(String.valueOf(Constants.PIPELINE_BASE_PATH) + "bowtie2-build " + this.getVariable(OPTION_REF_NEW_TRANS).$() + "  ${transRef} \n"), (String)"bowtie2-build Transcriptome Index"))) + this.jobId + "_oa_all=\"" + this.getOptionParamatersStrAs$() + " --transcriptome-index=" + this.getVariable(OPTION_FODLER_NEW_TRANS).$() + "/${transcriptPrefix} \" \n" + BashHelper.command_withTrack((String)"${transRef}", (String)(String.valueOf(Constants.PIPELINE_BASE_PATH) + "tophat -G " + this.getVariableByCMDSwitch("-G").$() + "  --transcriptome-index=" + this.getVariable(OPTION_FODLER_NEW_TRANS).$() + "/${transcriptPrefix}  ${transRef} \n"), (String)"Tophat Build Transcriptome") + "printf \"  ========================================== \\n\\n \" \n")));
        builder.append("outputFolder=\"" + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\"\n");
        builder.append("_refIndex=\"" + this.getVariable(OUTPUT_REF_INDEX).$() + "\"\n");
        builder.append("[ -f \"${_refIndex}.fa\" ]  || (  " + Tracking.trackLogWarning((String)"Could not find FASTA file ${_refIndex}.fa , Will create it.") + Constants.PIPELINE_BASE_PATH + "bowtie2-inspect ${_refIndex} > \"${_refIndex}.fa\"  )\n");
        builder.append("[ -d \"${outputFolder}/align_summary\" ] ||  mkdir \"${outputFolder}/align_summary\" \n");
        builder.append(BashHelper.Batcher_noLog((FileListVariable)((FileListVariable)this.getVariable(INPUT_FASTQ_FILE)), (String)BashHelper.IF((String)(" -z  \"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\" "), (String)"outputFileName=\"${inputFile1BaseName}\"\n", (String)("outputFileName=\"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\"\n")), (String)"", (String)BashHelper.IF((String)(" -z  \"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\" "), (String)"outputFileName=$(hlp_lncName  \"$inputFile1BaseName\" \"$inputFile2BaseName\" )\n[ -z \"${outputFileName}\" ] && outputFileName=\"${inputFile1BaseName}_${inputFile2BaseName}\"\n"), (String)(String.valueOf(this.getVariable(OUTPUT_LIBRARY_NAMES).getBashVarName("$_i")) + "=\"${outputFileName}\"\n" + this.getVariable(OUTPUT_ACCEPTED_HITS).getBashVarName("$_i") + "=\"${outputFolder}/${outputFileName}.bam\"\n"), (boolean)true));
        builder.append(BashHelper.BatcherParallel((FileListVariable)((FileListVariable)this.getVariable(INPUT_FASTQ_FILE)), (String)("outputFileName=\"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\"\n"), (String)"", (String)("echo \"Running Tophat2 for : ${_inputFile1}\"\n" + Constants.PIPELINE_BASE_PATH + "tophat  " + this.getOptionParamatersStrAs$() + " -o \"${outputFolder}/${outputFileName}\"  ${_refIndex} ${_inputFile1}  \n"), (String)"", (String)("echo \"Running Tophat2 for : ${_inputFile1},${_inputFile2}\"\n" + Constants.PIPELINE_BASE_PATH + "tophat  " + this.getOptionParamatersStrAs$() + " -o \"${outputFolder}/${outputFileName}\"  ${_refIndex} ${_inputFile1}  ${_inputFile2} \n"), (String)(String.valueOf(BashHelper.moveWithWarning((String)"${outputFolder}/${outputFileName}/accepted_hits.bam", (String)"${outputFolder}/${outputFileName}.bam")) + BashHelper.moveWithWarning((String)"${outputFolder}/${outputFileName}/align_summary.txt", (String)"${outputFolder}/align_summary/${outputFileName}_align_summary.txt"))));
        FilesVariable outBamFiles = (FilesVariable)this.getVariable(OUTPUT_ACCEPTED_HITS);
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)outBamFiles, (String)"", (String)BashHelper.If((String)BashConditions.fileExist((String)outBamFiles.$("${_i}"))).Then("samtools index " + outBamFiles.$("${_i}")).toString(), (String)"samtools index"));
    }

    protected String getFilterCheckCommand() {
        String checkLevel = Tracking.TrackCheckLevels.Fail.toString();
        if (this.getParent() == null) {
            checkLevel = Tracking.TrackCheckLevels.Warning.toString();
        }
        String filterName = "RM";
        String statusVar = "_g_filter_status";
        String cmdCheck = "";
        cmdCheck = String.valueOf(cmdCheck) + "dARate=\"" + this.getVariable(OPTION_RM_FILTER).$() + "\"\n";
        cmdCheck = String.valueOf(cmdCheck) + "[ -n \"${dARate}\" ] ||  dARate=\"80\" \n";
        cmdCheck = String.valueOf(cmdCheck) + BashHelper.Batcher_noLog((FileListVariable)((FileListVariable)this.getVariable(INPUT_FASTQ_FILE)), (String)("outputFileName=\"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\"\n" + "fileNames=\"${_inputFile1}\"\n"), (String)"", (String)"fileNames=\"${fileNames},${_inputFile2}\"\n", (String)(BashHelper.If((String)"-f \"${outputFolder}/align_summary/${outputFileName}_align_summary.txt\"").Then("allRes=$(cat  \"${outputFolder}/align_summary/${outputFileName}_align_summary.txt\" )\nallRes=${allRes//%/%%}\nprintf \"A summary of the alignment counts:\\n\"\nprintf \"$allRes\\n\\n\"\nalignRes=$(grep  \"overall read\" \"${outputFolder}/align_summary/${outputFileName}_align_summary.txt\")\nIFS=\"%\" read -r -a fres <<< \"$alignRes\"\naRate=${fres[0]}\n[ -n \"${aRate}\" ] || aRate=\"0\"\n").Else(" echo \"ERROR : Missing alignment summary File\" \naRate=\"0\"\n") + "com=$(echo $aRate\">=\"$dARate | bc -l)\n" + BashHelper.IF((String)"[ com -eq 0 ]", (String)(String.valueOf(Tracking.trackLogCheck((String)"${fileNames}", (String)filterName, (Tracking.TrackCheckType)Tracking.TrackCheckType.Filter, (Tracking.TrackCheckLevels)Tracking.TrackCheckLevels.Fail, (String)"Overall Alignment rate ${aRate} is less than definded threshold $dARate")) + BashHelper.assign((String)statusVar, (String)checkLevel)), (String)Tracking.trackLogCheck((String)"${fileNames}", (String)filterName, (Tracking.TrackCheckType)Tracking.TrackCheckType.Filter, (Tracking.TrackCheckLevels)Tracking.TrackCheckLevels.Pass, (String)"Overall Alignment rate ${aRate} is Ok"))));
        return cmdCheck;
    }

    protected void generateCommandWrapUp(StringBuilder builder) {
    }
}

