/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.mapping;

import com.biotechvana.shared.jobs.PreprocessingFilters;
import com.biotechvana.utils.Constants;
import com.biotechvana.utils.FilenameUtils;
import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.VariablesRule;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.JobLink;
import com.biotechvana.workflow.descriptors.Publication;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class MappingBwaJob
extends WorkflowJob {
    public static final String JOB_ID = "bwa";
    public static final String JOB_NAME = "Bwa";
    public static final String OPTION_RM_FILTER = "OPTION_RM";
    public static final String INPUT_INDEX_CHOICE = "INPUT_INDEX_CHOICE";
    public static final String INPUT_INDEX_FASTA_FILE = "INPUT_INDEX_FASTA_FILE";
    public static final String INPUT_INDEX_PREFIX = "INPUT_INDEX_PREFIX";
    public static final String INPUT_INDEX_ALG = "INPUT_INDEX_ALG";
    public static final String INPUT_ALN_ALG = "INPUT_ALN_ALG";
    public static final String OPTION_ALN_ALG = "OPTION_ALN_ALG";
    public static final String OUTPUT_LIBRARY_NAMES = "OUTPUT_LIBRARY_NAMES";
    public static final String INPUT_INDEX_FILE = "INPUT_INDEX_FILE";
    public static final String INPUT_FILES = "INPUT_FILES";
    public static final String INPUT_READS_SIZE = "INPUT_READS_SIZE";
    public static final String OPTION_KEEP_TO_SAM = "OPTION_KEEP_TO_SAM";
    public static final String INPTU_OPTION_ALN_ALN = "OPTIONS_ALN";
    public static final String INPTU_OPTION_ALN_MEM = "OPTIONS_MEM";
    public static final String INPTU_OPTION_ALN_SAM = "OPTIONS_SAM";
    private static final String Short_Read = "Short Read";
    private static final String Long_Read = "Long Read";
    public static final String OUTPUT_BAM_FILES = "OUTPUT_FILES";
    public static final String OUTPUT_SAM_FILES = "OUTPUT_SAM_FILES";
    private static final String OPTION_ALN_BACKTRACK = "BWA-Backtrack";
    private static final String OPTION_ALN_SW = "BWS-SW";
    private static final String OPTION_ALN_MEM = "BWA-MEM";

    public MappingBwaJob() {
        this.jobName = JOB_NAME;
        this.jobDesc = new JobDescriptor(JOB_ID);
        this.jobDesc.setDesc("BWA is a software package for mapping low-divergent sequences against a large reference genome, such as the human genome. It consists of three algorithms: BWA-backtrack, BWA-SW and BWA-MEM. The first algorithm is designed for Illumina sequence reads up to 100bp, while the rest two for longer sequences ranged from 70bp to 1Mbp. BWA-MEM and BWA-SW share similar features such as long-read support and split alignment, but BWA-MEM, which is the latest, is generally recommended for high-quality queries as it is faster and more accurate");
        this.jobDesc.addPublication(new Publication().setAuthors("Li, H. and Durbin, R.").setTitle("Fast and accurate long-read alignment with Burrows-Wheeler transform").setJournal("Bioinformatics").setVolume(26).setIssue(5).setYear(2010).setPages("589-595").setDOI("10.1093/bioinformatics/btp698").setPubmed("20080505"));
        this.jobDesc.addLink(new JobLink().setTitle(JOB_ID).setUrl("http://bio-bwa.sourceforge.net/bwa.shtml").setType(JobLink.LinkType.Manual));
        VariableDescriptor varIndexChioce = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_CHOICE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexChioce.isRequired = true;
        varIndexChioce.setVariableName("Create new index from a Fasta File");
        varIndexChioce.setHelpMsg("Create new one from a Fasta File or Use an exisiting index.");
        this.jobDesc.addVariable(varIndexChioce);
        VariableDescriptor varUsedIndexFile = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varUsedIndexFile.isRequired = true;
        varUsedIndexFile.setVariableName("Index File");
        varUsedIndexFile.setShortHelpMsg("Drag an Existing index *.amb, *.ann, *.bwt, *.pac, or *.sa extension");
        varUsedIndexFile.setHelpMsg("Use an Existing index - Files end with ( *.amb, *.ann, *.bwt, *.pac, or *.sa ) extension. The index should have be built with (bwa index) program.");
        this.jobDesc.addVariable(varUsedIndexFile);
        VariableDescriptor varIndexFile = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_FASTA_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexFile.isRequired = true;
        varIndexFile.setVariableName("Input Ref Fasta File");
        varIndexFile.setShortHelpMsg("Drag a Fasta file to build a new index");
        varIndexFile.setHelpMsg("Reference Fasta file to build a new index");
        this.jobDesc.addVariable(varIndexFile);
        VariableDescriptor varIndexFilePrefix = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_PREFIX, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexFilePrefix.setVariableName("Prefix");
        varIndexFilePrefix.setIsFileName(true);
        varIndexFilePrefix.setHelpMsg("A prefix name for the output index file.");
        this.jobDesc.addVariable(varIndexFilePrefix);
        SelectionListVariableDescriptor varIndexFileAlgorith = VariableDescriptor.SelectionList((String)INPUT_INDEX_ALG, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexFilePrefix.isRequired = true;
        varIndexFileAlgorith.setVariableName("Algorithm");
        varIndexFileAlgorith.addOptionValue("is", "is", "IS linear-time algorithm for constructing suffix array. It requires 5.37N memory where N is the size of the database. IS is moderately fast, but does not work with database larger than 2GB.");
        varIndexFileAlgorith.addOptionValue("bwtsw", "bwtsw", " Algorithm implemented in BWT-SW. This method works with the whole human genome.");
        varIndexFileAlgorith.setDefaultIndexValue(1);
        varIndexFileAlgorith.setHelpMsg("Algorithm for constructing BWT index.");
        this.jobDesc.addVariable((VariableDescriptor)varIndexFileAlgorith);
        SelectionListVariableDescriptor varMappingType = VariableDescriptor.SelectionList((String)INPUT_READS_SIZE, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varMappingType.isRequired = true;
        varMappingType.addOptionValue(Short_Read);
        varMappingType.addOptionValue(Long_Read);
        varMappingType.setVariableName("Reads Size");
        varMappingType.setDefaultIndexValue(0);
        this.jobDesc.addVariable((VariableDescriptor)varMappingType);
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)INPUT_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input File");
        varReadInputFile.addAcceptedFileFormat("FASTQ", false, true);
        this.jobDesc.addVariable(varReadInputFile);
        SelectionListVariableDescriptor varAlnAlgorith = VariableDescriptor.SelectionList((String)INPUT_ALN_ALG, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varAlnAlgorith.isRequired = true;
        varAlnAlgorith.setVariableName("Alignment Algorithm");
        varAlnAlgorith.addOptionValue("mem");
        varAlnAlgorith.addOptionValue("aln/samse/sampe");
        varAlnAlgorith.setDefaultIndexValue(0);
        varAlnAlgorith.setHelpMsg("Algorithm to use for short reads alignment");
        this.jobDesc.addVariable((VariableDescriptor)varAlnAlgorith);
        VariableDescriptor outputVarLibraryName = VariableDescriptor.createDescriptorFor((String)OUTPUT_LIBRARY_NAMES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        outputVarLibraryName.setVariableName("Library Names");
        outputVarLibraryName.setHelpMsg("Library Names");
        outputVarLibraryName.setGUIVisible(false);
        this.jobDesc.addVariable(outputVarLibraryName);
        VariableDescriptor varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_RM_FILTER, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Expected Overall alignment rate");
        varOptions.setHelpMsg("Min/Expected overall alignment rate to consider the mapping succesfull. Has no effect of the bahavoiur of The mapper. Used only for managment pipeline and tracking. Default 80");
        varOptions.setDefaultValue("80");
        this.jobDesc.addVariable(varOptions);
        this.createOptionVar(VariableDescriptor.VariableType.Double, "-n", "Maximum edit distance-fraction of missing alignments", "aln", "Maximum edit distance if the value is INT, or the fraction of missing alignments given 2% uniform base error rate if FLOAT. In the latter case, the maximum edit distance is automatically chosen for different read lengths. [0.04]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-o", "Maximum number of gap opens", "aln", "Maximum number of gap opens. Default [1]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-e", "Maximum number of gap extensions", "aln", "Maximum number of gap extensions, -1 for k-difference mode (disallowing long gaps). Default [-1]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-d", "Disallow a long deletion within INT bp towards the 3\u2019-end", "aln", "Disallow a long deletion within INT bp towards the 3\u2019-end. Default [16]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-i", "Disallow an indel within INT bp towards the ends", "aln", "Disallow an indel within INT bp towards the ends. Default [5]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-l", "Take the first INT subsequence as seed", "aln", "Take the first INT subsequence as seed. If INT is larger than the query sequence, seeding will be disabled. For long reads, this option is typically ranged from 25 to 35 for -k 2. Default [inf]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-k", "Maximum edit distance", "aln", "Maximum edit distance in the seed. Default [2]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-M", "Mismatch penalty", "aln", "Mismatch penalty. BWA will not search for suboptimal hits with a score lower than (bestScore-misMsc). Default [3]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-O", "Gap open penalty", "aln", "Gap open penalty. Default [11]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-E", "Gap extension penalty", "aln", "Gap extension penalty. Default [4]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-R", "Proceed with suboptimal alignments if there are no more than INT equally best hits.", "aln", "Proceed with suboptimal alignments if there are no more than INT equally best hits. This option only affects paired-end mapping. Increasing this threshold helps to improve the pairing accuracy at the cost of speed, especially for short reads (~32bp).");
        this.createOptionVar(VariableDescriptor.VariableType.Checked, "-c", "Reverse query but not complement it", "aln", "Reverse query but not complement it, which is required for alignment in the color space. (Disabled since 0.6.x)");
        this.createOptionVar(VariableDescriptor.VariableType.Checked, "-N", "Disable iterative search", "aln", "Disable iterative search. All hits with no more than maxDiff differences will be found. This mode is much slower than the default.");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-q", "Parameter for read trimming", "aln", "Parameter for read trimming. BWA trims a read down to argmax_x{\\sum_{i=x+1}^l(INT-q_i)} if q_l<INT where l is the original read length. Default [0]");
        this.createOptionVar(VariableDescriptor.VariableType.Checked, "-I", "The input is in the Illumina 1.3+ read format", "aln", "The input is in the Illumina 1.3+ read format (quality equals ASCII-64)");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-B", "Length of barcode starting from the 5\u2019-end", "aln", "Length of barcode starting from the 5\u2019-end. When INT is positive, the barcode of each read will be trimmed before mapping and will be written at the BC SAM tag. For paired-end reads, the barcode from both ends are concatenated. Default [0]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-k", "Minimum seed length", "mem", "Minimum seed length. Matches shorter than INT will be missed. The alignment speed is usually insensitive to this value unless it significantly deviates 20. [19]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-w", "Band width", "mem", "Band width. Essentially, gaps longer than INT will not be found. Note that the maximum gap length is also affected by the scoring matrix and the hit length, not solely determined by this option. [100]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-d", "Off-diagonal X-dropoff (Z-dropoff)", "mem", "\tOff-diagonal X-dropoff (Z-dropoff). Stop extension when the difference between the best and the current extension score is above |i-j|*A+INT, where i and j are the current positions of the query and reference, respectively, and A is the matching score. Z-dropoff is similar to BLAST\u2019s X-dropoff except that it doesn\u2019t penalize gaps in one of the sequences in the alignment. Z-dropoff not only avoids unnecessary extension, but also reduces poor alignments inside a long good alignment. [100]");
        this.createOptionVar(VariableDescriptor.VariableType.Double, "-r", "Trigger re-seeding for a MEM longer than minSeedLen*FLOAT.", "mem", "Trigger re-seeding for a MEM longer than minSeedLen*FLOAT. This is a key heuristic parameter for tuning the performance. Larger value yields fewer seeds, which leads to faster alignment speed but lower accuracy. [1.5]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-c", "Discard a MEM if it has more than INT occurence in the genome", "mem", "Discard a MEM if it has more than INT occurence in the genome. This is an insensitive parameter. [10000]");
        this.createOptionVar(VariableDescriptor.VariableType.Checked, "-P", "Perform SW in the paired-end mode", "mem", "In the paired-end mode, perform SW to rescue missing hits only but do not try to find hits that fit a proper pair");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-A", "Matching score", "mem", "Matching score. [1]s");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-B", "Mismatch penalty", "mem", "Mismatch penalty. The sequence error rate is approximately: {.75 * exp[-log(4) * B/A]}. [4]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-O", "Gap open penalty", "mem", "Gap open penalty. [6]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-E", "Gap extension penalty", "mem", "Gap extension penalty. A gap of length k costs O + k*E (i.e. -O is for opening a zero-length gap). [1]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-L", "Clipping penalty", "mem", "Clipping penalty. When performing SW extension, BWA-MEM keeps track of the best score reaching the end of query. If this score is larger than the best SW score minus the clipping penalty, clipping will not be applied. Note that in this case, the SAM AS tag reports the best SW score; clipping penalty is not deducted. [5]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-U", "Penalty for an unpaired read pair.", "mem", "Penalty for an unpaired read pair. BWA-MEM scores an unpaired read pair as scoreRead1+scoreRead2-INT and scores a paired as scoreRead1+scoreRead2-insertPenalty. It compares these two scores to determine whether we should force pairing. [9]");
        this.createOptionVar(VariableDescriptor.VariableType.Checked, "-p", "Assume the first input query file is interleaved paired-end FASTA/Q", "mem", "Assume the first input query file is interleaved paired-end FASTA/Q.");
        this.createOptionVar(VariableDescriptor.VariableType.String, "-R", "Complete read group header line", "mem", "Complete read group header line. \u2019\t\u2019 can be used in STR and will be converted to a TAB in the output SAM. The read group ID will be attached to every read in the output. An example is \"@RG\tID:foo\tSM:bar\". [null]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-T", "Don\u2019t output alignment with score lower than INT", "mem", "Don\u2019t output alignment with score lower than INT. This option only affects output. [30]");
        this.createOptionVar(VariableDescriptor.VariableType.Checked, "-a", "Output all found alignments", "mem", "Output all found alignments for single-end or unpaired paired-end reads. These alignments will be flagged as secondary alignments.");
        this.createOptionVar(VariableDescriptor.VariableType.Checked, "-C", "Append append FASTA/Q comment to SAM output", "mem", "Append append FASTA/Q comment to SAM output. This option can be used to transfer read meta information (e.g. barcode) to the SAM output. Note that the FASTA/Q comment (the string after a space in the header line) must conform the SAM spec (e.g. BC:Z:CGTAC). Malformated comments lead to incorrect SAM output.");
        this.createOptionVar(VariableDescriptor.VariableType.Checked, "-H", "Use hard clipping \u2019H\u2019 in the SAM output", "mem", "Use hard clipping \u2019H\u2019 in the SAM output. This option may dramatically reduce the redundancy of output when mapping long contig or BAC sequences.");
        this.createOptionVar(VariableDescriptor.VariableType.Checked, "-M", "Mark shorter split hits as secondary", "mem", "Mark shorter split hits as secondary (for Picard compatibility).");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-a", "Score of a match", "bwasw", "Score of a match. Default [1]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-b", "Mismatch penalty", "bwasw", "Mismatch penalty. Default [3]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-q", "Gap open penalty", "bwasw", "Gap open penalty. Default [5]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-r", "Gap extension penalty", "bwasw", "Gap extension penalty. The penalty for a contiguous gap of size k is q+k*r. Default [2]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-w", "Band width in the banded alignment", "bwasw", "Band width in the banded alignment. Default [33]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-T", "Minimum score threshold divided by a", "bwasw", "Minimum score threshold divided by -a (Score of a match). Default [37]");
        this.createOptionVar(VariableDescriptor.VariableType.Double, "-c", "Coefficient for threshold adjustment according to query length", "bwasw", "Coefficient for threshold adjustment according to query length. Given an l-long query, the threshold for a hit to be retained is a*max{T,c*log(l)}. Default [5.5]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-z", "Z-best heuristics", "bwasw", "Z-best heuristics. Higher -z increases accuracy at the cost of speed. Default [1]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-s", "Maximum SA interval size for initiating a seed", "bwasw", "Maximum SA interval size for initiating a seed. Higher -s increases accuracy at the cost of speed. Default [3]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-N", "Minimum number of seeds supporting the resultant alignment", "bwasw", "Minimum number of seeds supporting the resultant alignment to skip reverse alignment. Default [5]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-a", "Maximum insert size", "sampe", "Maximum insert size for a read pair to be considered being mapped properly. Since 0.4.5, this option is only used when there are not enough good alignment to infer the distribution of insert sizes. [500]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-o", "Maximum occurrences of a read for pairing", "sampe", "Maximum occurrences of a read for pairing. A read with more occurrneces will be treated as a single-end read. Reducing this parameter helps faster pairing. [100000]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-n", "Maximum number of alignments to output in the XA tag for reads paired properly", "sampe", "Maximum number of alignments to output in the XA tag for reads paired properly. If a read has more than INT hits, the XA tag will not be written. [3]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-N", "Maximum number of alignments to output in the XA tag for disconcordant read pairs (excluding singletons)", "sampe", "Maximum number of alignments to output in the XA tag for disconcordant read pairs (excluding singletons). If a read has more than INT hits, the XA tag will not be written. [10]");
        this.createOptionVar(VariableDescriptor.VariableType.String, "-r", "Specify the read group", "sampe", "Specify the read group in a format like \u2018@RG\tID:foo\tSM:bar\u2019. [null]");
        this.createOptionVar(VariableDescriptor.VariableType.Int, "-n", "Maximum number of alignments to output in the XA tag for reads paired properly", "samse", "Maximum number of alignments to output in the XA tag for reads paired properly. If a read has more than INT hits, the XA tag will not be written. [3]");
        this.createOptionVar(VariableDescriptor.VariableType.String, "-r", "Specify the read group", "samse", "Specify the read group in a format like \u2018@RG\tID:foo\tSM:bar\u2019. [null]");
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        VariableDescriptor varConvertToSam = VariableDescriptor.createDescriptorFor((String)OPTION_KEEP_TO_SAM, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varConvertToSam.setVariableName("Keep Sam Files");
        varConvertToSam.setHelpMsg("Output files are coverted to bam format and sam files are deleted by default. If you need to keep the sam files format check this option.");
        this.jobDesc.addVariable(varConvertToSam);
        VariableDescriptor outputVarAcceptedHits = VariableDescriptor.createDescriptorFor((String)OUTPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        outputVarAcceptedHits.setVariableName("aligned Files");
        outputVarAcceptedHits.setHelpMsg("A list of read alignments in Bam format.");
        this.jobDesc.addVariable(outputVarAcceptedHits);
        varOptions = VariableDescriptor.createDescriptorFor((String)OUTPUT_SAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        varOptions.setVariableName("SAM Files");
        varOptions.setHelpMsg("SAM Files.");
        this.jobDesc.addVariable(varOptions);
        PreprocessingFilters.addPrepresoccesingRMFilter(this.jobDesc, outputVarAcceptedHits, this.jobDesc.getVariableDescById(OPTION_RM_FILTER));
        this.initJobFromDesc(this.jobDesc);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_FILE), VariablesRule.Condition.False, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_FASTA_FILE), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_PREFIX), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_ALG), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(INPUT_READS_SIZE), this.getVariable(INPUT_ALN_ALG), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, Short_Read, true);
    }

    private void createOptionVar(VariableDescriptor.VariableType varType, String cmdParmName, String varName, String subProgName, String helpMsg) {
        VariableDescriptor varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)varType, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName(varName);
        varOption.setHelpMsg(helpMsg);
        varOption.setCommandParamater(cmdParmName);
        varOption.setSubProgName(subProgName);
        varOption.setVariableGroup(subProgName);
        this.jobDesc.addVariable(varOption);
    }

    public boolean notifyVarValueChanged(String varKey, String value) {
        try {
            if (varKey.equals(INPUT_READS_SIZE)) {
                if (value.equals(Short_Read)) {
                    ((FileVariable)this.getVariable(INPUT_FILES)).setShowPairingOptions(true);
                } else {
                    ((FileVariable)this.getVariable(INPUT_FILES)).setShowPairingOptions(false);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Error in INPUT_READS_SIZE  " + this.getJobDescID() + ex.getMessage());
        }
        return true;
    }

    public String notifyVarValueChanging(String varKey, String value) {
        try {
            if (varKey.equals(INPUT_INDEX_FILE)) {
                String refIndex = value;
                System.out.println(refIndex);
                String ext = FilenameUtils.getExtension((String)refIndex);
                System.out.println(ext);
                if (ext != null && (ext.equals(".amb") || ext.equals(".ann") || ext.equals(".bwt") || ext.equals(".pac") || ext.equals(".sa"))) {
                    String raw = FilenameUtils.getBasename((String)refIndex, (boolean)true);
                    String path = org.apache.commons.io.FilenameUtils.getPath((String)refIndex);
                    return "/" + path + raw;
                }
                this.getVariable(INPUT_INDEX_FILE).setWarning("May not be a BWA Index File.");
            }
        }
        catch (Exception ex) {
            System.out.println("Error in INPUT_READS_SIZE  " + this.getJobDescID());
        }
        return value;
    }

    protected void generateCommand(StringBuilder command) {
        String createNewIndex = this.getVariable(INPUT_INDEX_CHOICE).$();
        String outputIndexFile = "_outputIndexFile";
        command.append(BashHelper.IF((String)BashConditions.Equal((String)createNewIndex, (String)"true"), (String)("_baseDir=$(dirname \"" + this.getVariable(INPUT_INDEX_FASTA_FILE).$() + "\")\n" + "inputIndexFileBaseName=$(basename " + this.getVariable(INPUT_INDEX_FASTA_FILE).$() + " | cut -d. -f1);\n" + outputIndexFile + "=\"${_baseDir}/${inputIndexFileBaseName}\"\n" + BashHelper.IF((String)this.getVariable(INPUT_INDEX_PREFIX).$(), (String)(String.valueOf(outputIndexFile) + "=\"${_baseDir}/" + this.getVariable(INPUT_INDEX_PREFIX).$() + "\"\n" + "prefixOption=\" -p ${" + outputIndexFile + "}\"\n")) + BashHelper.command_withTrack((String)this.getVariable(INPUT_INDEX_FASTA_FILE).$(), (String)(String.valueOf(Constants.PIPELINE_BWA_EXE) + " index " + " ${prefixOption} -a " + this.getVariable(INPUT_INDEX_ALG).$() + " " + this.getVariable(INPUT_INDEX_FASTA_FILE).$()), (String)(" bwa index build " + this.getVariable(INPUT_INDEX_ALG).$()))), (String)(String.valueOf(outputIndexFile) + "=\"" + this.getVariable(INPUT_INDEX_FILE).$() + "\"\n")));
        command.append("outputFolder=\"" + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\"\n");
        command.append(BashHelper.Batcher_noLog((FileListVariable)((FileListVariable)this.getVariable(INPUT_FILES)), (String)BashHelper.IF((String)(" -z  \"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\" "), (String)"outputFileName=\"${inputFile1BaseName}\"\n", (String)("outputFileName=\"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\"\n")), (String)"", (String)BashHelper.IF((String)(" -z  \"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\" "), (String)"outputFileName=$(hlp_lncName  \"$inputFile1BaseName\" \"$inputFile2BaseName\" )\n[ -z \"${outputFileName}\" ] && outputFileName=\"${inputFile1BaseName}_${inputFile2BaseName}\"\n"), (String)(String.valueOf(this.getVariable(OUTPUT_BAM_FILES).getBashVarName("$_i")) + "=\"${outputFolder}/${outputFileName}.bam\"\n" + this.getVariable(OUTPUT_SAM_FILES).getBashVarName("$_i") + "=\"${outputFolder}/${outputFileName}.sam\"\n" + this.getVariable(OUTPUT_LIBRARY_NAMES).getBashVarName("$_i") + "=\"${outputFileName}\"\n"), (boolean)true));
        String alnCmd = BashHelper.BatcherParallelSingleton((FileListVariable)((FileListVariable)this.getVariable(INPUT_FILES)), (String)("outputFileName=\"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\"\n"), (String)(String.valueOf(Constants.PIPELINE_BWA_EXE) + " aln " + this.getOptionParamatersStrAs$("aln") + "${" + outputIndexFile + "} ${_inputFile1} > ${outputFolder}/${inputFile1BaseName}.bwa \n " + Constants.PIPELINE_BWA_EXE + " samse " + this.getOptionParamatersStrAs$("samse") + "${" + outputIndexFile + "} ${outputFolder}/${inputFile1BaseName}.bwa  ${_inputFile1} > ${outputFolder}/${outputFileName}.sam "), (String)(String.valueOf(Constants.PIPELINE_BWA_EXE) + " aln " + this.getOptionParamatersStrAs$("aln") + "${" + outputIndexFile + "} ${_inputFile1} > ${outputFolder}/${inputFile1BaseName}.bwa \n " + Constants.PIPELINE_BWA_EXE + " aln " + this.getOptionParamatersStrAs$("aln") + " ${" + outputIndexFile + "} ${_inputFile2} > ${outputFolder}/${inputFile2BaseName}.bwa \n " + Constants.PIPELINE_BWA_EXE + " sampe " + this.getOptionParamatersStrAs$("sampe") + " ${" + outputIndexFile + "} ${outputFolder}/${inputFile1BaseName}.bwa ${outputFolder}/${inputFile2BaseName}.bwa  ${_inputFile1} ${_inputFile2} > ${outputFolder}/${outputFileName}.sam "));
        String memCmd = BashHelper.BatcherParallelSingleton((FileListVariable)((FileListVariable)this.getVariable(INPUT_FILES)), (String)("outputFileName=\"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\"\n"), (String)(String.valueOf(Constants.PIPELINE_BWA_EXE) + " mem  " + this.getOptionParamatersStrAs$("mem") + "  ${" + outputIndexFile + "} ${_inputFile1} > ${outputFolder}/${outputFileName}.sam "), (String)(String.valueOf(Constants.PIPELINE_BWA_EXE) + " mem  " + this.getOptionParamatersStrAs$("mem") + " ${" + outputIndexFile + "}   ${_inputFile1} ${_inputFile2} > ${outputFolder}/${outputFileName}.sam "));
        String swCmd = BashHelper.BatcherParallelSingleton((FileListVariable)((FileListVariable)this.getVariable(INPUT_FILES)), (String)("outputFileName=\"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\"\n"), (String)(String.valueOf(Constants.PIPELINE_BWA_EXE) + " bwasw " + this.getOptionParamatersStrAs$("bwasw") + " ${" + outputIndexFile + "} ${_inputFile1} > ${outputFolder}/${outputFileName}.sam "), (String)"");
        String ifShortReadBody = BashHelper.IF((String)("[ \"" + this.getVariable(INPUT_ALN_ALG).$() + "\" =  \"mem\" ]"), (String)memCmd, (String)alnCmd);
        command.append(BashHelper.IF((String)("[ \"" + this.getVariable(INPUT_READS_SIZE).$() + "\" = \"" + Short_Read + "\" ]"), (String)ifShortReadBody, (String)swCmd));
        command.append(BashHelper.BatcherParallelSingleton((FilesVariable)((FilesVariable)this.getVariable(OUTPUT_SAM_FILES)), (String)("outputFileName=\"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\"\n"), (String)(String.valueOf(Tracking.trackLog((String)"Converting Sam file ${outputFileName}.sam to Bam")) + BashHelper.echo((String)"Converting Sam file ${outputFileName}.sam to Bam format.") + "[ -s \"${outputFolder}/${outputFileName}.sam\" ] && samtools view -S -b  \"${outputFolder}/${outputFileName}.sam\"  > \"${outputFolder}/${outputFileName}.bam\"\n" + BashHelper.IF((String)BashConditions.False((JobVariable)this.getVariable(OPTION_KEEP_TO_SAM)), (String)(String.valueOf(Tracking.trackLog((String)"Cleaning: Deleting sam file ${outputFileName}.sam")) + "[ -f \"${outputFolder}/${outputFileName}.sam\" ] && rm \"${outputFolder}/${outputFileName}.sam\" "))), (String)"Convert Sam to Bam"));
        command.append(BashHelper.Batcher_noLog((FilesVariable)((FilesVariable)this.getVariable(OUTPUT_BAM_FILES)), (String)("outputFileName=\"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\"\n" + Tracking.trackLog((String)"Status Check ${outputFileName}.bam") + "[ -s \"${outputFolder}/${outputFileName}.bam\" ] && bamtools stats -in  \"${outputFolder}/${outputFileName}.bam\"  > \"${outputFolder}/${outputFileName}.stats\"\n"), (boolean)true));
        FilesVariable outBamFiles = (FilesVariable)this.getVariable(OUTPUT_BAM_FILES);
        command.append(BashHelper.BatcherParallelSingleton((FilesVariable)outBamFiles, (String)"", (String)BashHelper.If((String)BashConditions.fileExist((String)outBamFiles.$("${_i}"))).Then(String.valueOf(MappingBwaJob.st((String)("samtools sort -o " + outBamFiles.$("${_i}") + ".sorted.bam " + outBamFiles.$("${_i}")))) + MappingBwaJob.st((String)("rm " + outBamFiles.$("${_i}"))) + MappingBwaJob.st((String)("mv " + outBamFiles.$("${_i}") + ".sorted.bam " + outBamFiles.$("${_i}"))) + MappingBwaJob.st((String)("samtools index " + outBamFiles.$("${_i}")))).toString(), (String)"samtools index"));
    }

    protected void generateCommandWrapUp(StringBuilder builder) {
    }
}

