/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.mapping;

import com.biotechvana.shared.jobs.PreprocessingFilters;
import com.biotechvana.utils.Constants;
import com.biotechvana.utils.FilenameUtils;
import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.VariablesRule;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.JobLink;
import com.biotechvana.workflow.descriptors.Publication;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class MappingBowtie2Job
extends WorkflowJob {
    public static final String JOB_ID = "Bowtie2";
    public static final String JOB_NAME = "Bowtie2";
    public static final String INPUT_INDEX_CHOICE = "INPUT_INDEX_CHOICE";
    public static final String INPUT_INDEX_FASTA_FILE = "INDEX_FASTA_FILE";
    public static final String INPUT_INDEX_PREFIX = "INPUT_INDEX_PREFIX";
    public static final String INPUT_INDEX_FILE = "INPUT_INDEX_FILE";
    public static final String INPUT_READS_TYPE = "INPUT_READS_TYPE";
    public static final String INPUT_FASTQ_FILE = "INPUT_FILES";
    public static final String INPUT_MAPPING_ORIENTATION = "INPUT_MAPPING_ORIENTATION";
    public static final String INPUT_MAPPING_MIN_INSERT = "INPUT_MAPPING_MIN_INSERT";
    public static final String INPUT_MAPPING_MAX_INSERT = "INPUT_MAPPING_MAX_INSERT";
    public static final String INPUT_MAPPING_INSERT_SIZE = "INPUT_MAPPING_INSERT_SIZE";
    private static final String OPTION_INPUT_FORMAT = "OPTION_INPUT_FORMAT";
    public static final String OPTION_MODE = "OPTION_MODE";
    private static final String OPTION_PRESENT = "OPTION_PRESENT";
    private static final String OPTION_PRESENT_LOCAL = "OPTION_PRESENT_LOCAL";
    public static final String OUTPUT_LIBRARY_NAMES = "OUTPUT_LIBRARY_NAMES";
    private static final String OPTION_KEEP_TO_SAM = "OPTION_KEEP_SAM";
    public static final String OUTPUT_BAM_FILES = "OUTPUT_FILES";
    public static final String OUTPUT_SAM_FILES = "OUTPUT_SAM_FILES";
    private static final String GROUP_ALIGNMENT = "Alignment";
    private static final String GROUP_PIAR = "Pair End";
    private static final String GROUP_SCORING = "Scoring";
    public static final String OPTION_RM_FILTER = "OPTION_RM";

    public MappingBowtie2Job() {
        this.jobName = "Bowtie2";
        this.jobDesc = new JobDescriptor("Bowtie2");
        this.jobDesc.setDesc("Bowtie 2 is an ultrafast and memory-efficient tool for aligning sequencing reads to long reference sequences particularly good at aligning reads of about 50 up to 100s or 1,000s of characters to relatively long (e.g. mammalian) genomes");
        this.jobDesc.addPublication(new Publication().setAuthors("Langmead B, Salzberg S.L.").setTitle("Fast gapped-read alignment with Bowtie 2").setJournal("Nat Methods").setVolume(9).setYear(2012).setPages("357-359").setDOI("10.1038/nmeth.1923").setPubmed("22388286"));
        this.jobDesc.addLink(new JobLink().setTitle("Bowtie 2").setUrl("http://bowtie-bio.sourceforge.net/bowtie2/manual.shtml").setType(JobLink.LinkType.Manual));
        VariableDescriptor varIndexChioce = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_CHOICE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexChioce.isRequired = true;
        varIndexChioce.setVariableName("Create new index from a Fasta File");
        varIndexChioce.setHelpMsg("Create new one from a Fasta File or Use an exisiting index.");
        varIndexChioce.setDefaultValue("false");
        this.jobDesc.addVariable(varIndexChioce);
        VariableDescriptor varUsedIndexFile = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varUsedIndexFile.isRequired = true;
        varUsedIndexFile.setVariableName("Index File");
        varUsedIndexFile.setShortHelpMsg("Drag an Existing index .bt2 or .bt2l extensions");
        varUsedIndexFile.setHelpMsg("Bowtie2 Indices files end with .bt2 or .bt2l extensions and are build by bowtie2-build program.");
        this.jobDesc.addVariable(varUsedIndexFile);
        VariableDescriptor varIndexFile = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_FASTA_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexFile.isRequired = true;
        varIndexFile.setVariableName("Input Ref Fasta File");
        varIndexFile.setHelpMsg("Reference Fasta file to build a new index.");
        varIndexFile.setShortHelpMsg("Drag  a Fasta file to build a new index.");
        this.jobDesc.addVariable(varIndexFile);
        VariableDescriptor varIndexFilePrefix = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_PREFIX, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexFilePrefix.isRequired = true;
        varIndexFilePrefix.setVariableName("Prefix");
        varIndexFilePrefix.setIsFileName(true);
        varIndexFilePrefix.setHelpMsg("A prefix name for the output index file. Defualt same as the prefix of the input Fasta File Name.");
        this.jobDesc.addVariable(varIndexFilePrefix);
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)INPUT_FASTQ_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input File");
        varReadInputFile.setHelpMsg("Input fastq files to map.");
        varReadInputFile.addAcceptedFileFormat("FASTQ", true, true);
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor varReadMinInsert = VariableDescriptor.createDescriptorFor((String)INPUT_MAPPING_MIN_INSERT, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varReadMinInsert.setVariableName("Min Insert");
        varReadMinInsert.setCommandParamater("-I");
        varReadMinInsert.setHelpMsg("The minimum fragment length for valid paired-end alignments. E.g. if -I 60 is specified and a paired-end alignment consists of two 20-bp alignments in the appropriate orientation with a 20-bp gap between them, that alignment is considered valid (as long as -X is also satisfied). A 19-bp gap would not be valid in that case. If trimming options -3 or -5 are also used, the -I constraint is applied with respect to the untrimmed mates. The larger the difference between -I and -X, the slower Bowtie 2 will run. This is because larger differences bewteen -I and -X require that Bowtie 2 scan a larger window to determine if a concordant alignment exists. For typical fragment length ranges (200 to 400 nucleotides), Bowtie 2 is very efficient. Default: 0 (essentially imposing no minimum)");
        this.jobDesc.addVariable(varReadMinInsert);
        VariableDescriptor varReadMaxInsert = VariableDescriptor.createDescriptorFor((String)INPUT_MAPPING_MAX_INSERT, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varReadMaxInsert.setVariableName("Max Insert");
        varReadMaxInsert.setCommandParamater("-X");
        varReadMaxInsert.setHelpMsg("The maximum fragment length for valid paired-end alignments. E.g. if -X 100 is specified and a paired-end alignment consists of two 20-bp alignments in the proper orientation with a 60-bp gap between them, that alignment is considered valid (as long as -I is also satisfied). A 61-bp gap would not be valid in that case. If trimming options -3 or -5 are also used, the -X constraint is applied with respect to the untrimmed mates, not the trimmed mates. Default: 500.");
        this.jobDesc.addVariable(varReadMaxInsert);
        SelectionListVariableDescriptor varReadOrientation = VariableDescriptor.SelectionList((String)INPUT_MAPPING_ORIENTATION, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varReadOrientation.addOptionValue("fr", "--fr", "fw/rev");
        varReadOrientation.addOptionValue("rf", "--rf", "rev/fw");
        varReadOrientation.addOptionValue("ff", "--ff", "fw/fw");
        varReadOrientation.setVariableName("upstream/downstream mate orientations");
        varReadOrientation.setCommandParamater(" ");
        varReadOrientation.setHelpMsg("The upstream/downstream mate orientations for a valid paired-end alignment against the forward reference strand. E.g., if --fr is specified and there is a candidate paired-end alignment where mate 1 appears upstream of the reverse complement of mate 2 and the fragment length constraints (-I and -X) are met, that alignment is valid. Also, if mate 2 appears upstream of the reverse complement of mate 1 and all other constraints are met, that too is valid. --rf likewise requires that an upstream mate1 be reverse-complemented and a downstream mate2 be forward-oriented. --ff requires both an upstream mate 1 and a downstream mate 2 to be forward-oriented. Default: --fr (appropriate for Illumina's Paired-end Sequencing Assay).");
        this.jobDesc.addVariable((VariableDescriptor)varReadOrientation);
        SelectionListVariableDescriptor varShortReadsType = VariableDescriptor.SelectionList((String)INPUT_READS_TYPE, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varShortReadsType.isRequired = true;
        varShortReadsType.addOptionValue("Single-end");
        varShortReadsType.addOptionValue("Paired-end");
        varShortReadsType.setVariableName("Reads Input Type");
        varShortReadsType.setDefaultIndexValue(0);
        varShortReadsType.setGUIVisible(false);
        this.jobDesc.addVariable((VariableDescriptor)varShortReadsType);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        SelectionListVariableDescriptor varOptionsSelectionList = VariableDescriptor.SelectionList((String)OPTION_INPUT_FORMAT, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptionsSelectionList.addOptionValue("FASTQ", "-q", "Reads are FASTQ files. FASTQ files usually have extension .fq or .fastq. FASTQ is the default format.");
        varOptionsSelectionList.addOptionValue("FASTA", "-f", "Reads are FASTA files. FASTA files usually have extension .fa, .fasta, .mfa, .fna or similar. FASTA files do not have a way of specifying quality values, so when if this option is set, the result is as if --ignore-quals is also set.");
        varOptionsSelectionList.setVariableName("Input Format");
        varOptionsSelectionList.setCommandParamater(" ");
        this.jobDesc.addVariable((VariableDescriptor)varOptionsSelectionList);
        varOptionsSelectionList = VariableDescriptor.SelectionList((String)OPTION_MODE, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptionsSelectionList.addOptionValue("end-to-end", "--end-to-end", "In this mode, Bowtie 2 requires that the entire read align from one end to the other, without any trimming (or \"soft clipping\") of characters from either end. The match bonus --ma always equals 0 in this mode, so all alignment scores are less than or equal to 0, and the greatest possible alignment score is 0. --end-to-end is the default mode.");
        varOptionsSelectionList.addOptionValue("local", "--local", "In this mode, Bowtie 2 does not require that the entire read align from one end to the other. Rather, some characters may be omitted (\"soft clipped\") from the ends in order to achieve the greatest possible alignment score. The match bonus --ma is used in this mode, and the best possible alignment score is equal to the match bonus (--ma) times the length of the read. Specifying --local and one of the presets (e.g. --local --very-fast) is equivalent to specifying the local version of the preset (--very-fast-local). This is mutually exclusive with --end-to-end. --end-to-end is the default mode.");
        varOptionsSelectionList.setVariableName("Alignment Mode");
        varOptionsSelectionList.setHelpMsg("Local mode: does not require that the entire read align from one end to the other.Rather, some characters may be omitted (\"soft clipped\") from the ends in order to achieve the greatest possible alignment score.");
        varOptionsSelectionList.setCommandParamater(" ");
        varOptionsSelectionList.setVariableGroup(GROUP_ALIGNMENT);
        this.jobDesc.addVariable((VariableDescriptor)varOptionsSelectionList);
        varOptionsSelectionList = VariableDescriptor.SelectionList((String)OPTION_PRESENT, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptionsSelectionList.addOptionValue("Fast", "--fast", "Same as:  -D 10 -R 2 -N 0 -L 22 -i S,0,2.50");
        varOptionsSelectionList.addOptionValue("Very fast", "--very-fast", "Same as:  -D 5 -R 1 -N 0 -L 22 -i S,0,2.50");
        varOptionsSelectionList.addOptionValue("Sensitive", "--sensitive", "Same as: -D 15 -R 2 -N 0 -L 22 -i S,1,1.15");
        varOptionsSelectionList.addOptionValue("Very sensitive", "--very-sensitive", "Same as: -D 20 -R 3 -N 0 -L 20 -i S,1,0.50");
        varOptionsSelectionList.setVariableName("Presets End-to-End");
        varOptionsSelectionList.setCommandParamater(" ");
        varOptionsSelectionList.setHelpMsg("Presets for end to end alignment mode.");
        this.jobDesc.addVariable((VariableDescriptor)varOptionsSelectionList);
        varOptionsSelectionList = VariableDescriptor.SelectionList((String)OPTION_PRESENT_LOCAL, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptionsSelectionList.addOptionValue("Fast", "--fast-local", "Same as:  -D 10 -R 2 -N 0 -L 22 -i S,1,1.75");
        varOptionsSelectionList.addOptionValue("Very fast", "--very-fast-local", "Same as:  -D 5 -R 1 -N 0 -L 25 -i S,1,2.00");
        varOptionsSelectionList.addOptionValue("Sensitive", "--sensitive-local", "Same as: -D 15 -R 2 -N 0 -L 20 -i S,1,0.75");
        varOptionsSelectionList.addOptionValue("Very sensitive", "--very-sensitive-local", "Same as: -D 20 -R 3 -N 0 -L 20 -i S,1,0.50");
        varOptionsSelectionList.setVariableName("Presets Local");
        varOptionsSelectionList.setCommandParamater(" ");
        varOptionsSelectionList.setHelpMsg("Presets for local alignment mode.");
        this.jobDesc.addVariable((VariableDescriptor)varOptionsSelectionList);
        VariableDescriptor varOptions = VariableDescriptor.createDescriptorFor((String)OPTION_RM_FILTER, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Double, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Expected Overall alignment rate");
        varOptions.setHelpMsg("Min/Expected overall alignment rate to consider the mapping succesfull. Has no effect of the bahavoiur of The mapper. Used only for managment pipeline and tracking. Default 80");
        varOptions.setDefaultValue("80");
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Suppress unpaired alignments for paired reads");
        varOptions.setHelpMsg("By default, when bowtie2 cannot find a concordant or discordant alignment for a pair, it then tries to find alignments for the individual mates. This option disables that behavior.");
        varOptions.setCommandParamater("--no-mixed");
        varOptions.setVariableGroup(GROUP_PIAR);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Suppress discordant alignments for paired reads");
        varOptions.setHelpMsg("By default, bowtie2 looks for discordant alignments if it cannot find any concordant alignments. A discordant alignment is an alignment where both mates align uniquely, but that does not satisfy the paired-end constraints (--fr/--rf/--ff, -I, -X). This option disables that behavior.");
        varOptions.setCommandParamater("--no-discordant");
        varOptions.setVariableGroup(GROUP_PIAR);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Not concordant when mates extend past each other");
        varOptions.setHelpMsg("If the mates \"dovetail\", that is if one mate alignment extends past the beginning of the other such that the wrong mate begins upstream, consider that to be concordant. See also: Mates can overlap, contain or dovetail each other. Default: mates cannot dovetail in a concordant alignment.");
        varOptions.setCommandParamater("--dovetail");
        varOptions.setVariableGroup(GROUP_PIAR);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Not concordant when one mate alignment contains other");
        varOptions.setHelpMsg("If one mate alignment contains the other, consider that to be non-concordant. See also: Mates can overlap, contain or dovetail each other. Default: a mate can contain the other in a concordant alignment.");
        varOptions.setCommandParamater("--no-contain");
        varOptions.setVariableGroup(GROUP_PIAR);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Not concordant when mates overlap at all");
        varOptions.setHelpMsg("If one mate alignment overlaps the other at all, consider that to be non-concordant. See also: Mates can overlap, contain or dovetail each other. Default: mates can overlap in a concordant alignment.");
        varOptions.setCommandParamater("--no-overlap");
        varOptions.setVariableGroup(GROUP_PIAR);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Max # of mismatches in seed alignment");
        varOptions.setHelpMsg("Sets the Max number of mismatches allowed in a seed alignment during multiseed alignment. Can be set to 0 or 1. Setting this higher makes alignment slower (often much slower) but increases sensitivity. Default: 0");
        varOptions.setCommandParamater("-N");
        varOptions.setVariableGroup(GROUP_ALIGNMENT);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Length of seed substrings");
        varOptions.setHelpMsg("Sets the length of the seed substrings to align during multiseed alignment. Smaller values make alignment slower but more sensitive. Default: the --sensitive preset is used by default, which sets -L to 20 both in --end-to-end mode and in --local mode. Must be > 3 and < 32. Default (22)");
        varOptions.setCommandParamater("-L");
        varOptions.setVariableGroup(GROUP_ALIGNMENT);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Interval between seed substrings w/r/t read len");
        varOptions.setHelpMsg("Sets a function governing the interval between seed substrings to use during multiseed alignment. Default (S,1,1.15)");
        varOptions.setCommandParamater("-i");
        varOptions.setVariableGroup(GROUP_ALIGNMENT);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Func for max # non-A/C/G/Ts permitted in Alignment");
        varOptions.setHelpMsg("Sets a function governing the maximum number of ambiguous characters (usually Ns and/or .s) allowed in a read as a function of read length. For instance, specifying -L,0,0.15 sets the N-ceiling function f to f(x) = 0 + 0.15 * x, where x is the read length. See also: setting function options. Reads exceeding this ceiling are filtered out. Default (L,0,0.15)");
        varOptions.setCommandParamater("--n-ceil");
        varOptions.setVariableGroup(GROUP_ALIGNMENT);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Number of extr ref char");
        varOptions.setHelpMsg("Pads dynamic programming problems by <int> columns on either side to allow gaps. Default (15)");
        varOptions.setCommandParamater("--dpad");
        varOptions.setVariableGroup(GROUP_ALIGNMENT);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Disallow gaps within <int> nucs of read extremes");
        varOptions.setHelpMsg("Disallow gaps within <int> nucs of read extremes. Default (4)");
        varOptions.setCommandParamater("--gbar");
        varOptions.setVariableGroup(GROUP_ALIGNMENT);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Treat all quality values as 30 on Phred scale");
        varOptions.setHelpMsg("When calculating a mismatch penalty, always consider the quality value at the mismatched position to be the highest possible, regardless of the actual value. I.e. input is treated as though all quality values are high. This is also the default behavior when the input doesn't specify quality values (e.g. in -f, -r, or -c modes)");
        varOptions.setCommandParamater("--ignore-quals");
        varOptions.setVariableGroup(GROUP_ALIGNMENT);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Do not align forward (original) version of read");
        varOptions.setHelpMsg("Bowtie2 will not attempt to align unpaired reads to the forward (Watson) reference strand.");
        varOptions.setCommandParamater("--nofw");
        varOptions.setVariableGroup(GROUP_ALIGNMENT);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Do not align reverse-complement version of read");
        varOptions.setHelpMsg("bowtie2 will not attempt to align unpaired reads against the reverse-complement (Crick) reference strand. In paired-end mode, --nofw and --norc pertain to the fragments; i.e. specifying --nofw causes bowtie2 to explore only those paired-end configurations corresponding to fragments from the reverse-complement (Crick) strand.");
        varOptions.setCommandParamater("--norc");
        varOptions.setVariableGroup(GROUP_ALIGNMENT);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Do not allow 1 mismatch alignments before attempting to scan for the optimal seeded alignments");
        varOptions.setHelpMsg("By default, Bowtie 2 will attempt to find either an exact or a 1-mismatch end-to-end alignment for the read before trying the multiseed heuristic. Such alignments can be found very quickly, and many short read alignments have exact or near-exact end-to-end alignments. However, this can lead to unexpected alignments when the user also sets options governing the multiseed heuristic, like -L and -N. For instance, if the user specifies -N 0 and -L equal to the length of the read, the user will be surprised to find 1-mismatch alignments reported. This option prevents Bowtie 2 from searching for 1-mismatch end-to-end alignments before using the multiseed heuristic, which leads to the expected behavior when combined with options such as -L and -N. This comes at the expense of speed.");
        varOptions.setCommandParamater("no-1mm-upfront");
        varOptions.setVariableGroup(GROUP_ALIGNMENT);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Match bonus");
        varOptions.setHelpMsg("Sets the match bonus. In --local mode <int> is added to the alignment score for each position where a read character aligns to a reference character and the characters match. Not used in --end-to-end mode. Default: 2.");
        varOptions.setCommandParamater("--ma");
        varOptions.setVariableGroup(GROUP_SCORING);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Max penalty for mismatch MX,MN ");
        varOptions.setHelpMsg("Sets the maximum (MX) and minimum (MN) mismatch penalties, both integers. A number less than or equal to MX and greater than or equal to MN is subtracted from the alignment score for each position where a read character aligns to a reference character, the characters do not match, and neither is an N. If --ignore-quals is specified, the number subtracted quals MX. Otherwise, the number subtracted is MN + floor( (MX-MN)(MIN(Q, 40.0)/40.0) ) where Q is the Phred quality value. Default: MX = 6, MN = 2.. Default (6)");
        varOptions.setCommandParamater("--mp");
        varOptions.setVariableGroup(GROUP_SCORING);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Penalty for non-A/C/G/Ts in read/ref");
        varOptions.setHelpMsg("Sets penalty for positions where the read, reference, or both, contain an ambiguous character such as N. Default (1)");
        varOptions.setCommandParamater("--np");
        varOptions.setVariableGroup(GROUP_SCORING);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Read gap open, extend penalties <int1>,<int2>");
        varOptions.setHelpMsg("Sets the read gap open (<int1>) and extend (<int2>) penalties. A read gap of length N gets a penalty of <int1> + N * <int2>. Default (5,3)");
        varOptions.setCommandParamater("--rdg");
        varOptions.setVariableGroup(GROUP_SCORING);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Reference gap open, extend penalties <int1>,<int2>");
        varOptions.setHelpMsg("Sets the reference gap open (<int1>) and extend (<int2>) penalties. A reference gap of length N gets a penalty of <int1> + N * <int2>. Default (5.3)");
        varOptions.setCommandParamater("--rfg");
        varOptions.setVariableGroup(GROUP_SCORING);
        this.jobDesc.addVariable(varOptions);
        varOptions = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOptions.setVariableName("Min acceptable alignment score w/r/t read length");
        varOptions.setHelpMsg("Sets a function governing the minimum alignment score needed for an alignment to be considered valid (i.e. good enough to report). This is a function of read length. For instance, specifying L,0,-0.6 sets the minimum-score function f to f(x) = 0 + -0.6 * x, where x is the read length. See also: setting function options. Default ( G,20,8 for local, L,-0.6,-0.6 for end-to-end)");
        varOptions.setCommandParamater("--score-min");
        varOptions.setVariableGroup(GROUP_SCORING);
        this.jobDesc.addVariable(varOptions);
        VariableDescriptor varConvertToSam = VariableDescriptor.createDescriptorFor((String)OPTION_KEEP_TO_SAM, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varConvertToSam.setVariableName("Keep Sam Files.");
        varConvertToSam.setHelpMsg("Output files are coverted to bam format and sam files are deleted by default. If you need to keep the sam files format check this option.");
        this.jobDesc.addVariable(varConvertToSam);
        VariableDescriptor outputVarAcceptedHits = VariableDescriptor.createDescriptorFor((String)OUTPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        outputVarAcceptedHits.setVariableName("aligned Files");
        outputVarAcceptedHits.setHelpMsg("A list of read alignments in Bam format.");
        this.jobDesc.addVariable(outputVarAcceptedHits);
        varOptions = VariableDescriptor.createDescriptorFor((String)OUTPUT_SAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        varOptions.setVariableName("SAM Files");
        varOptions.setHelpMsg("SAM Files.");
        this.jobDesc.addVariable(varOptions);
        VariableDescriptor outputVarLibraryName = VariableDescriptor.createDescriptorFor((String)OUTPUT_LIBRARY_NAMES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        outputVarLibraryName.setVariableName("Library Names");
        outputVarLibraryName.setHelpMsg("Library Names");
        outputVarLibraryName.setGUIVisible(false);
        this.jobDesc.addVariable(outputVarLibraryName);
        PreprocessingFilters.addPrepresoccesingRMFilter(this.jobDesc, outputVarAcceptedHits, this.jobDesc.getVariableDescById(OPTION_RM_FILTER));
        this.initJobFromDesc(this.jobDesc);
        if (((FileVariable)this.getVariable(INPUT_FASTQ_FILE)).getIsPairedFiles()) {
            this.getVariable(INPUT_READS_TYPE).setValue("Paired-end");
        }
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_FILE), VariablesRule.Condition.False, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(INPUT_READS_TYPE), this.getVariable(INPUT_MAPPING_MIN_INSERT), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, "Paired-end");
        new VariablesRule(this.getVariable(INPUT_READS_TYPE), this.getVariable(INPUT_MAPPING_MAX_INSERT), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, "Paired-end");
        new VariablesRule(this.getVariable(INPUT_READS_TYPE), this.getVariable(INPUT_MAPPING_ORIENTATION), VariablesRule.Condition.EqualTo, VariablesRule.Action.Enable, "Paired-end");
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_FASTA_FILE), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_PREFIX), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
    }

    public boolean notifyVarValueChanged(String varKey, String value) {
        try {
            if (varKey.equals(INPUT_FASTQ_FILE)) {
                if (((FileVariable)this.getVariable(INPUT_FASTQ_FILE)).getIsPairedFiles()) {
                    this.getVariable(INPUT_READS_TYPE).setValue("Paired-end");
                } else {
                    this.getVariable(INPUT_READS_TYPE).setValue("Single-end");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public String notifyVarValueChanging(String varKey, String value) {
        try {
            if (varKey.equals(INPUT_INDEX_FILE)) {
                String refIndex = value;
                String ext = FilenameUtils.getExtension((String)refIndex);
                if (ext != null && (ext.equals(".bt2") || ext.equals(".bt") || ext.equals(".bt2l"))) {
                    String raw = FilenameUtils.getBasename((String)refIndex, (boolean)true);
                    raw = FilenameUtils.getBasename((String)raw, (boolean)true);
                    String path = org.apache.commons.io.FilenameUtils.getPath((String)refIndex);
                    return "/" + path + raw;
                }
                this.getVariable(INPUT_INDEX_FILE).setWarning("May not be a Bowtie Index File.");
            }
        }
        catch (Exception ex) {
            System.out.println("notifyVarValueChanging Error in " + varKey + "  " + this.getJobDescID());
        }
        return value;
    }

    public boolean isValid() {
        boolean valid = super.isValid();
        return valid;
    }

    protected void generateCommand(StringBuilder command) {
        String indexCreateProg = String.valueOf(Constants.PIPELINE_BASE_PATH) + "bowtie2-build -q ";
        String createNewIndex = this.getVariable(INPUT_INDEX_CHOICE).$();
        String outputIndexFile = "_outputIndexFile";
        command.append(BashHelper.IF((String)BashConditions.Equal((String)createNewIndex, (String)"true"), (String)("_baseDir=$(dirname \"" + this.getVariable(INPUT_INDEX_FASTA_FILE).$() + "\")\n" + "inputIndexFileBaseName=" + BashHelper.getBaseName((JobVariable)this.getVariable(INPUT_INDEX_FASTA_FILE)) + outputIndexFile + "=\"${_baseDir}/${inputIndexFileBaseName}\"\n" + BashHelper.IF((String)this.getVariable(INPUT_INDEX_PREFIX).$(), (String)(String.valueOf(outputIndexFile) + "=\"${_baseDir}/" + this.getVariable(INPUT_INDEX_PREFIX).$() + "\"\n")) + "prefixOption=\"  ${" + outputIndexFile + "}\"\n" + BashHelper.command_withTrack((String)this.getVariable(INPUT_INDEX_FASTA_FILE).$(), (String)(String.valueOf(indexCreateProg) + this.getVariable(INPUT_INDEX_FASTA_FILE).$() + " ${prefixOption} "), (String)"bowtie2-build Reference Index")), (String)(String.valueOf(outputIndexFile) + "=\"" + this.getVariable(INPUT_INDEX_FILE).$() + "\"\n")));
        command.append("set -o pipefail \n");
        command.append("outputFolder=\"" + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\"\n");
        command.append("[ -d \"${outputFolder}/align_summary\" ] ||  mkdir \"${outputFolder}/align_summary\" \n");
        command.append(BashHelper.Batcher_noLog((FileListVariable)((FileListVariable)this.getVariable(INPUT_FASTQ_FILE)), (String)BashHelper.IF((String)(" -z  \"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\" "), (String)"outputFileName=\"${inputFile1BaseName}\"\n", (String)("outputFileName=\"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\"\n")), (String)"", (String)BashHelper.IF((String)(" -z  \"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\" "), (String)"outputFileName=$(hlp_lncName  \"$inputFile1BaseName\" \"$inputFile2BaseName\" )\n[ -z \"${outputFileName}\" ] && outputFileName=\"${inputFile1BaseName}_${inputFile2BaseName}\"\n"), (String)(String.valueOf(this.getVariable(OUTPUT_BAM_FILES).getBashVarName("$_i")) + "=\"${outputFolder}/${outputFileName}.bam\"\n" + this.getVariable(OUTPUT_SAM_FILES).getBashVarName("$_i") + "=\"${outputFolder}/${outputFileName}.sam\"\n" + this.getVariable(OUTPUT_LIBRARY_NAMES).getBashVarName("$_i") + "=\"${outputFileName}\"\n"), (boolean)true));
        command.append(BashHelper.BatcherParallelSingleton((FileListVariable)((FileListVariable)this.getVariable(INPUT_FASTQ_FILE)), (String)("outputFileName=\"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\"\n"), (String)("echo \"Running Bowtie2 for : ${_inputFile1}\"\n" + Constants.PIPELINE_BOWTIE2_EXE + this.getOptionParamatersStrAs$() + " -S \"${outputFolder}/${outputFileName}.sam\" -x ${_outputIndexFile} -U ${_inputFile1} |& tee  \"${outputFolder}/align_summary/${outputFileName}_align_summary.txt\" \n"), (String)("echo \"Running Bowtie2 for : ${_inputFile1},${_inputFile2}\"\n" + Constants.PIPELINE_BOWTIE2_EXE + this.getOptionParamatersStrAs$() + " -S \"${outputFolder}/${outputFileName}.sam\" -x ${_outputIndexFile} -1 ${_inputFile1}  -2  ${_inputFile2}  |& tee   \"${outputFolder}/align_summary/${outputFileName}_align_summary.txt\"  \n")));
        command.append("set +o pipefail \n");
        command.append(BashHelper.BatcherParallelSingleton((FilesVariable)((FilesVariable)this.getVariable(OUTPUT_SAM_FILES)), (String)("outputFileName=\"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\"\n"), (String)(String.valueOf(Tracking.trackLog((String)"Converting Sam file ${outputFileName}.sam to Bam")) + BashHelper.echo((String)"Converting Sam file ${outputFileName}.sam to Bam format.") + "[ -s \"${outputFolder}/${outputFileName}.sam\" ] && samtools view -S -b  \"${outputFolder}/${outputFileName}.sam\"  > \"${outputFolder}/${outputFileName}.bam\"\n" + BashHelper.IF((String)BashConditions.False((JobVariable)this.getVariable(OPTION_KEEP_TO_SAM)), (String)(String.valueOf(Tracking.trackLog((String)"Cleaning: Deleting sam file ${outputFileName}.sam")) + "[ -f \"${outputFolder}/${outputFileName}.sam\" ] && rm \"${outputFolder}/${outputFileName}.sam\" "))), (String)"Convert Sam to Bam"));
        FilesVariable outBamFiles = (FilesVariable)this.getVariable(OUTPUT_BAM_FILES);
        command.append(BashHelper.BatcherParallelSingleton((FilesVariable)outBamFiles, (String)"", (String)BashHelper.If((String)BashConditions.fileExist((String)outBamFiles.$("${_i}"))).Then(String.valueOf(MappingBowtie2Job.st((String)("samtools sort -o " + outBamFiles.$("${_i}") + ".sorted.bam " + outBamFiles.$("${_i}")))) + MappingBowtie2Job.st((String)("rm " + outBamFiles.$("${_i}"))) + MappingBowtie2Job.st((String)("mv " + outBamFiles.$("${_i}") + ".sorted.bam " + outBamFiles.$("${_i}"))) + MappingBowtie2Job.st((String)("samtools index " + outBamFiles.$("${_i}")))).toString(), (String)"samtools index"));
    }

    protected String getFilterCheckCommand() {
        String checkLevel = Tracking.TrackCheckLevels.Fail.toString();
        if (this.getParent() == null) {
            checkLevel = Tracking.TrackCheckLevels.Warning.toString();
        }
        String filterName = "RM";
        String statusVar = "_g_filter_status";
        String cmdCheck = "";
        cmdCheck = String.valueOf(cmdCheck) + "dARate=\"" + this.getVariable(OPTION_RM_FILTER).$() + "\"\n";
        cmdCheck = String.valueOf(cmdCheck) + "[ -n \"${dARate}\" ] ||  dARate=\"80\" \n";
        cmdCheck = String.valueOf(cmdCheck) + BashHelper.Batcher_noLog((FileListVariable)((FileListVariable)this.getVariable(INPUT_FASTQ_FILE)), (String)("outputFileName=\"" + this.getVariable(OUTPUT_LIBRARY_NAMES).$("$_i") + "\"\n" + "fileNames=\"${_inputFile1}\"\n"), (String)"", (String)"fileNames=\"${fileNames},${_inputFile2}\"\n", (String)("allRes=$(cat  \"${outputFolder}/align_summary/${outputFileName}_align_summary.txt\")\nallRes=${allRes//%/%%}\nprintf \"A summary of the alignment counts:\\n\"\nprintf \"$allRes\\n\\n\"\nalignRes=$(grep  \"overall alignment\" \"${outputFolder}/align_summary/${outputFileName}_align_summary.txt\")\nIFS=\"%\" read -r -a fres <<< \"$alignRes\"\naRate=${fres[0]}\n[ -n \"${aRate}\" ] || aRate=\"0\"\ncom=$(echo $aRate\">=\"$dARate | bc -l)\n" + BashHelper.IF((String)"[ com -eq 0 ]", (String)(String.valueOf(Tracking.trackLogCheck((String)"${fileNames}", (String)filterName, (Tracking.TrackCheckType)Tracking.TrackCheckType.Filter, (String)checkLevel, (String)"Overall Alignment rate ${aRate} is less than defined threshold $dARate")) + BashHelper.assign((String)statusVar, (String)checkLevel)), (String)Tracking.trackLogCheck((String)"${fileNames}", (String)filterName, (Tracking.TrackCheckType)Tracking.TrackCheckType.Filter, (Tracking.TrackCheckLevels)Tracking.TrackCheckLevels.Pass, (String)"Overall Alignment rate ${aRate} is Ok"))));
        return cmdCheck;
    }
}

