/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.fileExplorerBasic.jobs;

import com.biotechvana.fileExplorerBasic.FileExplorerBasic;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.ui.di.UISynchronize;

public class PasteFilesJob
extends Job {
    private FileExplorerBasic fileExplorer;

    public PasteFilesJob(String name, final FileExplorerBasic fileExplorer) {
        super(name);
        final UISynchronize sync = (UISynchronize)fileExplorer.getMPart().getContext().get(UISynchronize.class);
        this.fileExplorer = fileExplorer;
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                sync.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (fileExplorer.getCut()) {
                            File[] selectedFiles = fileExplorer.getSelectedFilesCut();
                            if (selectedFiles != null) {
                                try {
                                    fileExplorer.deleteNodes(selectedFiles, (IProgressMonitor)new NullProgressMonitor());
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            fileExplorer.setCut(false);
                        }
                    }
                });
            }
        });
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.fileExplorer.paste(super.getName(), monitor);
        monitor.done();
        return Status.OK_STATUS;
    }
}

