/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.fileExplorerBasic;

import com.biotechvana.utils.AlphanumComparator;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class FileExplorerContentProvider
implements ITreeContentProvider {
    private Collator col = Collator.getInstance();
    private AlphanumComparator alphanumComparator = new AlphanumComparator();
    private String workspacePath;
    private String workspaceName;
    private TreeViewer fileExplorer;

    public FileExplorerContentProvider(File workspace, TreeViewer fileExplorer) {
        this.fileExplorer = fileExplorer;
        this.workspacePath = workspace.getParent();
        this.workspaceName = workspace.getName();
        this.col.setStrength(0);
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<File> fileList = new ArrayList<File>();
        File[] children = ((File)parentElement).listFiles();
        this.col.setStrength(0);
        String parentPath = ((File)parentElement).getAbsolutePath();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File item = fileArray[n2];
                if (parentPath.compareToIgnoreCase(this.workspacePath) == 0) {
                    if (item.getName().compareToIgnoreCase(this.workspaceName) == 0) {
                        fileList.add(item);
                    }
                } else {
                    fileList.add(item);
                }
                ++n2;
            }
            Collections.sort(fileList, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    if (o1.isDirectory() && !o2.isDirectory()) {
                        return -1;
                    }
                    if (!o1.isDirectory() && o2.isDirectory()) {
                        return 1;
                    }
                    if (FileExplorerContentProvider.this.hasNumbers(o1.getName()) || FileExplorerContentProvider.this.hasNumbers(o2.getName())) {
                        return FileExplorerContentProvider.this.alphanumComparator.compare((Object)o1.getName().toUpperCase(), (Object)o2.getName().toUpperCase());
                    }
                    return FileExplorerContentProvider.this.col.compare(o1.getName(), o2.getName());
                }
            });
            return fileList.toArray();
        }
        return new Object[0];
    }

    private boolean hasNumbers(String text) {
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) >= '0' && text.charAt(i) <= '9') {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object getParent(Object element) {
        return new File(element.toString()).getParent();
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

