/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.postprocessing.picard;

import com.biotechvana.variantseq.jobs.PicardHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.JobLink;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileVariable;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class CoverageAnalysisJob
extends ISWFJob {
    public static final String JOB_ID = "coverage";
    public static final String JOB_NAME = "Coverage Analysis";
    public static final String INPUT_BED_FILE = "INPUT_BED_FILE";
    private static final String OUTPUT_HIST_FILES = "OUTPUT_HIST_FILES";
    private static final String OUTPUT_UNSEQ_TARGETS_FILES = "OUTPUT_UNSEQ_TARGETS_FILES";

    public CoverageAnalysisJob() {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc("Coverage Analysis using Bedtools");
        this.jobDesc.addLink(new JobLink().setTitle("Bedtools").setUrl("https://bedtools.readthedocs.io/en/latest/").setType(JobLink.LinkType.Manual));
    }

    protected void createInputs() {
        VariableDescriptor varReadInputFile = PicardHelper.createInputBamFilesVar();
        this.jobDesc.addVariable(varReadInputFile);
        VariableDescriptor inputVar = VariableDescriptor.createDescriptorFor((String)INPUT_BED_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        inputVar.setVariableName("Input intervals bed file");
        inputVar.setHelpMsg("Input intervals in bed format");
        this.jobDesc.addVariable(inputVar);
    }

    protected void createOutputs() {
        VariableDescriptor bamOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_UNSEQ_TARGETS_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        bamOutputFile.isRequired = true;
        bamOutputFile.setVariableName("unsequenced targets list Files");
        bamOutputFile.setHelpMsg("unsequenced targets list Files");
        this.jobDesc.addVariable(bamOutputFile);
        VariableDescriptor metricsOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_HIST_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        metricsOutputFile.isRequired = true;
        metricsOutputFile.setVariableName("hist Files");
        metricsOutputFile.setHelpMsg("hist Files");
        this.jobDesc.addVariable(metricsOutputFile);
    }

    protected void createOptions() {
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefix = "bedtools ";
        FilesVariable inputBamFilesVar = (FilesVariable)this.getVariable(VariantAnaylsisVariableBag.INPUT_BAM_FILES);
        FileVariable inputBedFile = (FileVariable)this.getVariable(INPUT_BED_FILE);
        FilesVariable outputHISTFilesVar = (FilesVariable)this.getVariable(OUTPUT_HIST_FILES);
        FilesVariable outpuUNSEQFilesVar = (FilesVariable)this.getVariable(OUTPUT_UNSEQ_TARGETS_FILES);
        builder.append(BashHelper.BatcherParallelSingleton((FilesVariable)inputBamFilesVar, (String)(CoverageAnalysisJob.st((String)BashHelper.arrayAdd((JobVariable)outputHISTFilesVar, (String)"${outputFolder}/${inputFileBaseName}.hist")) + CoverageAnalysisJob.st((String)BashHelper.arrayAdd((JobVariable)outpuUNSEQFilesVar, (String)"${outputFolder}/${inputFileBaseName}.unsequenced.targets.list"))), (String)(CoverageAnalysisJob.st((String)(cmdPrefix + " coverage -hist " + this.getOptionParamatersStrAs$() + "  -b ${_inputFile}  -a " + inputBedFile.$() + " > ${outputFolder}/${inputFileBaseName}_coverage.txt")) + CoverageAnalysisJob.st((String)("grep ^all  ${outputFolder}/${inputFileBaseName}_coverage.txt  > " + outputHISTFilesVar.$("${_i}"))) + CoverageAnalysisJob.st((String)(cmdPrefix + " genomecov  " + this.getOptionParamatersStrAs$() + "  -ibam ${_inputFile}  -bga | awk-4==0   > ${outputFolder}/${inputFileBaseName}.uncoverage.txt")) + CoverageAnalysisJob.st((String)(cmdPrefix + " intersect  " + this.getOptionParamatersStrAs$() + "  -b ${outputFolder}/${inputFileBaseName}.uncoverage.txt -a " + inputBedFile.$() + " > " + outpuUNSEQFilesVar.$("${_i}")))), (String)"Bedtools Coverage"));
        builder.append(BashHelper.command_withTrack((String)"${outputFolder}", (String)(CoverageAnalysisJob.st((String)"cd ${outputFolder}") + CoverageAnalysisJob.st((String)"plot_coverage.R ")), (String)"Plot Coverage"));
    }
}

