/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs.filtering.gatk;

import com.biotechvana.variantseq.jobs.GATKHelper;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.CmdListMergeStrategy;
import com.biotechvana.workflow.ISWFJob;
import com.biotechvana.workflow.descriptors.IntVariableDescriptor;
import com.biotechvana.workflow.descriptors.StringsVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class GATKVariantFiltrationJob
extends ISWFJob {
    public static final String JOB_ID = "variantFiltration";
    public static final String JOB_NAME = "GATK - VariantFiltration";
    public static final String INPUT_VCF_FILES = "INPUT_VARIANTS_VCF";
    public static final String OUTPUT_VCF_FILES = "OUTPUT_VARIANTS_VCF";
    public static final String INPUT_REF_FASTA = VariantAnaylsisVariableBag.INPUT_REF_FASTA;

    public GATKVariantFiltrationJob() {
        super(JOB_ID, JOB_NAME);
        GATKHelper.addToolGroup(this.jobDesc);
        this.jobDesc.setDesc("Filter variant calls based on INFO and/or FORMAT annotations");
        this.jobDesc.setRef(GATKHelper.getCitation(GATKHelper.getManualPage("VariantFiltration", "org_broadinstitute_hellbender_tools_walkers_filters_VariantFiltration.php")));
    }

    protected void createInputs() {
        VariableDescriptor varReferenceFasta = GATKHelper.createReferenceVar();
        varReferenceFasta.isRequired = false;
        this.jobDesc.addVariable(varReferenceFasta);
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)INPUT_VCF_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input VCF Files");
        varReadInputFile.setHelpMsg("Input VCF Files.");
        varReadInputFile.addAcceptedFileFormat("VCF");
        this.jobDesc.addVariable(varReadInputFile);
    }

    protected void createOutputs() {
        VariableDescriptor variantOutputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_VCF_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        variantOutputFile.setVariableName("Filtered Variants vcf");
        variantOutputFile.setHelpMsg("variant calls output vcf files");
        this.jobDesc.addVariable(variantOutputFile);
    }

    protected void createOptions() {
        StringsVariableDescriptor optionalVarStrings = VariableDescriptor.Strings((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVarStrings.isRequired = true;
        optionalVarStrings.setVariableName("Filter Expression:");
        optionalVarStrings.setHelpMsg("One or more expression used with INFO fields to filter.");
        optionalVarStrings.setCommandParamater("--filter-expression");
        optionalVarStrings.setCommandParamaterAlt("-filter");
        optionalVarStrings.setCmdListMergerQuate("\"");
        optionalVarStrings.setCmdListMergeStrategy(CmdListMergeStrategy.Repeat);
        this.jobDesc.addVariable((VariableDescriptor)optionalVarStrings);
        optionalVarStrings = VariableDescriptor.Strings((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVarStrings.setVariableName("Names to use for the list of filters:");
        optionalVarStrings.setHelpMsg("Names to use for the list of filters.");
        optionalVarStrings.setCommandParamater("--filter-name");
        optionalVarStrings.setCmdListMergerQuate("\"");
        optionalVarStrings.setCmdListMergeStrategy(CmdListMergeStrategy.Repeat);
        this.jobDesc.addVariable((VariableDescriptor)optionalVarStrings);
        optionalVarStrings = VariableDescriptor.Strings((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVarStrings.setVariableName("Genotype Filter Expression:");
        optionalVarStrings.setHelpMsg("One or more expressions used with FORMAT (sample/genotype-level) fields to filter.");
        optionalVarStrings.setCommandParamater("--genotype-filter-expression");
        optionalVarStrings.setCommandParamaterAlt("-G-filter");
        optionalVarStrings.setCmdListMergerQuate("\"");
        optionalVarStrings.setCmdListMergeStrategy(CmdListMergeStrategy.Repeat);
        this.jobDesc.addVariable((VariableDescriptor)optionalVarStrings);
        optionalVarStrings = VariableDescriptor.Strings((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVarStrings.setVariableName("Names to use for the list of sample/genotype filters:");
        optionalVarStrings.setHelpMsg("Names to use for the list of sample/genotype filters (must be a 1-to-1 mapping); this name is put in the FILTER field for variants that get filtered");
        optionalVarStrings.setCommandParamater("--genotype-filter-name");
        optionalVarStrings.setCmdListMergerQuate("\"");
        optionalVarStrings.setCmdListMergeStrategy(CmdListMergeStrategy.Repeat);
        this.jobDesc.addVariable((VariableDescriptor)optionalVarStrings);
        IntVariableDescriptor optionalVarInt = VariableDescriptor.Int((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVarInt.setVariableName("Cluster Size");
        optionalVarInt.setCommandParamater("--cluster-size");
        optionalVarInt.setCommandParamaterAlt("-cluster");
        optionalVarInt.setMinValue(2.0);
        optionalVarInt.setHelpMsg("The number of SNPs which make up a cluster. Must be at least 2. Default 3");
        this.jobDesc.addVariable((VariableDescriptor)optionalVarInt);
        VariableDescriptor optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Cluster window size");
        optionalVar.setCommandParamater("--cluster-window-size");
        optionalVar.setCommandParamaterAlt("-window");
        optionalVar.setHelpMsg("The window size (in bases) in which to evaluate clustered SNPs. Default 0");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Filter records NOT in given input mask");
        optionalVar.setCommandParamater("--filter-not-in-mask");
        optionalVar.setHelpMsg("By default, if the --mask argument is used, any variant falling in a mask will be filtered. If this argument is used, logic is reversed, and variants falling outside a given mask will be filtered. Use case is, for example, if we have an interval list or BED file with \"good\" sites. Note that it is up to the user to adapt the name of the mask to make it clear that the reverse logic was used (e.g. if masking against Hapmap, use --mask-name=hapmap for the normal masking and --mask-name=not_hapmap for the reverse masking).");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Remove previous filters applied to the VCF");
        optionalVar.setCommandParamater("--invalidate-previous-filters");
        optionalVar.setHelpMsg(" Invalidate previous filters applied to the VariantContext, applying only the filters here");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Invert the selection criteria for --filter-expression");
        optionalVar.setCommandParamater("--invert-filter-expression");
        optionalVar.setCommandParamaterAlt("-invfilter");
        optionalVar.setHelpMsg("Invert the selection criteria for --filter-expression");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Invert the selection criteria for --genotype-filter-expression");
        optionalVar.setCommandParamater("--invert-genotype-filter-expression");
        optionalVar.setCommandParamaterAlt("-invG-filter");
        optionalVar.setHelpMsg("Invert the selection criteria for --genotype-filter-expression");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("When evaluating the JEXL expressions, missing values should be considered failing the expression");
        optionalVar.setCommandParamater("--missing-values-evaluate-as-failing");
        optionalVar.setHelpMsg("When evaluating the JEXL expressions, missing values should be considered failing the expression");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Set filtered genotypes to no-call");
        optionalVar.setCommandParamater("--set-filtered-genotype-to-no-call");
        optionalVar.setHelpMsg("Set filtered genotypes to no-call");
        this.jobDesc.addVariable(optionalVar);
        optionalVar = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Don't emit genotype fields when writing vcf file output");
        optionalVar.setCommandParamater("-sites-only-vcf-output");
        optionalVar.setHelpMsg("If true, don't emit genotype fields when writing vcf file output. Default false");
        this.jobDesc.addVariable(optionalVar);
        GATKHelper.createSharedOptions(this.jobDesc, new String[]{GATKHelper.GATK_OPTION_SWITCH_INTERVALS_MERGING_RULE, GATKHelper.GATK_OPTION_SWITCH_INTERVALS, GATKHelper.GATK_OPTION_SWITCH_CREATE_BAM_MD5, GATKHelper.GATK_OPTION_SWITCH_CREATE_VCF_MD5, GATKHelper.GATK_OPTION_SWITCH_DISABLE_TOOL_DEFAULT_READ_FILTERS, GATKHelper.GATK_OPTION_SWITCH_EXCLUDE_INTERVALS, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_EXCLUSION_PADDING, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_PADDING, GATKHelper.GATK_OPTION_SWITCH_INTERVALS_SET_RULE, GATKHelper.GATK_OPTION_SWITCH_LENIENT, GATKHelper.GATK_OPTION_SWITCH_READ_FILTER, GATKHelper.GATK_OPTION_SWITCH_READ_VALIDATION_STRINGENCY, GATKHelper.GATK_OPTION_SWITCH_ARGUMENTS_FILE});
    }

    protected void createRules() {
    }

    protected void generateCommand(StringBuilder builder) {
        String cmdPrefix = GATKHelper.getGATKCmdPrefix() + " VariantFiltration " + GATKHelper.getTmpOption();
        FilesVariable inputVCFFilesVar = (FilesVariable)this.getVariable(INPUT_VCF_FILES);
        FilesVariable outFilesVar = (FilesVariable)this.getVariable(OUTPUT_VCF_FILES);
        JobVariable refFileVar = this.getVariable(INPUT_REF_FASTA);
        String outputExt = "vcf";
        GATKHelper.checkPrepareReference(builder, refFileVar);
        builder.append(GATKVariantFiltrationJob.st((String)("OIFS=$IFS  IFS=$newline arr_oa=( $(xargs -n1 <<<\"" + this.getOptionParamatersStrAs$() + "\") ) IFS=$OIFS")) + BashHelper.BatcherParallelSingleton((FilesVariable)inputVCFFilesVar, (String)GATKVariantFiltrationJob.st((String)BashHelper.arrayAdd((JobVariable)outFilesVar, (String)"${outputFolder}/${inputFileBaseName}.vcf")), (String)(cmdPrefix + " \"${arr_oa[@]}\"  -V ${_inputFile} -O " + outFilesVar.$("${_i}")), (String)"VariantFiltration"));
    }
}

