/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.variantseq.jobs;

import com.biotechvana.utils.Constants;
import com.biotechvana.variantseq.workflow.manager.VariantAnaylsisVariableBag;
import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.JobLink;
import com.biotechvana.workflow.descriptors.Publication;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FilesVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class PicardHelper {
    public static final String PICARD_OPTION_SWITCH_CREATE_INDEX = "CREATE_INDEX";
    public static final String PICARD_OPTION_SWITCH_CREATE_INDEX_CHECK = "CREATE_INDEX=true";

    public static String getDesc(String programDesc) {
        if (programDesc == null) {
            programDesc = "";
        }
        return "Picard is a set of command line tools for manipulating high-throughput sequencing (HTS) data and formats such as SAM/BAM/CRAM and VCF.\n" + programDesc;
    }

    public static String getPicardCmdPrefix() {
        return Constants.PIPELINE_PICARD_EXE;
    }

    public static void getCitation(JobDescriptor jobDesc) {
        jobDesc.addPublication(new Publication().setAuthors("Wysoker A, Tibbetts K, Fennell T. 2011").setTitle("PicardTools 1.5.3").setYear(2011).setUrl("http://sourceforge.net/projects/picard/files/picard-tools/"));
    }

    public static String getCitation() {
        return "<a href=\"http://broadinstitute.github.io/picard/\">http://broadinstitute.github.io/picard/</a>";
    }

    public static String getCitation(String extCite) {
        return PicardHelper.getCitation() + "\n" + extCite;
    }

    public static String getManualPage(String pName) {
        return pName + "  <a href=\"https://broadinstitute.github.io/picard/command-line-overview.html#" + pName + "\"> Manual Page</a>";
    }

    public static JobLink getManualLink(String pName) {
        return new JobLink().setTitle(pName).setUrl("https://broadinstitute.github.io/picard/command-line-overview.html#" + pName).setType(JobLink.LinkType.Manual);
    }

    public static void generateCheckandSortBam(StringBuilder command, FilesVariable inputBams, FilesVariable outputBams, String sortOrder) {
        command.append(BashHelper.st((String)"tmpFolder=\"${outputFolder}/sort_tmp\""));
        command.append(BashHelper.st((String)"mkdir -p ${tmpFolder}"));
        command.append(BashHelper.Batcher_noLog((FilesVariable)inputBams, (String)(BashHelper.st((String)"sortType=$(getSortOrder $_inputFile)") + BashHelper.st((String)("fileExt=" + BashHelper.getExt((String)"_inputFile"))) + String.valueOf(BashHelper.If((String)BashConditions.notEqual((String)"${sortType}", (String)sortOrder)).Then(Tracking.trackLog((String)"$_inputFile is not sorted. Trying to Sort it.", (boolean)true) + BashHelper.st((String)BashHelper.assign((JobVariable)outputBams, (String)"${_i}", (String)"${tmpFolder}/${inputFileBaseName}.${fileExt}")) + BashHelper.st((String)"command_Id=\"${_i}_${inputFileBaseName}\"") + BashHelper.command_background_withTrack((String)"$_inputFile", (String)(" samtools sort -o " + outputBams.$("${_i}") + " ${_inputFile}"), (String)"command_Id", (String)"Sorting Bam File")).Else(BashHelper.st((String)BashHelper.assign((JobVariable)outputBams, (String)"${_i}", (String)"${_inputFile}"))))), (boolean)true));
        command.append(BashHelper.st((String)"wait"));
    }

    public static void createPicardSharedOptions(JobDescriptor jobDesc) {
        SelectionListVariableDescriptor optionalVar = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        optionalVar.setVariableName("Create a BAM index when writing a coordinate-sorted BAM file");
        optionalVar.addOptionValue("true");
        optionalVar.addOptionValue("false");
        optionalVar.setCommandParamaterSep("=");
        optionalVar.setHelpMsg("Whether to create a BAM index when writing a coordinate-sorted BAM file or not. Default value: false");
        optionalVar.setCommandParamater(PICARD_OPTION_SWITCH_CREATE_INDEX);
        jobDesc.addVariable((VariableDescriptor)optionalVar);
    }

    public static VariableDescriptor createInputBamFilesVar() {
        VariableDescriptor varReadInputFile = VariableDescriptor.createDescriptorFor((String)VariantAnaylsisVariableBag.INPUT_BAM_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varReadInputFile.isRequired = true;
        varReadInputFile.setVariableName("Input Bam Files");
        varReadInputFile.setHelpMsg("Input Bam Files.");
        varReadInputFile.addAcceptedFileFormat("BAM");
        return varReadInputFile;
    }

    public static String getTmpOption() {
        return " TMP_DIR=$tmpFolder ";
    }
}

