/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.ftpqueue;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.commons.ftpservice.IFTPTransfer;
import com.biotechvana.commons.ftpservice.IFileTransferJob;
import com.biotechvana.commons.ftpservice.IFtpFileTransfer;
import com.biotechvana.commons.ftpservice.TransferStatus;
import com.biotechvana.commons.ftpservice.TransferType;
import org.apache.commons.io.FileUtils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class TransfersControlProgress {
    Composite cntParent;
    ProgressBar progressBar;
    Label progressLabel;
    ToolBar actionBar;
    ToolItem actionButton;
    private Composite progressBarComposite;
    private Label jobImageLabel;
    private MouseAdapter mouseListener;
    boolean started = false;
    boolean canceled = false;
    IFTPTransfer transferObject;

    void createProgressBar(Composite parent, int style) {
        if (this.progressBar != null && !this.progressBar.isDisposed()) {
            this.progressBar.dispose();
        }
        this.progressBar = new ProgressBar(parent, style);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        parent.layout();
    }

    protected TransfersControlProgress(Composite control) {
        this.cntParent = new Composite(control, 2048);
        this.cntParent.setLayout((Layout)new GridLayout(3, false));
        this.cntParent.setBackground(control.getDisplay().getSystemColor(25));
        this.progressLabel = new Label(this.cntParent, 0);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = 50;
        this.progressLabel.setText("");
        this.progressBarComposite = new Composite(this.cntParent, 0);
        this.progressBarComposite.setLayoutData((Object)new GridData(4, 2, true, true));
        this.progressBarComposite.setLayout((Layout)new FillLayout());
        this.createProgressBar(this.progressBarComposite, 2);
        this.actionBar = new ToolBar(this.cntParent, 131072);
        this.actionBar.setCursor(control.getDisplay().getSystemCursor(0));
        this.actionButton = new ToolItem(this.actionBar, 0);
        this.actionButton.setToolTipText("Cancel");
        this.actionButton.setImage(SharedImages.SQUARERED);
        this.actionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransfersControlProgress.this.actionButton.setEnabled(false);
                TransfersControlProgress.this.cancelOrRemove();
            }
        });
    }

    private void cancelOrRemove() {
        this.createProgressBar(this.progressBarComposite, 2);
        this.canceled = true;
        this.progressLabel.setText("...");
    }

    public TransfersControlProgress(Composite control, IFileTransferJob transferJob) {
        this(control);
        this.actionButton.addSelectionListener((SelectionListener)new StopJobButtonListener(transferJob));
        this.transferObject = transferJob;
        if (this.transferObject.getTransferType() == TransferType.DOWNLOAD) {
            this.progressLabel.setImage(SharedImages.ARROWDOWN);
        } else {
            this.progressLabel.setImage(SharedImages.ARROWUP);
        }
    }

    public TransfersControlProgress(Composite control, IFtpFileTransfer ftpFileTransfer) {
        this(control);
        this.actionButton.addSelectionListener((SelectionListener)new StopFileButtonListener(ftpFileTransfer));
        this.transferObject = ftpFileTransfer;
        if (this.transferObject.getTransferType() == TransferType.DOWNLOAD) {
            this.progressLabel.setImage(SharedImages.ARROWDOWN);
        } else {
            this.progressLabel.setImage(SharedImages.ARROWUP);
        }
    }

    public Control getConrol() {
        return this.cntParent;
    }

    public void dispose() {
        this.cntParent.dispose();
    }

    void refresh() {
        if (this.cntParent.isDisposed()) {
            return;
        }
        if (this.transferObject.getStatus() == TransferStatus.RUNNING && !this.started) {
            this.createProgressBar(this.progressBarComposite, 65536);
            this.started = true;
        }
        if (this.started && !this.canceled) {
            IFtpFileTransfer file;
            float progress = (float)this.transferObject.getTransferedBytes() / (float)this.transferObject.getTotalSize() * 100.0f;
            this.progressBar.setSelection((int)progress);
            if (this.transferObject instanceof IFileTransferJob) {
                IFileTransferJob iFileTransferJob = (IFileTransferJob)this.transferObject;
            }
            if (this.transferObject instanceof IFtpFileTransfer && (file = (IFtpFileTransfer)this.transferObject).getStatus() == TransferStatus.RUNNING) {
                this.progressLabel.setText(FileUtils.byteCountToDisplaySize((long)file.getSpeed()) + "/s");
            }
        }
    }

    public class StopFileButtonListener
    implements SelectionListener {
        IFtpFileTransfer job;

        public StopFileButtonListener(IFtpFileTransfer object) {
            this.job = object;
        }

        public void widgetSelected(SelectionEvent e) {
            this.job.setStatus(TransferStatus.STOPED);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.job.setStatus(TransferStatus.STOPED);
        }
    }

    public class StopJobButtonListener
    implements SelectionListener {
        IFileTransferJob job;

        public StopJobButtonListener(IFileTransferJob object) {
            this.job = object;
        }

        public void widgetSelected(SelectionEvent e) {
            this.job.stop();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.job.stop();
        }
    }
}

