/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.pipelineCommander;

import com.biotechvana.pipelineCommander.PipelineCommander;
import com.biotechvana.utils.IPrefs;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;

public class PipelineCommanderSshUtils {
    private String host;
    private String user;
    private String password;
    private String command;
    private String email;
    private String reply;
    private boolean emailOnCompletion;
    private boolean finishedSuccessfully = false;
    IPrefs prefs;

    public PipelineCommanderSshUtils(IPrefs prefs, String host, String user, String password, String command, String email, boolean emailOnCompletion) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.command = command;
        this.email = email;
        this.emailOnCompletion = emailOnCompletion;
        this.prefs = prefs;
    }

    public void executeCommand() throws Exception {
        try {
            PipelineCommander pc = new PipelineCommander(this.host, this.prefs);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter output = new OutputStreamWriter(baos);
            pc.prepareCommandRequest(this.user, this.password, this.command.toString(), true, this.email, this.emailOnCompletion);
            pc.postPipelineRequest(output);
            this.reply = new String(baos.toString());
            this.parseFinishedSuccessfully();
        }
        catch (Exception ex) {
            throw new Exception("Cannot execute command: " + ex.getMessage(), ex);
        }
    }

    public String getReply() {
        return this.reply;
    }

    private void parseFinishedSuccessfully() {
        try {
            StringTokenizer tokenizer = new StringTokenizer(this.reply, "\n");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!token.trim().contains("SSH authentication valid")) continue;
                this.finishedSuccessfully = true;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean hasFinishedSuccessfully() {
        return this.finishedSuccessfully;
    }
}

