/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.servercommons.dialogs.preferences;

import com.biotechvana.utils.PreferenceManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PreferencesFTPDialog
extends TitleAreaDialog {
    private Label labelHost;
    private Label labelUser;
    private Label labelPassword;
    private Label labelPort;
    private Text textHost;
    private Text textUser;
    private Text textPassword;
    private Text textPort;
    private Button buttonTest;

    public PreferencesFTPDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("FTP connection settings");
        this.setMessage("Set your FTP connection settings");
        this.getButton(0).setEnabled(false);
        this.validate();
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(compositeParent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        this.labelHost = new Label(composite, 0);
        this.labelHost.setText("Host / IP:");
        GridData layoutData = new GridData();
        this.labelHost.setLayoutData((Object)layoutData);
        this.textHost = new Text(composite, 2052);
        layoutData = new GridData();
        layoutData.widthHint = 200;
        this.textHost.setLayoutData((Object)layoutData);
        this.labelPort = new Label(composite, 0);
        this.labelPort.setText("Port:");
        layoutData = new GridData();
        this.labelPort.setLayoutData((Object)layoutData);
        this.textPort = new Text(composite, 2052);
        this.textPort.setText("21");
        layoutData = new GridData();
        layoutData.widthHint = 200;
        this.textPort.setLayoutData((Object)layoutData);
        this.labelUser = new Label(composite, 0);
        this.labelUser.setText("User:");
        layoutData = new GridData();
        this.labelUser.setLayoutData((Object)layoutData);
        this.textUser = new Text(composite, 2052);
        layoutData = new GridData();
        layoutData.widthHint = 200;
        this.textUser.setLayoutData((Object)layoutData);
        this.labelPassword = new Label(composite, 0);
        this.labelPassword.setText("Password:");
        layoutData = new GridData();
        this.labelPassword.setLayoutData((Object)layoutData);
        this.textPassword = new Text(composite, 0x400804);
        layoutData = new GridData();
        layoutData.widthHint = 200;
        this.textPassword.setLayoutData((Object)layoutData);
        this.buttonTest = new Button(composite, 8);
        this.buttonTest.setText("Test connection settings");
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.buttonTest.setLayoutData((Object)layoutData);
        this.initForm();
        this.addListeners();
        return super.createDialogArea(parent);
    }

    private void initForm() {
        String preferenceHost = PreferenceManager.getInstance().get("ftp_host", "");
        String preferencePort = PreferenceManager.getInstance().get("ftp_port", "");
        String preferenceUser = PreferenceManager.getInstance().get("ftp_user", "");
        String preferencePassword = PreferenceManager.getInstance().get("ftp_password", "");
        if (!preferenceHost.isEmpty()) {
            this.textHost.setText(preferenceHost);
        }
        if (!preferencePort.isEmpty()) {
            this.textPort.setText(preferencePort);
        } else {
            this.textPort.setText("21");
        }
        if (!preferenceUser.isEmpty()) {
            this.textUser.setText(preferenceUser);
        }
        if (!preferencePassword.isEmpty()) {
            this.textPassword.setText(preferencePassword);
        }
    }

    protected void okPressed() {
        this.savePreferences();
        super.okPressed();
    }

    private void savePreferences() {
        PreferenceManager.getInstance().put("ftp_host", this.textHost.getText());
        PreferenceManager.getInstance().put("ftp_port", this.textPort.getText());
        PreferenceManager.getInstance().put("ftp_user", this.textUser.getText());
        PreferenceManager.getInstance().put("ftp_password", this.textPassword.getText());
    }

    private void addListeners() {
        this.buttonTest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    MessageDialog.openInformation((Shell)PreferencesFTPDialog.this.getShell(), (String)"FTP connection settings", (String)("Connected successfully to " + PreferencesFTPDialog.this.textHost.getText()));
                }
                catch (NumberFormatException e1) {
                    MessageDialog.openWarning((Shell)PreferencesFTPDialog.this.getShell(), (String)"FTP settings", (String)"Invalid port number");
                }
                catch (Exception e1) {
                    MessageDialog.openError((Shell)PreferencesFTPDialog.this.getShell(), (String)"FTP connection settings", (String)("Can not connect to " + PreferencesFTPDialog.this.textHost.getText()));
                }
            }
        });
        this.textHost.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PreferencesFTPDialog.this.validate();
            }
        });
        this.textUser.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PreferencesFTPDialog.this.validate();
            }
        });
        this.textPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PreferencesFTPDialog.this.validate();
            }
        });
    }

    private void validate() {
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(false);
        if (this.textHost.getText().isEmpty()) {
            this.setErrorMessage("Host name is required");
            return;
        }
        if (this.textUser.getText().isEmpty()) {
            this.setErrorMessage("User name is required");
            return;
        }
        if (this.textPassword.getText().isEmpty()) {
            this.setErrorMessage("Password is required");
            return;
        }
        this.getButton(0).setEnabled(true);
    }
}

