/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.variables;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.workflow.IWorkflowJobComposite;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.ui.compsite.ListTableControl;
import com.biotechvana.workflow.ui.variables.VariableComposite;
import com.biotechvana.workflow.variables.JobVariable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class LiteralListVariableComposite
extends VariableComposite {
    ListTableControl listTableControl;
    boolean varUpdateLoopBack = false;
    boolean controlUpdateLoopBack = false;

    protected LiteralListVariableComposite(Composite parent, IWorkflowJobComposite parentJobComposite, JobVariable var, int istyle) {
        super(parent, parentJobComposite, var, istyle);
    }

    @Override
    protected void createContolsPart() {
        VariableDescriptor.VariableType varType = this.var.getDescVarType();
        Assert.isTrue((varType == VariableDescriptor.VariableType.Strings ? 1 : 0) != 0);
        if (this.var.getDescGUIVisible()) {
            Object cmdParamater;
            int varDesclabelHSpan = 2;
            this.varDesclabel = new Link((Composite)this, 0x40 | this.style);
            GridData layoutData = new GridData(1, 0x1000000, false, false, varDesclabelHSpan, 1);
            layoutData.minimumWidth = 50;
            layoutData.minimumWidth = 50;
            layoutData.widthHint = 400;
            this.varDesclabel.setLayoutData((Object)layoutData);
            if (this.parentJobComposite.supportShowHelp()) {
                this.varDesclabel.setText(this.var.getDescFriendlyName() + " : !");
                this.varDesclabel.setToolTipText("Double Click! to Show more help.");
            } else {
                this.varDesclabel.setText(this.var.getDescFriendlyName());
                if (this.var.getDescHelpMsg() != null) {
                    this.varDesclabel.setToolTipText(this.var.getDescHelpMsg());
                }
            }
            FontData fontdata = this.varDesclabel.getFont().getFontData()[0];
            fontdata.setStyle(1);
            Font font = new Font((Device)this.getDisplay(), fontdata);
            this.varDesclabel.setFont(font);
            Link varErrorslabel = new Link((Composite)this, 0x40 | this.style);
            layoutData = new GridData(4, 1, true, false, 1, 2);
            layoutData.widthHint = 300;
            layoutData.horizontalIndent = 10;
            varErrorslabel.setLayoutData((Object)layoutData);
            this.disposableParts.add(varErrorslabel);
            String helpMsg = this.var.getDescHelpMsg();
            if (helpMsg == null) {
                helpMsg = "";
            }
            if (!((String)(cmdParamater = this.var.getDescCommandParamater().trim())).isEmpty()) {
                cmdParamater = "(" + (String)cmdParamater;
                String alt = this.var.getDescCommandParamaterAlt().trim();
                if (!alt.isEmpty()) {
                    cmdParamater = (String)cmdParamater + "/" + alt;
                }
                cmdParamater = (String)cmdParamater + ") ";
            }
            varErrorslabel.setCursor(this.getDisplay().getSystemCursor(21));
            varErrorslabel.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                    LiteralListVariableComposite.this.parentJobComposite.requestShowHelp(LiteralListVariableComposite.this.var);
                }
            });
            this.varHelplabel = varErrorslabel;
            this.helpMsg = (String)cmdParamater + helpMsg;
            layoutData = new GridData(4, 1, true, false, 1, 1);
            layoutData.widthHint = 500;
            if (varType == VariableDescriptor.VariableType.Strings) {
                layoutData.horizontalIndent = 50;
                layoutData.heightHint = 150;
                layoutData.horizontalSpan = 1;
                layoutData.minimumWidth = 500;
            }
            layoutData = new GridData(4, 4, true, false, 2, 1);
            layoutData.horizontalIndent = 25;
            layoutData.minimumWidth = 500;
            layoutData.heightHint = 150;
            this.listTableControl = new ListTableControl(){

                @Override
                protected void beforeCreatingToolbar(ToolBar toolBar) {
                    if (LiteralListVariableComposite.this.var.hasCustomGUIActions()) {
                        ToolItem item = new ToolItem(toolBar, 8);
                        item.setToolTipText("Custom Actions");
                        item.setImage(SharedImages.VIEW_MENU);
                        final Menu menu = LiteralListVariableComposite.this.getCustomActionMenu((Composite)item.getParent().getShell());
                        item.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent event) {
                                ToolItem item = (ToolItem)event.widget;
                                Rectangle rect = item.getBounds();
                                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                                menu.setLocation(pt.x, pt.y + rect.height);
                                menu.setVisible(true);
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                            }
                        });
                    }
                }
            };
            this.listTableControl.createTableControl(this);
            this.controlDecoration = this.listTableControl.getControlDecoration();
            this.controlDecoration.setDescriptionText("");
            this.controlDecoration.hide();
            this.listTableControl.getControl().setToolTipText(this.var.getDescHelpMsg());
            String value = this.var.getValue();
            if (value != null) {
                this.controlUpdateLoopBack = true;
                this.listTableControl.setListValue(value);
                this.controlUpdateLoopBack = false;
            }
            this.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    String value = LiteralListVariableComposite.this.var.getValue().trim();
                    if (!value.equals(LiteralListVariableComposite.this.listTableControl.getListValue())) {
                        LiteralListVariableComposite.this.listTableControl.setListValue(value);
                    }
                }
            });
            this.varControl = this.listTableControl.getControl();
            this.varControl.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    LiteralListVariableComposite.this.var.setValue(LiteralListVariableComposite.this.listTableControl.getListValue());
                }
            });
            this.listTableControl.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                }
            });
        }
    }

    void createBtns(Composite parent, final Table varValueList) {
        GridData layoutData;
        if (this.var.hasCustomGUIActions()) {
            Button customActionBtn = this.addCustomActionMenuBtn(parent);
            layoutData = new GridData(1, 1, false, true, 1, 1);
            layoutData.widthHint = 40;
            layoutData.heightHint = 26;
            customActionBtn.setLayoutData((Object)layoutData);
            customActionBtn.setToolTipText("Actions Menu");
        }
        Button moveUp = new Button(parent, 8);
        layoutData = new GridData(1, 1, false, true, 1, 1);
        layoutData.widthHint = 40;
        layoutData.heightHint = 26;
        moveUp.setImage(SharedImages.ARROWUP);
        moveUp.setLayoutData((Object)layoutData);
        moveUp.setToolTipText("Move selected Items Up");
        moveUp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button buttonSelectAll = new Button(parent, 8);
        buttonSelectAll.setText("Select all");
        layoutData = new GridData(1, 0x1000000, false, true, 1, 1);
        layoutData.widthHint = 120;
        buttonSelectAll.setLayoutData((Object)layoutData);
        buttonSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                varValueList.selectAll();
            }
        });
        Button buttonSelectNone = new Button(parent, 8);
        buttonSelectNone.setText("Select None");
        layoutData = new GridData(1, 0x1000000, false, true, 1, 1);
        layoutData.widthHint = 120;
        buttonSelectNone.setLayoutData((Object)layoutData);
        buttonSelectNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                varValueList.deselectAll();
            }
        });
        Button buttonDeleteQuery = new Button(parent, 8);
        buttonDeleteQuery.setText("Delete Selected");
        layoutData = new GridData(1, 0x1000000, false, true, 1, 1);
        layoutData.widthHint = 120;
        buttonDeleteQuery.setLayoutData((Object)layoutData);
        buttonDeleteQuery.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        Button moveDown = new Button(parent, 8);
        layoutData = new GridData(1, 1024, false, true, 1, 1);
        layoutData.widthHint = 40;
        layoutData.heightHint = 26;
        moveDown.setImage(SharedImages.ARROWDOWN);
        moveDown.setLayoutData((Object)layoutData);
        moveDown.setToolTipText("Move selected Items Down");
        moveDown.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public static List createBasicControl(IWorkflowJobComposite parentJobComposite, Composite parent, final JobVariable variable, int observerUpdateEvent, boolean orderBtn, boolean sortBtn) {
        final List varValueList = new List(parent, 2818);
        Listener updateEvenet = new Listener(){

            public void handleEvent(Event event) {
                String value = variable.getValue();
                if (value != null) {
                    String[] lines;
                    varValueList.removeAll();
                    String[] stringArray = lines = variable.getValue().split("\n");
                    int n = lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        if (!line.isEmpty()) {
                            varValueList.add(line);
                        }
                        ++n2;
                    }
                }
            }
        };
        updateEvenet.handleEvent(null);
        varValueList.addListener(observerUpdateEvent, updateEvenet);
        varValueList.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                Object val = "";
                String[] stringArray = varValueList.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    val = (String)val + file + "\n";
                    ++n2;
                }
                variable.setValue((String)val);
            }
        });
        Menu menu = new Menu((Control)varValueList);
        varValueList.setMenu(menu);
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText("Delete Selected");
        menuItem = new MenuItem(menu, 0);
        menuItem.setText("Delete All");
        menuItem = new MenuItem(menu, 2);
        menuItem = new MenuItem(menu, 0);
        menuItem.setText("Select All");
        menuItem = new MenuItem(menu, 0);
        menuItem.setText("Select None");
        if (orderBtn) {
            menuItem = new MenuItem(menu, 2);
            menuItem = new MenuItem(menu, 0);
            menuItem.setText("Move Selected Up");
            menuItem.setImage(SharedImages.ARROWUP);
            menuItem = new MenuItem(menu, 0);
            menuItem.setText("Move Selected Down");
            menuItem.setImage(SharedImages.ARROWDOWN);
        }
        if (sortBtn) {
            menuItem = new MenuItem(menu, 2);
            menuItem = new MenuItem(menu, 64);
            menuItem.setText("Sort");
            Menu subMenu = new Menu(menu);
            menuItem.setMenu(subMenu);
            menuItem = new MenuItem(subMenu, 8);
            menuItem.setText("Sort by Name");
            menuItem = new MenuItem(subMenu, 8);
            menuItem.setText("Sort by Name/number");
        }
        return varValueList;
    }

    public boolean setFocus() {
        if (this.varControl != null && !this.varControl.isDisposed()) {
            return this.varControl.setFocus();
        }
        return super.setFocus();
    }

    class DropdownSelectionListener
    extends SelectionAdapter {
        private ToolItem dropdown;
        private Menu menu;

        public DropdownSelectionListener(ToolItem dropdown) {
            this.dropdown = dropdown;
            this.menu = new Menu((Control)dropdown.getParent().getShell());
        }

        public void add(String item) {
            MenuItem menuItem = new MenuItem(this.menu, 0);
            menuItem.setText(item);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MenuItem selected = (MenuItem)event.widget;
                    DropdownSelectionListener.this.dropdown.setText(selected.getText());
                }
            });
        }

        public void widgetSelected(SelectionEvent event) {
            ToolItem item = (ToolItem)event.widget;
            Rectangle rect = item.getBounds();
            Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
            this.menu.setLocation(pt.x, pt.y + rect.height);
            this.menu.setVisible(true);
        }
    }
}

