/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.commons.dialogs;

import com.biotechvana.users.UserManager;
import com.biotechvana.utils.IPrefs;
import com.biotechvana.utils.PreferenceManager;
import com.biotechvana.utils.ProxyManager;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PreferencesProxyDialog
extends TitleAreaDialog {
    private final String TITLE = "Proxy connection settings";
    private Button buttonConfigNone;
    private Button buttonConfigSystem;
    private Button buttonConfigManual;
    private Button buttonConfigAuto;
    private Text textHTTPHost;
    private Text textHTTPPort;
    private Text textFTPHost;
    private Text textFTPPort;
    private Text textUser;
    private Text textPassword;
    private Text textAuto;
    private ProxyManager proxyManager;

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        PreferencesProxyDialog dialog = new PreferencesProxyDialog(shell);
        dialog.open();
        shell.setText("Proxy test");
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public PreferencesProxyDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Proxy connection settings");
        this.setMessage("Set your proxy connection settings");
        this.getShell().setText("Proxy connection settings");
        this.validate();
    }

    protected Control createDialogArea(Composite parent, UserManager userManager) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        compositeParent.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(compositeParent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(768));
        this.buttonConfigNone = new Button(composite, 16);
        this.buttonConfigNone.setText("Without proxy");
        GridData layoutData = new GridData();
        this.buttonConfigNone.setLayoutData((Object)layoutData);
        this.buttonConfigSystem = new Button(composite, 16);
        this.buttonConfigSystem.setText("Use system proxy settings");
        layoutData = new GridData();
        this.buttonConfigSystem.setLayoutData((Object)layoutData);
        this.buttonConfigManual = new Button(composite, 16);
        this.buttonConfigManual.setText("Manual configuration:");
        layoutData = new GridData();
        this.buttonConfigManual.setLayoutData((Object)layoutData);
        Composite compositeManual = this.createManualComposite(composite);
        layoutData = new GridData();
        layoutData.horizontalIndent = 40;
        compositeManual.setLayoutData((Object)layoutData);
        this.buttonConfigAuto = new Button(composite, 16);
        this.buttonConfigAuto.setText("URL for automatic proxy configuration (.pac):");
        this.textAuto = new Text(composite, 2052);
        layoutData = new GridData(768);
        layoutData.horizontalIndent = 40;
        this.textAuto.setLayoutData((Object)layoutData);
        this.addListeners();
        this.proxyManager = new ProxyManager((IPrefs)userManager);
        this.loadSettings();
        return compositeParent;
    }

    private Composite createManualComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        composite.setLayout((Layout)layout);
        Label labelHTTPHost = new Label(composite, 0);
        labelHTTPHost.setText("HTTP host:");
        GridData layoutData = new GridData(128);
        labelHTTPHost.setLayoutData((Object)layoutData);
        this.textHTTPHost = new Text(composite, 2052);
        layoutData = new GridData(768);
        this.textHTTPHost.setLayoutData((Object)layoutData);
        Label labelHTTPPort = new Label(composite, 0);
        labelHTTPPort.setText("HTTP port:");
        layoutData = new GridData(128);
        labelHTTPPort.setLayoutData((Object)layoutData);
        this.textHTTPPort = new Text(composite, 2052);
        layoutData.widthHint = 40;
        this.textHTTPPort.setLayoutData((Object)layoutData);
        Label labelUser = new Label(composite, 0);
        labelUser.setText("User:");
        layoutData = new GridData(128);
        labelUser.setLayoutData((Object)layoutData);
        this.textUser = new Text(composite, 2052);
        layoutData = new GridData();
        layoutData.widthHint = 200;
        this.textUser.setLayoutData((Object)layoutData);
        Label spacer = new Label(composite, 0);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        spacer.setLayoutData((Object)layoutData);
        Label labelPassword = new Label(composite, 0);
        labelPassword.setText("Password:");
        layoutData = new GridData(128);
        labelPassword.setLayoutData((Object)layoutData);
        this.textPassword = new Text(composite, 0x400804);
        layoutData = new GridData();
        layoutData.widthHint = 200;
        this.textPassword.setLayoutData((Object)layoutData);
        spacer = new Label(composite, 0);
        layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        spacer.setLayoutData((Object)layoutData);
        Label labelFTPHost = new Label(composite, 0);
        labelFTPHost.setText("FTP host:");
        layoutData = new GridData(128);
        labelFTPHost.setLayoutData((Object)layoutData);
        this.textFTPHost = new Text(composite, 2052);
        layoutData = new GridData();
        layoutData.widthHint = 200;
        this.textFTPHost.setLayoutData((Object)layoutData);
        Label labelFTPPort = new Label(composite, 0);
        labelFTPPort.setText("FTP port:");
        layoutData = new GridData(128);
        labelFTPPort.setLayoutData((Object)layoutData);
        this.textFTPPort = new Text(composite, 2052);
        layoutData = new GridData(128);
        layoutData.widthHint = 40;
        this.textFTPPort.setLayoutData((Object)layoutData);
        return composite;
    }

    protected void okPressed() {
        if (!this.validate()) {
            return;
        }
        this.saveSettings();
        super.okPressed();
    }

    private void enableManualOptions(boolean state) {
        this.textHTTPHost.setEnabled(state);
        this.textHTTPPort.setEnabled(state);
        this.textUser.setEnabled(state);
        this.textPassword.setEnabled(state);
        this.textFTPHost.setEnabled(state);
        this.textFTPPort.setEnabled(state);
    }

    private void enableAutoOptions(boolean state) {
        this.textAuto.setEnabled(state);
    }

    private void addListeners() {
        this.buttonConfigNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesProxyDialog.this.enableManualOptions(false);
                PreferencesProxyDialog.this.enableAutoOptions(false);
            }
        });
        this.buttonConfigSystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesProxyDialog.this.enableManualOptions(false);
                PreferencesProxyDialog.this.enableAutoOptions(false);
            }
        });
        this.buttonConfigManual.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesProxyDialog.this.enableManualOptions(true);
                PreferencesProxyDialog.this.enableAutoOptions(false);
            }
        });
        this.buttonConfigAuto.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesProxyDialog.this.enableManualOptions(false);
                PreferencesProxyDialog.this.enableAutoOptions(true);
            }
        });
    }

    private boolean validate() {
        this.setErrorMessage(null);
        if (this.buttonConfigManual.getSelection()) {
            if (this.textHTTPHost.getText() == null || this.textHTTPHost.getText().length() == 0) {
                this.setErrorMessage("Host cannot be null");
                return false;
            }
            if (this.textHTTPPort.getText() == null || this.textHTTPPort.getText().length() == 0) {
                this.setErrorMessage("Port cannot be null");
                return false;
            }
            try {
                int portNumber = Integer.parseInt(this.textHTTPPort.getText());
                if (portNumber <= 80 && portNumber > 65500) {
                    this.setErrorMessage("Invalid port number");
                    return false;
                }
            }
            catch (Exception ex) {
                this.setErrorMessage("Invalid port number");
                return false;
            }
        }
        if (this.buttonConfigAuto.getSelection() && (this.textAuto.getText() == null || this.textAuto.getText().length() == 0)) {
            this.setErrorMessage("Invalid URL");
            return false;
        }
        return true;
    }

    private void loadSettings() {
        block13: {
            this.enableManualOptions(false);
            this.enableAutoOptions(false);
            try {
                String proxyType = PreferenceManager.getInstance().get("proxy_type", "");
                if (proxyType.equals("proxy_type_none")) {
                    this.buttonConfigNone.setSelection(true);
                    break block13;
                }
                if (proxyType.equals("proxy_type_system")) {
                    this.buttonConfigSystem.setSelection(true);
                    break block13;
                }
                if (proxyType.equals("proxy_type_manual")) {
                    this.buttonConfigManual.setSelection(true);
                    this.enableManualOptions(true);
                    try {
                        Map proxySettings = this.proxyManager.getProxyManualSettings();
                        String proxyHTTPHost = (String)proxySettings.get("proxy_http_host");
                        String proxyHTTPPort = (String)proxySettings.get("proxy_http_port");
                        String proxyFTPHost = (String)proxySettings.get("proxy_ftp_host");
                        String proxyFTPPort = (String)proxySettings.get("proxy_ftp_port");
                        String proxyUser = (String)proxySettings.get("proxy_user");
                        String proxyPassword = (String)proxySettings.get("proxy_password");
                        this.textHTTPHost.setText(proxyHTTPHost);
                        this.textHTTPPort.setText(proxyHTTPPort);
                        this.textFTPHost.setText(proxyFTPHost);
                        this.textFTPPort.setText(proxyFTPPort);
                        if (proxyUser != null && proxyUser.length() > 0) {
                            this.textUser.setText(proxyUser);
                        }
                        if (proxyPassword != null && proxyPassword.length() > 0) {
                            this.textPassword.setText(proxyPassword);
                        }
                        break block13;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    break block13;
                }
                if (proxyType.equals("proxy_type_auto")) {
                    this.buttonConfigAuto.setSelection(true);
                    this.enableAutoOptions(true);
                    try {
                        String proxyUrl = this.proxyManager.getProxyAutoSettings();
                        if (proxyUrl != null && proxyUrl.length() > 0) {
                            this.textAuto.setText(proxyUrl);
                        }
                        break block13;
                    }
                    catch (Exception exception) {}
                    break block13;
                }
                this.buttonConfigSystem.setSelection(true);
            }
            catch (Exception ex) {
                this.buttonConfigSystem.setSelection(true);
            }
        }
    }

    private void saveSettings() {
        try {
            if (this.buttonConfigNone.getSelection()) {
                this.proxyManager.setProxyNone();
            } else if (this.buttonConfigSystem.getSelection()) {
                this.proxyManager.setProxySystem();
            } else if (this.buttonConfigManual.getSelection()) {
                this.proxyManager.setProxyManual(this.textHTTPHost.getText(), this.textHTTPPort.getText(), this.textFTPHost.getText(), this.textFTPPort.getText(), this.textUser.getText(), this.textPassword.getText());
                this.proxyManager.applyProxyManualSettings();
            } else if (this.buttonConfigAuto.getSelection()) {
                this.proxyManager.setProxyAuto(this.textAuto.getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

