/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.utils;

public class FilenameUtils {
    public static void main(String[] args) {
        String filename = "/home/pepe/test/myfile.txt";
        System.out.println("Original name: " + filename);
        System.out.println("Filename: " + FilenameUtils.getName(filename));
        System.out.println("Basename: " + FilenameUtils.getBasename(filename));
        System.out.println("Extension: " + FilenameUtils.getExtension(filename));
    }

    public static String getExtension(String filename) {
        return FilenameUtils.getExtension(filename, false);
    }

    public static String getExtension(String filename, boolean unixSep) {
        int indexDot;
        String extension = null;
        if (filename != null && !filename.isEmpty() && (indexDot = (filename = FilenameUtils.getName(filename, unixSep)).lastIndexOf(".")) != -1) {
            extension = filename.substring(indexDot);
        }
        return extension;
    }

    public static String getBasename(String filename) {
        return FilenameUtils.getBasename(filename, false);
    }

    public static String getBasename(String filename, boolean unixSep) {
        int indexDot;
        String basename = filename;
        if (filename != null && !filename.isEmpty() && (indexDot = (filename = FilenameUtils.getName(filename, unixSep)).lastIndexOf(".")) != -1) {
            basename = filename.substring(0, indexDot);
        }
        return basename;
    }

    public static String getName(String filename) {
        return FilenameUtils.getName(filename, false);
    }

    public static String getName(String filename, boolean unixSep) {
        int indexSlash;
        String name = filename;
        String separator = "/";
        if (filename != null && !filename.isEmpty() && (indexSlash = filename.lastIndexOf(separator)) != -1) {
            name = filename.substring(indexSlash + 1);
        }
        return name;
    }

    public static String getPath(String filename) {
        int indexSlash;
        String path = "";
        String separator = "/";
        if (filename != null && !filename.isEmpty() && (indexSlash = filename.lastIndexOf(separator)) != -1) {
            path = filename.substring(0, indexSlash);
        }
        return path;
    }
}

